/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.pool.BeanFactory;
import org.jboss.pool.ObjectRecord;
import org.jboss.pool.PoolEvent;
import org.jboss.pool.PoolEventListener;
import org.jboss.pool.PoolGCThread;
import org.jboss.pool.PoolObjectFactory;
import org.jboss.pool.PooledObject;

public class ObjectPool
implements PoolEventListener {
    private static final String INITIALIZED = "Pool already initialized!";
    private static final PoolGCThread collector = new PoolGCThread();
    private Logger log = Logger.getLogger((Class)(class$org$jboss$pool$ObjectPool != null ? class$org$jboss$pool$ObjectPool : (class$org$jboss$pool$ObjectPool = ObjectPool.class$("org.jboss.pool.ObjectPool"))));
    private PoolObjectFactory factory;
    private String poolName;
    private final Map objects = new HashMap();
    private final Set deadObjects = Collections.synchronizedSet(new HashSet());
    private int minSize = 0;
    private int maxSize = 0;
    private boolean idleTimeout = false;
    private boolean runGC = false;
    private float maxIdleShrinkPercent = 1.0f;
    private long idleTimeoutMillis = 1800000L;
    private long gcMinIdleMillis = 1200000L;
    private long gcIntervalMillis = 120000L;
    private long lastGC = System.currentTimeMillis();
    private boolean blocking = true;
    private int blockingTimeout = 10000;
    private boolean trackLastUsed = false;
    private boolean invalidateOnError = false;
    private FIFOSemaphore permits;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$jboss$pool$ObjectPool;

    static {
        collector.start();
    }

    public ObjectPool() {
    }

    public ObjectPool(Class javaBeanClass, String poolName) {
        this.setObjectFactory(javaBeanClass);
        this.setName(poolName);
    }

    public ObjectPool(PoolObjectFactory factory, String poolName) {
        this.setObjectFactory(factory);
        this.setName(poolName);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private ObjectRecord createNewObject(Object parameters) {
        Object ob = null;
        try {
            ob = this.factory.createObject(parameters);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create connection");
        }
        if (ob != null) {
            ObjectRecord rec = new ObjectRecord(ob);
            Map map = this.objects;
            synchronized (map) {
                this.objects.put(ob, rec);
            }
            return rec;
        }
        throw new RuntimeException("could not create new object!");
    }

    public void fillToMin() {
        ArrayList<Object> newMCs = new ArrayList<Object>();
        try {
            while (this.objects.size() < this.minSize) {
                newMCs.add(this.getObject(null));
            }
        }
        catch (Exception exception) {}
        Iterator i = newMCs.iterator();
        while (i.hasNext()) {
            this.releaseObject(i.next());
        }
    }

    public long getAvailableObjects() {
        return this.permits.permits();
    }

    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public long getGCInterval() {
        return this.gcIntervalMillis;
    }

    public long getGCMinIdleTime() {
        return this.gcMinIdleMillis;
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMillis;
    }

    public float getMaxIdleTimeoutPercent() {
        return this.maxIdleShrinkPercent;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public String getName() {
        return this.poolName;
    }

    long getNextGCMillis(long now) {
        long t = this.lastGC + this.gcIntervalMillis - now;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNextGCMillis(): returning " + t));
        }
        if (!this.runGC) {
            return Long.MAX_VALUE;
        }
        return t;
    }

    public Object getObject() {
        return this.getObject(null);
    }

    public Object getObject(Object parameters) {
        if (this.objects == null) {
            throw new IllegalStateException("Tried to use pool before it was Initialized or after it was ShutDown!");
        }
        Object result = this.factory.isUniqueRequest();
        if (result != null) {
            return result;
        }
        try {
            if (this.permits.attempt((long)this.blockingTimeout)) {
                ObjectRecord rec = null;
                Map map = this.objects;
                synchronized (map) {
                    Iterator it = this.objects.values().iterator();
                    while (it.hasNext()) {
                        rec = (ObjectRecord)it.next();
                        if (rec != null && !rec.isInUse() && this.factory.checkValidObject(rec.getObject(), parameters)) {
                            try {
                                rec.setInUse(true);
                                break;
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {
                                this.log.info((Object)("Conflict trying to set rec. in use flag:" + rec.getObject()));
                                continue;
                            }
                        }
                        rec = null;
                    }
                }
                if (rec == null) {
                    rec = this.createNewObject(parameters);
                }
                if (rec == null) {
                    throw new RuntimeException("Pool is broken, did not find or create an object");
                }
                Object ob = rec.getObject();
                result = this.factory.prepareObject(ob);
                if (result != ob) {
                    rec.setClientObject(result);
                }
                if (result instanceof PooledObject) {
                    ((PooledObject)result).addPoolEventListener(this);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Pool " + this + " gave out object: " + result));
                }
                return result;
            }
            throw new RuntimeException("No ManagedConnections Available!");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException interruptedException) {
            this.log.info((Object)"Interrupted while requesting permit!", (Throwable)new Exception("stacktrace"));
            throw new RuntimeException("Interrupted while requesting permit!");
        }
        catch (Exception e) {
            this.log.info((Object)"problem getting connection from pool", (Throwable)e);
            throw new RuntimeException("problem getting connection from pool " + e.getMessage());
        }
    }

    private int getUsedCount() {
        int total = 0;
        Map map = this.objects;
        synchronized (map) {
            Iterator it = new HashSet(this.objects.values()).iterator();
            while (it.hasNext()) {
                ObjectRecord or = (ObjectRecord)it.next();
                if (or == null || !or.isInUse()) continue;
                ++total;
            }
        }
        return total;
    }

    public void initialize() {
        if (this.factory == null || this.poolName == null) {
            throw new IllegalStateException("Factory and Name must be set before pool initialization!");
        }
        if (this.initialized) {
            throw new IllegalStateException("Cannot initialize more than once!");
        }
        this.initialized = true;
        this.permits = new FIFOSemaphore((long)this.maxSize);
        this.factory.poolStarted(this);
        this.lastGC = System.currentTimeMillis();
        this.fillToMin();
        collector.addPool(this);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isGCEnabled() {
        return this.runGC;
    }

    public boolean isIdleTimeoutEnabled() {
        return this.idleTimeout;
    }

    public boolean isInvalidateOnError() {
        return this.invalidateOnError;
    }

    boolean isTimeToGC() {
        long now = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isTimeToGC(): " + (now >= this.lastGC + (long)Math.round((float)this.gcIntervalMillis * 0.9f))));
        }
        return now >= this.lastGC + (long)Math.round((float)this.gcIntervalMillis * 0.9f);
    }

    public boolean isTimestampUsed() {
        return this.trackLastUsed;
    }

    public void markObjectAsInvalid(Object object) {
        if (this.deadObjects == null) {
            throw new IllegalStateException("Tried to use pool before it was Initialized or after it was ShutDown!");
        }
        this.deadObjects.add(object);
    }

    public void objectClosed(PoolEvent evt) {
        this.releaseObject(evt.getSource());
    }

    public void objectError(PoolEvent evt) {
        if (this.invalidateOnError || evt.isCatastrophic()) {
            this.markObjectAsInvalid(evt.getSource());
        }
    }

    public void objectUsed(PoolEvent evt) {
        if (!this.trackLastUsed) {
            return;
        }
        this.setLastUsed(evt.getSource());
    }

    public void releaseObject(Object object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Pool " + this + " object released: " + object));
        }
        Object pooled = null;
        try {
            pooled = this.factory.translateObject(object);
            this.factory.returnObject(object);
        }
        catch (Exception e) {
            this.log.info((Object)"Exception trying to return object: ", (Throwable)e);
            return;
        }
        if (pooled == null) {
            this.log.info((Object)"Factory did not recognize object we tried to return.");
            return;
        }
        boolean removed = false;
        Map map = this.objects;
        synchronized (map) {
            ObjectRecord rec = (ObjectRecord)this.objects.get(pooled);
            if (rec == null) {
                throw new IllegalArgumentException("Object " + object + " is not in pool " + this.poolName + "!");
            }
            if (!rec.isInUse()) {
                Object var5_8 = null;
                return;
            }
            if (object instanceof PooledObject) {
                ((PooledObject)object).removePoolEventListener(this);
            }
            removed = this.deadObjects.remove(object);
            rec.setInUse(false);
            if (removed) {
                this.log.trace((Object)("Object was dead: " + object));
                this.objects.remove(pooled);
                rec.close();
            }
        }
        if (removed) {
            try {
                this.factory.deleteObject(pooled);
            }
            catch (Exception e) {
                this.log.error((Object)("Pool " + this + " factory (" + this.factory.getClass().getName() + " delete error: "), (Throwable)e);
            }
            this.fillToMin();
        }
        if (this.log.isTraceEnabled()) {
            if (removed) {
                this.log.trace((Object)("Pool " + this + " destroyed object " + object + "."));
            } else {
                this.log.trace((Object)("Pool " + this + " returned object " + object + " to the pool."));
            }
        }
        this.permits.release();
    }

    void runGCandShrink() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("runGCandShrink(): runGC = " + this.runGC + "; idleTimeout = " + this.idleTimeout));
        }
        if (this.runGC || this.idleTimeout) {
            HashSet objsCopy;
            Map map = this.objects;
            synchronized (map) {
                objsCopy = new HashSet(this.objects.values());
            }
            if (this.runGC) {
                Iterator it = objsCopy.iterator();
                while (it.hasNext()) {
                    ObjectRecord rec = (ObjectRecord)it.next();
                    if (rec == null || !rec.isInUse() || rec.getMillisSinceLastUse() < this.gcMinIdleMillis) continue;
                    this.releaseObject(rec.getClientObject());
                }
            }
            if (this.idleTimeout) {
                HashSet<ObjectRecord> eligible = new HashSet<ObjectRecord>();
                Iterator<Object> it = objsCopy.iterator();
                while (it.hasNext()) {
                    ObjectRecord rec = (ObjectRecord)it.next();
                    if (rec == null || rec.isInUse() || rec.getMillisSinceLastUse() <= this.idleTimeoutMillis) continue;
                    eligible.add(rec);
                }
                int max = Math.round((float)eligible.size() * this.maxIdleShrinkPercent);
                if (max == 0 && eligible.size() > 0) {
                    max = 1;
                }
                int count = 0;
                it = eligible.iterator();
                while (it.hasNext()) {
                    try {
                        ObjectRecord rec = (ObjectRecord)it.next();
                        if (rec != null) {
                            rec.setInUse(true);
                            Object pooled = rec.getObject();
                            Map map2 = this.objects;
                            synchronized (map2) {
                                this.objects.remove(pooled);
                            }
                            try {
                                this.factory.deleteObject(pooled);
                            }
                            catch (Exception e) {
                                this.log.error((Object)("Pool " + this + " factory (" + this.factory.getClass().getName() + " delete error: "), (Throwable)e);
                            }
                            rec.close();
                            ++count;
                        }
                        this.fillToMin();
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
        }
        this.lastGC = System.currentTimeMillis();
    }

    public void setBlocking(boolean blocking) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.blocking = blocking;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public void setGCEnabled(boolean enabled) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.runGC = enabled;
    }

    public void setGCInterval(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.gcIntervalMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setGCInterval(" + this.gcIntervalMillis + ")"));
        }
    }

    public void setGCMinIdleTime(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.gcMinIdleMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setGCMinIdleTime(" + millis + ")"));
        }
    }

    public void setIdleTimeout(long millis) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.idleTimeoutMillis = millis;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setIdleTimeout(" + millis + ")"));
        }
    }

    public void setIdleTimeoutEnabled(boolean enableTimeout) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.idleTimeout = enableTimeout;
    }

    public void setInvalidateOnError(boolean invalidate) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.invalidateOnError = invalidate;
    }

    public void setLastUsed(Object object) {
        ObjectRecord rec;
        if (!this.trackLastUsed) {
            return;
        }
        Object ob = null;
        try {
            ob = this.factory.translateObject(object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Pool " + this.getName() + " does not recognize object for last used time: " + object);
        }
        ObjectRecord objectRecord = rec = ob == null ? null : (ObjectRecord)this.objects.get(ob);
        if (rec == null) {
            throw new IllegalArgumentException("Pool " + this.getName() + " does not recognize object for last used time: " + object);
        }
        if (!rec.isInUse()) {
            throw new IllegalStateException("Cannot set last updated time for an object that's not in use!");
        }
        rec.setLastUsed();
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0 and 1!");
        }
        this.maxIdleShrinkPercent = percent;
    }

    public void setMaxSize(int size) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.maxSize = size;
        if (this.maxSize != 0 && this.minSize > this.maxSize) {
            this.minSize = this.maxSize;
            this.log.warn((Object)("pool min size set to " + this.minSize + " to stay <= max size"));
        }
    }

    public void setMinSize(int size) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.minSize = size;
        if (this.maxSize != 0 && this.minSize > this.maxSize) {
            this.maxSize = this.minSize;
            this.log.warn((Object)("pool max size set to " + this.maxSize + " to stay >= min size"));
        }
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cannot set pool name to null or empty!");
        }
        if (this.poolName != null && !this.poolName.equals(name)) {
            throw new IllegalStateException("Cannot change pool name once set!");
        }
        this.poolName = name;
        this.log = Logger.getLogger((String)(String.valueOf((class$org$jboss$pool$ObjectPool != null ? class$org$jboss$pool$ObjectPool : (class$org$jboss$pool$ObjectPool = ObjectPool.class$("org.jboss.pool.ObjectPool"))).getName()) + "." + name));
    }

    public void setObjectFactory(Class javaBeanClass) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.factory = new BeanFactory(javaBeanClass);
    }

    public void setObjectFactory(PoolObjectFactory factory) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.factory = factory;
    }

    public void setTimestampUsed(boolean timestamp) {
        if (this.initialized) {
            throw new IllegalStateException(INITIALIZED);
        }
        this.trackLastUsed = timestamp;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setTimestampUsed(" + timestamp + ")"));
        }
    }

    public void shutDown() {
        collector.removePool(this);
        this.factory.poolClosing(this);
        Map map = this.objects;
        synchronized (map) {
            Iterator it = this.objects.values().iterator();
            while (it.hasNext()) {
                ObjectRecord rec = (ObjectRecord)it.next();
                if (rec == null) continue;
                if (rec.isInUse()) {
                    this.factory.returnObject(rec.getClientObject());
                }
                this.factory.deleteObject(rec.getObject());
                rec.close();
            }
            this.objects.clear();
            this.deadObjects.clear();
        }
        this.factory = null;
        this.poolName = null;
        this.initialized = false;
    }

    public String toString() {
        return String.valueOf(this.poolName) + " [" + this.getUsedCount() + "/" + (this.objects == null ? 0 : this.objects.size()) + "/" + (this.maxSize == 0 ? "Unlimited" : Integer.toString(this.maxSize)) + "]";
    }
}

