/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.net.SocketFactory;

public class TimedSocketFactory
extends SocketFactory {
    public static final String JNP_TIMEOUT = "jnp.timeout";
    public static final String JNP_SO_TIMEOUT = "jnp.sotimeout";
    protected int timeout = 0;
    protected int soTimeout = 0;

    public TimedSocketFactory() {
    }

    public TimedSocketFactory(Hashtable env) {
        String value = (String)env.get(JNP_TIMEOUT);
        if (value != null) {
            this.timeout = Integer.parseInt(value);
        }
        if ((value = (String)env.get(JNP_SO_TIMEOUT)) != null) {
            this.soTimeout = Integer.parseInt(value);
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, null, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, localAddr, localPort);
    }

    public Socket createSocket(InetAddress hostAddr, int port) throws IOException {
        return this.createSocket(hostAddr, port, null, 0);
    }

    public Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort) throws IOException {
        Socket socket = null;
        socket = this.timeout <= 0 ? new Socket(hostAddr, port, localAddr, localPort) : this.createSocket(hostAddr, port, localAddr, localPort, this.timeout);
        socket.setSoTimeout(this.soTimeout);
        return socket;
    }

    protected Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort, int connectTimeout) throws IOException {
        ConnectThread t = new ConnectThread();
        Socket socket = t.createSocket(hostAddr, port, localAddr, localPort, connectTimeout);
        return socket;
    }

    class ConnectThread
    extends Thread {
        IOException ex;
        InetAddress hostAddr;
        InetAddress localAddr;
        int port;
        int localPort;
        int connectTimeout;
        Socket socket;

        ConnectThread() {
            super("JNP ConnectThread");
            super.setDaemon(true);
        }

        Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort, int connectTimeout) throws IOException {
            this.hostAddr = hostAddr;
            this.port = port;
            this.localAddr = localAddr;
            this.localPort = localPort;
            this.connectTimeout = connectTimeout;
            try {
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this.start();
                    this.wait(connectTimeout);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConnectException("Connect attempt timed out");
            }
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.socket == null) {
                throw new ConnectException("Connect attempt timed out");
            }
            return this.socket;
        }

        public void run() {
            try {
                this.socket = new Socket(this.hostAddr, this.port, this.localAddr, this.localPort);
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this.notify();
                }
            }
            catch (IOException e) {
                this.ex = e;
            }
        }
    }
}

