/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.crypto.digest;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;

public class SHAReverseInterleave
extends MessageDigestSpi {
    private static final int SHA_HASH_LEN = 20;
    private ByteArrayOutputStream evenBytes;
    private ByteArrayOutputStream oddBytes;
    private int count;
    private boolean skipLeadingZeros;
    private MessageDigest sha;

    public SHAReverseInterleave() {
        try {
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("Failed to obtain SHA MessageDigest");
        }
        this.evenBytes = new ByteArrayOutputStream();
        this.oddBytes = new ByteArrayOutputStream();
        this.engineReset();
    }

    protected int engineGetDigestLength() {
        return 40;
    }

    protected byte[] engineDigest() {
        byte[] E = this.evenBytes.toByteArray();
        int length = E.length;
        if (this.count % 2 == 1) {
            --length;
        }
        byte[] tmp = new byte[length];
        int i = 0;
        while (i < length) {
            tmp[i] = E[E.length - i - 1];
            System.out.println("E[" + i + "] = " + tmp[i]);
            ++i;
        }
        E = tmp;
        byte[] G = this.sha.digest(E);
        byte[] F = this.oddBytes.toByteArray();
        tmp = new byte[F.length];
        int i2 = 0;
        while (i2 < F.length) {
            tmp[i2] = F[F.length - i2 - 1];
            System.out.println("F[" + i2 + "] = " + tmp[i2]);
            ++i2;
        }
        F = tmp;
        this.sha.reset();
        byte[] H = this.sha.digest(F);
        length = G.length + H.length;
        byte[] digest = new byte[length];
        int i3 = 0;
        while (i3 < G.length) {
            digest[2 * i3] = G[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < H.length) {
            digest[2 * i4 + 1] = H[i4];
            ++i4;
        }
        this.engineReset();
        return digest;
    }

    protected void engineReset() {
        this.skipLeadingZeros = true;
        this.count = 0;
        this.evenBytes.reset();
        this.oddBytes.reset();
        this.sha.reset();
    }

    protected void engineUpdate(byte input) {
        if (this.skipLeadingZeros && input == 0) {
            return;
        }
        this.skipLeadingZeros = false;
        if (this.count % 2 == 0) {
            this.evenBytes.write(input);
        } else {
            this.oddBytes.write(input);
        }
        ++this.count;
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        int i = offset;
        while (i < offset + len) {
            this.engineUpdate(input[i]);
            ++i;
        }
    }
}

