/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.Boot;
import com.simontuffs.onejar.Handler;
import com.simontuffs.onejar.IProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarClassLoader
extends ClassLoader
implements IProperties {
    public static final String DOT_CONFIRM = ".onejar.confirm";
    public static final String LIB_PREFIX = "lib/";
    public static final String BINLIB_PREFIX = "binlib/";
    public static final String MAIN_PREFIX = "main/";
    public static final String RECORDING = "recording";
    public static final String TMP = "tmp";
    public static final String UNPACK = "unpack";
    public static final String EXPAND = "One-Jar-Expand";
    public static final String EXPAND_TMP = "One-Jar-Expand-Tmp";
    public static final String EXPAND_DIR = "One-Jar-Expand-Dir";
    public static final String SHOW_EXPAND = "One-Jar-Show-Expand";
    public static final String CONFIRM_EXPAND = "One-Jar-Confirm-Expand";
    public static final String CLASS = ".class";
    public static final String NL = System.getProperty("line.separator");
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    protected String name;
    protected boolean noExpand;
    protected boolean expanded;
    protected ClassLoader externalClassLoader;
    protected Map byteCode = Collections.synchronizedMap(new HashMap());
    protected Map pdCache = Collections.synchronizedMap(new HashMap());
    protected Map binLibPath = Collections.synchronizedMap(new HashMap());
    protected Set jarNames = Collections.synchronizedSet(new HashSet());
    protected boolean record = false;
    protected boolean flatten = false;
    protected boolean unpackFindResource = false;
    protected boolean verbose = false;
    protected boolean info = false;
    protected String recording = "recording";
    protected String jarName;
    protected String mainJar;
    protected String wrapDir;
    protected boolean delegateToParent;
    protected boolean classPool = false;

    protected String PREFIX() {
        return "JarClassLoader: ";
    }

    protected String NAME() {
        return this.name != null ? "'" + this.name + "' " : "";
    }

    protected void VERBOSE(String string) {
        if (this.verbose) {
            System.out.println(this.PREFIX() + this.NAME() + string);
        }
    }

    protected void WARNING(String string) {
        System.err.println(this.PREFIX() + "Warning: " + this.NAME() + string);
    }

    protected void INFO(String string) {
        if (this.info) {
            System.out.println(this.PREFIX() + "Info: " + this.NAME() + string);
        }
    }

    protected void PRINTLN(String string) {
        System.out.println(string);
    }

    protected void PRINT(String string) {
        System.out.print(string);
    }

    public JarClassLoader(String string) {
        this.wrapDir = string;
        this.delegateToParent = this.wrapDir == null;
        this.init();
    }

    public JarClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.delegateToParent = true;
        this.init();
    }

    protected void init() {
        String string = System.getProperty("one-jar.class.path");
        if (string != null) {
            String[] stringArray = string.split("\\|");
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                try {
                    arrayList.add(new URL(string2));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        arrayList.add(new URL("file:///" + new File(string2).getAbsolutePath()));
                        continue;
                    }
                    catch (MalformedURLException malformedURLException2) {
                        Boot.WARNING("Unable to parse external path: " + string2);
                    }
                }
            }
            URL[] uRLArray = arrayList.toArray(new URL[0]);
            Boot.INFO("external URLs=" + Arrays.asList(uRLArray));
            this.externalClassLoader = new URLClassLoader(uRLArray);
        }
    }

    public String load(String string) {
        String string2 = Boot.getMyJarPath();
        return this.load(string, string2);
    }

    public String load(String string, String string2) {
        if (this.record) {
            new File(this.recording).mkdirs();
        }
        try {
            boolean bl;
            Object object;
            if (string2 == null) {
                string2 = Boot.getMyJarPath();
            }
            JarFile jarFile = new JarFile(string2);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Manifest manifest = jarFile.getManifest();
            String[] stringArray = null;
            String string3 = manifest.getMainAttributes().getValue(EXPAND);
            String string4 = manifest.getMainAttributes().getValue(EXPAND_TMP);
            String string5 = System.getProperty("one-jar.expand.dir");
            if (string5 == null) {
                string5 = manifest.getMainAttributes().getValue(EXPAND_DIR);
            }
            boolean bl2 = true;
            File file = new File(".");
            if (string4 != null && Boolean.valueOf(string4).booleanValue()) {
                if (string5 != null) {
                    file = new File(string5);
                } else {
                    File file2 = File.createTempFile("one-jar", ".tmp");
                    file2.deleteOnExit();
                    file = new File(file2.getParentFile() + "/" + new File(string2).getName() + "/expand");
                }
            }
            if (!this.noExpand && string3 != null) {
                this.expanded = true;
                this.VERBOSE("One-Jar-Expand=" + string3);
                stringArray = string3.split(",");
                boolean bl3 = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(CONFIRM_EXPAND));
                if (bl3) {
                    object = this.getConfirmation(file);
                    if (object == null) {
                        object = "n";
                    }
                    if (((String)(object = ((String)object).trim().toLowerCase())).startsWith("q")) {
                        this.PRINTLN("exiting without expansion.");
                        System.exit(1);
                    } else if (((String)object).startsWith("n")) {
                        bl2 = false;
                    }
                }
            }
            if (bl = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(SHOW_EXPAND))) {
                this.PRINTLN("Expanding to: " + file.getAbsolutePath());
            }
            while (enumeration.hasMoreElements()) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                object = enumeration.nextElement();
                if (((ZipEntry)object).isDirectory()) continue;
                String string6 = ((ZipEntry)object).getName();
                if (stringArray != null && bl2 && JarClassLoader.shouldExpand(stringArray, string6)) {
                    object5 = new File(file, string6);
                    if (!((File)object5).exists() || ((File)object5).lastModified() < ((ZipEntry)object).getTime()) {
                        object4 = "Expanding:  " + string6;
                        if (bl) {
                            this.PRINTLN((String)object4);
                        } else {
                            this.INFO((String)object4);
                        }
                        if (((File)object5).exists()) {
                            this.INFO("Update because lastModified=" + new Date(((File)object5).lastModified()) + ", entry=" + new Date(((ZipEntry)object).getTime()));
                        }
                        if ((object3 = ((File)object5).getParentFile()) != null) {
                            ((File)object3).mkdirs();
                        }
                        this.VERBOSE("using jarFile.getInputStream(" + object + ")");
                        object2 = jarFile.getInputStream((ZipEntry)object);
                        FileOutputStream fileOutputStream = new FileOutputStream((File)object5);
                        this.copy((InputStream)object2, fileOutputStream);
                        ((InputStream)object2).close();
                        fileOutputStream.close();
                    } else {
                        object4 = "Up-to-date: " + string6;
                        if (bl) {
                            this.PRINTLN((String)object4);
                        } else {
                            this.VERBOSE((String)object4);
                        }
                    }
                }
                object5 = ((ZipEntry)object).getName();
                if (this.wrapDir != null && ((String)object5).startsWith(this.wrapDir) || ((String)object5).startsWith(LIB_PREFIX) || ((String)object5).startsWith(MAIN_PREFIX)) {
                    if (this.wrapDir != null && !((ZipEntry)object).getName().startsWith(this.wrapDir)) continue;
                    this.INFO("caching " + (String)object5);
                    this.VERBOSE("using jarFile.getInputStream(" + object + ")");
                    object4 = jarFile.getInputStream((ZipEntry)object);
                    if (object4 == null) {
                        throw new IOException("Unable to load resource /" + (String)object5 + " using " + this);
                    }
                    this.loadByteCode((InputStream)object4, (String)object5, manifest);
                    if (!((String)object5).startsWith(MAIN_PREFIX)) continue;
                    if (string == null) {
                        object4 = new JarInputStream(jarFile.getInputStream((ZipEntry)object));
                        object3 = ((JarInputStream)object4).getManifest();
                        ((ZipInputStream)object4).close();
                        if (object3 == null) continue;
                        string = ((JarInputStream)object4).getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        this.mainJar = object5;
                        continue;
                    }
                    if (this.mainJar == null) continue;
                    this.WARNING("A main class is defined in multiple jar files inside main/" + this.mainJar + " and " + (String)object5);
                    this.WARNING("The main class " + string + " from " + this.mainJar + " will be used");
                    continue;
                }
                if (this.wrapDir == null && string6.startsWith(UNPACK)) {
                    object4 = this.getClass().getResourceAsStream("/" + (String)object5);
                    if (object4 == null) {
                        throw new IOException((String)object5);
                    }
                    object3 = new File(TMP);
                    object2 = new File((File)object3, ((String)object5).replace('/', '.'));
                    if (((File)object2).exists()) continue;
                    this.INFO("unpacking " + (String)object5 + " into " + ((File)object3).getCanonicalPath());
                    this.loadByteCode((InputStream)object4, (String)object5, TMP, manifest);
                    ((File)object2).getParentFile().mkdirs();
                    ((File)object2).createNewFile();
                    continue;
                }
                if (string6.endsWith(CLASS)) {
                    this.loadBytes((JarEntry)object, jarFile.getInputStream((ZipEntry)object), "/", null, manifest);
                    continue;
                }
                this.INFO("resource: " + jarFile.getName() + "!/" + ((ZipEntry)object).getName());
            }
        }
        catch (IOException iOException) {
            System.err.println("Unable to load resource: " + iOException);
            iOException.printStackTrace(System.err);
        }
        return string;
    }

    public static boolean shouldExpand(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void loadByteCode(InputStream inputStream, String string, Manifest manifest) throws IOException {
        this.loadByteCode(inputStream, string, null, manifest);
    }

    protected void loadByteCode(InputStream inputStream, String string, String string2, Manifest manifest) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        JarEntry jarEntry = null;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) continue;
            this.loadBytes(jarEntry, jarInputStream, string, string2, manifest);
        }
    }

    protected void loadBytes(JarEntry jarEntry, InputStream inputStream, String string, String string2, Manifest manifest) throws IOException {
        Object object;
        Object object2;
        String string3 = jarEntry.getName().replace('/', '.');
        int n = string3.lastIndexOf(46);
        String string4 = string3.substring(n + 1);
        int n2 = string3.lastIndexOf(46, n - 1);
        if (n2 > -1 && this.getPackage((String)(object2 = string3.substring(0, n2))) == null) {
            object = JarClassLoader.class.getPackage();
            this.definePackage((String)object2, ((Package)object).getSpecificationTitle(), ((Package)object).getSpecificationVersion(), ((Package)object).getSpecificationVendor(), ((Package)object).getImplementationTitle(), ((Package)object).getImplementationVersion(), ((Package)object).getImplementationVendor(), null);
        }
        object2 = new ByteArrayOutputStream();
        this.copy(inputStream, (OutputStream)object2);
        if (string2 != null) {
            object = new File(string2, jarEntry.getName());
            ((File)object).getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            fileOutputStream.write(((ByteArrayOutputStream)object2).toByteArray());
            fileOutputStream.close();
        } else if (string4.equals("class")) {
            if (this.alreadyCached(string3, string, (ByteArrayOutputStream)object2)) {
                return;
            }
            this.byteCode.put(string3, new ByteCode(string3, jarEntry.getName(), (ByteArrayOutputStream)object2, string, manifest));
            this.VERBOSE("cached bytes for class " + string3);
        } else {
            object = string + "/" + string3;
            this.byteCode.put(object, new ByteCode((String)object, jarEntry.getName(), (ByteArrayOutputStream)object2, string, manifest));
            this.jarNames.add(string);
            this.VERBOSE("cached bytes for local name " + (String)object);
            if (this.alreadyCached(string3, string, (ByteArrayOutputStream)object2)) {
                return;
            }
            this.byteCode.put(string3, new ByteCode(string3, jarEntry.getName(), (ByteArrayOutputStream)object2, string, manifest));
            this.VERBOSE("cached bytes for entry name " + string3);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.externalClassLoader != null) {
            try {
                return this.externalClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((clazz = this.findLoadedClass(string)) != null) {
            return clazz;
        }
        this.VERBOSE("findClass(" + string + ")");
        String string2 = string + CLASS;
        ByteCode byteCode = (ByteCode)this.byteCode.get(string2);
        if (byteCode != null) {
            Object object;
            Object object2;
            ProtectionDomain protectionDomain;
            this.VERBOSE("found " + string + " in codebase '" + byteCode.codebase + "'");
            if (this.record) {
                this.record(byteCode);
            }
            if ((protectionDomain = (ProtectionDomain)this.pdCache.get(byteCode.codebase)) == null) {
                object2 = JarClassLoader.class.getProtectionDomain();
                URL uRL = ((ProtectionDomain)object2).getCodeSource().getLocation();
                try {
                    uRL = new URL("jar:" + uRL + "!/" + byteCode.codebase);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace(System.out);
                }
                object = new CodeSource(uRL, (Certificate[])null);
                protectionDomain = new ProtectionDomain((CodeSource)object, null, this, null);
                this.pdCache.put(byteCode.codebase, protectionDomain);
            }
            object2 = byteCode.bytes;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                object = string.substring(0, n);
                Package package_ = this.getPackage((String)object);
                Manifest manifest = byteCode.manifest;
                if (package_ != null) {
                    if (package_.isSealed()) {
                        if (!package_.isSealed()) {
                            throw new SecurityException("sealing violation: package " + (String)object + " is sealed");
                        }
                    } else if (manifest != null && this.isSealed((String)object, manifest)) {
                        throw new SecurityException("sealing violation: can't seal package " + (String)object + ": already loaded");
                    }
                } else if (manifest != null) {
                    this.definePackage((String)object, manifest);
                } else {
                    this.definePackage((String)object, null, null, null, null, null, null, null);
                }
            }
            return this.defineClass(string, (byte[])object2, protectionDomain);
        }
        this.VERBOSE(string + " not found");
        throw new ClassNotFoundException(string);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected Package definePackage(String string, Manifest manifest) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (string9 != null) {
            try {
                uRL = new URL(string9);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Error in " + Attributes.Name.SEALED + " manifest attribute: " + string9, malformedURLException);
            }
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL);
    }

    protected Class defineClass(String string, byte[] byArray, ProtectionDomain protectionDomain) throws ClassFormatError {
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    protected void record(ByteCode byteCode) {
        String string;
        File file = new File(this.recording, this.flatten ? "" : byteCode.codebase);
        File file2 = new File(file, string = byteCode.original);
        if (!file2.exists()) {
            file2.getParentFile().mkdirs();
            this.VERBOSE("" + file2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byteCode.bytes);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(this.PREFIX() + "unable to record " + file2 + ": " + iOException);
            }
        }
    }

    public InputStream getByteStream(String string) {
        InputStream inputStream = null;
        ByteCode byteCode = (ByteCode)this.byteCode.get(string);
        if (byteCode == null) {
            byteCode = (ByteCode)this.byteCode.get(this.resolve(string));
        }
        if (byteCode != null) {
            inputStream = new ByteArrayInputStream(byteCode.bytes);
        }
        if (inputStream == null && this.delegateToParent) {
            inputStream = ((JarClassLoader)this.getParent()).getByteStream(string);
        }
        this.VERBOSE("getByteStream(" + string + ") -> " + inputStream);
        return inputStream;
    }

    protected String resolve(String string) {
        String string2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.replace('/', '.');
        String string3 = null;
        String string4 = this.getCaller();
        ByteCode byteCode = (ByteCode)this.byteCode.get(string4 + CLASS);
        if (byteCode != null && this.byteCode.get(string2 = byteCode.codebase + "/" + string) != null) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = this.byteCode.get(string) == null ? null : string;
        }
        this.VERBOSE("resource " + string + " resolved to " + string3);
        return string3;
    }

    protected boolean alreadyCached(String string, String string2, ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteCode byteCode = (ByteCode)this.byteCode.get(string);
        if (byteCode != null) {
            if (!Arrays.equals(byteCode.bytes, byArray) && !string.startsWith("/META-INF")) {
                this.INFO(byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with different bytecode)");
            } else {
                this.VERBOSE(byteCode.name + " in " + string2 + " is hidden by " + byteCode.codebase + " (with same bytecode)");
            }
            return true;
        }
        return false;
    }

    protected String getCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (this.byteCode.get(stackTraceElementArray[i].getClassName() + CLASS) == null) continue;
            string = stackTraceElementArray[i].getClassName();
            break;
        }
        return string;
    }

    public void setRecording(String string) {
        this.recording = string;
        if (this.recording == null) {
            this.recording = RECORDING;
        }
    }

    public String getRecording() {
        return this.recording;
    }

    public void setRecord(boolean bl) {
        this.record = bl;
    }

    public boolean getRecord() {
        return this.record;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        if (this.verbose) {
            this.info = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public boolean getInfo() {
        return this.info;
    }

    protected URL findResource(String string) {
        try {
            this.INFO("findResource(" + string + ")");
            String string2 = this.resolve(string);
            if (string2 != null) {
                this.INFO("findResource() found: " + string);
                return new URL(Handler.PROTOCOL + ":" + string2);
            }
            this.INFO("findResource(): unable to locate " + string);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            this.WARNING("unable to locate " + string + " due to " + malformedURLException);
            return null;
        }
    }

    public Enumeration findResources(String string) throws IOException {
        Object object;
        this.INFO("findResources(" + string + ")");
        this.INFO("findResources: looking in " + this.jarNames);
        Iterator iterator = this.jarNames.iterator();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        string = string.replace('/', '.');
        while (iterator.hasNext()) {
            object = iterator.next().toString() + "/" + string;
            if (!this.byteCode.containsKey(object)) continue;
            arrayList.add(new URL(Handler.PROTOCOL + ":" + (String)object));
        }
        object = arrayList.iterator();
        return new Enumeration((Iterator)object){
            final /* synthetic */ Iterator val$ri;
            {
                this.val$ri = iterator;
            }

            public boolean hasMoreElements() {
                return this.val$ri.hasNext();
            }

            public Object nextElement() {
                return this.val$ri.next();
            }
        };
    }

    protected void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public String toString() {
        return super.toString() + (this.name != null ? "(" + this.name + ")" : "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setExpand(boolean bl) {
        this.noExpand = !bl;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected String findLibrary(String string) {
        String string2 = null;
        String string3 = BINLIB_PREFIX + System.mapLibraryName(string);
        if (this.binLibPath.get(string3) != null) {
            string2 = (String)this.binLibPath.get(string3);
        } else {
            try {
                int n = string3.lastIndexOf(46);
                String string4 = null;
                if (n >= 0) {
                    string4 = string3.substring(n);
                }
                InputStream inputStream = this.getClass().getResourceAsStream("/" + string3);
                File file = File.createTempFile(string + "-", string4);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.copy(inputStream, fileOutputStream);
                fileOutputStream.close();
                this.VERBOSE("Stored native library " + string + " at " + file);
                file.deleteOnExit();
                this.binLibPath.put(string3, file.getPath());
                string2 = file.getPath();
                if (string2 != null) {
                    this.VERBOSE("Found " + string2 + " in native binary library " + string3);
                }
            }
            catch (Throwable throwable) {
                this.WARNING("Unable to load native library: " + throwable);
            }
        }
        return string2;
    }

    protected String getConfirmation(File file) throws IOException {
        Closeable closeable;
        File file2 = new File(file, DOT_CONFIRM);
        String string = "";
        if (file2.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            string = bufferedReader.readLine();
            bufferedReader.close();
            this.PRINTLN("Previous confirmation for file expansion (" + string + ") was read from " + file2);
            return string;
        }
        while (string == null || !string.startsWith("n") && !string.startsWith("y") && !string.startsWith("q")) {
            this.promptForConfirm(file);
            closeable = new BufferedReader(new InputStreamReader(System.in));
            string = ((BufferedReader)closeable).readLine();
            ((BufferedReader)closeable).close();
        }
        try {
            closeable = new BufferedWriter(new FileWriter(file2));
            ((Writer)closeable).write(string + NL);
            ((BufferedWriter)closeable).close();
            this.PRINTLN("Your response has been stored in " + file2.getAbsolutePath() + ".  Please remove this file if you wish to change your mind.");
        }
        catch (IOException iOException) {
            this.WARNING("Unable to store confirmation response in " + file2.getAbsolutePath() + ": " + iOException);
        }
        return string;
    }

    protected void promptForConfirm(File file) {
        this.PRINTLN("Do you want to allow '" + Boot.getMyJarName() + "' to expand files into the file-system at the following location?");
        this.PRINTLN("  " + file);
        this.PRINT("Answer y(es) to expand files, n(o) to continue without expanding, or q(uit) to exit: ");
    }

    static {
        String string = System.getProperty(JAVA_PROTOCOL_HANDLER);
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            string = "|" + string;
        }
        string = "com.simontuffs" + string;
        System.setProperty(JAVA_PROTOCOL_HANDLER, string);
    }

    protected static class ByteCode {
        public byte[] bytes;
        public String name;
        public String original;
        public String codebase;
        public Manifest manifest;

        public ByteCode(String string, String string2, ByteArrayOutputStream byteArrayOutputStream, String string3, Manifest manifest) {
            this.name = string;
            this.original = string2;
            this.bytes = byteArrayOutputStream.toByteArray();
            this.codebase = string3;
            this.manifest = manifest;
        }
    }
}

