/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.JarClassLoader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Boot {
    public static final String BOOT_CLASS = "Boot-Class";
    public static final String ONE_JAR_CLASSLOADER = "One-Jar-Class-Loader";
    public static final String ONE_JAR_MAIN_CLASS = "One-Jar-Main-Class";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_JAR = "main/main.jar";
    public static final String WRAP_CLASS_LOADER = "Wrap-Class-Loader";
    public static final String WRAP_DIR = "wrap";
    public static final String WRAP_JAR = "/wrap/wraploader.jar";
    public static final String PROPERTY_PREFIX = "one-jar.";
    public static final String P_MAIN_CLASS = "one-jar.main.class";
    public static final String P_RECORD = "one-jar.record";
    public static final String P_JARNAMES = "one-jar.jar.names";
    public static final String P_VERBOSE = "one-jar.verbose";
    public static final String P_INFO = "one-jar.info";
    public static final String P_STATISTICS = "one-jar.statistics";
    public static final String P_SHOW_PROPERTIES = "one-jar.show.properties";
    public static final String P_JARPATH = "one-jar.jar.path";
    public static final String P_ONE_JAR_CLASS_PATH = "one-jar.class.path";
    public static final String P_JAVA_CLASS_PATH = "java.class.path";
    public static final String P_PATH_SEPARATOR = "|";
    public static final String P_EXPAND_DIR = "one-jar.expand.dir";
    public static final String HELP = "--one-jar-help";
    public static final String VERSION = "--one-jar-version";
    public static final String[] HELP_PROPERTIES = new String[]{"one-jar.main.class", "Specifies the name of the class which should be executed \n(via public static void main(String[])", "one-jar.record", "true:  Enables recording of the classes loaded by the application", "one-jar.jar.names", "true:  Recorded classes are kept in directories corresponding to their jar names.\nfalse: Recorded classes are flattened into a single directory.  \nDuplicates are ignored (first wins)", "one-jar.verbose", "true:  Print verbose classloading information", "one-jar.info", "true:  Print informative classloading information", "one-jar.statistics", "true:  Shows statistics about the One-Jar Classloader", "one-jar.jar.path", "Full path of the one-jar file being executed.  \nOnly needed if java.class.path does not contain the path to the jar, e.g. on Max OS/X.", "one-jar.class.path", "Extra classpaths to be added to the execution environment.  \nUse platform independent path separator '|'", "one-jar.expand.dir", "Directory to use for expanded files.", "one-jar.show.properties", "true:  Shows the JVM system properties."};
    public static final String[] HELP_ARGUMENTS = new String[]{"--one-jar-help", "Shows this message, then exits.", "--one-jar-version", "Shows the version of One-JAR, then exits."};
    protected static boolean info;
    protected static boolean verbose;
    protected static boolean statistics;
    protected static String myJarPath;
    protected static long startTime;
    protected static long endTime;
    private static JarClassLoader loader;

    public static synchronized JarClassLoader getClassLoader() {
        return loader;
    }

    public static synchronized void setClassLoader(JarClassLoader jarClassLoader) {
        if (loader != null) {
            throw new RuntimeException("Attempt to set a second Boot loader");
        }
        loader = jarClassLoader;
        Boot.setProperties(loader);
    }

    protected static void VERBOSE(String string) {
        if (verbose) {
            System.out.println("Boot: " + string);
        }
    }

    protected static void WARNING(String string) {
        System.err.println("Boot: Warning: " + string);
    }

    protected static void INFO(String string) {
        if (info) {
            System.out.println("Boot: Info: " + string);
        }
    }

    protected static void PRINTLN(String string) {
        System.out.println("Boot: " + string);
    }

    public static void main(String[] stringArray) throws Exception {
        Boot.run(stringArray);
    }

    public static void run(String[] stringArray) throws Exception {
        Object object;
        Class<?> clazz;
        Object object2;
        Object object3;
        String string;
        Boot.processArgs(stringArray);
        String string2 = null;
        Object object4 = new Properties();
        Object[] objectArray = "/one-jar.properties";
        InputStream inputStream = Boot.class.getResourceAsStream((String)objectArray);
        if (inputStream != null) {
            Boot.INFO("loading properties from " + (String)objectArray);
            ((Properties)object4).load(inputStream);
        }
        if ((inputStream = Boot.class.getResourceAsStream((String)(objectArray = "file:one-jar.properties"))) != null) {
            Boot.INFO("loading properties from " + (String)objectArray);
            ((Properties)object4).load(inputStream);
        }
        Object object5 = ((Properties)object4).propertyNames();
        while (object5.hasMoreElements()) {
            string = (String)object5.nextElement();
            if (System.getProperty(string) != null) continue;
            System.setProperty(string, ((Properties)object4).getProperty(string));
        }
        if (Boolean.valueOf(System.getProperty(P_SHOW_PROPERTIES, "false")).booleanValue()) {
            object4 = System.getProperties();
            objectArray = ((Properties)object4).keySet().toArray(new String[0]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                object5 = objectArray[i];
                System.out.println((String)object5 + "=" + ((Properties)object4).get(object5));
            }
        }
        string2 = System.getProperty(P_MAIN_CLASS);
        object4 = Boot.getMyJarPath();
        objectArray = new JarFile((String)object4);
        Manifest manifest = objectArray.getManifest();
        object5 = manifest.getMainAttributes();
        string = ((Attributes)object5).getValue(ONE_JAR_CLASSLOADER);
        if (string2 == null && (string2 = ((Attributes)object5).getValue(ONE_JAR_MAIN_CLASS)) == null && (string2 = ((Attributes)object5).getValue(BOOT_CLASS)) != null) {
            Boot.WARNING("The manifest attribute Boot-Class is deprecated in favor of the attribute One-Jar-Main-Class");
        }
        if (string2 == null) {
            object3 = Boot.class.getResourceAsStream("/main/main.jar");
            if (object3 != null) {
                object2 = new JarInputStream((InputStream)object3);
                clazz = ((JarInputStream)object2).getManifest();
                ((ZipInputStream)object2).close();
                string2 = ((Manifest)((Object)clazz)).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            } else {
                Boot.WARNING("Unable to locate main/main.jar in the JAR file " + Boot.getMyJarPath());
            }
        }
        if ((object3 = Boot.class.getResource(WRAP_JAR)) != null) {
            object2 = Boot.getBootLoader(string);
            Boot.setProperties((IProperties)object2);
            ((JarClassLoader)object2).load(null);
            clazz = Boot.class.getResourceAsStream(WRAP_JAR);
            if (clazz != null) {
                object = new JarInputStream((InputStream)((Object)clazz));
                String string3 = ((JarInputStream)object).getManifest().getMainAttributes().getValue(WRAP_CLASS_LOADER);
                ((ZipInputStream)object).close();
                if (string3 == null) {
                    Boot.WARNING(object3 + " did not contain a " + WRAP_CLASS_LOADER + " attribute, unable to load wrapping classloader");
                } else {
                    Boot.INFO("using " + string3);
                    JarClassLoader jarClassLoader = Boot.getWrapLoader((ClassLoader)object2, string3);
                    if (jarClassLoader == null) {
                        Boot.WARNING("Unable to instantiate " + string3 + " from " + WRAP_DIR + ": using default JarClassLoader");
                        jarClassLoader = Boot.getBootLoader(null);
                    }
                    Boot.setClassLoader(jarClassLoader);
                }
            }
        } else {
            Boot.setClassLoader(Boot.getBootLoader(string, Boot.class.getClassLoader()));
            Boot.INFO("using JarClassLoader: " + Boot.getClassLoader().getClass().getName());
        }
        Boot.setProperties(loader);
        string2 = loader.load(string2);
        if (string2 == null && !loader.isExpanded()) {
            throw new Exception(Boot.getMyJarName() + " main class was not found (fix: add main/main.jar with a Main-Class manifest attribute, or specify -D" + P_MAIN_CLASS + "=<your.class.name>), or use " + ONE_JAR_MAIN_CLASS + " in the manifest");
        }
        if (string2 != null) {
            object2 = Boot.class.getName();
            if (((String)object2).equals(string2)) {
                throw new Exception(Boot.getMyJarName() + " main class (" + string2 + ") would cause infinite recursion: check main.jar/META-INF/MANIFEST.MF/Main-Class attribute: " + string2);
            }
            Thread.currentThread().setContextClassLoader(loader);
            clazz = loader.loadClass(string2);
            endTime = System.currentTimeMillis();
            Boot.showTime();
            object = clazz.getMethod("main", String[].class);
            ((Method)object).invoke(null, new Object[]{stringArray});
        }
    }

    public static void showTime() {
        long l = System.currentTimeMillis();
        if (statistics) {
            Boot.PRINTLN("Elapsed time: " + (l - startTime) + "ms");
        }
    }

    public static void setProperties(IProperties iProperties) {
        Boot.INFO("setProperties(" + iProperties + ")");
        if (Boot.getProperty(P_RECORD)) {
            iProperties.setRecord(true);
            iProperties.setRecording(System.getProperty(P_RECORD));
        }
        if (Boot.getProperty(P_JARNAMES)) {
            iProperties.setRecord(true);
            iProperties.setFlatten(false);
        }
        if (Boot.getProperty(P_VERBOSE)) {
            iProperties.setVerbose(true);
            iProperties.setInfo(true);
            verbose = true;
        }
        if (Boot.getProperty(P_INFO)) {
            iProperties.setInfo(true);
            info = true;
        }
        statistics = Boot.getProperty(P_STATISTICS);
    }

    public static boolean getProperty(String string) {
        return Boolean.valueOf(System.getProperty(string, "false"));
    }

    public static String getMyJarName() {
        String string = Boot.getMyJarPath();
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getMyJarPath() {
        if (myJarPath != null) {
            return myJarPath;
        }
        myJarPath = System.getProperty(P_JARPATH);
        if (myJarPath == null) {
            try {
                String string = System.getProperty(P_JAVA_CLASS_PATH);
                String[] stringArray = string.split(System.getProperty("path.separator"));
                for (int i = 0; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    Boot.VERBOSE("Checking " + string + " as One-Jar file");
                    InputStream inputStream = null;
                    try {
                        inputStream = new URL(string).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            inputStream = new FileInputStream(string);
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    ZipEntry zipEntry = Boot.findJarEntry(new JarInputStream(inputStream), Boot.class.getName().replace('.', '/') + ".class");
                    if (zipEntry != null) {
                        myJarPath = string;
                    } else {
                        zipEntry = Boot.findZipEntry(new ZipFile(string), Boot.class.getName().replace('.', '/') + ".class");
                        if (zipEntry == null) continue;
                        myJarPath = string;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Boot.WARNING("jar=" + myJarPath + " loaded from " + P_JAVA_CLASS_PATH + " (" + System.getProperty(P_JAVA_CLASS_PATH) + ")");
            }
        }
        if (myJarPath == null) {
            throw new IllegalArgumentException("Unable to locate " + Boot.class.getName() + " in the java.class.path: consider using -D" + P_JARPATH + " to specify the one-jar filename.");
        }
        myJarPath = myJarPath.replace('\\', '/');
        return myJarPath;
    }

    public static JarEntry findJarEntry(JarInputStream jarInputStream, String string) throws IOException {
        JarEntry jarEntry;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (!jarEntry.getName().equals(string)) continue;
            return jarEntry;
        }
        return null;
    }

    public static ZipEntry findZipEntry(ZipFile zipFile, String string) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            Boot.VERBOSE("findZipEntry(): entry=" + zipEntry.getName());
            if (!zipEntry.getName().equals(string)) continue;
            return zipEntry;
        }
        return null;
    }

    public static int firstWidth(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        return n;
    }

    public static String pad(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        for (int i = 0; i < n - string2.length(); ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String wrap(String string, String string2, int n) {
        String string3 = Boot.pad(string, "", n);
        string2 = string2.replaceAll("\n", "\n" + string3);
        return string2;
    }

    public static void processArgs(String[] stringArray) throws Exception {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        if (hashSet.contains(HELP)) {
            int n;
            int n2 = Boot.firstWidth(HELP_ARGUMENTS);
            System.out.println("One-Jar uses the following command-line arguments");
            for (n = 0; n < HELP_ARGUMENTS.length; ++n) {
                System.out.print(Boot.pad("    ", HELP_ARGUMENTS[n++], n2 + 1));
                System.out.println(Boot.wrap("    ", HELP_ARGUMENTS[n], n2 + 1));
            }
            System.out.println();
            n2 = Boot.firstWidth(HELP_PROPERTIES);
            System.out.println("One-Jar uses the following VM properties (-D<property>=<true|false|string>)");
            for (n = 0; n < HELP_PROPERTIES.length; ++n) {
                System.out.print(Boot.pad("    ", HELP_PROPERTIES[n++], n2 + 1));
                System.out.println(Boot.wrap("    ", HELP_PROPERTIES[n], n2 + 1));
            }
            System.out.println();
            System.exit(0);
        } else if (hashSet.contains(VERSION)) {
            InputStream inputStream = Boot.class.getResourceAsStream("/.version");
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                System.out.println("One-JAR version " + string);
            } else {
                System.out.println("Unable to determine One-JAR version (missing /.version resource in One-JAR archive)");
            }
            System.exit(0);
        }
    }

    protected static JarClassLoader getBootLoader(final String string) {
        JarClassLoader jarClassLoader = (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        Constructor<?> constructor = clazz.getConstructor(String.class);
                        return constructor.newInstance(Boot.WRAP_DIR);
                    }
                    catch (Exception exception) {
                        Boot.WARNING("Unable to instantiate " + string + ": " + exception + " continuing using default " + JarClassLoader.class.getName());
                    }
                }
                return new JarClassLoader(Boot.WRAP_DIR);
            }
        });
        return jarClassLoader;
    }

    protected static JarClassLoader getBootLoader(final String string, ClassLoader classLoader) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        Constructor<?> constructor = clazz.getConstructor(ClassLoader.class);
                        return constructor.newInstance(Boot.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        Boot.WARNING("Unable to instantiate " + string + ": " + exception + " continuing using default " + JarClassLoader.class.getName());
                    }
                }
                return new JarClassLoader(Boot.class.getClassLoader());
            }
        });
    }

    protected static JarClassLoader getWrapLoader(final ClassLoader classLoader, final String string) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Constructor<?> constructor = clazz.getConstructor(ClassLoader.class);
                    return constructor.newInstance(classLoader);
                }
                catch (Throwable throwable) {
                    Boot.WARNING(throwable.toString());
                    return null;
                }
            }
        });
    }

    public static long getEndTime() {
        return endTime;
    }

    public static long getStartTime() {
        return startTime;
    }

    static {
        startTime = System.currentTimeMillis();
        endTime = 0L;
        loader = null;
    }
}

