/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOUSE. See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not write to the Free Software
 * Foundation, inc., 59 Temple Place, Suite 330, Boston MA 02111-1307
 * USA
 */

package gui;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import j3d.*;

import javax.swing.event.*;
import javax.swing.filechooser.FileFilter;

import java.awt.image.*;
/**
 * Insert the type's description here.
 *
 * @author: Yuriy Mikhaylovskiy
 */

public class PostProcessor extends JPanel {
  String project;
  private boolean openGL;
  public static final String ver = "Post Processor";
  Hashtable db_node = new Hashtable();
  Hashtable db_node_tmp = new Hashtable();
  Hashtable db_element = new Hashtable();
  Hashtable db_element_type = new Hashtable();
  Hashtable db_displacements = new Hashtable();
  Hashtable db_strains = new Hashtable();
  Hashtable db_stresses = new Hashtable();
  private Properties ConfDB = new Properties();

  DefaultListModel model_show = new DefaultListModel();
  DefaultListModel model_hide = new DefaultListModel();

  JList Show_list = new JList(model_show);
  JList Hide_list = new JList(model_hide);

  String[][] db_graph_tmp;
  String db_graph_inf;
  String[] st_result = { "DISPLACEMENTS (I)","DISPLACEMENTS (X)","DISPLACEMENTS (Y)","DISPLACEMENTS (Z)","STRAINS (I)","STRAINS (X)","STRAINS (Y)","STRAINS (Z)","STRAINS (XY)","STRAINS (YZ)","STRAINS (XZ)","STRESSES (I)","STRESSES (X)","STRESSES (Y)","STRESSES (Z)","STRESSES (XY)","STRESSES (YZ)","STRESSES (XZ)" };
  //xx yy zz xy yz xz

  float maxdx,maxdy,maxdz,maxdi,maxex,maxey,maxez,maxexy,maxeyz,maxexz,maxsx,maxsy,maxsz,maxsxy,maxsyz,maxsxz,maxei,maxsi,
  mindx,mindy,mindz,mindi,minex,miney,minez,minexy,mineyz,minexz,minei,minsx,minsy,minsz,minsxy,minsyz,minsxz,minsi;
  float tfmax, tfmin;

  ImageIcon img_new = new ImageIcon(PostProcessor.class.getResource("new.gif"));
  ImageIcon img_open = new ImageIcon(PostProcessor.class.getResource("open.gif"));
  ImageIcon img_add = new ImageIcon(PostProcessor.class.getResource("add.gif"));
  ImageIcon img_save = new ImageIcon(PostProcessor.class.getResource("save.gif"));
  ImageIcon img_saveall = new ImageIcon(PostProcessor.class.getResource("saveall.gif"));
  ImageIcon img_zooma = new ImageIcon(PostProcessor.class.getResource("zooma.gif"));
  ImageIcon img_center = new ImageIcon(PreProcessor.class.getResource("center.png"));
  ImageIcon img_zoomin = new ImageIcon(PostProcessor.class.getResource("zoomin.gif"));
  ImageIcon img_zoomout = new ImageIcon(PostProcessor.class.getResource("zoomout.gif"));
  ImageIcon img_show = new ImageIcon(PreProcessor.class.getResource("show.png"));
  ImageIcon img_hide = new ImageIcon(PreProcessor.class.getResource("hide.png"));
  ImageIcon img_view_top = new ImageIcon(PostProcessor.class.getResource("view_top.gif"));
  ImageIcon img_view_bottom = new ImageIcon(PostProcessor.class.getResource("view_bottom.gif"));
  ImageIcon img_view_left = new ImageIcon(PostProcessor.class.getResource("view_left.gif"));
  ImageIcon img_view_right = new ImageIcon(PostProcessor.class.getResource("view_right.gif"));
  ImageIcon img_view_front = new ImageIcon(PostProcessor.class.getResource("view_front.gif"));
  ImageIcon img_view_back = new ImageIcon(PostProcessor.class.getResource("view_back.gif"));
  ImageIcon img_view_sw = new ImageIcon(PostProcessor.class.getResource("view_sw.gif"));
  ImageIcon img_view_se = new ImageIcon(PostProcessor.class.getResource("view_se.gif"));
  ImageIcon img_view_ne = new ImageIcon(PostProcessor.class.getResource("view_ne.gif"));
  ImageIcon img_view_nw = new ImageIcon(PostProcessor.class.getResource("view_nw.gif"));
  ImageIcon img_gradient = new ImageIcon(PostProcessor.class.getResource("gradient.gif"));

  BufferedImage bi_grad;

  JTextField tf_deformed = new JTextField();
  JTextField tf_max = new JTextField();
  JTextField tf_min = new JTextField();

  JPanel jPanel2 = new JPanel();
  JPanel jPanel3 = new JPanel();
  JPanel jPanel5 = new JPanel();
  JPanel jPanel7 = new JPanel();
  JPanel jPanel8 = new JPanel();
  JPanel jPanel9 = new JPanel();

  JButton b_viewbottom = new JButton();
  JButton b_viewtop = new JButton();
  JButton b_zoomout = new JButton();
  JButton b_zoomin = new JButton();
  JButton b_showhide = new JButton();
  JButton b_zooma = new JButton();
  JButton b_center = new JButton();
  JButton b_open = new JButton();
  JButton b_viewleft = new JButton();
  JButton b_saveall = new JButton();
  JButton b_save = new JButton();

  JCheckBox cb_conturfill = new JCheckBox();
  JCheckBox cb_element = new JCheckBox();
  JCheckBox cb_deformed = new JCheckBox();
  JComboBox cb_result = new JComboBox(st_result);
  JCheckBox cb_node = new JCheckBox();
  JCheckBox cb_gradient = new JCheckBox();
  JCheckBox cb_gradientresult = new JCheckBox();
  JCheckBox cb_mesh = new JCheckBox();

  JScrollPane jScrollPane1 = new JScrollPane();

  JList time_step = new JList();

  JToolBar jToolBar1 = new JToolBar();

  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();

  Canvas3D J3D;

  GridLayout gridLayout1 = new GridLayout();

  JButton b_viewright = new JButton();
  JButton b_viewsw = new JButton();
  JButton b_viewse = new JButton();
  JButton b_viewne = new JButton();
  JButton b_viewnw = new JButton();
  JButton b_viewfront = new JButton();
  JButton b_viewback = new JButton();

  private boolean show = true;
  
  Hashtable db_element_hide = new Hashtable();
  

  public PostProcessor(boolean openGL) {
    this.openGL = openGL;  
      
    try { jbInit(); }catch(Exception e) { e.printStackTrace();}
  }
  private void jbInit() throws Exception {
    J3D = CanvasFactory.getCanvas(null,openGL);
    load_configuration();
    
    mindi = 0;
    minsi = 0;
    minei = 0;
      
    bi_grad = new BufferedImage(img_gradient.getIconWidth(), img_gradient.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
    Graphics2D big_grad = bi_grad.createGraphics();
    big_grad.drawImage(img_gradient.getImage(),0,0,this);
    jPanel7.setLayout(new BorderLayout());
    tf_deformed.setText("1");
    tf_deformed.setPreferredSize(new Dimension(30, 21));
    tf_deformed.setMinimumSize(new Dimension(30, 21));
    
    tf_max.setPreferredSize(new Dimension(70, 21));
    tf_min.setPreferredSize(new Dimension(70, 21));
    tf_max.setMinimumSize(new Dimension(30, 21));
    tf_min.setMinimumSize(new Dimension(30, 21));
    
    this.setLayout(new BorderLayout());
    //J3D.GRADIENTCOLOR=0;
    J3D.setGRIDMODE(false);
    J3D.setGRAPHICSMODE(Canvas3D.GRAPHICSMODE_SURFACE);
    b_viewbottom.setToolTipText("Bottom View");
    b_viewbottom.setIcon(img_view_bottom);
    b_viewbottom.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewbottom_actionPerformed(e);
      }
    });
    cb_conturfill.setSelected(true);
    cb_conturfill.setText("Contour fill");
    cb_conturfill.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    b_viewtop.setToolTipText("Top View");
    b_viewtop.setIcon(img_view_top);
    b_viewtop.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewtop_actionPerformed(e);
      }
    });

    b_zoomout.setToolTipText("Zoom out");
    b_zoomout.setIcon(img_zoomout);
    b_zoomout.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_zoomout_actionPerformed(e);
      }
    });
    b_zoomin.setToolTipText("Zoom in");
    b_zoomin.setIcon(img_zoomin);
    b_zoomin.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_zoomin_actionPerformed(e);
      }
    });
    b_showhide.setToolTipText("Hides or shows the selected objects. Press this without anything selected to switch view");
    b_showhide.setIcon(img_hide);
    b_showhide.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {

        b_showhide();
        
        if (show) b_showhide.setIcon(img_hide);
            else b_showhide.setIcon(img_show);
        
      }
    });
    jPanel3.setLayout(new BorderLayout());
    b_zooma.setToolTipText("Zoom All");
    b_zooma.setIcon(img_zooma);
    b_zooma.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
          J3D.view_all();
      }
    });
    b_center.setToolTipText("Set the selected object to center of rotation");
    b_center.setIcon(img_center);
    b_center.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        J3D.setCenterOfRotation();
      }
    });
    cb_element.setText("Elements label");
    cb_element.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    cb_deformed.setSelected(true);
    cb_deformed.setText("Deformed");
    cb_deformed.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    cb_node.setText("Nodes label");
    cb_node.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    jScrollPane1.setPreferredSize(new Dimension(26, 160));
    time_step.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        draw();
      }
    });
    b_open.setToolTipText("Open *.res");
    b_open.setIcon(img_open);
    b_open.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_open_actionPerformed(e);
      }
    });
    cb_mesh.setSelected(true);
    cb_mesh.setText("Mesh");
    cb_mesh.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    b_viewleft.setToolTipText("Left View");
    b_viewleft.setIcon(img_view_left);
    b_viewleft.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewleft_actionPerformed(e);
      }
    });
    b_saveall.setToolTipText("Save images");
    b_saveall.setIcon(img_saveall);
    b_saveall.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_saveall_actionPerformed(e);
      }
    });
    jToolBar1.setFloatable(false);
    b_save.setToolTipText("Save image");
    b_save.setIcon(img_save);
    b_save.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_save_actionPerformed(e);
      }
    });
    jLabel3.setText("Time step");
    J3D.setBackground(Color.white);
    J3D.setBackground(Color.white);
    jLabel2.setText("Result");
    jLabel1.setText("Show");
    cb_gradient.setText("Gradient");
    cb_gradient.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    b_viewright.setToolTipText("Right View");
    b_viewright.setIcon(img_view_right);
    b_viewright.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewright_actionPerformed(e);
      }
    });
    b_viewsw.setToolTipText("SW Isometric View");
    b_viewsw.setIcon(img_view_sw);
    b_viewsw.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewsw_actionPerformed(e);
      }
    });
    b_viewse.setToolTipText("SE Isometric View");
    b_viewse.setIcon(img_view_se);
    b_viewse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewse_actionPerformed(e);
      }
    });
    b_viewne.setToolTipText("NE Isometric View");
    b_viewne.setIcon(img_view_ne);
    b_viewne.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewne_actionPerformed(e);
      }
    });
    b_viewnw.setToolTipText("NW Isometric View");
    b_viewnw.setIcon(img_view_nw);
    b_viewnw.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewnw_actionPerformed(e);
      }
    });
    b_viewfront.setToolTipText("Front View");
    b_viewfront.setIcon(img_view_front);
    b_viewfront.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewfront_actionPerformed(e);
      }
    });
    b_viewback.setToolTipText("Back View");
    b_viewback.setIcon(img_view_back);
    b_viewback.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        b_viewback_actionPerformed(e);
      }
    });
    cb_gradientresult.setSelected(true);
    cb_gradientresult.setText("Gradient Result");
    cb_gradientresult.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        draw();
      }
    });
    cb_result.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
          
          switch (cb_result.getSelectedIndex()) {
          case 0:
              tf_max.setText("" + maxdi);
              tfmax = maxdi;
              tf_min.setText("" + mindi);
              tfmin = mindi;
              break;
          case 1:
              tf_max.setText("" + maxdx);
              tfmax = maxdx;
              tf_min.setText("" + mindx);
              tfmin = mindx;
              break;
          case 2:
              tf_max.setText("" + maxdy);
              tfmax = maxdy;
              tf_min.setText("" + mindy);
              tfmin = mindy;
              break;
          case 3:
              tf_max.setText("" + maxdz);
              tfmax = maxdz;
              tf_min.setText("" + mindz);
              tfmin = mindz;
              break;
          case 4:
              tf_max.setText("" + maxei);
              tfmax = maxei;
              tf_min.setText("" + minei);
              tfmin = minei;
              break;
          case 5:
              tf_max.setText("" + maxex);
              tfmax = maxex;
              tf_min.setText("" + minex);
              tfmin = minex;
              break;
          case 6:
              tf_max.setText("" + maxey);
              tfmax = maxey;
              tf_min.setText("" + miney);
              tfmin = miney;
              break;
          case 7:
              tf_max.setText("" + maxez);
              tfmax = maxez;
              tf_min.setText("" + minez);
              tfmin = minez;
              break;
          case 8:
              tf_max.setText("" + maxexy);
              tfmax = maxexy;
              tf_min.setText("" + minexy);
              tfmin = minexy;
              break;
          case 9:
              tf_max.setText("" + maxeyz);
              tfmax = maxeyz;
              tf_min.setText("" + mineyz);
              tfmin = mineyz;
              break;
          case 10:
              tf_max.setText("" + maxexz);
              tfmax = maxexz;
              tf_min.setText("" + minexz);
              tfmin = minexz;
              break;
          case 11:
              tf_max.setText("" + maxsi);
              tfmax = maxsi;
              tf_min.setText("" + minsi);
              tfmin = minsi;
              break;
          case 12:
              tf_max.setText("" + maxsx);
              tfmax = maxsx;
              tf_min.setText("" + minsx);
              tfmin = minsx;
              break;
          case 13:
              tf_max.setText("" + maxsy);
              tfmax = maxsy;
              tf_min.setText("" + minsy);
              tfmin = minsy;
              break;
          case 14:
              tf_max.setText("" + maxsz);
              tfmax = maxsz;
              tf_min.setText("" + minsz);
              tfmin = minsz;
              break;
          case 15:
              tf_max.setText("" + maxsxy);
              tfmax = maxsxy;
              tf_min.setText("" + minsxy);
              tfmin = minsxy;
              break;
          case 16:
              tf_max.setText("" + maxsyz);
              tfmax = maxsyz;
              tf_min.setText("" + minsyz);
              tfmin = minsyz;
              break;
          case 17:
              tf_max.setText("" + maxsxz);
              tfmax = maxsxz;
              tf_min.setText("" + minsxz);
              tfmin = minsxz;
              break;
          }
          
        draw();
      }
    });
    
    tf_max.addKeyListener(new java.awt.event.KeyAdapter() {
        public void keyPressed(KeyEvent e) {
          tf_max_keyPressed(e);
        }
      });
    tf_min.addKeyListener(new java.awt.event.KeyAdapter() {
        public void keyPressed(KeyEvent e) {
          tf_min_keyPressed(e);
        }
      });


    this.add(jPanel2, BorderLayout.CENTER);
    jPanel2.setLayout(new BorderLayout());

    if (J3D instanceof Canvas3DGL)
        jPanel2.add((Canvas)J3D, BorderLayout.CENTER);
    else
        jPanel2.add((JPanel)J3D, BorderLayout.CENTER);
    
    
    this.add(jPanel9, BorderLayout.NORTH);
    jPanel9.setLayout(new BorderLayout());
    jPanel9.add(jToolBar1,BorderLayout.WEST);
    jPanel9.add(jPanel8,BorderLayout.EAST);
    jPanel8.add(new JLabel("Min"), BorderLayout.WEST);
    jPanel8.add(tf_min, BorderLayout.WEST);
    jPanel8.add(new JLabel("Max"), BorderLayout.EAST);
    jPanel8.add(tf_max, BorderLayout.EAST);

    jToolBar1.add(b_open, null);
    jToolBar1.add(b_save, null);
    jToolBar1.add(b_saveall, null);
    jToolBar1.addSeparator();
    jToolBar1.add(b_showhide,null);
    jToolBar1.add(b_zoomin, null);
    jToolBar1.add(b_zoomout, null);
    jToolBar1.add(b_zooma, null);
    jToolBar1.add(b_center,null);
    jToolBar1.addSeparator();
    jToolBar1.add(b_viewtop, null);
    jToolBar1.add(b_viewbottom, null);
    jToolBar1.add(b_viewleft, null);
    jToolBar1.add(b_viewright, null);
    jToolBar1.add(b_viewfront, null);
    jToolBar1.add(b_viewback, null);
    jToolBar1.addSeparator();
    jToolBar1.add(b_viewsw, null);
    jToolBar1.add(b_viewse, null);
    jToolBar1.add(b_viewne, null);
    jToolBar1.add(b_viewnw, null);
    jToolBar1.addSeparator();

    this.add(jPanel3, BorderLayout.WEST);

    jPanel3.add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(time_step, null);

    jPanel3.add(jPanel5, BorderLayout.NORTH);
    jPanel5.setLayout(gridLayout1);
        gridLayout1.setRows(11);
    jPanel5.add(jLabel1, null);
    jPanel5.add(cb_mesh, null);
    jPanel5.add(jPanel7, null);
        jPanel7.add(cb_deformed, BorderLayout.CENTER);
        jPanel7.add(tf_deformed, BorderLayout.EAST);
    jPanel5.add(cb_conturfill, null);
    jPanel5.add(cb_gradient, null);
    jPanel5.add(cb_node, null);
    jPanel5.add(cb_element, null);
    jPanel5.add(cb_gradientresult, null);
    jPanel5.add(jLabel2, null);
    jPanel5.add(cb_result, null);
    jPanel5.add(jLabel3, null);
    
  }

  public void setVisible(boolean v){
      super.setVisible(v);
      
      if (J3D instanceof Canvas3DGL)
          J3D.setVisible(v);
  }
  
  
  public void error(Object st){
    JOptionPane.showMessageDialog(null,"Error: "+st,"Error!",JOptionPane.ERROR_MESSAGE);
    System.out.println("Error: "+st);
  }


  public void load(String st){
    try{
      //Rod_2 "Type100" ElemType Linear "MeshType100"
      //Beam_2 "Type110" ElemType Linear "MeshType110"
      //Beam_Spring_2,Contact_Line "Type120" ElemType Linear "MeshType120"
      //Contact_Triangle "Type420" ElemType Triangle "MeshType420"
      //Shell_C0_3 "Type210" ElemType Triangle "MeshType210"
      //Shell_BT_4 "Type300" ElemType Quadrilateral "MeshType300"
      //Solid_Iso_6 "Type500" ElemType Hexahedra "MeshType500"
      J3D.remove_all();
      time_step.removeAll();
      maxdx=maxdy=maxdz=maxdi=maxex=maxey=maxez=maxexy=maxeyz=maxexz=maxsx=maxsy=maxsz=maxsxy=maxsyz=maxsxz=maxei=maxsi=Float.MIN_VALUE;
      mindx=mindy=mindz=minex=miney=minez=minexy=mineyz=minexz=minsx=minsy=minsz=minsxy=minsyz=minsxz=Float.MAX_VALUE;
      db_node = new Hashtable();
      db_element = new Hashtable();
      db_element_type = new Hashtable();
      db_displacements = new Hashtable();
      db_strains = new Hashtable();
      db_stresses = new Hashtable();
      model_show.removeAllElements();
      model_hide.removeAllElements();
      DefaultListModel model = new DefaultListModel();
      String st_msh = st.substring(0,st.length()-3)+"msh";
      String st_dat = st;
      RandomAccessFile in = new RandomAccessFile(st_msh, "r");
      String dat;
      System.out.print("\nLoading mesh ...");
      while((dat=in.readLine())!=null){
        if(dat.startsWith("COORDINATES")){
          _Point p3d;
          while(!(dat=in.readLine()).startsWith("END")){
            StringTokenizer st_t = new StringTokenizer(dat);
            String index = st_t.nextToken();
            p3d = toPoint3d(dat);
            db_node.put(index,p3d);
          }
        }else if(dat.startsWith("ELEMENTS")){
          while(!(dat=in.readLine()).startsWith("END")){
            StringTokenizer st_t = new StringTokenizer(dat);
            String index = st_t.nextToken();
            int[] arr = toArrayInt(dat);
            db_element.put(index,arr);
            if(arr.length==2){
              J3D.add3D(new _Element2Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[1]+""),Color.black));
            }else if(arr.length==3){
              J3D.add3D(new _Element3Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[1]+""),(_Point)db_node.get(arr[2]+""),null,Color.black));
            }else if(arr.length==4){
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[1]+""),(_Point)db_node.get(arr[2]+""),(_Point)db_node.get(arr[3]+""),null,Color.black));
            }else  if(arr.length==8){
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[1]+""),(_Point)db_node.get(arr[2]+""),(_Point)db_node.get(arr[3]+""),null,Color.black));
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[4]+""),(_Point)db_node.get(arr[5]+""),(_Point)db_node.get(arr[6]+""),(_Point)db_node.get(arr[7]+""),null,Color.black));
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[1]+""),(_Point)db_node.get(arr[5]+""),(_Point)db_node.get(arr[4]+""),null,Color.black));
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[1]+""),(_Point)db_node.get(arr[2]+""),(_Point)db_node.get(arr[6]+""),(_Point)db_node.get(arr[5]+""),null,Color.black));
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[2]+""),(_Point)db_node.get(arr[3]+""),(_Point)db_node.get(arr[7]+""),(_Point)db_node.get(arr[6]+""),null,Color.black));
              J3D.add3D(new _Element4Post((_Point)db_node.get(arr[0]+""),(_Point)db_node.get(arr[3]+""),(_Point)db_node.get(arr[7]+""),(_Point)db_node.get(arr[4]+""),null,Color.black));
            }
            model_show.addElement(index);
          }
        }
      }
      in.close();
      in = new RandomAccessFile(st_dat, "r");
      System.out.print("... OK\nLoading data ...");
      dat=in.readLine();
      while(dat!=null){
        headerMessage(dat);
        //System.out.println(dat);
        if(dat.toUpperCase().startsWith("GAUSSPOINTS")){
          StringTokenizer st_t = new StringTokenizer(dat,"\"");
          st_t.nextToken();
          String et = st_t.nextToken();
          dat=in.readLine();
          st_t = new StringTokenizer(dat,":");
          st_t.nextToken();
          int np = Integer.parseInt(st_t.nextToken().trim());
          db_element_type.put(et,""+np);
          while(!(dat=in.readLine()).toUpperCase().startsWith("END")){  }
        }else if(dat.indexOf("DISPLACEMENTS")!=-1){
          StringTokenizer st_t = new StringTokenizer(dat.trim());
          st_t.nextToken();
          st_t.nextToken();
          String step = st_t.nextToken();
          model.addElement(step);
          Hashtable v = new Hashtable();
          while((dat=in.readLine())!=null && dat.indexOf("LOCAL")==-1 && dat.indexOf("GLOBAL")==-1){
            st_t = new StringTokenizer(dat);
            String key = st_t.nextToken();
            _Point p = toPoint3d(dat);
            mindx=Math.min(mindx,p.x);
            mindy=Math.min(mindy,p.y);
            mindz=Math.min(mindz,p.z);
            maxdx=Math.max(maxdx,p.x);
            maxdy=Math.max(maxdy,p.y);
            maxdz=Math.max(maxdz,p.z);
            maxdi=Math.max(maxdi,(float)Math.sqrt(p.x*p.x+p.y*p.y+p.z*p.z));
            v.put(key,p);
          }
          db_displacements.put(step,v);
        }else if(dat.indexOf("STRESSES")!=-1){
          StringTokenizer st_t = new StringTokenizer(dat.trim());
          st_t.nextToken();
          st_t.nextToken();
          String step = st_t.nextToken();
          Hashtable v = (Hashtable)db_stresses.get(step);
          if(v==null) v = new Hashtable();
          while((dat=in.readLine())!=null  && dat.indexOf("LOCAL")==-1 && dat.indexOf("GLOBAL")==-1 && dat.indexOf("DISPLACEMENTS")==-1){
            st_t = new StringTokenizer(dat);
            if(st_t.countTokens()==7){
              long pos = in.getFilePointer();
              String dat1=in.readLine();
              StringTokenizer st_t1=null;
              if(dat1!=null) st_t1 = new StringTokenizer(dat1);
              if(dat1==null || st_t1.countTokens()==7 || dat1.indexOf("LOCAL")!=-1 || dat1.indexOf("GLOBAL")!=-1 || dat1.indexOf("DISPLACEMENTS")!=-1){
                in.seek(pos);
              }else{
                dat+=" "+dat1+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine();
              }
            }
            String key = st_t.nextToken();
            float[] arr = toArrayFloat(dat);
            if(arr.length==1){
              minsx=Math.min(minsx,arr[0]);
              maxsx=Math.max(maxsx,arr[0]);
              maxsi=Math.max(maxsi,Math.abs(arr[0]));
            }else if(arr.length==6){
              minsx=Math.min(minsx,arr[0]);
              minsy=Math.min(minsy,arr[1]);
              minsz=Math.min(minsz,arr[2]);
              minsxy=Math.min(minsxy,arr[3]);
              minsyz=Math.min(minsyz,arr[4]);
              minsxz=Math.min(minsxz,arr[5]);
              maxsx=Math.max(maxsx,arr[0]);
              maxsy=Math.max(maxsy,arr[1]);
              maxsz=Math.max(maxsz,arr[2]);
              maxsxy=Math.max(maxsxy,arr[3]);
              maxsyz=Math.max(maxsyz,arr[4]);
              maxsxz=Math.max(maxsxz,arr[5]);
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[0]-arr[1],2)+Math.pow(arr[1]-arr[2],2)+Math.pow(arr[2]-arr[0],2)+6*(arr[3]*arr[3]+arr[4]*arr[4]+arr[5]*arr[5])));
            }else{
              minsx=Math.min(minsx,(arr[0]+arr[6]+arr[12]+arr[18]+arr[24]+arr[30]+arr[36]+arr[42])/8);
              minsy=Math.min(minsy,(arr[1]+arr[7]+arr[13]+arr[19]+arr[25]+arr[31]+arr[37]+arr[43])/8);
              minsz=Math.min(minsz,(arr[2]+arr[8]+arr[14]+arr[20]+arr[26]+arr[32]+arr[38]+arr[44])/8);
              minsxy=Math.min(minsxy,(arr[3]+arr[9]+arr[15]+arr[21]+arr[27]+arr[33]+arr[39]+arr[45])/8);
              minsyz=Math.min(minsyz,(arr[4]+arr[10]+arr[16]+arr[22]+arr[28]+arr[34]+arr[40]+arr[46])/8);
              minsxz=Math.min(minsxz,(arr[5]+arr[11]+arr[17]+arr[23]+arr[29]+arr[35]+arr[41]+arr[47])/8);
              maxsx=Math.max(maxsx,(arr[0]+arr[6]+arr[12]+arr[18]+arr[24]+arr[30]+arr[36]+arr[42])/8);
              maxsy=Math.max(maxsy,(arr[1]+arr[7]+arr[13]+arr[19]+arr[25]+arr[31]+arr[37]+arr[43])/8);
              maxsz=Math.max(maxsz,(arr[2]+arr[8]+arr[14]+arr[20]+arr[26]+arr[32]+arr[38]+arr[44])/8);
              maxsxy=Math.max(maxsxy,(arr[3]+arr[9]+arr[15]+arr[21]+arr[27]+arr[33]+arr[39]+arr[45])/8);
              maxsyz=Math.max(maxsyz,(arr[4]+arr[10]+arr[16]+arr[22]+arr[28]+arr[34]+arr[40]+arr[46])/8);
              maxsxz=Math.max(maxsxz,(arr[5]+arr[11]+arr[17]+arr[23]+arr[29]+arr[35]+arr[41]+arr[47])/8);
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[0]-arr[1],2)+Math.pow(arr[1]-arr[2],2)+Math.pow(arr[2]-arr[0],2)+6*(arr[3]*arr[3]+arr[4]*arr[4]+arr[5]*arr[5])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[6]-arr[7],2)+Math.pow(arr[7]-arr[8],2)+Math.pow(arr[8]-arr[6],2)+6*(arr[9]*arr[9]+arr[10]*arr[10]+arr[11]*arr[11])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[12]-arr[13],2)+Math.pow(arr[13]-arr[14],2)+Math.pow(arr[14]-arr[12],2)+6*(arr[15]*arr[15]+arr[16]*arr[16]+arr[17]*arr[17])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[18]-arr[19],2)+Math.pow(arr[19]-arr[20],2)+Math.pow(arr[20]-arr[18],2)+6*(arr[21]*arr[21]+arr[22]*arr[22]+arr[23]*arr[23])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[24]-arr[25],2)+Math.pow(arr[25]-arr[26],2)+Math.pow(arr[26]-arr[24],2)+6*(arr[27]*arr[27]+arr[28]*arr[28]+arr[29]*arr[29])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[30]-arr[31],2)+Math.pow(arr[31]-arr[32],2)+Math.pow(arr[32]-arr[30],2)+6*(arr[33]*arr[33]+arr[34]*arr[34]+arr[35]*arr[35])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[36]-arr[37],2)+Math.pow(arr[36]-arr[38],2)+Math.pow(arr[38]-arr[36],2)+6*(arr[39]*arr[39]+arr[40]*arr[40]+arr[41]*arr[41])));
              maxsi=(float)Math.max(maxsi,Math.sqrt(2)/2*Math.sqrt(Math.pow(arr[42]-arr[43],2)+Math.pow(arr[43]-arr[44],2)+Math.pow(arr[44]-arr[42],2)+6*(arr[45]*arr[45]+arr[46]*arr[46]+arr[47]*arr[47])));
            }
            v.put(key,arr);
          }
          db_stresses.put(step,v);
        }else if(dat.indexOf("STRAINS")!=-1){
          StringTokenizer st_t = new StringTokenizer(dat.trim());
          st_t.nextToken();
          st_t.nextToken();
          String step = st_t.nextToken();
          Hashtable v = (Hashtable)db_strains.get(step);
          if(v==null) v = new Hashtable();
          while((dat=in.readLine())!=null  && dat.indexOf("LOCAL")==-1 && dat.indexOf("GLOBAL")==-1 && dat.indexOf("DISPLACEMENTS")==-1){
            st_t = new StringTokenizer(dat);
            if(st_t.countTokens()==7){
              long pos = in.getFilePointer();
              String dat1=in.readLine();
              StringTokenizer st_t1=null;
              if(dat1!=null) st_t1 = new StringTokenizer(dat1);
              if(dat1==null || st_t1.countTokens()==7 || dat1.indexOf("LOCAL")!=-1 || dat1.indexOf("GLOBAL")!=-1 || dat1.indexOf("DISPLACEMENTS")!=-1){
                in.seek(pos);
              }else{
                dat+=" "+dat1+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine()+" "+in.readLine();
              }
            }
            String key = st_t.nextToken();
            float[] arr = toArrayFloat(dat);
            if(arr.length==1){
              minex=Math.min(minex,arr[0]);
              maxex=Math.max(maxex,arr[0]);
              maxei=Math.max(maxei,Math.abs(arr[0]));
            }else if(arr.length==6){
              minex=Math.min(minex,arr[0]);
              miney=Math.min(miney,arr[1]);
              minez=Math.min(minez,arr[2]);
              minexy=Math.min(minexy,arr[3]);
              mineyz=Math.min(mineyz,arr[4]);
              minexz=Math.min(minexz,arr[5]);
              maxex=Math.max(maxex,arr[0]);
              maxey=Math.max(maxey,arr[1]);
              maxez=Math.max(maxez,arr[2]);
              maxexy=Math.max(maxexy,arr[3]);
              maxeyz=Math.max(maxeyz,arr[4]);
              maxexz=Math.max(maxexz,arr[5]);
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[0]-arr[1],2)+Math.pow(arr[1]-arr[2],2)+Math.pow(arr[2]-arr[0],2)+1.5*(arr[3]*arr[3]+arr[4]*arr[4]+arr[5]*arr[5])));
            }else{
              minex=Math.min(minex,(arr[0]+arr[6]+arr[12]+arr[18]+arr[24]+arr[30]+arr[36]+arr[42])/8);
              miney=Math.min(miney,(arr[1]+arr[7]+arr[13]+arr[19]+arr[25]+arr[31]+arr[37]+arr[43])/8);
              minez=Math.min(minez,(arr[2]+arr[8]+arr[14]+arr[20]+arr[26]+arr[32]+arr[38]+arr[44])/8);
              minexy=Math.min(minexy,(arr[3]+arr[9]+arr[15]+arr[21]+arr[27]+arr[33]+arr[39]+arr[45])/8);
              mineyz=Math.min(mineyz,(arr[4]+arr[10]+arr[16]+arr[22]+arr[28]+arr[34]+arr[40]+arr[46])/8);
              minexz=Math.min(minexz,(arr[5]+arr[11]+arr[17]+arr[23]+arr[29]+arr[35]+arr[41]+arr[47])/8);
              maxex=Math.max(maxex,(arr[0]+arr[6]+arr[12]+arr[18]+arr[24]+arr[30]+arr[36]+arr[42])/8);
              maxey=Math.max(maxey,(arr[1]+arr[7]+arr[13]+arr[19]+arr[25]+arr[31]+arr[37]+arr[43])/8);
              maxez=Math.max(maxez,(arr[2]+arr[8]+arr[14]+arr[20]+arr[26]+arr[32]+arr[38]+arr[44])/8);
              maxexy=Math.max(maxexy,(arr[3]+arr[9]+arr[15]+arr[21]+arr[27]+arr[33]+arr[39]+arr[45])/8);
              maxeyz=Math.max(maxeyz,(arr[4]+arr[10]+arr[16]+arr[22]+arr[28]+arr[34]+arr[40]+arr[46])/8);
              maxexz=Math.max(maxexz,(arr[5]+arr[11]+arr[17]+arr[23]+arr[29]+arr[35]+arr[41]+arr[47])/8);
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[0]-arr[1],2)+Math.pow(arr[1]-arr[2],2)+Math.pow(arr[2]-arr[0],2)+1.5*(arr[3]*arr[3]+arr[4]*arr[4]+arr[5]*arr[5])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[6]-arr[7],2)+Math.pow(arr[7]-arr[8],2)+Math.pow(arr[8]-arr[6],2)+1.5*(arr[9]*arr[9]+arr[10]*arr[10]+arr[11]*arr[11])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[12]-arr[13],2)+Math.pow(arr[13]-arr[14],2)+Math.pow(arr[14]-arr[12],2)+1.5*(arr[15]*arr[15]+arr[16]*arr[16]+arr[17]*arr[17])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[18]-arr[19],2)+Math.pow(arr[19]-arr[20],2)+Math.pow(arr[20]-arr[18],2)+1.5*(arr[21]*arr[21]+arr[22]*arr[22]+arr[23]*arr[23])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[24]-arr[25],2)+Math.pow(arr[25]-arr[26],2)+Math.pow(arr[26]-arr[24],2)+1.5*(arr[27]*arr[27]+arr[28]*arr[28]+arr[29]*arr[29])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[30]-arr[31],2)+Math.pow(arr[31]-arr[32],2)+Math.pow(arr[32]-arr[30],2)+1.5*(arr[33]*arr[33]+arr[34]*arr[34]+arr[35]*arr[35])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[36]-arr[37],2)+Math.pow(arr[36]-arr[38],2)+Math.pow(arr[38]-arr[36],2)+1.5*(arr[39]*arr[39]+arr[40]*arr[40]+arr[41]*arr[41])));
              maxei=(float)Math.max(maxei,Math.sqrt(2)/3*Math.sqrt(Math.pow(arr[42]-arr[43],2)+Math.pow(arr[43]-arr[44],2)+Math.pow(arr[44]-arr[42],2)+1.5*(arr[45]*arr[45]+arr[46]*arr[46]+arr[47]*arr[47])));
            }
            v.put(key,arr);
          }
          db_strains.put(step,v);
        }else dat=in.readLine();
      }
      in.close();
      System.out.print("... OK\n");
      headerMessage(ver+"   "+project);
      try{
        time_step.setModel(model);
      } catch(Exception e2){}

//    Set initial state    
      tf_max.setText("" + maxdi);
      tfmax = maxdi;
      tf_min.setText("" + mindi);
      tfmin = mindi;
      
      time_step.setSelectedIndex(0);
      
      J3D.repaint();
    } catch(Exception e1) {error(e1);}

  }

  public _Point toPoint3d(String st)throws Exception{
    StringTokenizer st_t = new StringTokenizer(st);
    st_t.nextToken();
    return new _Point(new Float(st_t.nextToken()).floatValue(),new Float(st_t.nextToken()).floatValue(),new Float(st_t.nextToken()).floatValue(),Color.red);
  }
  public int[] toArrayInt(String st)throws Exception{
    StringTokenizer st_t = new StringTokenizer(st);
    int[] arr = new int[st_t.countTokens()-1];
    st_t.nextToken();
    for(int i=0; i<arr.length; i++){
      arr[i]= Integer.parseInt(st_t.nextToken());
    }
    return arr;
  }
  public float[] toArrayFloat(String st)throws Exception{
    StringTokenizer st_t = new StringTokenizer(st);
    float[] arr = new float[st_t.countTokens()-1];
    st_t.nextToken();
    for(int i=0; i<arr.length; i++){
      arr[i]= Float.parseFloat(st_t.nextToken());
    }
    return arr;
  }
  public void message(Object obj){
    Frame f = getFrame(this);
    f.setTitle(""+obj);
  }

  public Color getGradient(float min, float val, float max){
    int d = Math.round((val-min)/(max-min)*256);
    if(d>255)d=255;
    if(d<0)d=0;
    return new Color(bi_grad.getRGB(0,d));
  }
  public void draw(){
      
    _Element2Post el2;
    _Element3Post el3;
    _Element4Post el4;
      
    if(time_step.getModel().getSize()==0)return;
    J3D.setGRAPHICSMODE(Canvas3D.GRAPHICSMODE_SURFACE);
    if(cb_gradient.isSelected()) J3D.setRENDERMODE(Canvas3D.RENDERMODE_RENDER); else J3D.setRENDERMODE(Canvas3D.RENDERMODE_SHADE);
    if(!cb_mesh.isSelected() && cb_conturfill.isSelected()) J3D.setGRAPHICSMODE(Canvas3D.GRAPHICSMODE_SOLID);
    if(cb_mesh.isSelected() && !cb_conturfill.isSelected()) J3D.setGRAPHICSMODE(Canvas3D.GRAPHICSMODE_WIREFRAME);
    if(!cb_mesh.isSelected() && !cb_conturfill.isSelected())J3D.setGRAPHICSMODE(Canvas3D.GRAPHICSMODE_NADA);
    float kd = 1;
    if(cb_deformed.isSelected())
      try{kd=Float.parseFloat(tf_deformed.getText());}catch(Exception e){error("Factor of deformation - "+e);}
      else kd=0;
    J3D.remove_all();
//    for(int i=0; i<model_hide.size(); i++) db_element_hide.put(model_hide.elementAt(i)+"","");
    String time = time_step.getSelectedValue()+"";
    //Show nodes
    if(cb_node.isSelected()){
        Hashtable db_node_tmp = (Hashtable)db_displacements.get(time);
        for(Enumeration en = db_node_tmp.keys(); en.hasMoreElements();){
          String key = en.nextElement()+"";
          _Point p1 = (_Point)db_node.get(key);
          _Point p2 = (_Point)db_node_tmp.get(key);
          J3D.add3D(new _OrientedText(key,(p1.x+p2.x*kd),(p1.y+p2.y*kd),(p1.z+p2.z*kd)));
        }
    }
    
    //Show elements
    if(cb_element.isSelected()){
      Hashtable db_node_tmp = (Hashtable)db_displacements.get(time);
      Hashtable db_stresses_tmp = (Hashtable)db_stresses.get(time);
      for(Enumeration en = db_stresses_tmp.keys(); en.hasMoreElements();){
        String key = en.nextElement()+"";

        if(show == true && db_element_hide.containsKey(key))continue;
        if(show == false && db_element_hide.containsKey(key) == false)continue;

        int[] arr = (int[])db_element.get(key);
        float x=0,y=0,z=0;
        for(int i=0; i<arr.length; i++){
          _Point p = (_Point)db_node.get(arr[i]+"");
          _Point pt = (_Point)db_node_tmp.get(arr[i]+"");
          x+=p.x+pt.x*kd;
          y+=p.y+pt.y*kd;
          z+=p.z+pt.z*kd;
        }
        x/=arr.length;
        y/=arr.length;
        z/=arr.length;
        J3D.add3D(new _OrientedText(key,x,y,z));
      }
    }
    //DISPLACEMENTS (I)
    if(cb_result.getSelectedIndex()<4){
      Hashtable db_node_tmp = (Hashtable)db_displacements.get(time);
      Hashtable db_stresses_tmp = (Hashtable)db_stresses.get(time);
      for(Enumeration en = db_stresses_tmp.keys(); en.hasMoreElements();){
        String key = en.nextElement()+"";

        if(show == true && db_element_hide.containsKey(key))continue;
        if(show == false && db_element_hide.containsKey(key) == false)continue;

        int[] arr = (int[])db_element.get(key);
        if(arr.length==2){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          if(cb_result.getSelectedIndex()==0){
            el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(0,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z))/2,maxdi));
            J3D.add3D(el2);
            el2.set_Id(key);
            J3D.add3D(new _Point(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi)));
            J3D.add3D(new _Point(x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi)));
          }else if(cb_result.getSelectedIndex()==1){
            el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(mindx,(p21.x+p22.x)/2,maxdx));
            J3D.add3D(el2);
            el2.set_Id(key);
            J3D.add3D(new _Point(x1,y1,z1,getGradient(mindx,p21.x,maxdx)));
            J3D.add3D(new _Point(x2,y2,z2,getGradient(mindx,p22.x,maxdx)));
          }else if(cb_result.getSelectedIndex()==2){
              el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(mindy,(p21.y+p22.y)/2,maxdy));
            J3D.add3D(el2);
            el2.set_Id(key);
            J3D.add3D(new _Point(x1,y1,z1,getGradient(mindy,p21.y,maxdy)));
            J3D.add3D(new _Point(x2,y2,z2,getGradient(mindy,p22.y,maxdy)));
          }else if(cb_result.getSelectedIndex()==3){
              el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(mindz,(p21.z+p22.z)/2,maxdz));
            J3D.add3D(el2);
            el2.set_Id(key);
            J3D.add3D(new _Point(x1,y1,z1,getGradient(mindz,p21.z,maxdz)));
            J3D.add3D(new _Point(x2,y2,z2,getGradient(mindz,p22.z,maxdz)));
          }
        }else if(arr.length==3){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          if(cb_result.getSelectedIndex()==0){
            el3 = new _Element3Post(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi),
                                    x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi),
                                    x3,y3,z3,getGradient(0,(float)Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z),maxdi),
                                    getGradient(0,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z)+Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z))/3,maxdi),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==1){
            el3 = new _Element3Post(x1,y1,z1,getGradient(mindx,p21.x,maxdx),
                                    x2,y2,z2,getGradient(mindx,p22.x,maxdx),
                                    x3,y3,z3,getGradient(mindx,p23.x,maxdx),
                                    getGradient(mindx,(p21.x+p22.x+p23.x)/3,maxdx),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==2){
            el3 = new _Element3Post(x1,y1,z1,getGradient(mindy,p21.y,maxdy),
                                    x2,y2,z2,getGradient(mindy,p22.y,maxdy),
                                    x3,y3,z3,getGradient(mindy,p23.y,maxdy),
                                    getGradient(mindy,(p21.y+p22.y+p23.y)/3,maxdy),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==3){
            el3 = new _Element3Post(x1,y1,z1,getGradient(mindz,p21.z,maxdz),
                                    x2,y2,z2,getGradient(mindz,p22.z,maxdz),
                                    x3,y3,z3,getGradient(mindz,p23.z,maxdz),
                                    getGradient(mindz,(p21.z+p22.z+p23.z)/3,maxdz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }
        }else if(arr.length==4){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          if(cb_result.getSelectedIndex()==0){
            el4 = new _Element4Post(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi),
                                x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi),
                                x3,y3,z3,getGradient(0,(float)Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z),maxdi),
                                x4,y4,z4,getGradient(0,(float)Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z),maxdi),
                                getGradient(0,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z)+Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z)+Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==1){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindx,p21.x,maxdx),
                                x2,y2,z2,getGradient(mindx,p22.x,maxdx),
                                x3,y3,z3,getGradient(mindx,p23.x,maxdx),
                                x4,y4,z4,getGradient(mindx,p24.x,maxdx),
                                getGradient(mindx,(p21.x+p22.x+p23.x+p24.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==2){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindy,p21.y,maxdy),
                                x2,y2,z2,getGradient(mindy,p22.y,maxdy),
                                x3,y3,z3,getGradient(mindy,p23.y,maxdy),
                                x4,y4,z4,getGradient(mindy,p24.y,maxdy),
                                getGradient(mindy,(p21.y+p22.y+p23.y+p24.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==3){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindz,p21.z,maxdz),
                                x2,y2,z2,getGradient(mindz,p22.z,maxdz),
                                x3,y3,z3,getGradient(mindz,p23.z,maxdz),
                                x4,y4,z4,getGradient(mindz,p24.z,maxdz),
                                getGradient(mindz,(p21.z+p22.z+p23.z+p24.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }
        }else if(arr.length==8){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p15 = (_Point)db_node.get(arr[4]+"");
          _Point p16 = (_Point)db_node.get(arr[5]+"");
          _Point p17 = (_Point)db_node.get(arr[6]+"");
          _Point p18 = (_Point)db_node.get(arr[7]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          _Point p25 = (_Point)db_node_tmp.get(arr[4]+"");
          _Point p26 = (_Point)db_node_tmp.get(arr[5]+"");
          _Point p27 = (_Point)db_node_tmp.get(arr[6]+"");
          _Point p28 = (_Point)db_node_tmp.get(arr[7]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float x5=p15.x+p25.x*kd;
          float x6=p16.x+p26.x*kd;
          float x7=p17.x+p27.x*kd;
          float x8=p18.x+p28.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float y5=p15.y+p25.y*kd;
          float y6=p16.y+p26.y*kd;
          float y7=p17.y+p27.y*kd;
          float y8=p18.y+p28.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          float z5=p15.z+p25.z*kd;
          float z6=p16.z+p26.z*kd;
          float z7=p17.z+p27.z*kd;
          float z8=p18.z+p28.z*kd;
          if(cb_result.getSelectedIndex()==0){
            el4 = new _Element4Post(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi),
                                x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi),
                                x3,y3,z3,getGradient(0,(float)Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z),maxdi),
                                x4,y4,z4,getGradient(0,(float)Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z)+Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z)+Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x5,y5,z5,getGradient(0,(float)Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z),maxdi),
                                x6,y6,z6,getGradient(0,(float)Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z),maxdi),
                                x7,y7,z7,getGradient(0,(float)Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z),maxdi),
                                x8,y8,z8,getGradient(0,(float)Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z)+Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z)+Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z)+Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi),
                                x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi),
                                x6,y6,z6,getGradient(0,(float)Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z),maxdi),
                                x5,y5,z5,getGradient(0,(float)Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z)+Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z)+Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x4,y4,z4,getGradient(0,(float)Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z),maxdi),
                                x3,y3,z3,getGradient(0,(float)Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z),maxdi),
                                x7,y7,z7,getGradient(0,(float)Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z),maxdi),
                                x8,y8,z8,getGradient(0,(float)Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z)+Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z)+Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z)+Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x2,y2,z2,getGradient(0,(float)Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z),maxdi),
                                x3,y3,z3,getGradient(0,(float)Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z),maxdi),
                                x7,y7,z7,getGradient(0,(float)Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z),maxdi),
                                x6,y6,z6,getGradient(0,(float)Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p22.x*p22.x+p22.y*p22.y+p22.z*p22.z)+Math.sqrt(p23.x*p23.x+p23.y*p23.y+p23.z*p23.z)+Math.sqrt(p27.x*p27.x+p27.y*p27.y+p27.z*p27.z)+Math.sqrt(p26.x*p26.x+p26.y*p26.y+p26.z*p26.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(0,(float)Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z),maxdi),
                                x4,y4,z4,getGradient(0,(float)Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z),maxdi),
                                x8,y8,z8,getGradient(0,(float)Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z),maxdi),
                                x5,y5,z5,getGradient(0,(float)Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z),maxdi),
                                getGradient(mindi,(float)(Math.sqrt(p21.x*p21.x+p21.y*p21.y+p21.z*p21.z)+Math.sqrt(p24.x*p24.x+p24.y*p24.y+p24.z*p24.z)+Math.sqrt(p28.x*p28.x+p28.y*p28.y+p28.z*p28.z)+Math.sqrt(p25.x*p25.x+p25.y*p25.y+p25.z*p25.z))/4,maxdi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==1){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindx,p21.x,maxdx),
                                x2,y2,z2,getGradient(mindx,p22.x,maxdx),
                                x3,y3,z3,getGradient(mindx,p23.x,maxdx),
                                x4,y4,z4,getGradient(mindx,p24.x,maxdx),
                                getGradient(mindx,(p21.x+p22.x+p23.x+p24.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x5,y5,z5,getGradient(mindx,p25.x,maxdx),
                                x6,y6,z6,getGradient(mindx,p26.x,maxdx),
                                x7,y7,z7,getGradient(mindx,p27.x,maxdx),
                                x8,y8,z8,getGradient(mindx,p28.x,maxdx),
                                getGradient(mindx,(p25.x+p26.x+p27.x+p28.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindx,p21.x,maxdx),
                                x2,y2,z2,getGradient(mindx,p22.x,maxdx),
                                x6,y6,z6,getGradient(mindx,p26.x,maxdx),
                                x5,y5,z5,getGradient(mindx,p25.x,maxdx),
                                getGradient(mindx,(p21.x+p22.x+p26.x+p25.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x4,y4,z4,getGradient(mindx,p24.x,maxdx),
                                x3,y3,z3,getGradient(mindx,p23.x,maxdx),
                                x7,y7,z7,getGradient(mindx,p27.x,maxdx),
                                x8,y8,z8,getGradient(mindx,p28.x,maxdx),
                                getGradient(mindx,(p24.x+p23.x+p27.x+p28.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x2,y2,z2,getGradient(mindx,p22.x,maxdx),
                                x3,y3,z3,getGradient(mindx,p23.x,maxdx),
                                x7,y7,z7,getGradient(mindx,p27.x,maxdx),
                                x6,y6,z6,getGradient(mindx,p26.x,maxdx),
                                getGradient(mindx,(p22.x+p23.x+p27.x+p26.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindx,p21.x,maxdx),
                                x4,y4,z4,getGradient(mindx,p24.x,maxdx),
                                x8,y8,z8,getGradient(mindx,p28.x,maxdx),
                                x5,y5,z5,getGradient(mindx,p25.x,maxdx),
                                getGradient(mindx,(p21.x+p24.x+p28.x+p25.x)/4,maxdx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==2){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindy,p21.y,maxdy),
                                x2,y2,z2,getGradient(mindy,p22.y,maxdy),
                                x3,y3,z3,getGradient(mindy,p23.y,maxdy),
                                x4,y4,z4,getGradient(mindy,p24.y,maxdy),
                                getGradient(mindy,(p21.y+p22.y+p23.y+p24.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x5,y5,z5,getGradient(mindy,p25.y,maxdy),
                                x6,y6,z6,getGradient(mindy,p26.y,maxdy),
                                x7,y7,z7,getGradient(mindy,p27.y,maxdy),
                                x8,y8,z8,getGradient(mindy,p28.y,maxdy),
                                getGradient(mindy,(p25.y+p26.y+p27.y+p28.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindy,p21.y,maxdy),
                                x2,y2,z2,getGradient(mindy,p22.y,maxdy),
                                x6,y6,z6,getGradient(mindy,p26.y,maxdy),
                                x5,y5,z5,getGradient(mindy,p25.y,maxdy),
                                getGradient(mindy,(p21.y+p22.y+p26.y+p25.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x4,y4,z4,getGradient(mindy,p24.y,maxdy),
                                x3,y3,z3,getGradient(mindy,p23.y,maxdy),
                                x7,y7,z7,getGradient(mindy,p27.y,maxdy),
                                x8,y8,z8,getGradient(mindy,p28.y,maxdy),
                                getGradient(mindy,(p24.y+p23.y+p27.y+p28.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x2,y2,z2,getGradient(mindy,p22.y,maxdy),
                                x3,y3,z3,getGradient(mindy,p23.y,maxdy),
                                x7,y7,z7,getGradient(mindy,p27.y,maxdy),
                                x6,y6,z6,getGradient(mindy,p26.y,maxdy),
                                getGradient(mindy,(p22.y+p23.y+p27.y+p26.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindy,p21.y,maxdy),
                                x4,y4,z4,getGradient(mindy,p24.y,maxdy),
                                x8,y8,z8,getGradient(mindy,p28.y,maxdy),
                                x5,y5,z5,getGradient(mindy,p25.y,maxdy),
                                getGradient(mindy,(p21.y+p24.y+p28.y+p25.y)/4,maxdy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==3){
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindz,p21.z,maxdz),
                                x2,y2,z2,getGradient(mindz,p22.z,maxdz),
                                x3,y3,z3,getGradient(mindz,p23.z,maxdz),
                                x4,y4,z4,getGradient(mindz,p24.z,maxdz),
                                getGradient(mindz,(p21.z+p22.z+p23.z+p24.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x5,y5,z5,getGradient(mindz,p25.z,maxdz),
                                x6,y6,z6,getGradient(mindz,p26.z,maxdz),
                                x7,y7,z7,getGradient(mindz,p27.z,maxdz),
                                x8,y8,z8,getGradient(mindz,p28.z,maxdz),
                                getGradient(mindz,(p25.z+p26.z+p27.z+p28.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x1,y1,z1,getGradient(mindz,p21.z,maxdz),
                                x2,y2,z2,getGradient(mindz,p22.z,maxdz),
                                x6,y6,z6,getGradient(mindz,p26.z,maxdz),
                                x5,y5,z5,getGradient(mindz,p25.z,maxdz),
                                getGradient(mindz,(p21.z+p22.z+p26.z+p25.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x4,y4,z4,getGradient(mindz,p24.z,maxdz),
                                x3,y3,z3,getGradient(mindz,p23.z,maxdz),
                                x7,y7,z7,getGradient(mindz,p27.z,maxdz),
                                x8,y8,z8,getGradient(mindz,p28.z,maxdz),
                                getGradient(mindz,(p24.z+p23.z+p27.z+p28.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            el4 = new _Element4Post(x2,y2,z2,getGradient(mindz,p22.z,maxdz),
                                x3,y3,z3,getGradient(mindz,p23.z,maxdz),
                                x7,y7,z7,getGradient(mindz,p27.z,maxdz),
                                x6,y6,z6,getGradient(mindz,p26.z,maxdz),
                                getGradient(mindz,(p22.z+p23.z+p27.z+p26.z)/4,maxdz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
           el4 = new _Element4Post(x1,y1,z1,getGradient(mindz,p21.z,maxdz),
                                x4,y4,z4,getGradient(mindz,p24.z,maxdz),
                                x8,y8,z8,getGradient(mindz,p28.z,maxdz),
                                x5,y5,z5,getGradient(mindz,p25.z,maxdz),
                                getGradient(mindz,(p21.z+p24.z+p28.z+p25.z)/4,maxdz),Color.black);
           J3D.add3D(el4);
           el4.set_Id(key);
          }
        }
      }
    //STRAINS
    }else if(cb_result.getSelectedIndex()<11){
      Hashtable db_node_tmp = (Hashtable)db_displacements.get(time);
      Hashtable db_strains_tmp = (Hashtable)db_strains.get(time);
      for(Enumeration en = db_strains_tmp.keys(); en.hasMoreElements();){
        String key = en.nextElement()+"";

        if(show == true && db_element_hide.containsKey(key))continue;
        if(show == false && db_element_hide.containsKey(key) == false)continue;

        int[] arr = (int[])db_element.get(key);
        if(arr.length==2){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float[] ee = (float[])db_strains_tmp.get(key);
          if(cb_result.getSelectedIndex()==4 || cb_result.getSelectedIndex()==5){
            el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(minei,ee[0],maxei));
            J3D.add3D(el2);
            el2.set_Id(key);
            
          }else {
              el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,Color.black);
              J3D.add3D(el2);
              el2.set_Id(key);
          }
        }else if(arr.length==3){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float[] ee = (float[])db_strains_tmp.get(key);
          if(cb_result.getSelectedIndex()==4){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+1.5*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5]))),maxei),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==5){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minex,ee[0],maxex),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==6){
              el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(miney,ee[1],maxey),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==7){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minez,ee[2],maxez),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==8){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minexy,ee[3],maxexy),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==9){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(mineyz,ee[4],maxeyz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==10){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minexz,ee[5],maxexz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }
        }else if(arr.length==4){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          float[] ee = (float[])db_strains_tmp.get(key);
          if(cb_result.getSelectedIndex()==4){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+1.5*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5]))),maxei),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            }else if(cb_result.getSelectedIndex()==5){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(minex,ee[0],maxex),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            }else if(cb_result.getSelectedIndex()==6){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(miney,ee[1],maxey),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            }else if(cb_result.getSelectedIndex()==7){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(minez,ee[2],maxez),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            }else if(cb_result.getSelectedIndex()==8){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(minexy,ee[3],maxexy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
            }else if(cb_result.getSelectedIndex()==9){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(mineyz,ee[4],maxeyz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==10){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,this.getGradient(minexz,ee[5],maxexz),Color.black);
          }
        }else if(arr.length==8){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p15 = (_Point)db_node.get(arr[4]+"");
          _Point p16 = (_Point)db_node.get(arr[5]+"");
          _Point p17 = (_Point)db_node.get(arr[6]+"");
          _Point p18 = (_Point)db_node.get(arr[7]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          _Point p25 = (_Point)db_node_tmp.get(arr[4]+"");
          _Point p26 = (_Point)db_node_tmp.get(arr[5]+"");
          _Point p27 = (_Point)db_node_tmp.get(arr[6]+"");
          _Point p28 = (_Point)db_node_tmp.get(arr[7]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float x5=p15.x+p25.x*kd;
          float x6=p16.x+p26.x*kd;
          float x7=p17.x+p27.x*kd;
          float x8=p18.x+p28.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float y5=p15.y+p25.y*kd;
          float y6=p16.y+p26.y*kd;
          float y7=p17.y+p27.y*kd;
          float y8=p18.y+p28.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          float z5=p15.z+p25.z*kd;
          float z6=p16.z+p26.z*kd;
          float z7=p17.z+p27.z*kd;
          float z8=p18.z+p28.z*kd;
          float[] ee = (float[])db_strains_tmp.get(key);
          if(cb_result.getSelectedIndex()==4){
            if(ee.length==6){
              float ss = (float)(Math.sqrt(2)/3*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+1.5*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5])));
              Color fill = getGradient(0,ss,maxei);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow((ee[0]+ee[6]+ee[12]+ee[18])/4-(ee[1]+ee[7]+ee[13]+ee[19])/4,2)+Math.pow((ee[1]+ee[7]+ee[13]+ee[19])/4-(ee[2]+ee[8]+ee[14]+ee[20])/4,2)+Math.pow((ee[2]+ee[8]+ee[14]+ee[20])/4-(ee[0]+ee[6]+ee[12]+ee[18])/4,2)+1.5*((ee[3]+ee[9]+ee[15]+ee[21])/4*(ee[3]+ee[9]+ee[15]+ee[21])/4+(ee[4]+ee[10]+ee[16]+ee[22])/4*(ee[4]+ee[10]+ee[16]+ee[22])/4+(ee[5]+ee[11]+ee[17]+ee[23])/4*(ee[5]+ee[11]+ee[17]+ee[23])/4))),maxei),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow((ee[24]+ee[30]+ee[36]+ee[42])/4-(ee[25]+ee[31]+ee[37]+ee[43])/4,2)+Math.pow((ee[25]+ee[31]+ee[37]+ee[43])/4-(ee[26]+ee[32]+ee[38]+ee[44])/4,2)+Math.pow((ee[26]+ee[32]+ee[38]+ee[44])/4-(ee[24]+ee[30]+ee[36]+ee[42])/4,2)+1.5*((ee[27]+ee[33]+ee[39]+ee[45])/4*(ee[27]+ee[33]+ee[39]+ee[45])/4+(ee[28]+ee[34]+ee[40]+ee[46])/4*(ee[28]+ee[34]+ee[40]+ee[46])/4+(ee[29]+ee[35]+ee[41]+ee[47])/4*(ee[29]+ee[35]+ee[41]+ee[47])/4))),maxei),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow((ee[18]+ee[12]+ee[36]+ee[42])/4-(ee[19]+ee[13]+ee[37]+ee[43])/4,2)+Math.pow((ee[19]+ee[13]+ee[37]+ee[43])/4-(ee[20]+ee[14]+ee[38]+ee[44])/4,2)+Math.pow((ee[20]+ee[14]+ee[38]+ee[44])/4-(ee[18]+ee[12]+ee[36]+ee[42])/4,2)+1.5*((ee[21]+ee[15]+ee[39]+ee[45])/4*(ee[21]+ee[15]+ee[39]+ee[45])/4+(ee[22]+ee[16]+ee[40]+ee[46])/4*(ee[22]+ee[16]+ee[40]+ee[46])/4+(ee[23]+ee[17]+ee[41]+ee[47])/4*(ee[23]+ee[17]+ee[41]+ee[47])/4))),maxei),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow((ee[6]+ee[12]+ee[30]+ee[36])/4-(ee[7]+ee[13]+ee[31]+ee[37])/4,2)+Math.pow((ee[7]+ee[13]+ee[31]+ee[37])/4-(ee[8]+ee[14]+ee[32]+ee[38])/4,2)+Math.pow((ee[8]+ee[14]+ee[32]+ee[38])/4-(ee[6]+ee[12]+ee[30]+ee[36])/4,2)+1.5*((ee[9]+ee[15]+ee[33]+ee[39])/4*(ee[9]+ee[15]+ee[33]+ee[39])/4+(ee[10]+ee[16]+ee[34]+ee[40])/4*(ee[10]+ee[16]+ee[34]+ee[40])/4+(ee[11]+ee[17]+ee[35]+ee[41])/4*(ee[11]+ee[17]+ee[35]+ee[41])/4))),maxei),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minei,(float)(Math.sqrt(2)/3*Math.sqrt(Math.pow((ee[0]+ee[18]+ee[24]+ee[42])/4-(ee[1]+ee[19]+ee[25]+ee[43])/4,2)+Math.pow((ee[1]+ee[19]+ee[25]+ee[43])/4-(ee[2]+ee[20]+ee[26]+ee[44])/4,2)+Math.pow((ee[2]+ee[20]+ee[26]+ee[44])/4-(ee[0]+ee[18]+ee[24]+ee[42])/4,2)+1.5*((ee[3]+ee[21]+ee[27]+ee[45])/4*(ee[3]+ee[21]+ee[27]+ee[45])/4+(ee[4]+ee[22]+ee[28]+ee[46])/4*(ee[4]+ee[22]+ee[28]+ee[46])/4+(ee[5]+ee[23]+ee[29]+ee[47])/4*(ee[5]+ee[23]+ee[29]+ee[47])/4))),maxei),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==5){
            if(ee.length==6){
              Color fill = getGradient(minex,ee[0],maxex);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minex,(ee[0]+ee[6]+ee[12]+ee[18])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minex,(ee[24]+ee[30]+ee[36]+ee[42])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minex,(ee[0]+ee[6]+ee[30]+ee[24])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minex,(ee[18]+ee[12]+ee[36]+ee[42])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minex,(ee[6]+ee[12]+ee[30]+ee[36])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minex,(ee[0]+ee[18]+ee[24]+ee[42])/4,maxex),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==6){
            if(ee.length==6){
              Color fill = getGradient(miney,ee[1],maxey);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(miney,(ee[1]+ee[7]+ee[13]+ee[19])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(miney,(ee[25]+ee[31]+ee[37]+ee[43])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(miney,(ee[1]+ee[7]+ee[31]+ee[25])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(miney,(ee[19]+ee[13]+ee[37]+ee[43])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(miney,(ee[7]+ee[13]+ee[31]+ee[37])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(miney,(ee[1]+ee[19]+ee[25]+ee[43])/4,maxey),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==7){
            if(ee.length==6){
              Color fill = getGradient(minez,ee[2],maxez);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minez,(ee[2]+ee[8]+ee[14]+ee[20])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minez,(ee[26]+ee[32]+ee[38]+ee[44])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minez,(ee[2]+ee[8]+ee[32]+ee[26])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minez,(ee[20]+ee[14]+ee[38]+ee[44])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minez,(ee[8]+ee[14]+ee[32]+ee[38])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minez,(ee[2]+ee[20]+ee[26]+ee[44])/4,maxez),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==8){
            if(ee.length==6){
              Color fill = getGradient(minexy,ee[3],maxexy);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minexy,(ee[3]+ee[9]+ee[15]+ee[21])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minexy,(ee[27]+ee[33]+ee[39]+ee[45])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minexy,(ee[3]+ee[9]+ee[33]+ee[27])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minexy,(ee[21]+ee[15]+ee[39]+ee[45])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minexy,(ee[9]+ee[15]+ee[33]+ee[39])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minexy,(ee[3]+ee[21]+ee[27]+ee[45])/4,maxexy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==9){
            if(ee.length==6){
              Color fill = getGradient(mineyz,ee[4],maxeyz);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(mineyz,(ee[4]+ee[10]+ee[16]+ee[22])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(mineyz,(ee[28]+ee[34]+ee[40]+ee[46])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(mineyz,(ee[4]+ee[10]+ee[34]+ee[28])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(mineyz,(ee[22]+ee[16]+ee[40]+ee[46])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(mineyz,(ee[10]+ee[16]+ee[34]+ee[40])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(mineyz,(ee[4]+ee[22]+ee[28]+ee[46])/4,maxeyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==10){
            if(ee.length==6){
              Color fill = getGradient(minexz,ee[5],maxexz);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minexz,(ee[5]+ee[11]+ee[17]+ee[23])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minexz,(ee[29]+ee[35]+ee[41]+ee[47])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minexz,(ee[5]+ee[11]+ee[35]+ee[29])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minexz,(ee[23]+ee[17]+ee[41]+ee[47])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minexz,(ee[11]+ee[17]+ee[35]+ee[41])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minexz,(ee[5]+ee[23]+ee[29]+ee[47])/4,maxexz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }
        }
      }
    //STRESSES
    }else{
      Hashtable db_node_tmp = (Hashtable)db_displacements.get(time);
      Hashtable db_stresses_tmp = (Hashtable)db_stresses.get(time);
      for(Enumeration en = db_stresses_tmp.keys(); en.hasMoreElements();){
        String key = en.nextElement()+"";

        if(show == true && db_element_hide.containsKey(key))continue;
        if(show == false && db_element_hide.containsKey(key) == false)continue;

        int[] arr = (int[])db_element.get(key);
        if(arr.length==2){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float[] ee = (float[])db_stresses_tmp.get(key);
          if(cb_result.getSelectedIndex()==11 || cb_result.getSelectedIndex()==12){
            el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,getGradient(minsi,ee[0],maxsi));
            J3D.add3D(el2);
            el2.set_Id(key);
          }else {
          el2 = new _Element2Post(x1,y1,z1,x2,y2,z2,Color.black);
          J3D.add3D(el2);
          el2.set_Id(key);
          }
        }else if(arr.length==3){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float[] ee = (float[])db_stresses_tmp.get(key);
          if(cb_result.getSelectedIndex()==11){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+6*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5]))),maxsi),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==12){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsx,ee[0],maxsx),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==13){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsy,ee[1],maxsy),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==14){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsz,ee[2],maxsz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==15){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsxy,ee[3],maxsxy),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==16){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsyz,ee[4],maxsyz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }else if(cb_result.getSelectedIndex()==17){
            el3 = new _Element3Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,getGradient(minsxz,ee[5],maxsxz),Color.black);
            J3D.add3D(el3);
            el3.set_Id(key);
          }
        }else if(arr.length==4){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          float[] ee = (float[])db_stresses_tmp.get(key);
          if(cb_result.getSelectedIndex()==11){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+6*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5]))),maxsi),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==12){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsx,ee[0],maxsx),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==13){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsy,ee[1],maxsy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==14){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsz,ee[2],maxsz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==15){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsxy,ee[3],maxsxy),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==16){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsyz,ee[4],maxsyz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }else if(cb_result.getSelectedIndex()==17){
            el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsxz,ee[5],maxsxz),Color.black);
            J3D.add3D(el4);
            el4.set_Id(key);
          }
        }else if(arr.length==8){
          _Point p11 = (_Point)db_node.get(arr[0]+"");
          _Point p12 = (_Point)db_node.get(arr[1]+"");
          _Point p13 = (_Point)db_node.get(arr[2]+"");
          _Point p14 = (_Point)db_node.get(arr[3]+"");
          _Point p15 = (_Point)db_node.get(arr[4]+"");
          _Point p16 = (_Point)db_node.get(arr[5]+"");
          _Point p17 = (_Point)db_node.get(arr[6]+"");
          _Point p18 = (_Point)db_node.get(arr[7]+"");
          _Point p21 = (_Point)db_node_tmp.get(arr[0]+"");
          _Point p22 = (_Point)db_node_tmp.get(arr[1]+"");
          _Point p23 = (_Point)db_node_tmp.get(arr[2]+"");
          _Point p24 = (_Point)db_node_tmp.get(arr[3]+"");
          _Point p25 = (_Point)db_node_tmp.get(arr[4]+"");
          _Point p26 = (_Point)db_node_tmp.get(arr[5]+"");
          _Point p27 = (_Point)db_node_tmp.get(arr[6]+"");
          _Point p28 = (_Point)db_node_tmp.get(arr[7]+"");
          float x1=p11.x+p21.x*kd;
          float x2=p12.x+p22.x*kd;
          float x3=p13.x+p23.x*kd;
          float x4=p14.x+p24.x*kd;
          float x5=p15.x+p25.x*kd;
          float x6=p16.x+p26.x*kd;
          float x7=p17.x+p27.x*kd;
          float x8=p18.x+p28.x*kd;
          float y1=p11.y+p21.y*kd;
          float y2=p12.y+p22.y*kd;
          float y3=p13.y+p23.y*kd;
          float y4=p14.y+p24.y*kd;
          float y5=p15.y+p25.y*kd;
          float y6=p16.y+p26.y*kd;
          float y7=p17.y+p27.y*kd;
          float y8=p18.y+p28.y*kd;
          float z1=p11.z+p21.z*kd;
          float z2=p12.z+p22.z*kd;
          float z3=p13.z+p23.z*kd;
          float z4=p14.z+p24.z*kd;
          float z5=p15.z+p25.z*kd;
          float z6=p16.z+p26.z*kd;
          float z7=p17.z+p27.z*kd;
          float z8=p18.z+p28.z*kd;
          float[] ee = (float[])db_stresses_tmp.get(key);
          if(cb_result.getSelectedIndex()==11){
            if(ee.length==6){
              float ss = (float)(Math.sqrt(2)/2*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+6*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5])));
              Color fill = getGradient(0,ss,maxsi);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[0]+ee[6]+ee[12]+ee[18])/4-(ee[1]+ee[7]+ee[13]+ee[19])/4,2)+Math.pow((ee[1]+ee[7]+ee[13]+ee[19])/4-(ee[2]+ee[8]+ee[14]+ee[20])/4,2)+Math.pow((ee[2]+ee[8]+ee[14]+ee[20])/4-(ee[0]+ee[6]+ee[12]+ee[18])/4,2)+6*((ee[3]+ee[9]+ee[15]+ee[21])/4*(ee[3]+ee[9]+ee[15]+ee[21])/4+(ee[4]+ee[10]+ee[16]+ee[22])/4*(ee[4]+ee[10]+ee[16]+ee[22])/4+(ee[5]+ee[11]+ee[17]+ee[23])/4*(ee[5]+ee[11]+ee[17]+ee[23])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[24]+ee[30]+ee[36]+ee[42])/4-(ee[25]+ee[31]+ee[37]+ee[43])/4,2)+Math.pow((ee[25]+ee[31]+ee[37]+ee[43])/4-(ee[26]+ee[32]+ee[38]+ee[44])/4,2)+Math.pow((ee[26]+ee[32]+ee[38]+ee[44])/4-(ee[24]+ee[30]+ee[36]+ee[42])/4,2)+6*((ee[27]+ee[33]+ee[39]+ee[45])/4*(ee[27]+ee[33]+ee[39]+ee[45])/4+(ee[28]+ee[34]+ee[40]+ee[46])/4*(ee[28]+ee[34]+ee[40]+ee[46])/4+(ee[29]+ee[35]+ee[41]+ee[47])/4*(ee[29]+ee[35]+ee[41]+ee[47])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[0]+ee[6]+ee[30]+ee[24])/4-(ee[1]+ee[7]+ee[31]+ee[25])/4,2)+Math.pow((ee[1]+ee[7]+ee[31]+ee[25])/4-(ee[2]+ee[8]+ee[32]+ee[26])/4,2)+Math.pow((ee[2]+ee[8]+ee[32]+ee[26])/4-(ee[0]+ee[6]+ee[30]+ee[24])/4,2)+6*((ee[3]+ee[9]+ee[33]+ee[27])/4*(ee[3]+ee[9]+ee[33]+ee[27])/4+(ee[4]+ee[10]+ee[34]+ee[28])/4*(ee[4]+ee[10]+ee[34]+ee[28])/4+(ee[5]+ee[11]+ee[35]+ee[29])/4*(ee[5]+ee[11]+ee[35]+ee[29])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[18]+ee[12]+ee[36]+ee[42])/4-(ee[19]+ee[13]+ee[37]+ee[43])/4,2)+Math.pow((ee[19]+ee[13]+ee[37]+ee[43])/4-(ee[20]+ee[14]+ee[38]+ee[44])/4,2)+Math.pow((ee[20]+ee[14]+ee[38]+ee[44])/4-(ee[18]+ee[12]+ee[36]+ee[42])/4,2)+6*((ee[21]+ee[15]+ee[39]+ee[45])/4*(ee[21]+ee[15]+ee[39]+ee[45])/4+(ee[22]+ee[16]+ee[40]+ee[46])/4*(ee[22]+ee[16]+ee[40]+ee[46])/4+(ee[23]+ee[17]+ee[41]+ee[47])/4*(ee[23]+ee[17]+ee[41]+ee[47])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[6]+ee[12]+ee[30]+ee[36])/4-(ee[7]+ee[13]+ee[31]+ee[37])/4,2)+Math.pow((ee[7]+ee[13]+ee[31]+ee[37])/4-(ee[8]+ee[14]+ee[32]+ee[38])/4,2)+Math.pow((ee[8]+ee[14]+ee[32]+ee[38])/4-(ee[6]+ee[12]+ee[30]+ee[36])/4,2)+6*((ee[9]+ee[15]+ee[33]+ee[39])/4*(ee[9]+ee[15]+ee[33]+ee[39])/4+(ee[10]+ee[16]+ee[34]+ee[40])/4*(ee[10]+ee[16]+ee[34]+ee[40])/4+(ee[11]+ee[17]+ee[35]+ee[41])/4*(ee[11]+ee[17]+ee[35]+ee[41])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsi,(float)(Math.sqrt(2)/2*Math.sqrt(Math.pow((ee[0]+ee[18]+ee[24]+ee[42])/4-(ee[1]+ee[19]+ee[25]+ee[43])/4,2)+Math.pow((ee[1]+ee[19]+ee[25]+ee[43])/4-(ee[2]+ee[20]+ee[26]+ee[44])/4,2)+Math.pow((ee[2]+ee[20]+ee[26]+ee[44])/4-(ee[0]+ee[18]+ee[24]+ee[42])/4,2)+6*((ee[3]+ee[21]+ee[27]+ee[45])/4*(ee[3]+ee[21]+ee[27]+ee[45])/4+(ee[4]+ee[22]+ee[28]+ee[46])/4*(ee[4]+ee[22]+ee[28]+ee[46])/4+(ee[5]+ee[23]+ee[29]+ee[47])/4*(ee[5]+ee[23]+ee[29]+ee[47])/4))),maxsi),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==12){
            if(ee.length==6){
              Color fill = getGradient(minsx,ee[0],maxsx);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsx,(ee[0]+ee[6]+ee[12]+ee[18])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsx,(ee[24]+ee[30]+ee[36]+ee[42])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsx,(ee[0]+ee[6]+ee[30]+ee[24])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsx,(ee[18]+ee[12]+ee[36]+ee[42])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsx,(ee[6]+ee[12]+ee[30]+ee[36])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsx,(ee[0]+ee[18]+ee[24]+ee[42])/4,maxsx),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==13){
            if(ee.length==6){
              Color fill = getGradient(minsy,ee[1],maxsy);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsy,(ee[1]+ee[7]+ee[13]+ee[19])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsy,(ee[25]+ee[31]+ee[37]+ee[43])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsy,(ee[1]+ee[7]+ee[31]+ee[25])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsy,(ee[19]+ee[13]+ee[37]+ee[43])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsy,(ee[7]+ee[13]+ee[31]+ee[37])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsy,(ee[1]+ee[19]+ee[25]+ee[43])/4,maxsy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==14){
            if(ee.length==6){
              Color fill = getGradient(minsz,ee[2],maxsz);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsz,(ee[2]+ee[8]+ee[14]+ee[20])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsz,(ee[26]+ee[32]+ee[38]+ee[44])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsz,(ee[2]+ee[8]+ee[32]+ee[26])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsz,(ee[20]+ee[14]+ee[38]+ee[44])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsz,(ee[8]+ee[14]+ee[32]+ee[38])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsz,(ee[2]+ee[20]+ee[26]+ee[44])/4,maxsz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==15){
            if(ee.length==6){
              Color fill = getGradient(minsxy,ee[3],maxsxy);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsxy,(ee[3]+ee[9]+ee[15]+ee[21])/4,maxsxy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsxy,(ee[27]+ee[33]+ee[39]+ee[45])/4,maxsxy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsxy,(ee[3]+ee[9]+ee[33]+ee[27])/4,maxsxy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsxy,(ee[21]+ee[15]+ee[39]+ee[45])/4,maxsxy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsxy,(ee[9]+ee[15]+ee[33]+ee[39])/4,maxsxy),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsxy,(ee[3]+ee[21]+ee[27]+ee[45])/4,maxsxy),Color.black);
            }
          }else if(cb_result.getSelectedIndex()==16){
            if(ee.length==6){
              Color fill = getGradient(minsyz,ee[4],maxsyz);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsyz,(ee[4]+ee[10]+ee[16]+ee[22])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsyz,(ee[28]+ee[34]+ee[40]+ee[46])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsyz,(ee[4]+ee[10]+ee[34]+ee[28])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsyz,(ee[22]+ee[16]+ee[40]+ee[46])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsyz,(ee[10]+ee[16]+ee[34]+ee[40])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsyz,(ee[4]+ee[22]+ee[28]+ee[46])/4,maxsyz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }else if(cb_result.getSelectedIndex()==17){
            if(ee.length==6){
              Color fill = getGradient(minsxz,ee[5],maxsxz);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,fill,Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }else{
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,getGradient(minsxz,(ee[5]+ee[11]+ee[17]+ee[23])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x5,y5,z5,x6,y6,z6,x7,y7,z7,x8,y8,z8,getGradient(minsxz,(ee[29]+ee[35]+ee[41]+ee[47])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x2,y2,z2,x6,y6,z6,x5,y5,z5,getGradient(minsxz,(ee[5]+ee[11]+ee[35]+ee[29])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x4,y4,z4,x3,y3,z3,x7,y7,z7,x8,y8,z8,getGradient(minsxz,(ee[23]+ee[17]+ee[41]+ee[47])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x2,y2,z2,x3,y3,z3,x7,y7,z7,x6,y6,z6,getGradient(minsxz,(ee[11]+ee[17]+ee[35]+ee[41])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
              el4 = new _Element4Post(x1,y1,z1,x4,y4,z4,x8,y8,z8,x5,y5,z5,getGradient(minsxz,(ee[5]+ee[23]+ee[29]+ee[47])/4,maxsxz),Color.black);
              J3D.add3D(el4);
              el4.set_Id(key);
            }
          }
        }
      }
    }
    
    if(cb_gradientresult.isSelected()){
      BufferedImage image = (BufferedImage)createImage(130,290);
      Graphics g = image.getGraphics();
      float min = 0;
      float max = 0;
      if(cb_result.getSelectedIndex()==0){max=maxdi; min=mindi;}
      else if(cb_result.getSelectedIndex()==1){max=maxdx; min=mindx;}
      else if(cb_result.getSelectedIndex()==2){max=maxdy; min=mindy;}
      else if(cb_result.getSelectedIndex()==3){max=maxdz; min=mindz;}
      else if(cb_result.getSelectedIndex()==4){max=maxei; min=minei;}
      else if(cb_result.getSelectedIndex()==5){max=maxex; min=minex;}
      else if(cb_result.getSelectedIndex()==6){max=maxey; min=miney;}
      else if(cb_result.getSelectedIndex()==7){max=maxez; min=minez;}
      else if(cb_result.getSelectedIndex()==8){max=maxexy; min=minexy;}
      else if(cb_result.getSelectedIndex()==9){max=maxeyz; min=mineyz;}
      else if(cb_result.getSelectedIndex()==10){max=maxexz; min=minexz;}
      else if(cb_result.getSelectedIndex()==11){max=maxsi; min=minsi;}
      else if(cb_result.getSelectedIndex()==12){max=maxsx; min=minsx;}
      else if(cb_result.getSelectedIndex()==13){max=maxsy; min=minsy;}
      else if(cb_result.getSelectedIndex()==14){max=maxsz; min=minsz;}
      else if(cb_result.getSelectedIndex()==15){max=maxsxy; min=minsxy;}
      else if(cb_result.getSelectedIndex()==16){max=maxsyz; min=minsyz;}
      else if(cb_result.getSelectedIndex()==17){max=maxsxz; min=minsxz;}
      if(max<min)min=0;
      g.setColor(Color.white);
      g.fillRect(0,0,image.getWidth(),image.getHeight());
      g.setColor(Color.black);
      g.drawRect(0,0,image.getWidth()-1,image.getHeight()-1);
      g.drawString(cb_result.getSelectedItem()+"",5,15);
      for(int i=0; i<17; i++) g.drawString(""+(min+(max-min)/16*i),16,i*16+5+25);
      for(int i=5; i<15; i++) g.drawImage(img_gradient.getImage(),i,25,null);
      if (J3D instanceof Canvas3DGL)
          J3D.add3D(new _BgImage(image,((Canvas3DGL)J3D).getWidth()-135,5));
      else
          J3D.add3D(new _BgImage(image,((Canvas3DSW)J3D).getWidth()-135,5));
          
    }
    J3D.view_repaint();
  }
  public static Frame getFrame(Component component){
    for(; component != null && !(component instanceof Frame); component = component.getParent());
    return (Frame)component;
  }
  
  
  void b_showhide() {
  
      _Object[] obj = J3D.getSelectedObjects3D();

      if (obj.length != 0) {
          for (int i=0; i<obj.length; i++) 
              if (obj[i] instanceof _Element2Post || obj[i] instanceof _Element3Post || obj[i] instanceof _Element4Post) 
                  if (show)
                      db_element_hide.put(obj[i].get_Id()+"","");
                  else
                      db_element_hide.remove(obj[i].get_Id()+"");
      }
      else
          show = !show;
      
      J3D.clearSelectOnAllObjects3D();
      J3D.view_reset();
      J3D.view_repaint();
      draw();
  }
  
  
  
  
  
  void b_open_actionPerformed(ActionEvent e) {
      FileFilter f1 =  new FileFilter() {
          public boolean accept(File f) {
              if (f.isDirectory()) return true;
              return f.getName().toLowerCase().endsWith(".res");
          }
          
          public String getDescription() {
              return "Open solver result (.res)";
          }
      };
      
      JFileChooser fd = new JFileChooser(ConfDB.getProperty("Filepath"));
      fd.setSize(350,200);
      fd.addChoosableFileFilter(f1);  
      
      try {
          
          int choise = fd.showOpenDialog(this);
          
          if(choise == JFileChooser.APPROVE_OPTION && fd.getSelectedFile()!=null){
              String infile = fd.getSelectedFile().getAbsolutePath();
              
              if (fd.getFileFilter().equals(f1) || infile.toLowerCase().endsWith(".in")) 
                  load(infile);
          }
          
          // Update configuration file with path
          if (fd.getSelectedFile() != null) {
              ConfDB.setProperty("Filepath", fd.getSelectedFile().getAbsolutePath());
              save_configuration();
              header(fd.getSelectedFile().getName());
          }
          
    } catch(Exception e1) {error(e1);}
  }


  void db_graph_preparation(int Y, String nd_el) {
      String info=null;
      String[][] arr = new String[time_step.getModel().getSize()][2];
      switch(Y){
        case 0://DISPLACEMENTS (I)
        info="#The results are from node: "+nd_el+"\n#X: time   Y: displacement in direction (I)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_displacements.get(arr[i][0]);
          _Point p3d = (_Point)ht.get(nd_el);
          arr[i][1]=Math.sqrt(p3d.x*p3d.x+p3d.y*p3d.y+p3d.z*p3d.z)+"";
        }
        break;
        case 1://DISPLACEMENTS (X)
        info="#The results are from node: "+nd_el+"\n#X: time   Y: displacement in direction (X)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_displacements.get(arr[i][0]);
          _Point p3d = (_Point)ht.get(nd_el);
          arr[i][1]=p3d.x+"";
        }
        break;
        case 2://DISPLACEMENTS (Y)
        info="#The results are from node: "+nd_el+"\n#X: time   Y: displacement in direction (Y)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_displacements.get(arr[i][0]);
          _Point p3d = (_Point)ht.get(nd_el);
          arr[i][1]=p3d.y+"";
        }
        break;
        case 3://DISPLACEMENTS (Z)
        info="#The results are from node: "+nd_el+"\n#X: time   Y: displacement in direction (Z)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_displacements.get(arr[i][0]);
          _Point p3d = (_Point)ht.get(nd_el);
          arr[i][1]=p3d.z+"";
        }
        break;
        case 4://STRAINS (I)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (I)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{
            arr[i][1]=(Math.sqrt(2)/3*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+1.5*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5])))+"";
          }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 5://STRAINS (X)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (X)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[0]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 6://STRAINS (Y)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (Y)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[1]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 7://STRAINS (Z)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (Z)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[2]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 8://STRAINS (XY)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (XY)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[3]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 9://STRAINS (YZ)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (YZ)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[4]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 10://STRAINS (XZ)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: strain in direction (XZ)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_strains.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[5]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 11://STRESSES (I)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (I)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{
            arr[i][1]=(Math.sqrt(2)/2*Math.sqrt(Math.pow(ee[0]-ee[1],2)+Math.pow(ee[1]-ee[2],2)+Math.pow(ee[2]-ee[0],2)+6*(ee[3]*ee[3]+ee[4]*ee[4]+ee[5]*ee[5])))+"";
          }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 12://STRESSES (X)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (X)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[0]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 13://STRESSES (Y)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (Y)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[1]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 14://STRESSES (Z)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (Z)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[2]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 15://STRESSES (XY)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (XY)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[3]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 16://STRESSES (YZ)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (YZ)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[4]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        case 17://STRESSES (XZ)
        info="#The results are from element: "+nd_el+"\n#X: time   Y: stress in direction (XZ)";
        for(int i=0; i<arr.length; i++){
          arr[i][0]=time_step.getModel().getElementAt(i)+"";
          Hashtable ht = (Hashtable)db_stresses.get(arr[i][0]);
          float[] ee = (float[])ht.get(nd_el);
          try{ arr[i][1]=ee[5]+""; }catch(Exception e1){arr[i][1]="";}
        }
        break;
        default: break;
      }
      db_graph_tmp=arr;
      db_graph_inf=info;
  }


  void b_save_actionPerformed(ActionEvent e) {
      FileFilter f1 = new FileFilter() {
          public boolean accept(File f) {
              if (f.isDirectory()) return true;
              return f.getName().toLowerCase().endsWith(".png");
          }
          
          public String getDescription() {
              return "Picture of result (.png)";
          }
      };
      
      try {
          
          JFileChooser fd = new JFileChooser(ConfDB.getProperty("Filepath"));
          fd.setSize(350,200);
          fd.addChoosableFileFilter(f1);  
          
          int choise = fd.showSaveDialog(this);
          
          if(choise == JFileChooser.APPROVE_OPTION && fd.getSelectedFile()!=null){
              String st = fd.getSelectedFile().getAbsolutePath();
              
              if (fd.getFileFilter().equals(f1)) {
                  if(!st.toLowerCase().endsWith(".png"))st+=".png";
                  J3D.save_Image(st);
              }
          }
          
          // Update configuration file with path
          if (fd.getSelectedFile() != null) {
              ConfDB.setProperty("Filepath", fd.getSelectedFile().getAbsolutePath());
              save_configuration();
              header(fd.getSelectedFile().getName());
          }
          
      } catch(Exception e1) {error(e1);}
  }

  void time_step_valueChanged(ListSelectionEvent e) {

  }

  void b_zoomin_actionPerformed(ActionEvent e) {
    J3D.view_scale(1.2f);
  }

  void b_zoomout_actionPerformed(ActionEvent e) {
    J3D.view_scale(0.8f);
  }

  void b_viewtop_actionPerformed(ActionEvent e) {
    J3D.view_top();
  }

  void b_viewbottom_actionPerformed(ActionEvent e) {
    J3D.view_bottom();
  }

  void b_viewsw_actionPerformed(ActionEvent e) {
    J3D.view_sw();
  }

  void b_viewse_actionPerformed(ActionEvent e) {
    J3D.view_se();
  }

  void b_viewne_actionPerformed(ActionEvent e) {
    J3D.view_ne();
  }

  void b_viewnw_actionPerformed(ActionEvent e) {
    J3D.view_nw();
  }

  void b_viewleft_actionPerformed(ActionEvent e) {
    J3D.view_left();
  }

  void b_viewright_actionPerformed(ActionEvent e) {
    J3D.view_right();
  }

  void b_viewfront_actionPerformed(ActionEvent e) {
    J3D.view_front();
  }

  void b_viewback_actionPerformed(ActionEvent e) {
    J3D.view_back();
  }

  void b_saveall_actionPerformed(ActionEvent e) {
      FileFilter f1 = new FileFilter() {
          public boolean accept(File f) {
              if (f.isDirectory()) return true;
              return f.getName().toLowerCase().endsWith(".png");
          }
          
          public String getDescription() {
              return "Picture of result (.png)";
          }
      };
      
      try {
          
          JFileChooser fd = new JFileChooser(ConfDB.getProperty("Filepath"));
          fd.setSize(350,200);
          fd.addChoosableFileFilter(f1);  
          
          int choise = fd.showSaveDialog(this);
          
          if(choise == JFileChooser.APPROVE_OPTION && fd.getSelectedFile()!=null){
              String file = fd.getSelectedFile().getAbsolutePath();
              
              if (fd.getFileFilter().equals(f1)) {
                  if(file.toLowerCase().endsWith(".png")) file=file.substring(0,file.lastIndexOf("."));
                  File f = new File(file);
                  if(f.exists()){
                      error("File '"+file+"' exists!");
                      return;
                  }
                  f.mkdir();
                  for(int i=0; i<time_step.getModel().getSize(); i++){
                      time_step.setSelectedIndex(i);
                      headerMessage("Save result to image: "+file+File.separator+time_step.getSelectedValue()+".png");
                      J3D.save_Image(file+File.separator+time_step.getSelectedValue());
                  }
                  headerMessage(ver+"   "+project);
              }
          }
          
          // Update configuration file with path
          if (fd.getSelectedFile() != null) {
              ConfDB.setProperty("Filepath", fd.getSelectedFile().getAbsolutePath());
              save_configuration();
          }
          
      } catch(Exception e1) {error(e1);}
  }

  void tf_max_keyPressed(KeyEvent e) {
      if(e.getKeyCode()==KeyEvent.VK_ENTER){
        try{
          tfmax=Float.parseFloat(tf_max.getText());
          
          switch (cb_result.getSelectedIndex()) {
          case 0:
              maxdi = tfmax;
              break;
          case 1:
              maxdx = tfmax;
              break;
          case 2:
              maxdy = tfmax;
              break;
          case 3:
              maxdz = tfmax;
              break;
          case 4:
              maxei = tfmax;
              break;
          case 5:
              maxex = tfmax;
              break;
          case 6:
              maxey = tfmax;
              break;
          case 7:
              maxez = tfmax;
              break;
          case 8:
              maxexy = tfmax;
              break;
          case 9:
              maxeyz = tfmax;
              break;
          case 10:
              maxexz = tfmax;
              break;
          case 11:
              maxsi = tfmax;
              break;
          case 12:
              maxsx = tfmax;
              break;
          case 13:
              maxsy = tfmax;
              break;
          case 14:
              maxsz = tfmax;
              break;
          case 15:
              maxsxy = tfmax;
              break;
          case 16:
              maxsyz = tfmax;
              break;
          case 17:
              maxsxz = tfmax;
              break;
              
          }
          
          draw();
        }catch(Exception e1){error(e1);}
      }else if(e.getKeyCode()==KeyEvent.VK_ESCAPE)  tf_max.setText(tfmax+"");
    }

    void tf_min_keyPressed(KeyEvent e) {
      if(e.getKeyCode()==KeyEvent.VK_ENTER){
        try{
          tfmin=Float.parseFloat(tf_min.getText());

          switch (cb_result.getSelectedIndex()) {
          case 0:
              mindi = tfmin;
              break;
          case 1:
              mindx = tfmin;
              break;
          case 2:
              mindy = tfmin;
              break;
          case 3:
              mindz = tfmin;
              break;
          case 4:
              minei = tfmin;
              break;
          case 5:
              minex = tfmin;
              break;
          case 6:
              miney = tfmin;
              break;
          case 7:
              minez = tfmin;
              break;
          case 8:
              minexy = tfmin;
              break;
          case 9:
              mineyz = tfmin;
              break;
          case 10:
              minexz = tfmin;
              break;
          case 11:
              minsi = tfmin;
              break;
          case 12:
              minsx = tfmin;
              break;
          case 13:
              minsy = tfmin;
              break;
          case 14:
              minsz = tfmin;
              break;
          case 15:
              minsxy = tfmin;
              break;
          case 16:
              minsyz = tfmin;
              break;
          case 17:
              minsxz = tfmin;
              break;
              
          }
          
          
          draw();
        }catch(Exception e1){error(e1);}
      }else if(e.getKeyCode()==KeyEvent.VK_ESCAPE)  tf_min.setText(tfmin+"");
    }
  
  
  
  
  public void sort(Vector v){
    for(int i=0; i<v.size(); i++){
      String st1 = v.elementAt(i)+"";
      for(int j=i; j<v.size(); j++){
        String st2 = v.elementAt(j)+"";
        if(st1.compareTo(st2)>1){
          v.setElementAt(st2,i);
          v.setElementAt(st1,j);
        }
      }
    }
  }

  public void exit(){
    System.out.println("PostProcessor finalize.");
  }
  
  private void load_configuration() {
	  FileInputStream fin = null;
	  try {
		  ConfDB.clear();
		  fin = new FileInputStream("Post.conf");
		  ConfDB.load(fin);
		  fin.close();
	  } catch (IOException e) { 
		  error(e); }
  }
  private void save_configuration() {
	  FileOutputStream fout;
	  try {
		  fout = new FileOutputStream("Post.conf");
		  ConfDB.store(fout, "Configuration file for Impact Postprocessor");
		  fout.close();
	  } catch (IOException e) { 
		  error(e); }
  }
public void headerMessage(String m) {
     Frame f = getFrame(this);
     String s = f.getTitle();
     
     String s1 = s.substring(0,s.lastIndexOf("]")+1);
     f.setTitle(s1+" " + m);
     
 }
public void header(String m) {
     Frame f = getFrame(this);
     String s = f.getTitle();
     
     String s1 = s.substring(0,s.indexOf("[POST:")+6);
     String s2 = s.substring(s.indexOf("[GRPH:"), s.length());
     f.setTitle(s1+m+"] "+s2);
 }


}
