/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.FileRegex;
import com.stevesoft.pat.Regex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class Grep {
    boolean iflag = false;
    boolean pflag = false;
    boolean vflag = false;
    boolean verbose = false;
    Regex re;
    Vector v = new Vector();
    int lineno;
    String _file = "";

    public static void main(String[] stringArray) throws Exception {
        Grep grep = new Grep();
        grep.doArgs(stringArray);
    }

    public boolean getIFlag() {
        return this.iflag;
    }

    public void setIFlag(boolean bl) {
        this.iflag = bl;
    }

    public boolean getPFlag() {
        return this.pflag;
    }

    public void setPFlag(boolean bl) {
        this.pflag = bl;
    }

    public boolean getVFlag() {
        return this.vflag;
    }

    public void setVFlag(boolean bl) {
        this.vflag = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setRegex(Regex regex) {
        this.re = regex;
    }

    public Regex getRegex() {
        return this.re;
    }

    void setLineno(int n) {
        this.lineno = n;
    }

    int getLineno() {
        return this.lineno;
    }

    void incLineno() {
        ++this.lineno;
    }

    String getFile() {
        return this._file;
    }

    void setFile(String string) {
        this._file = string;
    }

    void doArgs(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            char c;
            if (stringArray[n].charAt(0) == '-') {
                int n2 = 1;
                while (n2 < stringArray[n].length()) {
                    c = stringArray[n].charAt(n2);
                    switch (c) {
                        case 'i': {
                            this.iflag = true;
                            break;
                        }
                        case 'p': {
                            this.pflag = true;
                            break;
                        }
                        case 'v': {
                            this.vflag = true;
                            break;
                        }
                        default: {
                            throw new Error("Unknown flag: " + c);
                        }
                    }
                    ++n2;
                }
            } else if (this.re == null) {
                Regex regex = new Regex(String.valueOf(this.iflag ? "(?i)" : "") + stringArray[n]);
                regex.optimize();
                this.setRegex(regex);
            } else {
                String[] stringArray2 = FileRegex.list(stringArray[n]);
                c = '\u0000';
                while (c < stringArray2.length) {
                    this.v.addElement(stringArray2[c]);
                    ++c;
                }
            }
            ++n;
        }
        if (this.v.size() > 1) {
            this.setVerbose(true);
        }
        if (this.v.size() == 0) {
            this.doInputStream(System.in);
        }
        int n3 = 0;
        while (n3 < this.v.size()) {
            this.doFile((String)this.v.elementAt(n3));
            ++n3;
        }
    }

    void doInputStream(InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.setFile("STDIN");
        this.setLineno(0);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        this.process(bufferedReader, printWriter);
        printWriter.close();
    }

    void doFile(String string) throws Exception {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        this.setFile(string);
        this.setLineno(0);
        this.process(bufferedReader, printWriter);
        bufferedReader.close();
        printWriter.close();
    }

    void process(BufferedReader bufferedReader, PrintWriter printWriter) throws Exception {
        String string = this.nextLine(bufferedReader);
        while (string != null) {
            if (this.re.search(string) ^ this.vflag) {
                if (this.verbose) {
                    printWriter.print(String.valueOf(this.getFile()) + " " + this.getLineno() + ": ");
                }
                printWriter.println(string);
            }
            string = this.nextLine(bufferedReader);
        }
    }

    String nextLine(BufferedReader bufferedReader) throws Exception {
        if (this.pflag) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            while (string != null && !string.trim().equals("")) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
                this.incLineno();
            }
            return stringBuffer.toString();
        }
        String string = bufferedReader.readLine();
        this.incLineno();
        return string;
    }
}

