/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.util.LinkedList;
import java.util.List;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.ProcessoAssincronoIf;

public class ProcessosAssincronos
extends Thread {
    private List listaProximos = new LinkedList();
    private Integer lockLista = new Integer(0);
    private static ProcessosAssincronos instance = new ProcessosAssincronos();
    public static final int INICIADO = 0;
    public static final int PAUSADO = 1;
    public static final int FINALIZADO = 2;
    private long cacherSleep = Long.parseLong(FabricaUtilitarios.getProperties().getProperty("aplicacao.infraestrutura.processosassincronos.intervalo", "500"));
    private transient int estado = 2;

    public static ProcessosAssincronos getInstance() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    public static ProcessosAssincronos getInstancia() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    private ProcessosAssincronos() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.estado == 0) {
                        Integer n = this.lockLista;
                        synchronized (n) {
                            if (this.listaProximos.size() > 0) {
                                ProcessoAssincronoIf processo = (ProcessoAssincronoIf)this.listaProximos.remove(0);
                                processo.executa();
                            }
                        }
                    }
                    ProcessosAssincronos.sleep(this.cacherSleep);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void inicia() {
        LogPPGD.debug("############ Iniciando PainelCacher ##############");
        this.estado = 0;
    }

    public void pausa() {
        this.estado = 1;
    }

    public void encerra() {
        LogPPGD.debug("############ Encerrando PainelCacher ##############");
        this.estado = 2;
        this.reiniciaCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void esvaziaCache() {
        this.estado = 2;
        Integer n = this.lockLista;
        synchronized (n) {
            this.listaProximos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reiniciaCache() {
        Integer n = this.lockLista;
        synchronized (n) {
            this.listaProximos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adicionaTarefa(ProcessoAssincronoIf aParam) {
        Integer n = this.lockLista;
        synchronized (n) {
            this.listaProximos.add(aParam);
        }
    }
}

