/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.interpretador;

import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class AnalisadorSintatico
implements PropertyChangeListener {
    protected Map operacoes = new Hashtable();
    protected ObjetoNegocio instanciaPrincipal = null;
    protected StringTokenizer tokensOperacao = null;
    protected LinkedList tokens = new LinkedList();
    protected int posAtual = 0;

    private AnalisadorSintatico() {
    }

    public AnalisadorSintatico(String strOp, ObjetoNegocio pInstanciaPrincipal) {
        this.tokensOperacao = new StringTokenizer(strOp, " ");
        while (this.tokensOperacao.hasMoreTokens()) {
            this.tokens.add(this.tokensOperacao.nextToken().trim());
        }
        this.instanciaPrincipal = pInstanciaPrincipal;
    }

    protected String getTokenAtual() {
        if (this.posAtual < this.tokens.size()) {
            String token = ((String)this.tokens.get(this.posAtual)).trim();
            return token;
        }
        return null;
    }

    protected String getProximoToken() {
        ++this.posAtual;
        return ((String)this.tokens.get(this.posAtual)).trim();
    }

    protected String getToken(int pos) {
        if (pos < this.tokens.size()) {
            return (String)this.tokens.get(pos);
        }
        return null;
    }

    protected void avancaToken() {
        ++this.posAtual;
    }

    protected boolean temMaisTokens() {
        return this.posAtual + 1 < this.tokens.size();
    }

    protected boolean ehOperador(String proxToken) {
        return proxToken.equals("+") || proxToken.equals("-") || proxToken.equals("*") || proxToken.equals("/");
    }

    protected boolean ehCondicional(String token) {
        return token.toUpperCase().equals("SE");
    }
}

