/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.OpcaoLogico;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoLogico;
import serpro.ppgd.negocio.util.LogPPGD;

public class Logico
extends Informacao {
    private String conteudo = "";
    public static String SIM = "1";
    public static String NAO = "0";
    public static String LABEL_SIM = "Sim";
    public static String LABEL_NAO = "N\u00e3o";
    public boolean selecaoMultipla = false;
    private Map opcoes = new Hashtable();
    private LinkedList listaOrdenada = new LinkedList();
    private Vector listaValidadoresimpeditivosTemporaria = new Vector();

    public Logico() {
        super("");
    }

    public void addValidador(ValidadorIf validador) {
        if (validador instanceof ValidadorImpeditivoDefault && !(validador instanceof ValidadorImpeditivoLogico)) {
            throw new IllegalArgumentException("O Validador adicionado n\u00e3o \u00e9 do tipo ValidadorImpeditivoLogico.\n Fa\u00e7a com que esse herde de ValidadorImpeditivoLogico.");
        }
        super.addValidador(validador);
    }

    public void atualizaListaValidadoresImpeditivos(String proximaOpcao) {
        Vector<ValidadorImpeditivoLogico> lista = new Vector<ValidadorImpeditivoLogico>();
        Iterator itValidadores = super.getListaValidadoresImpeditivos().iterator();
        while (itValidadores.hasNext()) {
            ValidadorImpeditivoLogico val = (ValidadorImpeditivoLogico)itValidadores.next();
            if (val.getValorOpcaoDoLogico().trim().equals("") || !this.getOpcoes().containsKey(val.getValorOpcaoDoLogico().trim()) || !proximaOpcao.equals(val.getValorOpcaoDoLogico())) continue;
            lista.add(val);
        }
        this.listaValidadoresimpeditivosTemporaria.clear();
        this.listaValidadoresimpeditivosTemporaria.addAll(lista);
    }

    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> retorno = new LinkedList<ValidadorImpeditivoDefault>();
        Iterator itValidadores = this.getListaValidadoresImpeditivos().iterator();
        while (itValidadores.hasNext()) {
            ValidadorImpeditivoDefault validador = (ValidadorImpeditivoDefault)itValidadores.next();
            if (validador.getSeveridade() == 5) {
                retorno.addFirst(validador);
                continue;
            }
            if (validador.getSeveridade() != 4) continue;
            retorno.addLast(validador);
        }
        this.listaValidadoresimpeditivosTemporaria.clear();
        this.listaValidadoresimpeditivosTemporaria.addAll(retorno);
    }

    public Vector getListaValidadoresImpeditivos() {
        return this.listaValidadoresimpeditivosTemporaria;
    }

    public void adicionaOpcao(String lbl, String val) {
        if (this.opcoes.containsKey(val)) {
            this.listaOrdenada.remove(this.opcoes.get(val));
        }
        OpcaoLogico o = new OpcaoLogico(lbl, val);
        this.opcoes.put(val, o);
        this.listaOrdenada.addLast(o);
    }

    public void addOpcao(String codigo, String label) {
        if (this.opcoes.containsKey(codigo)) {
            this.listaOrdenada.remove(this.opcoes.get(codigo));
        }
        OpcaoLogico o = new OpcaoLogico(label, codigo);
        this.opcoes.put(codigo, o);
        this.listaOrdenada.addLast(o);
    }

    public String getLabelOpcao(String valor) {
        if (this.opcoes.containsKey(valor)) {
            return ((OpcaoLogico)this.opcoes.get((Object)valor)).labelOpcao;
        }
        return "";
    }

    public String getValorOpcao(String lbl) {
        String retorno = "";
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            OpcaoLogico o = (OpcaoLogico)it.next();
            if (!o.labelOpcao.trim().equals(lbl.trim())) continue;
            return o.valorOpcao;
        }
        return retorno;
    }

    public Logico(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public void converteEmTipoSimNao(String valorInicial) {
        this.adicionaOpcao(LABEL_SIM, SIM);
        this.adicionaOpcao(LABEL_NAO, NAO);
        this.setConteudo(valorInicial);
    }

    public void clear() {
        this.setConteudo("");
    }

    public String asString() {
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            OpcaoLogico o = (OpcaoLogico)it.next();
            if (!o.selecionado) continue;
            return o.valorOpcao;
        }
        return this.conteudo;
    }

    public String getConteudoFormatado() {
        return this.asString();
    }

    public void setConteudo(String val) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        String antigo = this.conteudo;
        this.clearRetornosValidacoes();
        if (!this.opcoes.containsKey(val)) {
            val = "";
        }
        this.conteudo = val;
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            OpcaoLogico o = (OpcaoLogico)it.next();
            if (o.valorOpcao.trim().equals(val.trim())) {
                o.selecionado = true;
                continue;
            }
            o.selecionado = false;
        }
        this.disparaObservadores(antigo);
    }

    public boolean isVazio() {
        return this.asString() == null || this.asString().trim().length() == 0;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList getListaOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean selecaoMultipla) {
        this.selecaoMultipla = selecaoMultipla;
    }
}

