/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.editors.PPGDCheckBox;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.OpcaoDefault;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.Opcao;
import serpro.ppgd.negocio.util.LogPPGD;

public class JEditOpcao
extends JEditCampo {
    private Box box;
    private int orientacaoTexto;
    private static final Color DEFAULT_FOREGROUND = new JCheckBox().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map opcoes;
    private LinkedList listaOrdenada = new LinkedList();

    public JEditOpcao() {
        this((Informacao)new OpcaoDefault());
    }

    public JEditOpcao(Informacao campo) {
        super(campo);
        this.setOrientacaoTexto(1);
    }

    public void setFont(Font pFont) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            opcao.setFont(pFont);
        }
    }

    public void setForeground(Color pCor) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            opcao.setForeground(pCor);
        }
    }

    public void setFont(String pCodigoOpcao, Color pCor) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setForeground(pCor);
        }
    }

    public void setFont(String pCodigoOpcao, Font pFont) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setFont(pFont);
        }
    }

    public void addListener(String pCodigoOpcao, EventListener listener) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            this.adicionaListener(opcao, listener);
        }
    }

    private void adicionaListener(JCheckBox opcao, EventListener listener) {
        if (listener instanceof ActionListener) {
            opcao.addActionListener((ActionListener)listener);
        } else if (listener instanceof ItemListener) {
            opcao.addItemListener((ItemListener)listener);
        } else if (listener instanceof KeyListener) {
            opcao.addKeyListener((KeyListener)listener);
        } else if (listener instanceof FocusListener) {
            opcao.addFocusListener((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            opcao.addMouseListener((MouseListener)listener);
        } else if (listener instanceof MouseMotionListener) {
            opcao.addMouseMotionListener((MouseMotionListener)listener);
        }
    }

    public void addListener(EventListener listener) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            this.adicionaListener(opcao, listener);
        }
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int orientacaoTexto) {
        this.orientacaoTexto = orientacaoTexto;
        this.buildComponente();
    }

    public void setOpcaoHabilitada(String pCodigoOpcao, boolean pOpt) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setEnabled(pOpt);
            if (!pOpt) {
                opcao.setForeground(DISABLED_FOREGROUND);
            } else {
                opcao.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.setObservadorAtivo(false);
        if (evt == null) {
            LogPPGD.debug((String)("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass()));
        }
        if ((evt.getPropertyName() == null || !evt.getPropertyName().equals("ReadOnly")) && evt.getNewValue() instanceof String) {
            String novoValor = (String)evt.getNewValue();
            if (novoValor == null) {
                novoValor = "";
            }
            String descNovoValor = ((Opcao)this.getInformacao()).getDescricaoOpcoes();
            Iterator it = this.opcoes.values().iterator();
            while (it.hasNext()) {
                JCheckBox cb = (JCheckBox)it.next();
                if (descNovoValor.indexOf(cb.getText().trim()) > -1) {
                    this.setBloqueiaItemListener(true);
                    cb.setSelected(true);
                    this.setBloqueiaItemListener(false);
                    continue;
                }
                this.setBloqueiaItemListener(true);
                cb.setSelected(false);
                this.setBloqueiaItemListener(false);
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            JCheckBox cb = (JCheckBox)it.next();
            cb.setEnabled(!readOnly);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            JCheckBox cb = (JCheckBox)it.next();
            cb.setEnabled(habilitado);
            cb.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
    }

    public JComponent getComponenteFoco() {
        if (this.opcoes.values().size() > 0) {
            return (JCheckBox)this.opcoes.values().toArray()[0];
        }
        return null;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bloqueiaItemListener) {
        this.bloqueiaItemListener = bloqueiaItemListener;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.opcoes = new Hashtable();
        this.listaOrdenada = new LinkedList();
        this.box = this.getOrientacaoTexto() == 0 ? Box.createHorizontalBox() : Box.createVerticalBox();
        Opcao opcao = (Opcao)this.getInformacao();
        if (opcao != null) {
            Iterator itOpcoes = opcao.getListaOrdenada().iterator();
            while (itOpcoes.hasNext()) {
                ItemOpcao opt = (ItemOpcao)itOpcoes.next();
                PPGDCheckBox cb = new PPGDCheckBox(opt.getCodigo(), opt.getDescricao(), opt.isSelecionado());
                cb.setInformacao(this.campo);
                cb.setVisible(true);
                cb.setSelected(opt.isSelecionado());
                this.opcoes.put(cb.getName(), cb);
                this.listaOrdenada.addLast(cb);
                cb.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        if (e.getOppositeComponent() == null) {
                            return;
                        }
                        JEditOpcao.this.setIdentificacaoFoco(false);
                        JEditOpcao.this.chamaValidacao();
                    }
                });
                cb.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        JCheckBox opcao = (JCheckBox)e.getSource();
                        String codigoOpcao = opcao.getName().trim();
                        ((Opcao)JEditOpcao.this.getInformacao()).atualizaListaValidadoresImpeditivos(codigoOpcao);
                        if (!JEditOpcao.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditOpcao.this.verificaValidacoesImpeditivas(codigoOpcao)) {
                            return;
                        }
                        if (e.getStateChange() == 1 && !JEditOpcao.this.isBloqueiaItemListener()) {
                            ((Opcao)JEditOpcao.this.getInformacao()).addSelectedItem(codigoOpcao);
                        }
                        if (e.getStateChange() == 2 && !JEditOpcao.this.isBloqueiaItemListener()) {
                            ((Opcao)JEditOpcao.this.getInformacao()).delSelectedItem(codigoOpcao);
                        }
                    }
                });
                if (this.getOrientacaoTexto() == 0) {
                    this.box.add(new JLabel(" "));
                }
                this.box.add((Component)cb);
            }
            this.setObservadorAtivo(false);
            PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
            this.implementacaoPropertyChange(evt);
            this.setObservadorAtivo(true);
        }
        this.add((Component)this.box, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    protected void informacaoModificada() {
        this.buildComponente();
    }

    public void setEstiloFonte(int estilo) {
        JCheckBox checkBox = null;
        checkBox = !this.opcoes.isEmpty() ? (JCheckBox)this.opcoes.values().toArray()[0] : new JCheckBox();
        Font f = checkBox.getFont();
        f = f.deriveFont(estilo);
        this.setFont(f);
    }

    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        JCheckBox checkBox = null;
        checkBox = !this.opcoes.isEmpty() ? (JCheckBox)this.opcoes.values().toArray()[0] : new JCheckBox();
        Font f = checkBox.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.setFont(f);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

