/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.gui.editors.PPGDSpinner;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;

public class JEditInteiro
extends JEditCampo {
    private JSpinner componente;
    private SpinnerNumberModel model;

    public JEditInteiro() {
        super((Informacao)new Inteiro("Inteiro"));
    }

    public JEditInteiro(Informacao campo) {
        super(campo);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (evt != null && evt.getPropertyName() != null && evt.getPropertyName().equals("LIMITES")) {
            if (this.getInformacao() instanceof Inteiro) {
                int limiteMax = ((Inteiro)this.getInformacao()).getLimiteMaximo();
                int limiteMin = ((Inteiro)this.getInformacao()).getLimiteMinimo();
                if (limiteMax != -1) {
                    this.setValorMaximo(limiteMax);
                }
                if (limiteMin != -1) {
                    this.setValorMinimo(limiteMin);
                }
            }
            return;
        }
        this.getInformacao().setObservadoresAtivos(false);
        this.setObservadorAtivo(false);
        Integer newValue = new Integer(((Inteiro)this.getInformacao()).asInteger());
        Integer maxValue = (Integer)this.model.getMaximum();
        Integer minValue = (Integer)this.model.getMinimum();
        if (newValue > maxValue) {
            newValue = maxValue;
        } else if (newValue < minValue) {
            newValue = minValue;
        }
        this.componente.setValue(newValue);
        this.getInformacao().setObservadoresAtivos(true);
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEnabled(false);
        } else {
            this.componente.setEnabled(true);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.componente.setEnabled(habilitado);
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void setValorMinimo(int aValorMinimo) {
        this.model.setMinimum(new Integer(aValorMinimo));
        this.implementacaoPropertyChange(null);
    }

    public int getValorMinimo() {
        return Integer.parseInt(this.model.getMinimum().toString());
    }

    public void setValorMaximo(int aValorMax) {
        this.model.setMaximum(new Integer(aValorMax));
        this.implementacaoPropertyChange(null);
    }

    public int getValorMaximo() {
        return Integer.parseInt(this.model.getMaximum().toString());
    }

    public void setValorOffset(int aOffset) {
        this.model.setStepSize(new Integer(aOffset));
    }

    public int getValorOffset() {
        return this.model.getStepSize().intValue();
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.model = new SpinnerNumberModel(0, 0, 10000, 1);
            this.componente = new PPGDSpinner((SpinnerModel)this.model);
            this.model.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    Integer value;
                    JEditInteiro.this.setIdentificacaoFoco(false);
                    Integer newValue = value = (Integer)JEditInteiro.this.componente.getValue();
                    Integer maxValue = (Integer)JEditInteiro.this.model.getMaximum();
                    Integer minValue = (Integer)JEditInteiro.this.model.getMinimum();
                    if (newValue > maxValue) {
                        newValue = maxValue;
                    } else if (newValue < minValue) {
                        newValue = minValue;
                    }
                    JEditInteiro.this.getInformacao().setConteudo(newValue.toString());
                }
            });
        }
        this.add((Component)this.componente, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    protected void informacaoModificada() {
        Inteiro inteiro = (Inteiro)this.getInformacao();
        int valor = inteiro.asInteger();
        this.componente.setValue(new Integer(valor));
        ((PPGDSpinner)this.componente).setInformacao(this.campo);
        if (this.getInformacao() instanceof Inteiro) {
            int limiteMax = ((Inteiro)this.getInformacao()).getLimiteMaximo();
            int limiteMin = ((Inteiro)this.getInformacao()).getLimiteMinimo();
            if (limiteMax != -1) {
                this.setValorMaximo(limiteMax);
            }
            if (limiteMin != -1) {
                this.setValorMinimo(limiteMin);
            }
        }
    }

    public void setEstiloFonte(int estilo) {
        Font f = this.componente.getFont();
        f = f.deriveFont(estilo);
        this.componente.setFont(f);
    }

    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.componente.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.componente.setFont(f);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

