/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditColecao;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;

public class JDialogEditCampoLeitor
extends JDialog
implements KeyListener {
    private JEditCampo campoOriginal;
    private Vector valorExibido = new Vector();
    private int linhaSelecionadaOriginal;
    private int colunaSelecionadaOriginal;
    private JButton jButtonOk;
    private JButton jButtonCancelar;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private ComboBoxJTable jTable1;
    private DefaultTableModel modelo;

    public JDialogEditCampoLeitor(JFrame parent, JEditCampo campo) {
        super((Frame)parent, true);
        this.campoOriginal = campo;
        this.initComponents();
        this.preencherTabela();
        this.showDialog();
    }

    private void preencherTabela() {
        if (this.campoOriginal instanceof JEditCodigo) {
            this.preencherTabela((JEditCodigo)this.campoOriginal);
        } else if (this.campoOriginal instanceof JEditColecao) {
            this.preencherTabela((JEditColecao)this.campoOriginal);
        }
    }

    private void preencherTabela(JEditColecao editColecao) {
        List lista = ((Codigo)this.campoOriginal.campo).getColecaoElementoTabela();
        Iterator it = lista.iterator();
        while (it.hasNext()) {
            ElementoTabela e = (ElementoTabela)it.next();
            String conteudo = e.getConteudo(editColecao.colunaExibidaLabel);
            this.modelo.addRow(new Object[]{conteudo});
            this.valorExibido.add(conteudo);
        }
        this.selecionarLinha(((Codigo)editColecao.getInformacao()).getIndiceElementoTabela());
    }

    private void preencherTabela(JEditCodigo editCodigo) {
        JComboBox combo = editCodigo.combo;
        List lista = ((Codigo)this.campoOriginal.campo).getColecaoElementoTabela();
        Iterator it = lista.iterator();
        while (it.hasNext()) {
            ElementoTabela e = (ElementoTabela)it.next();
            StringBuffer conteudo = new StringBuffer();
            int i = 0;
            while (i < editCodigo.colsVisiveis.length) {
                if (editCodigo.colsVisiveis[i]) {
                    conteudo.append(e.getConteudo(i)).append(" ");
                }
                ++i;
            }
            this.modelo.addRow(new Object[]{conteudo.toString()});
            this.valorExibido.add(conteudo.toString());
        }
        this.selecionarLinha(combo.getSelectedIndex());
    }

    private void selecionarCampoOriginal(JEditCodigo editCodigo) {
        if (editCodigo.combo != null) {
            editCodigo.combo.setSelectedIndex(this.jTable1.getSelectedRow());
        }
        this.sair();
    }

    private void selecionarCampoOriginal(JEditColecao editColecao) {
        int indice = this.jTable1.getSelectedRow();
        List lista = ((Codigo)this.campoOriginal.campo).getColecaoElementoTabela();
        ElementoTabela elem = (ElementoTabela)lista.get(indice);
        ((Codigo)editColecao.getInformacao()).setConteudo(elem.getConteudo(editColecao.colunaExibidaCodigo));
        this.sair();
    }

    private void sair() {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setTitle(this.campoOriginal.getInformacao().getNomeCampo());
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new ComboBoxJTable();
        this.jButtonOk = new JButton();
        this.jButtonCancelar = new JButton();
        this.setDefaultCloseOperation(0);
        this.modelo = new DefaultTableModel(0, 0);
        this.modelo.addColumn(this.campoOriginal.getInformacao().getNomeCampo());
        this.jTable1.setModel(this.modelo);
        this.jTable1.setRowSelectionAllowed(true);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setTableHeader(null);
        this.jScrollPane1.setColumnHeaderView(null);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jTable1.setSelectionMode(0);
        this.jTable1.addKeyListener(this);
        this.jButtonOk.setText("Confirmar");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogEditCampoLeitor.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancelar.setText("Cancelar");
        this.jButtonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogEditCampoLeitor.this.jButtonCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonCancelar).addContainerGap(226, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 242, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonOk).add((Component)this.jButtonCancelar)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addContainerGap(18, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.campoOriginal instanceof JEditCodigo) {
            this.selecionarCampoOriginal((JEditCodigo)this.campoOriginal);
        } else if (this.campoOriginal instanceof JEditColecao) {
            this.selecionarCampoOriginal((JEditColecao)this.campoOriginal);
        }
    }

    private void jButtonCancelarActionPerformed(ActionEvent evt) {
        this.sair();
    }

    public void keyPressed(KeyEvent k) {
        if (k.getKeyCode() == 10) {
            if (this.campoOriginal instanceof JEditCodigo) {
                this.selecionarCampoOriginal((JEditCodigo)this.campoOriginal);
            } else if (this.campoOriginal instanceof JEditColecao) {
                this.selecionarCampoOriginal((JEditColecao)this.campoOriginal);
            }
        } else {
            this.selecionarIniciandoPor(k.getKeyChar());
        }
    }

    private void selecionarIniciandoPor(char keyChar) {
        int linha = -1;
        int i = 0;
        while (i < this.valorExibido.size()) {
            String valor = (String)this.valorExibido.get(i);
            if (valor.toUpperCase().charAt(0) == keyChar || valor.toLowerCase().charAt(0) == keyChar) {
                linha = i;
                break;
            }
            ++i;
        }
        if (linha > -1) {
            this.selecionarLinha(linha);
        }
    }

    private void selecionarLinha(int linha) {
        if (linha > -1) {
            this.jTable1.setRowSelectionInterval(linha, linha);
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(linha, 0, false));
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public class ComboBoxJTable
    extends JTable {
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

