/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CPeerSurfaceData;
import apple.awt.CSurfaceData;
import apple.awt.CToolkit;
import apple.awt.CocoaEvent;
import apple.awt.ComponentModel;
import apple.awt.CoreGraphicsAPI;
import apple.awt.EventFactoryProxy;
import apple.awt.FlushEvent;
import apple.awt.NSGraphicsContextAPI;
import apple.awt.NSViewAPI;
import apple.awt.PeerPaintEvent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.PaintEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.peer.ContainerPeer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JWindow;
import sun.awt.SunGraphicsCallback;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public abstract class ContainerModel
extends ComponentModel
implements ContainerPeer {
    static final boolean kDEBUG_PAINTING = false;
    static Font sDefaultFont;
    long fNSView;
    PeerPaintEvent fPeerPainterLOCKABLE;
    private Object fPaintingLock;
    private boolean fInLiveResize;
    long fCurrentContext;
    long fCurrentNSGraphicsContext;
    private CPeerSurfaceData fSurfaceData;
    private Object fSurfaceLock = new SurfaceLock();
    private boolean fTargetIsSwingComponent;
    Insets fInsets = new Insets(0, 0, 0, 0);
    static final /* synthetic */ boolean $assertionsDisabled;

    ContainerModel(Component component) {
        super(component);
        this.fTargetIsSwingComponent = component instanceof JComponent || component instanceof JFrame || component instanceof JWindow;
    }

    void initContainer() {
        this.fNSView = -1L;
        this.fPaintingLock = new PaintingLock();
        this.fInLiveResize = false;
        this.fCurrentContext = 0L;
        this.fCurrentNSGraphicsContext = 0L;
        this.fSurfaceData = null;
    }

    protected void disposeImpl() {
        CocoaEvent.dispatchAlert(null);
        if (this.fSurfaceData != null) {
            CPeerSurfaceData cPeerSurfaceData = this.fSurfaceData;
            this.fSurfaceData = null;
            cPeerSurfaceData.invalidate();
        }
        super.disposeImpl();
    }

    public Rectangle getBounds() {
        return this.fTarget.getBounds();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    void addDamagedArea(Rectangle rectangle) {
        this.paintArea.add(rectangle, 800);
    }

    void addDamagedArea(Rectangle rectangle, int n) {
        this.paintArea.add(rectangle, n);
    }

    void addDamagedArea(int n, int n2, int n3, int n4) {
        this.addDamagedArea(new Rectangle(n, n2, n3, n4));
    }

    void paintDamagedArea() {
        try {
            this.replaceSurfaceData();
            this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.paintPending = false;
    }

    public long getViewPtr() {
        if (this.fNSView <= 0L) {
            this.fNSView = this._getViewPtr(this.fModelPtr);
        }
        return this.fNSView;
    }

    private native long _getViewPtr(long var1);

    void resetViewPtr() {
        this.fNSView = this._getViewPtr(this.fModelPtr);
    }

    public abstract PeerPaintEvent getPeerPainter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInLiveResizing(boolean bl) {
        Object object = this.fPaintingLock;
        synchronized (object) {
            this.fInLiveResize = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inLiveResize() {
        Object object;
        if (!(this.fTarget instanceof Window) && (object = this.getCWindowContainer()) != null) {
            return ((ContainerModel)object).inLiveResize();
        }
        object = this.fPaintingLock;
        synchronized (object) {
            return this.fInLiveResize;
        }
    }

    boolean isInactiveSurfaceSituation() {
        if (this.fNSView == 0L) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            boolean bl;
            Object object = EventFactoryProxy.getCurrentEvent();
            boolean bl2 = bl = object instanceof PeerPaintEvent ? ((PeerPaintEvent)object).isDispatching(Thread.currentThread()) : false;
            if (!bl && this.fNSView > 0L && this.inLiveResize()) {
                return true;
            }
        }
        return false;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        boolean bl = false;
        switch (n) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                bl = this.isInactiveSurfaceSituation();
                if (!(this.isLayouting || this.paintPending || bl)) {
                    PaintEvent paintEvent = (PaintEvent)aWTEvent;
                    this.addDamagedArea(paintEvent.getUpdateRect(), n);
                    this.paintDamagedArea();
                }
                return;
            }
        }
    }

    private Area createHeavyClip(Component[] componentArray) {
        GeneralPath generalPath = new GeneralPath();
        Rectangle rectangle = this.fTarget.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Area area = new Area(rectangle);
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i].getPeer() instanceof ComponentModel)) continue;
            Rectangle rectangle2 = componentArray[i].getBounds();
            --rectangle2.x;
            --rectangle2.y;
            generalPath.append(rectangle2, false);
            bl = true;
        }
        if (bl) {
            Area area2 = new Area(generalPath);
            area.exclusiveOr(area2);
            return area;
        }
        return null;
    }

    private void applyHeavyClip(Graphics2D graphics2D) {
        if (!(this.fTarget instanceof Container)) {
            return;
        }
        try {
            Area area;
            Component[] componentArray = ((Container)this.fTarget).getComponents();
            if (componentArray.length > 0 && (area = this.createHeavyClip(componentArray)) != null) {
                graphics2D.clip(area);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private SunGraphics2D createGraphics(SurfaceData surfaceData) throws NullPointerException {
        if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.createGraphics")) {
            throw new AssertionError();
        }
        if (surfaceData != null) {
            Font font = this.fTarget.getFont();
            Color color = this.fTarget.getForeground();
            Color color2 = this.fTarget.getBackground();
            ContainerModel containerModel = this;
            if (this.fTargetIsSwingComponent) {
                return new SunGraphics2D(surfaceData, color != null ? color : Color.black, color2 != null ? color2 : Color.white, font != null ? font : sDefaultFont);
            }
            SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData, color != null ? color : Color.black, color2 != null ? color2 : Color.white, font != null ? font : sDefaultFont){

                public void setClip(Shape shape) {
                    super.setClip(shape);
                    ContainerModel.this.applyHeavyClip(this);
                    this.clip(shape);
                }
            };
            this.applyHeavyClip(sunGraphics2D);
            return sunGraphics2D;
        }
        throw new NullPointerException();
    }

    public Graphics getGraphics() {
        try {
            boolean bl;
            boolean bl2 = EventQueue.isDispatchThread();
            Object object = EventFactoryProxy.getCurrentEvent();
            boolean bl3 = bl = object instanceof PeerPaintEvent ? ((PeerPaintEvent)object).isDispatching(Thread.currentThread()) : false;
            if (bl2 && !bl) {
                CocoaEvent.dispatchAlert(this);
            }
            if (this.isFullScreen()) {
                return this.getFrontBuffer().getGraphics();
            }
            if (bl2 && !bl && this.fNSView > 0L) {
                if (this.inLiveResize() || this.fPeerPainterLOCKABLE.isResizePending()) {
                    if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics (REJECT) : EDT, !PeerPaintEvent, inLiveResize")) {
                        throw new AssertionError();
                    }
                    NSViewAPI.redrawViewLater(this.fNSView);
                    return this.switchToDummyGraphics();
                }
                long l = NSViewAPI.prepareIfCanJavaDraw(this.fNSView);
                if (l == 0L && !this.inLiveResize()) {
                    l = NSViewAPI.prepareIfCanJavaDrawWithTimeout(this.fNSView, 25L);
                }
                if (l == 0L) {
                    NSViewAPI.redrawViewLater(this.fNSView);
                    return this.switchToDummyGraphics();
                }
                if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics : EDT, !PeerPaintEvent")) {
                    throw new AssertionError();
                }
                try {
                    this.setCurrentContext(l, false);
                    this.replaceSurfaceData();
                    FlushEvent flushEvent = new FlushEvent(this, this.fNSView, this.fSurfaceData);
                    flushEvent.postToQueue();
                }
                catch (Exception exception) {
                    NSViewAPI.cancelJavaDraw(this.fNSView);
                    NSViewAPI.redrawViewLater(this.fNSView);
                    return this.switchToDummyGraphics();
                }
                return this.createGraphics(this.fSurfaceData);
            }
            if (!bl2) {
                if (this.getViewPtr() <= 0L || !this.fTarget.isVisible()) {
                    if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics (REJECT) : !EDT, !isVisible, _markAsDirtyNotLiveResize")) {
                        throw new AssertionError();
                    }
                    NSViewAPI._markAsDirtyNotLiveResize(this.fNSView);
                    return this.switchToDummyGraphics();
                }
                if (!bl) {
                    if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics : !EDT, !PeerPaintEvent, getOffThreadGraphics")) {
                        throw new AssertionError();
                    }
                    return this.createGraphics(CPeerSurfaceData.createData(this, !this.isInactiveSurfaceSituation()));
                }
                if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics (REJECT) : !EDT, PeerPaintEvent, _markAsDirtyNotLiveResize")) {
                    throw new AssertionError();
                }
                NSViewAPI._markAsDirtyNotLiveResize(this.fNSView);
                return this.switchToDummyGraphics();
            }
            if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getGraphics : EDT, PeerPaintEvent")) {
                throw new AssertionError();
            }
            this.replaceSurfaceData();
            return this.createGraphics(this.fSurfaceData);
        }
        catch (NullPointerException nullPointerException) {
            return this.switchToDummyGraphics();
        }
        catch (Throwable throwable) {
            System.err.println("WARNING : Unexpected exception caught in ContainerModel.getGraphics");
            throwable.printStackTrace();
            return this.switchToDummyGraphics();
        }
    }

    void setCurrentContext(long l, boolean bl) {
        if (l != 0L && l != this.fCurrentNSGraphicsContext) {
            this.fCurrentNSGraphicsContext = l;
            this.fCurrentContext = NSGraphicsContextAPI.setCurrentNSGraphicsContext(l, bl ? this.fNSView : 0L);
            this.replaceSurfaceData();
        } else if (l == 0L) {
            System.out.println("Error in  setCurrentContext where nsGC == 0\n");
            this.fCurrentNSGraphicsContext = 0L;
            this.fCurrentContext = 0L;
        }
    }

    void unsetCurrentContext(long l) {
        if (this.fNSView > 0L && l != 0L) {
            NSGraphicsContextAPI.unsetCurrentNSGraphicsContext(this.fCurrentNSGraphicsContext, this.fNSView);
        } else {
            System.err.println("Error: PeerPaintEvent graphics context reset during paint.");
            Thread.dumpStack();
        }
        this.fCurrentNSGraphicsContext = 0L;
        this.fCurrentContext = 0L;
    }

    CPeerSurfaceData getSurfaceData() {
        boolean bl;
        boolean bl2 = EventQueue.isDispatchThread();
        Object object = EventFactoryProxy.getCurrentEvent();
        boolean bl3 = bl = object instanceof PeerPaintEvent ? ((PeerPaintEvent)object).isDispatching(Thread.currentThread()) : false;
        if (bl2 && !bl) {
            CocoaEvent.dispatchAlert(this);
        }
        if (bl2 && !bl && this.fNSView > 0L) {
            if (this.inLiveResize() || this.fPeerPainterLOCKABLE.isResizePending()) {
                if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getSurfaceData (REJECT) : EDT, !PeerPaintEvent, inLiveResize")) {
                    throw new AssertionError();
                }
                this.markSurfaceDataStale();
                return CPeerSurfaceData.createData(this, false);
            }
            long l = NSViewAPI.prepareIfCanJavaDraw(this.fNSView);
            if (l == 0L && !this.inLiveResize() && !bl) {
                l = NSViewAPI.prepareIfCanJavaDrawWithTimeout(this.fNSView, 25L);
            }
            if (l != 0L) {
                if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getSurfaceData : EDT, !PeerPaintEvent")) {
                    throw new AssertionError();
                }
                try {
                    this.replaceSurfaceData();
                    this.setCurrentContext(l, false);
                    FlushEvent flushEvent = new FlushEvent(this, this.fNSView, this.fSurfaceData);
                    flushEvent.postToQueue();
                }
                catch (Exception exception) {
                    NSViewAPI.cancelJavaDraw(this.fNSView);
                    if (this.fSurfaceData != null) {
                        this.fSurfaceData.invalidate();
                        this.fSurfaceData = null;
                    }
                    this.markSurfaceDataStale();
                    return CPeerSurfaceData.createData(this, false);
                }
                return this.fSurfaceData;
            }
            if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getSurfaceData (REJECT) : EDT, !PeerPaintEvent, CPeerSurfaceData(this, false)")) {
                throw new AssertionError();
            }
            if (this.fSurfaceData != null) {
                this.fSurfaceData.invalidate();
                this.fSurfaceData = null;
            }
            this.markSurfaceDataStale();
            return CPeerSurfaceData.createData(this, false);
        }
        if (bl2 && bl && this.fNSView > 0L) {
            if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getSurfaceData : EDT, PeerPaintEvent, replaceSurfaceData")) {
                throw new AssertionError();
            }
            this.replaceSurfaceData();
            return this.fSurfaceData;
        }
        if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.getSurfaceData : !EDT, CPeerSurfaceData(this)")) {
            throw new AssertionError();
        }
        return CPeerSurfaceData.createData(this, !this.isInactiveSurfaceSituation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData() {
        if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.replaceSurfaceData")) {
            throw new AssertionError();
        }
        Object object = this.fSurfaceLock;
        synchronized (object) {
            int n = this.fTarget.getWidth();
            int n2 = this.fTarget.getHeight();
            if (n != 0 && n2 != 0) {
                if (this.isFullScreen() && (n != this.fOldHeight || n2 != this.fOldHeight)) {
                    this.createFrontBuffer();
                    this.createBackBuffer();
                }
                this.fOldHeight = this.fTarget.getHeight();
                this.fOldWidth = this.fTarget.getWidth();
                CPeerSurfaceData cPeerSurfaceData = this.fSurfaceData;
                this.fSurfaceData = CPeerSurfaceData.createData(this, !this.isInactiveSurfaceSituation());
                if (cPeerSurfaceData != null) {
                    cPeerSurfaceData.invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeContext() {
        if (!$assertionsDisabled && !CToolkit.stdio("ContainerModel.completeContext")) {
            throw new AssertionError();
        }
        Object object = this.fSurfaceLock;
        synchronized (object) {
            if (this.fSurfaceData != null) {
                this.fSurfaceData.flush();
            }
        }
    }

    void markSurfaceDataStale() {
        PeerPaintEvent peerPaintEvent = this.getPeerPainter();
        if (peerPaintEvent != null) {
            peerPaintEvent.markSurfaceDataStale();
        }
    }

    private Graphics switchToDummyGraphics() {
        Color color;
        Color color2;
        boolean bl;
        if (this.fSurfaceData != null) {
            this.fSurfaceData.invalidate();
            this.fSurfaceData = null;
        }
        this.markSurfaceDataStale();
        boolean bl2 = EventQueue.isDispatchThread();
        Object object = EventFactoryProxy.getCurrentEvent();
        boolean bl3 = bl = object instanceof PeerPaintEvent ? ((PeerPaintEvent)object).isDispatching(Thread.currentThread()) : false;
        if (bl2 && !bl) {
            CocoaEvent.dispatchAlert(this);
        }
        CPeerSurfaceData cPeerSurfaceData = CPeerSurfaceData.createData(this, false);
        Font font = this.fTarget.getFont();
        if (font == null) {
            font = sDefaultFont;
        }
        if ((color2 = this.fTarget.getForeground()) == null) {
            color2 = Color.black;
        }
        if ((color = this.fTarget.getBackground()) == null) {
            color = Color.white;
        }
        SunGraphics2D sunGraphics2D = new SunGraphics2D(cPeerSurfaceData, color2, color, font);
        sunGraphics2D.drawpipe = CSurfaceData.sNullPipe;
        sunGraphics2D.fillpipe = CSurfaceData.sNullPipe;
        sunGraphics2D.shapepipe = CSurfaceData.sNullPipe;
        sunGraphics2D.textpipe = CSurfaceData.sNullPipe;
        sunGraphics2D.imagepipe = CSurfaceData.sNullPipe;
        return sunGraphics2D;
    }

    long getCGContext() {
        if (this.fCurrentContext != 0L) {
            return this.fCurrentContext;
        }
        return this.getContainerContext(this.fModelPtr, EventQueue.isDispatchThread(), 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.fTarget.getHeight());
    }

    private native long getContainerContext(long var1, boolean var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public void print(Graphics graphics) {
        if (this.fTarget instanceof Container) {
            super.print(graphics);
            SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.fTarget).getComponents(), graphics, 3);
        } else {
            this.fTarget.print(graphics);
        }
    }

    public ContainerModel(Container container) {
        super(container);
    }

    public void beginLayout() {
        try {
            this.isLayouting = true;
            this.setIsLayouting(this.fModelPtr, this.isLayouting);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void endLayout() {
        try {
            if (!(this.paintArea.isEmpty() || this.paintPending || this.fTarget.getIgnoreRepaint())) {
                this.postEvent(new PaintEvent(this.fTarget, 800, new Rectangle()));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.isLayouting = false;
        this.setIsLayouting(this.fModelPtr, this.isLayouting);
    }

    private native void setIsLayouting(long var1, boolean var3);

    public void updateCursorImmediately() {
        if (!this.fTarget.isShowing()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[2];
        CoreGraphicsAPI.CGGetGlobalInputPointerPosition(nArray);
        Point point = this.fTarget.getLocationOnScreen();
        n = nArray[0] - point.x;
        n2 = nArray[1] - point.y;
        Component component = null;
        if (this.fTarget instanceof Container) {
            component = ((Container)this.fTarget).findComponentAt(n, n2);
        }
        if (component == null) {
            return;
        }
        Cursor cursor = component.getCursor();
        this._updateCursorImmediately(this.fModelPtr, cursor);
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public Insets getInsets() {
        return this.fInsets;
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public Insets insets() {
        return this.getInsets();
    }

    static {
        $assertionsDisabled = !ContainerModel.class.desiredAssertionStatus();
        sDefaultFont = new Font("Lucida Grande", 0, 13);
    }

    class PaintingLock {
        PaintingLock() {
        }
    }

    class SurfaceLock {
        SurfaceLock() {
        }
    }
}

