/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.OSXVolatileImage;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import sun.awt.SunToolkit;

public abstract class ComponentModel
extends CComponent {
    protected GraphicsConfiguration fGraphicsConfiguration;
    protected long fModelPtr;
    int fOldWidth = 0;
    int fOldHeight = 0;

    public ComponentModel(Component component) {
        this.fTarget = component;
        this.fGraphicsConfiguration = this.fTarget.getGraphicsConfiguration();
        this.fOldWidth = component.getWidth();
        this.fOldHeight = component.getHeight();
        this.fModelPtr = this.initPeer(ComponentModel.findParentModel(component));
        SunToolkit.insertTargetMapping(this, SunToolkit.targetToAppContext(this.fTarget));
    }

    public abstract long initPeer(long var1);

    protected void disposeImpl() {
        CToolkit.targetDisposedPeer(this.fTarget, this);
        long l = this.fModelPtr;
        this.fModelPtr = 0L;
        this._disposeImpl(l);
    }

    private native void _disposeImpl(long var1);

    static long findParentModel(Component component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            ComponentPeer componentPeer = component.getPeer();
            if (!(componentPeer instanceof ComponentModel)) continue;
            return ((ComponentModel)componentPeer).fModelPtr;
        }
        return 0L;
    }

    long findWindowModelForChildComponent() {
        for (Container container = this.fTarget.getParent(); container != null; container = container.getParent()) {
            ComponentPeer componentPeer = container.getPeer();
            if (!(componentPeer instanceof CWindow)) continue;
            return ((ComponentModel)componentPeer).fModelPtr;
        }
        return 0L;
    }

    long getModelPtr() {
        return this.fModelPtr;
    }

    public final GraphicsConfiguration getGraphicsConfiguration() {
        return this.fGraphicsConfiguration;
    }

    public final VolatileImage createVolatileImage(int n, int n2) {
        return new OSXVolatileImage(this.fTarget, n, n2);
    }

    public void setVisible(boolean bl) {
        this._setVisible(this.fModelPtr, bl);
    }

    private native void _setVisible(long var1, boolean var3);

    public void setEnabled(boolean bl) {
        this._setEnabled(this.fModelPtr, bl);
    }

    private native void _setEnabled(long var1, boolean var3);

    public void setBounds(int n, int n2, int n3, int n4) {
        this._setBounds(this.fModelPtr, n, n2, n3, n4);
        if (this.fOldWidth != n3 || this.fOldHeight != n4) {
            this.markSurfaceDataStale();
            this.fOldWidth = n3;
            this.fOldHeight = n4;
        }
    }

    private native void _setBounds(long var1, int var3, int var4, int var5, int var6);

    public void updateCursorImmediately() {
        if (!this.fTarget.isShowing()) {
            return;
        }
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        Object object = null;
        Cursor cursor = null;
        if (aWTEvent != null) {
            object = aWTEvent.getSource();
        }
        cursor = object instanceof Component ? ((Component)object).getCursor() : this.fTarget.getCursor();
        this._updateCursorImmediately(this.fModelPtr, cursor);
    }

    protected native void _updateCursorImmediately(long var1, Cursor var3);

    public Point getLocationOnScreen() {
        CWindow cWindow = this.getCWindowContainer();
        Point point = cWindow.getLocationOnScreen();
        Component component = this.fTarget;
        while (component.getPeer() != cWindow) {
            Rectangle rectangle = component.getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            component = component.getParent();
        }
        return point;
    }

    public void setForeground(Color color) {
        this._setForeground(this.fModelPtr, color);
    }

    public void setBackground(Color color) {
        this._setBackground(this.fModelPtr, color);
    }

    private native void _setForeground(long var1, Color var3);

    private native void _setBackground(long var1, Color var3);

    public void setFont(Font font) {
        this._setFont(this.fModelPtr, font);
    }

    private native void _setFont(long var1, Font var3);

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        this._handleEvent(this.fModelPtr, aWTEvent);
    }

    private native void _handleEvent(long var1, AWTEvent var3);

    public Graphics getGraphics() {
        try {
            return this.fTarget.getParent().getGraphics();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

