/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CColorPaint;
import apple.awt.CRenderer;
import apple.awt.CTextPipe;
import apple.awt.CompositeCRenderer;
import apple.awt.ContainerModel;
import apple.awt.NSViewAPI;
import apple.awt.RuntimeOptions;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Vector;
import sun.awt.SunHints;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.NullPipe;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;

public abstract class CSurfaceData
extends SurfaceData {
    static final boolean kDEBUG_PAINTING = false;
    protected static final NullPipe sNullPipe = new NullPipe();
    protected static final CRenderer fCRenderer = new CRenderer();
    protected static final PixelToShapeConverter fPixelRenderer = new PixelToShapeConverter(fCRenderer);
    protected static final CTextPipe sTextPipe = new CTextPipe();
    protected static CompositeCRenderer sCompositeRenderer;
    private GraphicsConfiguration fConfig;
    private Rectangle fBounds;
    private static final Vector sDirtySurfaces;
    private boolean fIsDirtySurface = false;
    private SoftReference fSoftReference = null;
    static final boolean sRenderLine;
    static final boolean sRenderDrawRect;
    static final boolean sRenderFillRect;
    static final boolean sRenderDrawRoundRect;
    static final boolean sRenderFillRoundRect;
    static final boolean sRenderDrawOval;
    static final boolean sRenderFillOval;
    static final boolean sRenderDrawArc;
    static final boolean sRenderFillArc;
    static final boolean sRenderDrawPolygon;
    static final boolean sRenderFillPolygon;
    static final boolean sRenderDrawShape;
    static final boolean sRenderFillShape;
    static final boolean sRenderImage;
    static final boolean sRenderString;
    static final boolean sRenderGlyphs;
    static final boolean sRenderUnicodes;
    GraphicsQueue fGraphicsQueue;
    static final int kPrimitive = 0;
    static final int kImage = 1;
    static final int kText = 2;
    static final int kCopyArea = 3;
    static final int kExternal = 4;
    static final int kLine = 5;
    static final int kRect = 6;
    static final int kRoundRect = 7;
    static final int kOval = 8;
    static final int kArc = 9;
    static final int kPolygon = 10;
    static final int kShape = 11;
    static final int kString = 13;
    static final int kGlyphs = 14;
    static final int kUnicodes = 15;
    static final int kCommonParameterCount = 8;
    static final int kLineParametersCount = 8;
    static final int kRectParametersCount = 9;
    static final int kRoundRectParametersCount = 11;
    static final int kOvalParametersCount = 9;
    static final int kArcParametersCount = 12;
    static final int kPolygonParametersCount = 0;
    static final int kShapeParametersCount = 0;
    static final int kImageParametersCount = 21;
    static final int kStringParametersCount = 0;
    static final int kGlyphsParametersCount = 0;
    static final int kUnicodesParametersCount = 0;
    static final int kPixelParametersCount = 0;
    static final int kExternalParametersCount = 0;
    static final int kChangeFlagIndex = 0;
    static final int kBoundsXIndex = 1;
    static final int kBoundsYIndex = 2;
    static final int kBoundsWidthIndex = 3;
    static final int kBoundsHeightIndex = 4;
    static final int kClipStateIndex = 5;
    static final int kClipNumTypesIndex = 6;
    static final int kClipNumCoordsIndex = 7;
    static final int kClipWindingRuleIndex = 8;
    static final int kClipXIndex = 9;
    static final int kClipYIndex = 10;
    static final int kClipWidthIndex = 11;
    static final int kClipHeightIndex = 12;
    static final int kCTMaIndex = 13;
    static final int kCTMbIndex = 14;
    static final int kCTMcIndex = 15;
    static final int kCTMdIndex = 16;
    static final int kCTMtxIndex = 17;
    static final int kCTMtyIndex = 18;
    static final int kColorStateIndex = 19;
    static final int kColorRGBValueIndex = 20;
    static final int kColorIndexValueIndex = 21;
    static final int kColorPointerIndex = 22;
    static final int kColorRGBValue1Index = 23;
    static final int kColorWidthIndex = 24;
    static final int kColorRGBValue2Index = 25;
    static final int kColorHeightIndex = 26;
    static final int kColorIsCyclicIndex = 27;
    static final int kColorx1Index = 28;
    static final int kColortxIndex = 29;
    static final int kColory1Index = 30;
    static final int kColortyIndex = 31;
    static final int kColorx2Index = 32;
    static final int kColorsxIndex = 33;
    static final int kColory2Index = 34;
    static final int kColorsyIndex = 35;
    static final int kCompositeRuleIndex = 36;
    static final int kCompositeValueIndex = 37;
    static final int kStrokeJoinIndex = 38;
    static final int kStrokeCapIndex = 39;
    static final int kStrokeWidthIndex = 40;
    static final int kStrokeDashPhaseIndex = 41;
    static final int kStrokeLimitIndex = 42;
    static final int kHintsAntialiasIndex = 43;
    static final int kHintsTextAntialiasIndex = 44;
    static final int kHintsFractionalMetricsIndex = 45;
    static final int kHintsRenderingIndex = 46;
    static final int kHintsInterpolationIndex = 47;
    static final int kFlushIndex = 48;
    static final int kSizeOfParameters = 49;
    static final int kClipCoordinatesIndex = 0;
    static final int kClipTypesIndex = 1;
    static final int kTextureImageIndex = 2;
    static final int kStrokeDashArrayIndex = 3;
    static final int kFontIndex = 4;
    static final int kFontPaintIndex = 5;
    static final int kBoundsChangedBit = 1;
    static final int kBoundsNotChangedBit = -2;
    static final int kClipChangedBit = 2;
    static final int kClipNotChangedBit = -3;
    static final int kCTMChangedBit = 4;
    static final int kCTMNotChangedBit = -5;
    static final int kColorChangedBit = 8;
    static final int kColorNotChangedBit = -9;
    static final int kCompositeChangedBit = 16;
    static final int kCompositeNotChangedBit = -17;
    static final int kStrokeChangedBit = 32;
    static final int kStrokeNotChangedBit = -33;
    static final int kHintsChangedBit = 64;
    static final int kHintsNotChangedBit = -65;
    static final int kFontChangedBit = 128;
    static final int kFontNotChangedBit = -129;
    static final int kColorSimple = 0;
    static final int kColorAqua = 1;
    static final int kColorSystem = 2;
    static final int kColorGradient = 3;
    static final int kColorTexture = 4;
    static final int kColorNonCyclic = 0;
    static final int kColorCyclic = 1;
    static final int kClipRect = 0;
    static final int kClipShape = 1;
    static final int kFlushNone = 0;
    static final int kFlushCheck = 1;
    static final int kFlushPending = 2;
    int fChangeFlag;
    ByteBuffer fByteParameters = null;
    IntBuffer fIntParameters = null;
    FloatBuffer fFloatParameters = null;
    Object[] fObjectParameters = new Object[6];
    public int seedBounds = 0;
    public int seedClip = 0;
    public int seedTransform = 0;
    public int seedPaint = 0;
    public int seedComposite = 0;
    public int seedStroke = 0;
    public int seedFont = 0;
    public int seedRenderingHints = 0;
    boolean boundsSet = false;
    Rectangle userBounds = new Rectangle();
    float lastUserX = 0.0f;
    float lastUserY = 0.0f;
    float lastUserW = 0.0f;
    float lastUserH = 0.0f;
    FloatBuffer clipCoordinatesArray = null;
    IntBuffer clipTypesArray = null;
    Shape lastClipShape = null;
    float lastClipX = 0.0f;
    float lastClipY = 0.0f;
    float lastClipW = 0.0f;
    float lastClipH = 0.0f;
    final double[] lastCTM = new double[6];
    float lastCTMa = 0.0f;
    float lastCTMb = 0.0f;
    float lastCTMc = 0.0f;
    float lastCTMd = 0.0f;
    float lastCTMtx = 0.0f;
    float lastCTMty = 0.0f;
    static AffineTransform sIdentityMatrix;
    Paint lastPaint = null;
    BufferedImage texturePaintImage = null;
    Rectangle customPaintBounds = new Rectangle();
    Composite lastComposite;
    int lastCompositeAlphaRule = 0;
    float lastCompositeAlphaValue = 0.0f;
    BasicStroke lastStroke = null;
    static BasicStroke defaultBasicStroke;
    Font lastFont;
    Object hintValue;
    SunGraphics2D sg2dCurrent = null;
    final float[] segmentCoordinatesArray = new float[6];
    FloatBuffer shapeCoordinatesArray = null;
    IntBuffer shapeTypesArray = null;
    Rectangle srcCopyAreaRect = new Rectangle();
    Rectangle dstCopyAreaRect = new Rectangle();
    Rectangle finalCopyAreaRect = new Rectangle();
    Rectangle copyAreaBounds = new Rectangle();
    static final int kMinQueueSize = 2;
    static final int kQueueSizeMultiplier = 5;
    static final int kMaxQueueSize;
    static final int kQueueSizeGrowFlush;
    boolean fQueueGraphicsPrimitives = RuntimeOptions.EnableLazyDrawing;

    static native void init(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9);

    public CSurfaceData(SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Rectangle rectangle) {
        super(surfaceType, colorModel);
        this.fSoftReference = new SoftReference<CSurfaceData>(this);
        this.fConfig = graphicsConfiguration;
        this.fBounds = rectangle;
        this.fGraphicsQueue = new GraphicsQueue();
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        sunGraphics2D.imagepipe = fCRenderer;
        if (sunGraphics2D.strokeState == 2) {
            sunGraphics2D.drawpipe = fPixelRenderer;
            sunGraphics2D.fillpipe = fCRenderer;
        } else {
            sunGraphics2D.drawpipe = fCRenderer;
            sunGraphics2D.fillpipe = fCRenderer;
        }
        sunGraphics2D.shapepipe = fCRenderer;
        sunGraphics2D.textpipe = sTextPipe;
        if (sunGraphics2D.compositeState > 1) {
            if (sCompositeRenderer == null) {
                sCompositeRenderer = new CompositeCRenderer();
            }
            sCompositeRenderer.link(sunGraphics2D);
        }
    }

    public Rectangle getBounds() {
        return this.fBounds;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.fConfig;
    }

    public boolean isActive() {
        return true;
    }

    public int startExternal(SunGraphics2D sunGraphics2D) {
        return this.startExternal(fCRenderer, sunGraphics2D);
    }

    public void endExternal(SunGraphics2D sunGraphics2D) {
        this.endExternal(fCRenderer, sunGraphics2D);
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public void lock() {
        throw new InternalError("not implemented yet");
    }

    public void unlock() {
        throw new InternalError("not implemented yet");
    }

    public BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        throw new InternalError("subclass using unimplemented method");
    }

    public void invalidate() {
        super.invalidate();
        this.markDirty(false);
    }

    ContainerModel getPeer() {
        return null;
    }

    static int getRendererTypeForPrimitive(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 13: 
            case 14: 
            case 15: {
                return 2;
            }
        }
        return 0;
    }

    void setupBounds() {
        if (!this.boundsSet) {
            this.boundsSet = true;
            this.fFloatParameters.put(1, this.fBounds.x);
            this.fFloatParameters.put(2, this.fBounds.y);
            this.fFloatParameters.put(3, this.fBounds.width);
            this.fFloatParameters.put(4, this.fBounds.height);
        }
    }

    void setUserBounds(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (this.lastUserX != (float)n || this.lastUserY != (float)n2 || this.lastUserW != (float)n3 || this.lastUserH != (float)n4) {
            this.lastUserX = n;
            this.lastUserY = n2;
            this.lastUserW = n3;
            this.lastUserH = n4;
            this.fFloatParameters.put(1, n);
            this.fFloatParameters.put(2, n2);
            this.fFloatParameters.put(3, n3);
            this.fFloatParameters.put(4, n4);
            this.userBounds.setBounds(n, n2, n3, n4);
            this.fChangeFlag |= 1;
        } else {
            this.fChangeFlag |= 0xFFFFFFFE;
        }
    }

    void setupClip(SunGraphics2D sunGraphics2D) {
        if (this.seedClip == sunGraphics2D.seedClip) {
            return;
        }
        switch (sunGraphics2D.clipState) {
            case 0: 
            case 1: {
                Region region = sunGraphics2D.getCompClip();
                float f = region.getLoX();
                float f2 = region.getLoY();
                float f3 = region.getWidth();
                float f4 = region.getHeight();
                if (this.fIntParameters.get(5) != 0 || f != this.lastClipX || f2 != this.lastClipY || f3 != this.lastClipW || f4 != this.lastClipH) {
                    this.fFloatParameters.put(9, f);
                    this.fFloatParameters.put(10, f2);
                    this.fFloatParameters.put(11, f3);
                    this.fFloatParameters.put(12, f4);
                    this.lastClipX = f;
                    this.lastClipY = f2;
                    this.lastClipW = f3;
                    this.lastClipH = f4;
                    this.fChangeFlag |= 2;
                } else {
                    this.fChangeFlag &= 0xFFFFFFFD;
                }
                this.fIntParameters.put(5, 0);
                break;
            }
            case 2: {
                this.lastClipShape = sunGraphics2D.usrClip;
                GeneralPath generalPath = null;
                generalPath = sunGraphics2D.usrClip instanceof GeneralPath ? (GeneralPath)sunGraphics2D.usrClip : new GeneralPath(sunGraphics2D.usrClip);
                int n = this.getPathLength(generalPath);
                if (this.clipCoordinatesArray == null || this.clipCoordinatesArray.capacity() < n * 6) {
                    this.clipCoordinatesArray = CSurfaceData.getBufferOfSize(n * 6).asFloatBuffer();
                }
                if (this.clipTypesArray == null || this.clipTypesArray.capacity() < n) {
                    this.clipTypesArray = CSurfaceData.getBufferOfSize(n).asIntBuffer();
                }
                int n2 = this.getPathCoordinates(generalPath, this.clipCoordinatesArray, this.clipTypesArray);
                this.fIntParameters.put(6, this.clipTypesArray.position());
                this.fIntParameters.put(7, this.clipCoordinatesArray.position());
                this.fIntParameters.put(8, n2);
                this.fObjectParameters[1] = this.clipTypesArray;
                this.fObjectParameters[0] = this.clipCoordinatesArray;
                this.fChangeFlag |= 2;
                this.fIntParameters.put(5, 1);
            }
        }
        this.seedClip = sunGraphics2D.seedClip;
    }

    void setupTransform(SunGraphics2D sunGraphics2D) {
        if (this.seedTransform == sunGraphics2D.seedTransform) {
            return;
        }
        sunGraphics2D.transform.getMatrix(this.lastCTM);
        float f = (float)this.lastCTM[0];
        float f2 = (float)this.lastCTM[1];
        float f3 = (float)this.lastCTM[2];
        float f4 = (float)this.lastCTM[3];
        float f5 = (float)this.lastCTM[4];
        float f6 = (float)this.lastCTM[5];
        if (f5 != this.lastCTMtx || f6 != this.lastCTMty || f != this.lastCTMa || f2 != this.lastCTMb || f3 != this.lastCTMc || f4 != this.lastCTMd) {
            this.fFloatParameters.put(13, f);
            this.fFloatParameters.put(14, f2);
            this.fFloatParameters.put(15, f3);
            this.fFloatParameters.put(16, f4);
            this.fFloatParameters.put(17, f5);
            this.fFloatParameters.put(18, f6);
            this.lastCTMa = f;
            this.lastCTMb = f2;
            this.lastCTMc = f3;
            this.lastCTMd = f4;
            this.lastCTMtx = f5;
            this.lastCTMty = f6;
            this.fChangeFlag |= 4;
        } else {
            this.fChangeFlag &= 0xFFFFFFFB;
        }
        this.seedTransform = sunGraphics2D.seedTransform;
    }

    void setupPaint(SunGraphics2D sunGraphics2D) {
        if (this.seedPaint == sunGraphics2D.seedPaint && !this.isCustomPaint(sunGraphics2D)) {
            return;
        }
        if (sunGraphics2D.paint instanceof SystemColor) {
            SystemColor systemColor = (SystemColor)sunGraphics2D.paint;
            int n = systemColor.hashCode();
            if (this.fIntParameters.get(19) != 2 || this.fIntParameters.get(21) != n) {
                this.fIntParameters.put(19, 2);
                this.fIntParameters.put(21, n);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof CColorPaint) {
            CColorPaint cColorPaint = (CColorPaint)sunGraphics2D.paint;
            long l = cColorPaint.getNSColor();
            if (this.fIntParameters.get(19) != 1 || (long)this.fIntParameters.get(22) != l) {
                this.fIntParameters.put(19, 1);
                this.fIntParameters.put(22, (int)l);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof Color) {
            Color color = (Color)sunGraphics2D.paint;
            int n = color.getRGB();
            if (this.fIntParameters.get(19) != 0 || this.fIntParameters.get(20) != n) {
                this.fIntParameters.put(19, 0);
                this.fIntParameters.put(20, n);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof GradientPaint) {
            if (this.fIntParameters.get(19) != 3 || this.lastPaint != sunGraphics2D.paint) {
                GradientPaint gradientPaint = (GradientPaint)sunGraphics2D.paint;
                this.fIntParameters.put(19, 3);
                this.fIntParameters.put(23, gradientPaint.getColor1().getRGB());
                this.fIntParameters.put(25, gradientPaint.getColor2().getRGB());
                this.fIntParameters.put(27, gradientPaint.isCyclic() ? 1 : 0);
                Point2D point2D = gradientPaint.getPoint1();
                this.fFloatParameters.put(28, (float)point2D.getX());
                this.fFloatParameters.put(30, (float)point2D.getY());
                point2D = gradientPaint.getPoint2();
                this.fFloatParameters.put(32, (float)point2D.getX());
                this.fFloatParameters.put(34, (float)point2D.getY());
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof TexturePaint) {
            if (this.fIntParameters.get(19) != 4 || this.lastPaint != sunGraphics2D.paint) {
                TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
                this.fIntParameters.put(19, 4);
                this.texturePaintImage = texturePaint.getImage();
                this.fIntParameters.put(24, this.texturePaintImage.getWidth());
                this.fIntParameters.put(26, this.texturePaintImage.getHeight());
                Rectangle2D rectangle2D = texturePaint.getAnchorRect();
                this.fFloatParameters.put(29, (float)rectangle2D.getX());
                this.fFloatParameters.put(31, (float)rectangle2D.getY());
                this.fFloatParameters.put(33, (float)(rectangle2D.getWidth() / (double)this.texturePaintImage.getWidth()));
                this.fFloatParameters.put(35, (float)(rectangle2D.getHeight() / (double)this.texturePaintImage.getHeight()));
                this.fObjectParameters[2] = BufImgSurfaceData.createData(this.texturePaintImage);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (this.fIntParameters.get(19) != 4 || this.lastPaint != sunGraphics2D.paint || (this.fChangeFlag | 1) != 0) {
            Rectangle rectangle = this.customPaintBounds;
            if (sunGraphics2D.constrainClip != null) {
                rectangle.reshape(sunGraphics2D.constrainClip.getLoX(), sunGraphics2D.constrainClip.getLoY(), sunGraphics2D.constrainClip.getWidth(), sunGraphics2D.constrainClip.getHeight());
            } else {
                rectangle.reshape(sunGraphics2D.getCompClip().getLoX(), sunGraphics2D.getCompClip().getLoY(), sunGraphics2D.getCompClip().getWidth(), sunGraphics2D.getCompClip().getHeight());
            }
            PaintContext paintContext = sunGraphics2D.paint.createContext(sunGraphics2D.getDeviceColorModel(), rectangle, this.userBounds, sIdentityMatrix, sunGraphics2D.hints);
            WritableRaster writableRaster = (WritableRaster)paintContext.getRaster(this.userBounds.x, this.userBounds.y, this.userBounds.width, this.userBounds.height);
            ColorModel colorModel = paintContext.getColorModel();
            this.texturePaintImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.fIntParameters.put(19, 4);
            this.fIntParameters.put(24, this.texturePaintImage.getWidth());
            this.fIntParameters.put(26, this.texturePaintImage.getHeight());
            this.fFloatParameters.put(29, (float)this.userBounds.getX());
            this.fFloatParameters.put(31, (float)this.userBounds.getY());
            this.fFloatParameters.put(33, 1.0f);
            this.fFloatParameters.put(35, 1.0f);
            this.fObjectParameters[2] = BufImgSurfaceData.createData(this.texturePaintImage);
            this.fChangeFlag |= 8;
        } else {
            this.fChangeFlag &= 0xFFFFFFF7;
        }
        this.lastPaint = sunGraphics2D.paint;
        this.seedPaint = sunGraphics2D.seedPaint;
    }

    void setupComposite(SunGraphics2D sunGraphics2D) {
        if (this.seedComposite == sunGraphics2D.seedComposite) {
            return;
        }
        Composite composite = sunGraphics2D.composite;
        if (this.lastComposite != composite) {
            this.lastComposite = composite;
            int n = 3;
            float f = 1.0f;
            if (sunGraphics2D.compositeState <= 1 && composite != null) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                n = alphaComposite.getRule();
                f = alphaComposite.getAlpha();
            }
            if (this.lastCompositeAlphaRule != n || this.lastCompositeAlphaValue != f) {
                this.fIntParameters.put(36, n);
                this.fFloatParameters.put(37, f);
                this.lastCompositeAlphaRule = n;
                this.lastCompositeAlphaValue = f;
                this.fChangeFlag |= 0x10;
            } else {
                this.fChangeFlag &= 0xFFFFFFEF;
            }
        } else {
            this.fChangeFlag &= 0xFFFFFFEF;
        }
        this.seedComposite = sunGraphics2D.seedComposite;
    }

    void setupStroke(SunGraphics2D sunGraphics2D) {
        if (this.seedStroke == sunGraphics2D.seedStroke) {
            return;
        }
        BasicStroke basicStroke = defaultBasicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            System.err.println("custom stroke");
        }
        if (this.lastStroke != basicStroke) {
            this.fObjectParameters[3] = basicStroke.getDashArray();
            this.fFloatParameters.put(41, basicStroke.getDashPhase());
            this.fIntParameters.put(39, basicStroke.getEndCap());
            this.fIntParameters.put(38, basicStroke.getLineJoin());
            this.fFloatParameters.put(40, basicStroke.getLineWidth());
            this.fFloatParameters.put(42, basicStroke.getMiterLimit());
            this.fChangeFlag |= 0x20;
            this.lastStroke = basicStroke;
        } else {
            this.fChangeFlag &= 0xFFFFFFDF;
        }
        this.seedStroke = sunGraphics2D.seedStroke;
    }

    void setupFont(Font font, Paint paint) {
        if (font == null) {
            return;
        }
        if (font != this.lastFont || !font.equals(this.lastFont) || (this.fChangeFlag | 8) != 0) {
            this.fObjectParameters[4] = font;
            this.fObjectParameters[5] = paint;
            this.fChangeFlag |= 0x80;
            this.lastFont = font;
        } else {
            this.fChangeFlag &= 0xFFFFFF7F;
        }
    }

    void setupRenderingHints(SunGraphics2D sunGraphics2D) {
        if (this.seedRenderingHints == sunGraphics2D.seedRenderingHints) {
            return;
        }
        boolean bl = false;
        int n = this.getAntialiasHint(sunGraphics2D);
        if (this.fIntParameters.get(43) != n) {
            this.fIntParameters.put(43, n);
            bl = true;
        }
        int n2 = this.getTextAntialiasHint(sunGraphics2D);
        if (this.fIntParameters.get(44) != n2) {
            this.fIntParameters.put(44, n2);
            bl = true;
        }
        int n3 = this.getFractionalMetricsHint(sunGraphics2D);
        if (this.fIntParameters.get(45) != n3) {
            this.fIntParameters.put(45, n3);
            bl = true;
        }
        int n4 = this.getRenderingHint(sunGraphics2D);
        if (this.fIntParameters.get(46) != n4) {
            this.fIntParameters.put(46, n4);
            bl = true;
        }
        int n5 = this.getInterpolationHint(sunGraphics2D);
        if (this.fIntParameters.get(47) != n5) {
            this.fIntParameters.put(47, n5);
            bl = true;
        }
        this.fChangeFlag = bl ? (this.fChangeFlag |= 0x40) : (this.fChangeFlag &= 0xFFFFFFBF);
        this.seedRenderingHints = sunGraphics2D.seedRenderingHints;
    }

    int getAntialiasHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.antialiasHint != 0 ? sunGraphics2D.antialiasHint : RuntimeOptions.Antialiasing;
        return n;
    }

    int getTextAntialiasHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.textAntialiasHint != 0 ? sunGraphics2D.textAntialiasHint : (sunGraphics2D.antialiasHint != 0 ? (sunGraphics2D.antialiasHint == 2 ? 2 : 1) : RuntimeOptions.TextAntialiasing);
        return n;
    }

    int getRenderingHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.renderHint != 0 ? sunGraphics2D.renderHint : RuntimeOptions.Rendering;
        return n;
    }

    int getFractionalMetricsHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.fractionalMetricsHint != 0 ? sunGraphics2D.fractionalMetricsHint : RuntimeOptions.FractionalMetrics;
        return n;
    }

    int getInterpolationHint(SunGraphics2D sunGraphics2D) {
        this.hintValue = sunGraphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        int n = this.hintValue != null ? ((SunHints.Value)this.hintValue).getIndex() : -1;
        int n2 = n != -1 ? n : RuntimeOptions.Interpolation;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n) {
        SunGraphics2D sunGraphics2D2 = sunGraphics2D;
        synchronized (sunGraphics2D2) {
            this.setupGraphicsState(sunGraphics2D, n, sunGraphics2D.font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n, Font font) {
        if (this.fByteParameters == null) {
            this.fByteParameters = CSurfaceData.getBufferOfSize(49);
            this.fIntParameters = this.fByteParameters.asIntBuffer();
            this.fFloatParameters = this.fByteParameters.asFloatBuffer();
        }
        this.fChangeFlag = 0;
        SunGraphics2D sunGraphics2D2 = sunGraphics2D;
        synchronized (sunGraphics2D2) {
            if (this.sg2dCurrent != sunGraphics2D) {
                this.sg2dCurrent = sunGraphics2D;
                this.seedBounds = 0;
                this.seedClip = 0;
                this.seedTransform = 0;
                this.seedPaint = 0;
                this.seedComposite = 0;
                this.seedStroke = 0;
                this.seedFont = 0;
                this.seedRenderingHints = 0;
                this.setupBounds();
                this.setupClip(sunGraphics2D);
                this.setupTransform(sunGraphics2D);
                this.setupPaint(sunGraphics2D);
                this.setupComposite(sunGraphics2D);
                this.setupStroke(sunGraphics2D);
                this.setupFont(font, sunGraphics2D.paint);
                this.setupRenderingHints(sunGraphics2D);
            } else {
                int n2 = CSurfaceData.getRendererTypeForPrimitive(n);
                this.setupBounds();
                this.setupClip(sunGraphics2D);
                this.setupTransform(sunGraphics2D);
                if (n2 != 1 && n2 != 3) {
                    this.setupPaint(sunGraphics2D);
                }
                this.setupComposite(sunGraphics2D);
                if (n2 != 1 && n2 != 2 && n2 != 3) {
                    this.setupStroke(sunGraphics2D);
                }
                if (n2 != 1 && n2 != 0 && n2 != 3) {
                    this.setupFont(font, sunGraphics2D.paint);
                }
                this.setupRenderingHints(sunGraphics2D);
            }
        }
        this.fIntParameters.put(0, this.fChangeFlag);
    }

    int getPathLength(GeneralPath generalPath) {
        int n = 0;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            pathIterator.next();
            ++n;
        }
        return n;
    }

    int getPathCoordinates(GeneralPath generalPath, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        floatBuffer.clear();
        intBuffer.clear();
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(this.segmentCoordinatesArray);
            switch (n) {
                case 0: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    break;
                }
                case 1: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    break;
                }
                case 2: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    floatBuffer.put(this.segmentCoordinatesArray[2]);
                    floatBuffer.put(this.segmentCoordinatesArray[3]);
                    break;
                }
                case 3: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    floatBuffer.put(this.segmentCoordinatesArray[2]);
                    floatBuffer.put(this.segmentCoordinatesArray[3]);
                    floatBuffer.put(this.segmentCoordinatesArray[4]);
                    floatBuffer.put(this.segmentCoordinatesArray[5]);
                    break;
                }
            }
            intBuffer.put(n);
            pathIterator.next();
        }
        return pathIterator.getWindingRule();
    }

    public synchronized void doLine(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (sRenderLine) {
            this.setupGraphicsState(sunGraphics2D, 5);
            if (!this.fGraphicsQueue.addLine(f, f2, f3, f4)) {
                cRenderer.doLine(this, this.fByteParameters, this.fObjectParameters, f, f2, f3, f4);
            }
        }
    }

    public synchronized void doRect(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, boolean bl) {
        if (sRenderDrawRect && !bl || sRenderFillRect && bl) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                this.setUserBounds(sunGraphics2D, (int)f, (int)f2, (int)f3, (int)f4);
            }
            this.setupGraphicsState(sunGraphics2D, 6);
            if (!this.fGraphicsQueue.addRect(f, f2, f3, f4, bl)) {
                cRenderer.doRect(this, this.fByteParameters, this.fObjectParameters, f, f2, f3, f4, bl);
            }
        }
    }

    public synchronized void doRoundRect(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (sRenderDrawRoundRect && !bl || sRenderFillRoundRect && bl) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                this.setUserBounds(sunGraphics2D, (int)f, (int)f2, (int)f3, (int)f4);
            }
            this.setupGraphicsState(sunGraphics2D, 7);
            if (!this.fGraphicsQueue.addRoundRect(f, f2, f3, f4, f5, f6, bl)) {
                cRenderer.doRoundRect(this, this.fByteParameters, this.fObjectParameters, f, f2, f3, f4, f5, f6, bl);
            }
        }
    }

    public synchronized void doOval(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, boolean bl) {
        if (sRenderDrawOval && !bl || sRenderFillOval && bl) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                this.setUserBounds(sunGraphics2D, (int)f, (int)f2, (int)f3, (int)f4);
            }
            this.setupGraphicsState(sunGraphics2D, 8);
            if (!this.fGraphicsQueue.addOval(f, f2, f3, f4, bl)) {
                cRenderer.doOval(this, this.fByteParameters, this.fObjectParameters, f, f2, f3, f4, bl);
            }
        }
    }

    public synchronized void doArc(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
        if (sRenderDrawArc && !bl || sRenderFillArc && bl) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                this.setUserBounds(sunGraphics2D, (int)f, (int)f2, (int)f3, (int)f4);
            }
            this.setupGraphicsState(sunGraphics2D, 9);
            if (!this.fGraphicsQueue.addArc(f, f2, f3, f4, f5, f6, n, bl)) {
                cRenderer.doArc(this, this.fByteParameters, this.fObjectParameters, f, f2, f3, f4, f5, f6, n, bl);
            }
        }
    }

    public synchronized void doPolygon(CRenderer cRenderer, SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        this.flush();
        if (sRenderDrawPolygon && !bl2 || sRenderFillPolygon && bl2) {
            if (bl2 && this.isCustomPaint(sunGraphics2D)) {
                this.setUserBounds(sunGraphics2D, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
            }
            this.setupGraphicsState(sunGraphics2D, 10);
            cRenderer.doPoly(this, this.fByteParameters, this.fObjectParameters, nArray, nArray2, n, bl, bl2);
        }
    }

    public synchronized void drawfillShape(CRenderer cRenderer, SunGraphics2D sunGraphics2D, GeneralPath generalPath, boolean bl) {
        this.flush();
        if (sRenderDrawShape && !bl || sRenderFillShape && bl) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                Rectangle rectangle = generalPath.getBounds();
                this.setUserBounds(sunGraphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.setupGraphicsState(sunGraphics2D, 11);
            int n = this.getPathLength(generalPath);
            if (this.shapeCoordinatesArray == null || this.shapeCoordinatesArray.capacity() < n * 6) {
                this.shapeCoordinatesArray = CSurfaceData.getBufferOfSize(n * 6).asFloatBuffer();
            }
            if (this.shapeTypesArray == null || this.shapeTypesArray.capacity() < n) {
                this.shapeTypesArray = CSurfaceData.getBufferOfSize(n).asIntBuffer();
            }
            int n2 = this.getPathCoordinates(generalPath, this.shapeCoordinatesArray, this.shapeTypesArray);
            cRenderer.doShape(this, this.fByteParameters, this.fObjectParameters, n, this.shapeCoordinatesArray, this.shapeTypesArray, n2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blitImage(CRenderer cRenderer, SunGraphics2D sunGraphics2D, SurfaceData surfaceData, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        if (sRenderImage) {
            SurfaceData surfaceData2 = surfaceData;
            synchronized (surfaceData2) {
                Rectangle rectangle = surfaceData.getBounds();
                int n9 = (int)rectangle.getWidth();
                int n10 = (int)rectangle.getHeight();
                this.setupGraphicsState(sunGraphics2D, 1);
                if (!this.fGraphicsQueue.addImage(surfaceData, bl, bl2, n9, n10, n, n2, n3, n4, n5, n6, n7, n8, color)) {
                    ((CSurfaceData)surfaceData).flush();
                    cRenderer.doImage(this, this.fByteParameters, this.fObjectParameters, surfaceData, bl, bl2, n9, n10, n, n2, n3, n4, n5, n6, n7, n8);
                }
            }
        }
    }

    public synchronized void blitNSImage(CRenderer cRenderer, SunGraphics2D sunGraphics2D, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        this.flush();
        if (sRenderImage) {
            this.setupGraphicsState(sunGraphics2D, 1);
            cRenderer.doNSImage(this, this.fByteParameters, this.fObjectParameters, l, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }

    public synchronized int startExternal(CRenderer cRenderer, SunGraphics2D sunGraphics2D) {
        this.flush();
        this.setupGraphicsState(sunGraphics2D, 4);
        return cRenderer.doStartExternal(this, this.fByteParameters, this.fObjectParameters);
    }

    public synchronized void endExternal(CRenderer cRenderer, SunGraphics2D sunGraphics2D) {
        cRenderer.doEndExternal(this);
    }

    public synchronized void drawString(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        this.flush();
        if (sRenderString) {
            this.setupGraphicsState(sunGraphics2D, 13);
            cTextPipe.doDrawString(this, this.fByteParameters, this.fObjectParameters, string, d, d2);
        }
    }

    public synchronized void drawGlyphs(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        this.flush();
        if (sRenderGlyphs) {
            this.setupGraphicsState(sunGraphics2D, 14, glyphVector.getFont());
            cTextPipe.doDrawGlyphs(this, this.fByteParameters, this.fObjectParameters, glyphVector, f, f2);
        }
    }

    boolean isCustomPaint(SunGraphics2D sunGraphics2D) {
        return !(sunGraphics2D.paint instanceof SystemColor) && !(sunGraphics2D.paint instanceof CColorPaint) && !(sunGraphics2D.paint instanceof Color) && !(sunGraphics2D.paint instanceof GradientPaint) && !(sunGraphics2D.paint instanceof TexturePaint);
    }

    public synchronized void drawUnicodes(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, float f, float f2) {
        this.flush();
        if (sRenderUnicodes) {
            this.setupGraphicsState(sunGraphics2D, 15);
            if (n2 == 1) {
                cTextPipe.doOneUnicode(this, this.fByteParameters, this.fObjectParameters, cArray[n], f, f2);
            } else {
                cTextPipe.doUnicodes(this, this.fByteParameters, this.fObjectParameters, cArray, n, n2, f, f2);
            }
        }
    }

    void intersection(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        long l = n + rectangle.width;
        long l2 = n2 + rectangle.height;
        int n3 = rectangle2.x;
        int n4 = rectangle2.y;
        long l3 = n3 + rectangle2.width;
        long l4 = n4 + rectangle2.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        rectangle3.setBounds(n, n2, (int)l, (int)l2);
    }

    protected Rectangle clipCopyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaBounds.setBounds(sunGraphics2D.devClip.getLoX(), sunGraphics2D.devClip.getLoY(), sunGraphics2D.devClip.getWidth(), sunGraphics2D.devClip.getHeight());
        this.copyAreaBounds.move(-((int)sunGraphics2D.getTransform().getTranslateX()), -((int)sunGraphics2D.getTransform().getTranslateY()));
        this.srcCopyAreaRect.setBounds(n, n2, n3, n4);
        this.intersection(this.srcCopyAreaRect, this.copyAreaBounds, this.srcCopyAreaRect);
        if (this.srcCopyAreaRect.width <= 0 || this.srcCopyAreaRect.height <= 0) {
            return null;
        }
        this.dstCopyAreaRect.setBounds(this.srcCopyAreaRect.x + n5, this.srcCopyAreaRect.y + n6, this.srcCopyAreaRect.width, this.srcCopyAreaRect.height);
        this.intersection(this.dstCopyAreaRect, this.copyAreaBounds, this.dstCopyAreaRect);
        if (this.dstCopyAreaRect.width <= 0 || this.dstCopyAreaRect.height <= 0) {
            return null;
        }
        n = this.dstCopyAreaRect.x - n5;
        n2 = this.dstCopyAreaRect.y - n6;
        n3 = this.dstCopyAreaRect.width;
        n4 = this.dstCopyAreaRect.height;
        this.finalCopyAreaRect.setBounds(n, n2, n3, n4);
        return this.finalCopyAreaRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAll() {
        Vector vector;
        Object object = sDirtySurfaces;
        synchronized (object) {
            vector = (Vector)sDirtySurfaces.clone();
            sDirtySurfaces.removeAllElements();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            SoftReference softReference = (SoftReference)object.nextElement();
            SurfaceData surfaceData = (SurfaceData)softReference.get();
            if (surfaceData == null) continue;
            SurfaceData surfaceData2 = surfaceData;
            synchronized (surfaceData2) {
                surfaceData.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty(boolean bl) {
        Vector vector = sDirtySurfaces;
        synchronized (vector) {
            if (bl && !this.fIsDirtySurface) {
                this.fIsDirtySurface = true;
                sDirtySurfaces.addElement(this.fSoftReference);
            } else if (!bl) {
                this.fIsDirtySurface = false;
                sDirtySurfaces.remove(this.fSoftReference);
            }
        }
    }

    public void flush() {
        if (this.fQueueGraphicsPrimitives) {
            this.fGraphicsQueue.flushIfNeeded();
        }
    }

    void flushQueue(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, ByteBuffer byteBuffer2, int n, Object[] objectArray2, int n2) {
        this.flush(surfaceData, byteBuffer, objectArray, byteBuffer2, n, objectArray2, n2);
    }

    native void flush(SurfaceData var1, ByteBuffer var2, Object[] var3, ByteBuffer var4, int var5, Object[] var6, int var7);

    static ByteBuffer getBufferOfSize(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    static {
        sDirtySurfaces = new Vector();
        sRenderLine = RuntimeOptions.RenderLine;
        sRenderDrawRect = RuntimeOptions.RenderDrawRect;
        sRenderFillRect = RuntimeOptions.RenderFillRect;
        sRenderDrawRoundRect = RuntimeOptions.RenderDrawRoundRect;
        sRenderFillRoundRect = RuntimeOptions.RenderFillRoundRect;
        sRenderDrawOval = RuntimeOptions.RenderDrawOval;
        sRenderFillOval = RuntimeOptions.RenderFillOval;
        sRenderDrawArc = RuntimeOptions.RenderDrawArc;
        sRenderFillArc = RuntimeOptions.RenderFillArc;
        sRenderDrawPolygon = RuntimeOptions.RenderDrawPolygon;
        sRenderFillPolygon = RuntimeOptions.RenderFillPolygon;
        sRenderDrawShape = RuntimeOptions.RenderDrawShape;
        sRenderFillShape = RuntimeOptions.RenderFillShape;
        sRenderImage = RuntimeOptions.RenderImage;
        sRenderString = RuntimeOptions.RenderString;
        sRenderGlyphs = RuntimeOptions.RenderGlyphs;
        sRenderUnicodes = RuntimeOptions.RenderUnicodes;
        int n = 1;
        CSurfaceData.init(RuntimeOptions.ReuseImgRefs, RuntimeOptions.AdjustForJavaDrawing, RuntimeOptions.UsePathsForRects, RuntimeOptions.UseRectsForLines, true, RuntimeOptions.UseTwoImageLazyPixelConversion, RuntimeOptions.UseMPEnabledLazyPixelConversion, RuntimeOptions.MPLazyPixelConversionThresholdSize, RuntimeOptions.MPLazyPixelConversionExpireTime, n);
        sIdentityMatrix = new AffineTransform();
        defaultBasicStroke = new BasicStroke();
        kMaxQueueSize = RuntimeOptions.EnableLazyDrawingQueueSizeMax;
        kQueueSizeGrowFlush = RuntimeOptions.EnableLazyDrawingQueueSizeGrowFlush;
    }

    class GraphicsQueue {
        int fMaxQueueEntryCount = 8;
        ByteBuffer fQueue;
        int fQueueIndex = 0;
        IntBuffer fIntQueue;
        FloatBuffer fFloatQueue;
        Object[] fObjectQueue;
        int fObjectQueueIndex = 0;
        ByteBuffer fByteParameters;
        IntBuffer fIntParameters;
        FloatBuffer fFloatParameters;
        Object[] fObjectParameters;

        public GraphicsQueue() {
            if (8 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 8;
            }
            if (9 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 9;
            }
            if (11 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 11;
            }
            if (9 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 9;
            }
            if (12 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 12;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (21 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 21;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
        }

        boolean addLine(float f, float f2, float f3, float f4) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 5;
            if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        boolean addRect(float f, float f2, float f3, float f4, boolean bl) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 6;
            if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        boolean addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 7;
            if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fFloatQueue.put(this.fQueueIndex++, f5);
                this.fFloatQueue.put(this.fQueueIndex++, f6);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        boolean addOval(float f, float f2, float f3, float f4, boolean bl) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 8;
            if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        boolean addArc(float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n2 = 9;
            if (this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n2))) {
                this.init(n2);
                this.addCommonInfo(n2);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fFloatQueue.put(this.fQueueIndex++, f5);
                this.fFloatQueue.put(this.fQueueIndex++, f6);
                this.fIntQueue.put(this.fQueueIndex++, n);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        boolean addImage(SurfaceData surfaceData, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Color color) {
            if (!CSurfaceData.this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n11 = 1;
            boolean bl3 = false;
            if (surfaceData instanceof BufImgSurfaceData) {
                bl3 = ((BufImgSurfaceData)surfaceData).isImageOnlyAccess();
            }
            if (bl3 && this.canThisRendererBeQueued(CSurfaceData.getRendererTypeForPrimitive(n11))) {
                this.init(n11);
                this.addCommonInfo(n11);
                this.fIntQueue.put(this.fQueueIndex++, color != null ? 1 : 0);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                this.fIntQueue.put(this.fQueueIndex++, bl2 ? 1 : 0);
                this.fFloatQueue.put(this.fQueueIndex++, n);
                this.fFloatQueue.put(this.fQueueIndex++, n2);
                this.fFloatQueue.put(this.fQueueIndex++, n3);
                this.fFloatQueue.put(this.fQueueIndex++, n4);
                this.fFloatQueue.put(this.fQueueIndex++, n5);
                this.fFloatQueue.put(this.fQueueIndex++, n6);
                this.fFloatQueue.put(this.fQueueIndex++, n7);
                this.fFloatQueue.put(this.fQueueIndex++, n8);
                this.fFloatQueue.put(this.fQueueIndex++, n9);
                this.fFloatQueue.put(this.fQueueIndex++, n10);
                this.fObjectQueue[this.fObjectQueueIndex++] = surfaceData;
                return true;
            }
            this.flushIfNeeded();
            return false;
        }

        void addCommonInfo(int n) {
            CSurfaceData.this.markDirty(true);
            IntBuffer intBuffer = CSurfaceData.this.fIntParameters;
            boolean bl = this.fQueueIndex == 0;
            boolean bl2 = (CSurfaceData.this.fChangeFlag & 8) != 0;
            boolean bl3 = bl2 || bl;
            this.fIntQueue.put(this.fQueueIndex++, n);
            if (bl3) {
                this.fIntQueue.put(this.fQueueIndex++, 1);
                this.fIntQueue.put(this.fQueueIndex++, intBuffer.get(19));
                this.fIntQueue.put(this.fQueueIndex++, intBuffer.get(20));
            } else {
                this.fIntQueue.put(this.fQueueIndex++, 0);
            }
        }

        boolean canThisRendererBeQueued(int n) {
            boolean bl = false;
            IntBuffer intBuffer = CSurfaceData.this.fIntParameters;
            switch (n) {
                case 0: {
                    int n2 = -10;
                    if ((CSurfaceData.this.fChangeFlag & n2) != 0 || intBuffer.get(19) != 0) break;
                    bl = true;
                    break;
                }
                case 1: {
                    int n3 = -10;
                    if ((CSurfaceData.this.fChangeFlag & n3) != 0) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        void init(int n) {
            boolean bl;
            boolean bl2 = bl = this.fQueueIndex == 0;
            if (bl) {
                if (this.fByteParameters == null) {
                    this.fByteParameters = CSurfaceData.getBufferOfSize(49);
                    this.fIntParameters = this.fByteParameters.asIntBuffer();
                    this.fFloatParameters = this.fByteParameters.asFloatBuffer();
                    this.fObjectParameters = new Object[6];
                }
                ByteBuffer byteBuffer = CSurfaceData.this.fByteParameters;
                for (int i = 0; i < byteBuffer.capacity(); ++i) {
                    this.fByteParameters.put(i, byteBuffer.get(i));
                }
                Object[] objectArray = CSurfaceData.this.fObjectParameters;
                System.arraycopy(objectArray, 0, this.fObjectParameters, 0, objectArray.length);
            }
            if (this.fQueue == null) {
                this.fQueue = CSurfaceData.getBufferOfSize(2 * this.fMaxQueueEntryCount);
                this.fIntQueue = this.fQueue.asIntBuffer();
                this.fFloatQueue = this.fQueue.asFloatBuffer();
                this.fObjectQueue = new Object[2];
            } else {
                this.assureQueueHasEnoughRoom(n);
            }
        }

        void assureQueueHasEnoughRoom(int n) {
            if (!this.canThisPrimitiveFitInQueue(n)) {
                if (this.fIntQueue.capacity() < kMaxQueueSize) {
                    int n2 = this.fQueue.capacity() / 4 * 5;
                    ByteBuffer byteBuffer = CSurfaceData.getBufferOfSize(n2);
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    Object[] objectArray = new Object[n2 / this.fMaxQueueEntryCount];
                    if (this.fIntQueue.capacity() >= kQueueSizeGrowFlush) {
                        this.flushIfNeeded();
                    } else {
                        int n3;
                        for (n3 = 0; n3 < this.fQueueIndex; ++n3) {
                            intBuffer.put(n3, this.fIntQueue.get(n3));
                        }
                        for (n3 = 0; n3 < this.fObjectQueue.length; ++n3) {
                            objectArray[n3] = this.fObjectQueue[n3];
                        }
                    }
                    this.fQueue = byteBuffer;
                    this.fIntQueue = intBuffer;
                    this.fFloatQueue = floatBuffer;
                    this.fObjectQueue = objectArray;
                } else {
                    this.flushIfNeeded();
                }
            }
        }

        boolean canThisPrimitiveFitInQueue(int n) {
            boolean bl = false;
            int n2 = this.fIntQueue.capacity() - this.fQueueIndex;
            switch (n) {
                case 5: {
                    bl = n2 >= 8;
                    break;
                }
                case 6: {
                    bl = n2 >= 9;
                    break;
                }
                case 7: {
                    bl = n2 >= 11;
                    break;
                }
                case 8: {
                    bl = n2 >= 9;
                    break;
                }
                case 9: {
                    bl = n2 >= 12;
                    break;
                }
                case 1: {
                    bl = n2 >= 21;
                    bl = bl && this.fObjectQueueIndex < this.fObjectQueue.length;
                    break;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushIfNeeded() {
            if (this.fQueue != null) {
                block19: {
                    if (CSurfaceData.this.isActive()) {
                        if (this.fQueueIndex > 0) {
                            CSurfaceData.this.markDirty(false);
                            if (CSurfaceData.this.fIntParameters.get(48) == 2) {
                                this.fIntParameters.put(48, 2);
                                CSurfaceData.this.fIntParameters.put(48, 0);
                            }
                            try {
                                CSurfaceData.this.flushQueue(CSurfaceData.this, this.fByteParameters, this.fObjectParameters, this.fQueue, this.fQueueIndex, this.fObjectQueue, this.fObjectQueueIndex);
                            }
                            catch (InvalidPipeException invalidPipeException) {
                                CSurfaceData cSurfaceData = (CSurfaceData)CSurfaceData.this.sg2dCurrent.getSurfaceData();
                                if (cSurfaceData != null) {
                                    cSurfaceData.sg2dCurrent.revalidateAll();
                                    CSurfaceData cSurfaceData2 = cSurfaceData;
                                    synchronized (cSurfaceData2) {
                                        block18: {
                                            try {
                                                cSurfaceData.flushQueue(cSurfaceData, this.fByteParameters, this.fObjectParameters, this.fQueue, this.fQueueIndex, this.fObjectQueue, this.fObjectQueueIndex);
                                            }
                                            catch (InvalidPipeException invalidPipeException2) {
                                                ContainerModel containerModel = CSurfaceData.this.getPeer();
                                                if (containerModel == null) break block18;
                                                ContainerModel containerModel2 = containerModel;
                                                synchronized (containerModel2) {
                                                    if (!containerModel.isDisposed()) {
                                                        long l = containerModel.getViewPtr();
                                                        NSViewAPI.redrawViewLater(l);
                                                    }
                                                }
                                            }
                                        }
                                        break block19;
                                    }
                                }
                                System.err.println("Skipping the flushing of a non-empty queue because sg2dCurrent.getSurfaceData()=" + cSurfaceData);
                            }
                        }
                    } else if (!CSurfaceData.this.isActive()) {
                        System.err.println("Skipping the flushing of a non-empty queue because isActive()=" + CSurfaceData.this.isActive());
                    }
                }
                this.fQueueIndex = 0;
                this.fObjectQueueIndex = 0;
                this.fQueue.clear();
                this.fIntQueue.clear();
                this.fFloatQueue.clear();
            }
        }
    }
}

