/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CPrinterGraphics;
import apple.awt.CPrinterJobDialog;
import apple.awt.CPrinterPageDialog;
import apple.awt.CPrinterSurfaceData;
import apple.awt.EventDispatchAccess;
import apple.awt.NSPrintInfo;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.print.SunPrinterJobService;

public class CPrinterJob
extends RasterPrinterJob {
    private static String sShouldNotReachHere = "Should not reach here.";
    private boolean noDefaultPrinter = false;
    private static Font defaultFont;
    private long fNSPrintInfo = -1L;
    private Object fNSPrintInfoLock = new Object();

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return pageFormat;
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = this.pageSetup(pageFormat2, null);
        return bl ? pageFormat2 : pageFormat;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        super.setAttributes(printRequestAttributeSet);
        if (printRequestAttributeSet == null) {
            return;
        }
        NSPrintInfo nSPrintInfo = (NSPrintInfo)printRequestAttributeSet.get(NSPrintInfo.class);
        if (nSPrintInfo != null) {
            this.fNSPrintInfo = nSPrintInfo.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        CPrinterJob cPrinterJob;
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        if (!(printService instanceof SunPrinterJobService) || !((SunPrinterJobService)((Object)printService)).usesClass(this.getClass())) {
            this.spoolToService(printRequestAttributeSet);
            return;
        }
        this.setAttributes(printRequestAttributeSet);
        try {
            CPrinterJob cPrinterJob2 = this;
            synchronized (cPrinterJob2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            if (EventQueue.isDispatchThread()) {
                this.printLoop(false);
                new EventDispatchAccess(){

                    public boolean evaluate() {
                        return CPrinterJob.this.performingPrinting;
                    }
                }.pumpEventsAndWait();
            } else {
                this.printLoop(true);
            }
            Object var6_5 = null;
            cPrinterJob = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CPrinterJob cPrinterJob3 = this;
            synchronized (cPrinterJob3) {
                this.performingPrinting = false;
                this.notify();
            }
            throw throwable;
        }
        synchronized (cPrinterJob) {
            this.performingPrinting = false;
            this.notify();
        }
    }

    protected double getXRes() {
        return 0.0;
    }

    protected double getYRes() {
        return 0.0;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return 0.0;
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void startDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void endDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected native void abortDoc();

    public boolean pageSetup(PageFormat pageFormat, Printable printable) {
        CPrinterPageDialog cPrinterPageDialog = new CPrinterPageDialog(new Frame(), this, pageFormat, printable);
        cPrinterPageDialog.setVisible(true);
        boolean bl = cPrinterPageDialog.getRetVal();
        cPrinterPageDialog.dispose();
        return bl;
    }

    private boolean jobSetup(Pageable pageable, boolean bl) {
        CPrinterJobDialog cPrinterJobDialog = new CPrinterJobDialog(new Frame(), this, pageable, bl);
        cPrinterJobDialog.setVisible(true);
        boolean bl2 = cPrinterJobDialog.getRetVal();
        cPrinterJobDialog.dispose();
        return bl2;
    }

    private native void getDefaultPage(PageFormat var1);

    protected native void validatePaper(Paper var1, Paper var2);

    protected void finalize() {
        if (this.fNSPrintInfo != -1L) {
            this.dispose(this.fNSPrintInfo);
        }
    }

    private native long createNSPrintInfo();

    private native void dispose(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNSPrintInfo() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo == -1L) {
                this.fNSPrintInfo = this.createNSPrintInfo();
            }
            return this.fNSPrintInfo;
        }
    }

    private native void printLoop(boolean var1) throws PrinterException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printingDone() {
        CPrinterJob cPrinterJob = this;
        synchronized (cPrinterJob) {
            this.performingPrinting = false;
        }
    }

    private int getAdjustedLastPage() {
        int n;
        int n2 = this.getLastPage();
        if (n2 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n2 = this.mDocument.getNumberOfPages() - 1;
        }
        return n2;
    }

    private PageFormat getPageFormat(int n) {
        PageFormat pageFormat;
        try {
            pageFormat = this.getPageable().getPageFormat(n);
        }
        catch (Exception exception) {
            return null;
        }
        return pageFormat;
    }

    private Printable getPrintable(int n) {
        Printable printable;
        try {
            printable = this.getPageable().getPrintable(n);
        }
        catch (Exception exception) {
            return null;
        }
        return printable;
    }

    private Rectangle2D getPageFormatArea(PageFormat pageFormat) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        return double_;
    }

    private boolean cancelCheck() throws PrinterException {
        boolean bl = this.isCancelled();
        if (bl) {
            this.cancelDoc();
        }
        return bl;
    }

    private PeekGraphics createFirstPassGraphics(PrinterJob printerJob, PageFormat pageFormat) {
        BufferedImage bufferedImage = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), printerJob);
        Rectangle2D rectangle2D = this.getPageFormatArea(pageFormat);
        this.initPrinterGraphics(peekGraphics, rectangle2D);
        return peekGraphics;
    }

    private void printToPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, long l) throws PrinterException {
        Object object;
        Graphics2D graphics2D = null;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing()) {
            object = new BufferedImage(8, 8, 3);
            graphics2D = ((BufferedImage)object).createGraphics();
        } else {
            object = CPrinterSurfaceData.createData(pageFormat, l);
            if (defaultFont == null) {
                defaultFont = new Font("Dialog", 0, 12);
            }
            graphics2D = new SunGraphics2D((SurfaceData)object, Color.black, Color.white, defaultFont);
        }
        object = new CPrinterGraphics(graphics2D, printerJob);
        Rectangle2D rectangle2D = this.getPageFormatArea(pageFormat);
        this.initPrinterGraphics((Graphics2D)object, rectangle2D);
        printable.print((Graphics)object, pageFormat, n);
        graphics2D.dispose();
        graphics2D = null;
    }

    static {
        Toolkit.getDefaultToolkit();
    }
}

