/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CFontProperties;
import apple.awt.CGraphicsDevice;
import apple.awt.CPrinterJob;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.FontProperties;
import sun.awt.SunDisplayChanger;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.security.action.LoadLibraryAction;

public class CGraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    Font sDefaultFont;
    private SunDisplayChanger topLevels = new SunDisplayChanger();

    protected native int getNumScreens();

    public synchronized GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public void displayChanged() {
        GraphicsDevice[] graphicsDeviceArray = this.resetDisplays();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (!(graphicsDeviceArray[i] instanceof CGraphicsDevice)) continue;
            ((CGraphicsDevice)graphicsDeviceArray[i]).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public synchronized GraphicsDevice[] resetDisplays() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        return graphicsDeviceArray;
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    protected String getPlatformFontPath(boolean bl) {
        return NativeFontWrapper.getFontPath((boolean)bl);
    }

    protected GraphicsDevice makeScreenDevice(int n) {
        return new CGraphicsDevice(n);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new CPrinterJob();
    }

    public String mapFamilyName(String string, int n) {
        return string;
    }

    public String mapFontName(String string, int n) {
        return string;
    }

    public FontProperties getFontProperties() {
        Thread.dumpStack();
        return null;
    }

    protected FontProperties createFontProperties() {
        return new CFontProperties();
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        if (this.sDefaultFont == null) {
            this.sDefaultFont = new Font("Lucida Grande", 0, 13);
        }
        return new SunGraphics2D(surfaceData, Color.white, Color.black, this.sDefaultFont);
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

