/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.table;

import java.awt.Component;
import java.util.ListIterator;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.EditCodigo;
import serpro.ppgd.gui.EditMascara;
import serpro.ppgd.gui.EditValor;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.gui.table.TabelaComponentes;
import serpro.ppgd.gui.table.editors.PPGDCellEditorIf;
import serpro.ppgd.gui.table.editors.PPGDComboBoxEditor;
import serpro.ppgd.gui.table.editors.PPGDDefaultEditor;
import serpro.ppgd.gui.table.model.PPGDTableModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PPGDTable
extends TabelaComponentes {
    protected PPGDTableModel ppgdTableModel = new PPGDTableModel();
    private boolean mantemRegistrosEmBranco = true;

    public void setColecao(Colecao pColecao, int tamMaximoGrid) {
        this.ppgdTableModel = new PPGDTableModel();
        this.ppgdTableModel.setTamanhoMaximoGrid(tamMaximoGrid);
        this.ppgdTableModel.setColecao(pColecao);
        this.setModel(this.ppgdTableModel);
        this.preparaEditores();
        this.setAutoResizeMode(2);
    }

    public void preparaEditores() {
        ListIterator itCampos = this.ppgdTableModel.getAtributos().listIterator();
        int col = 0;
        while (itCampos.hasNext()) {
            itCampos.next();
            this.setaEditorColuna(this.ppgdTableModel.getAtributoInformacao(0, col), col);
            ++col;
        }
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Informacao info = this.ppgdTableModel.getAtributoInformacao(row, column);
        if (editor instanceof PPGDCellEditorIf) {
            ((PPGDCellEditorIf)((Object)editor)).getEditCampo().setAssociaInformacao(info);
        }
        return super.prepareEditor(editor, row, column);
    }

    public void setaEditorColuna(Informacao pInfo, int pCol) {
        EditCampo editCampo = null;
        editCampo = FabricaGUI.criaCampo(pInfo);
        if (editCampo instanceof EditMascara) {
            ((EditMascara)editCampo).setSelecionaTextoOnFocusGained(false);
        }
        if (editCampo instanceof EditValor) {
            ((EditValor)editCampo).setSelecionaTextoOnFocusGained(false);
        }
        DefaultCellEditor editor = editCampo instanceof EditCodigo ? new PPGDComboBoxEditor(editCampo) : new PPGDDefaultEditor(editCampo);
        this.customizaEditor(editor, pCol);
        this.getColumnModel().getColumn(pCol).setCellEditor(editor);
    }

    public void editarCelula(int pRow, int pCol) {
        this.editCellAt(pRow, pCol);
        ((PPGDCellEditorIf)((Object)this.getColumnModel().getColumn(pCol).getCellEditor())).getEditCampo().setaFoco(true);
    }

    protected void customizaEditor(DefaultCellEditor pEditor, int pCol) {
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setaLarguraColunas(int[] tamCols) {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            cm.getColumn(i).setPreferredWidth(tamCols[i]);
            cm.getColumn(i).setWidth(tamCols[i]);
            ++i;
        }
        this.resizeAndRepaint();
    }

    public void setaAlinhamentoColuna(int numCol, int aHorz) {
        TableColumnModel cm = this.getColumnModel();
        CellRendererPersonalizado renderer = new CellRendererPersonalizado(aHorz);
        cm.getColumn(numCol).setCellRenderer(renderer);
        this.resizeAndRepaint();
    }

    public void limparLinha(int pLinha) {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        this.ppgdTableModel.limparLinha(pLinha);
        this.limpaLinhasEmBranco();
    }

    public void limpaLinhasEmBranco() {
        if (!this.isMantemRegistrosEmBranco()) {
            this.ppgdTableModel.getColecao().excluirRegistrosEmBranco();
        }
        this.repaint();
    }

    public PPGDTableModel getPpgdTableModel() {
        return this.ppgdTableModel;
    }

    public boolean isMantemRegistrosEmBranco() {
        return this.mantemRegistrosEmBranco;
    }

    public void setMantemRegistrosEmBranco(boolean mantemRegistrosEmBranco) {
        this.mantemRegistrosEmBranco = mantemRegistrosEmBranco;
    }

    public void addItem(ObjetoNegocio obj) {
        ((PPGDTableModel)this.getModel()).getColecao().recuperarLista().add(obj);
        ((PPGDTableModel)this.getModel()).fireTableDataChanged();
    }

    class CellRendererPersonalizado
    extends DefaultTableCellRenderer {
        int aHorz;

        public CellRendererPersonalizado(int pAHorz) {
            this.aHorz = pAHorz;
        }

        protected void setValue(Object value) {
            if (value != null) {
                this.setHorizontalTextPosition(this.aHorz);
                this.setHorizontalAlignment(this.aHorz);
                this.setText(value == null ? "" : value.toString());
            } else {
                super.setValue(value);
            }
        }
    }
}

