/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.pendencia;

import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class TableModelPendencia
extends AbstractTableModel {
    protected String[] nomeColunas;
    protected List lstPendencia;
    protected Vector lstPendenciaTable;
    protected int numMinLinhas;
    protected int numLinhasTitulo;
    protected int totalAvisos;
    protected int totalErros;
    protected int[] tamColunas;
    protected int posicaoQuebraDeLinhaMensagem = 90;

    public TableModelPendencia(String[] nomeColunas, int numMinLinhas, int[] pTamColunas, List lstPendencia) {
        this.nomeColunas = nomeColunas;
        this.lstPendencia = lstPendencia;
        this.lstPendenciaTable = this.montaTableListaPendencia(lstPendencia);
        this.numMinLinhas = numMinLinhas;
        this.tamColunas = pTamColunas;
    }

    public int getColumnCount() {
        return this.nomeColunas.length;
    }

    public int getRowCount() {
        if (this.numMinLinhas > this.lstPendenciaTable.size()) {
            return this.numMinLinhas;
        }
        return this.lstPendenciaTable.size();
    }

    public String getColumnName(int col) {
        return this.nomeColunas[col];
    }

    public Object getValueAt(int row, int col) {
        LinhaPendencia linhaPendencia = this.getLinhaPendenciaAt(row);
        if (linhaPendencia != null) {
            switch (col) {
                case 0: {
                    return linhaPendencia.getTipo();
                }
                case 1: {
                    if (linhaPendencia.getSeveridade() == 0) {
                        String texto = linhaPendencia.getCampo();
                        texto = texto.replaceAll("<BR>", " ");
                        texto = texto.replaceAll("\n", " ");
                        texto = texto.replaceAll("<HTML>", " ");
                        texto = texto.replaceAll("</HTML>", " ");
                        texto = "<HTML><LEFT>" + UtilitariosString.insereQuebraDeLinha((String)texto, (int)(this.getPosicaoQuebraDeLinhaMensagem() - 15), (String)"<BR>") + "</LEFT></HTML>";
                        return "<html><b>" + texto + "</b></html>";
                    }
                    String texto = linhaPendencia.getCampo();
                    texto = texto.replaceAll("<BR>", " ");
                    texto = texto.replaceAll("\n", " ");
                    texto = texto.replaceAll("<HTML>", " ");
                    texto = texto.replaceAll("</HTML>", " ");
                    texto = "<HTML><LEFT>" + UtilitariosString.insereQuebraDeLinha((String)texto, (int)this.getPosicaoQuebraDeLinhaMensagem(), (String)"<BR>") + "</LEFT></HTML>";
                    return texto;
                }
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public Pendencia getPendenciaAt(int index) {
        LinhaPendencia linha = this.getLinhaPendenciaAt(index);
        if (linha == null) {
            return null;
        }
        return linha.getPendencia();
    }

    public LinhaPendencia getLinhaPendenciaAt(int index) {
        if (index < this.lstPendenciaTable.size()) {
            return (LinhaPendencia)this.lstPendenciaTable.get(index);
        }
        return null;
    }

    public int getTotalAvisos() {
        return this.totalAvisos;
    }

    public int getTotalErros() {
        return this.totalErros;
    }

    public Vector getListaPendencias() {
        return this.lstPendenciaTable;
    }

    protected Vector montaTableListaPendencia(List lstPendencia) {
        int contaLinhasTitulo = 0;
        Vector<LinhaPendencia> listaPendencia = new Vector<LinhaPendencia>(lstPendencia.size());
        String tituloFichaAnterior = "";
        String item = "";
        String itemPendente = "";
        int i = 0;
        while (i < lstPendencia.size()) {
            if (lstPendencia.get(i) != null) {
                Pendencia pendencia = (Pendencia)lstPendencia.get(i);
                String tituloFichaAtual = pendencia.getCampoInformacao().getFicha();
                byte severidade = pendencia.getSeveridade();
                if (!tituloFichaAtual.equals(tituloFichaAnterior)) {
                    if (severidade == 2 || severidade == 3 || severidade == 5) {
                        listaPendencia.add(new LinhaPendencia(0, tituloFichaAtual, null));
                    }
                    tituloFichaAnterior = tituloFichaAtual;
                    ++contaLinhasTitulo;
                }
                if (!(i != 0 && !tituloFichaAtual.equals(tituloFichaAnterior) || i > 0 && pendencia.getCampoInformacao() == ((Pendencia)lstPendencia.get(i - 1)).getCampoInformacao())) {
                    item = "";
                    if (pendencia.getNumItem() >= 1) {
                        item = this.getLabelNumeracaoItem(pendencia);
                    }
                    if (!(itemPendente = String.valueOf(pendencia.getMsg()) + item).equals("")) {
                        switch (severidade) {
                            case 2: {
                                ++this.totalAvisos;
                                break;
                            }
                            case 3: {
                                ++this.totalErros;
                                break;
                            }
                            case 5: {
                                ++this.totalErros;
                            }
                        }
                        if (severidade == 2 || severidade == 3 || severidade == 5) {
                            listaPendencia.add(new LinhaPendencia(severidade, itemPendente, pendencia));
                        }
                    }
                }
            }
            ++i;
        }
        this.numLinhasTitulo = contaLinhasTitulo;
        return listaPendencia;
    }

    public int[] getTamColunas() {
        return this.tamColunas;
    }

    public void setTamColunas(int[] tamColunas) {
        this.tamColunas = tamColunas;
    }

    public int getNumMinLinhas() {
        return this.numMinLinhas;
    }

    public void setNumMinLinhas(int numMinLinhas) {
        this.numMinLinhas = numMinLinhas;
    }

    public void atualizaPendencias(List pLstPendencia) {
        this.lstPendencia = pLstPendencia;
        this.totalAvisos = 0;
        this.totalErros = 0;
        this.lstPendenciaTable = this.montaTableListaPendencia(this.lstPendencia);
        this.fireTableDataChanged();
    }

    public int getPosicaoQuebraDeLinhaMensagem() {
        return this.posicaoQuebraDeLinhaMensagem;
    }

    public void setPosicaoQuebraDeLinhaMensagem(int posicaoQuebraDeLinhaMensagem) {
        this.posicaoQuebraDeLinhaMensagem = posicaoQuebraDeLinhaMensagem;
    }

    public String getLabelNumeracaoItem(Pendencia pendencia) {
        return " - item no. " + pendencia.getNumItem();
    }
}

