/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.BlinkBorder;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDCheckBox;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.Opcao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.LogPPGD;

public class EditOpcao
extends EditCampo {
    private static Opcao vazio = new Opcao();
    private Box box;
    private int orientacaoTexto = 0;
    private static final Color DEFAULT_FOREGROUND = new JCheckBox().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map opcoes;
    private LinkedList listaOrdenada = new LinkedList();
    private BlinkBorder borda;

    public EditOpcao() {
        super((Informacao)vazio);
    }

    public EditOpcao(Informacao campo, int tamanho) {
        super(campo, tamanho);
    }

    public EditOpcao(Informacao campo) {
        super(campo);
    }

    public void setFont(Font pFont) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            opcao.setFont(pFont);
        }
    }

    public void setForeground(Color pCor) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            opcao.setForeground(pCor);
        }
    }

    public void setFont(String pCodigoOpcao, Color pCor) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setForeground(pCor);
        }
    }

    public void setFont(String pCodigoOpcao, Font pFont) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setFont(pFont);
        }
    }

    public void addListener(String pCodigoOpcao, EventListener listener) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            this.adicionaListener(opcao, listener);
        }
    }

    private void adicionaListener(JCheckBox opcao, EventListener listener) {
        if (listener instanceof ActionListener) {
            opcao.addActionListener((ActionListener)listener);
        } else if (listener instanceof ItemListener) {
            opcao.addItemListener((ItemListener)listener);
        } else if (listener instanceof KeyListener) {
            opcao.addKeyListener((KeyListener)listener);
        } else if (listener instanceof FocusListener) {
            opcao.addFocusListener((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            opcao.addMouseListener((MouseListener)listener);
        } else if (listener instanceof MouseMotionListener) {
            opcao.addMouseMotionListener((MouseMotionListener)listener);
        }
    }

    public void addListener(EventListener listener) {
        Iterator itOpcoes = this.opcoes.values().iterator();
        while (itOpcoes.hasNext()) {
            JCheckBox opcao = (JCheckBox)itOpcoes.next();
            this.adicionaListener(opcao, listener);
        }
    }

    public void addValidador(ValidadorImpeditivoDefault validador, String valOpcao) {
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int orientacaoTexto) {
        this.orientacaoTexto = orientacaoTexto;
        this.box = new Box(orientacaoTexto);
        this.setInformacao(this.getInformacao());
    }

    public void setOpcaoHabilitada(String pCodigoOpcao, boolean pOpt) {
        if (this.opcoes.containsKey(pCodigoOpcao)) {
            JCheckBox opcao = (JCheckBox)this.opcoes.get(pCodigoOpcao);
            opcao.setEnabled(pOpt);
            if (!pOpt) {
                opcao.setForeground(DISABLED_FOREGROUND);
            } else {
                opcao.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public void setInformacao(Informacao campo) {
        this.opcoes = new Hashtable();
        this.listaOrdenada = new LinkedList();
        if (this.box == null) {
            this.box = new Box(this.getOrientacaoTexto());
        } else {
            this.box.removeAll();
        }
        Opcao opcao = (Opcao)campo;
        Iterator itOpcoes = opcao.getListaOrdenada().iterator();
        while (itOpcoes.hasNext()) {
            ItemOpcao opt = (ItemOpcao)itOpcoes.next();
            PPGDCheckBox cb = new PPGDCheckBox(opt.getCodigo(), opt.getDescricao(), opt.isSelecionado());
            cb.setInformacao(campo);
            cb.setVisible(true);
            cb.setSelected(opt.isSelecionado());
            this.opcoes.put(cb.getName(), cb);
            this.listaOrdenada.addLast(cb);
            cb.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    EditOpcao.this.setIdentificacaoFoco(false);
                    EditOpcao.this.chamaValidacao();
                }
            });
            cb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    JCheckBox opcao = (JCheckBox)e.getSource();
                    String codigoOpcao = opcao.getName().trim();
                    ((Opcao)EditOpcao.this.getInformacao()).atualizaListaValidadoresImpeditivos(codigoOpcao);
                    if (!EditOpcao.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !EditOpcao.this.verificaValidacoesImpeditivas(codigoOpcao)) {
                        return;
                    }
                    if (e.getStateChange() == 1 && !EditOpcao.this.isBloqueiaItemListener()) {
                        ((Opcao)EditOpcao.this.getInformacao()).addSelectedItem(codigoOpcao);
                    }
                    if (e.getStateChange() == 2 && !EditOpcao.this.isBloqueiaItemListener()) {
                        ((Opcao)EditOpcao.this.getInformacao()).delSelectedItem(codigoOpcao);
                    }
                    EditOpcao.this.chamaValidacao();
                }
            });
            if (this.getOrientacaoTexto() == 0) {
                this.box.add(new JLabel(" "));
            }
            this.box.add(cb);
        }
        this.setObservadorAtivo(false);
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
        this.implementacaoPropertyChange(evt);
        this.setObservadorAtivo(true);
        this.box.validate();
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void setIdentificacaoFoco(boolean status) {
        if (this.getComponenteEditor().getBorder() != null) {
            if (status) {
                this.borda = new BlinkBorder(this.getComponenteEditor());
                this.borda.start();
            } else if (this.borda != null) {
                this.borda.parar();
                this.borda = null;
            }
        } else {
            super.setIdentificacaoFoco(status);
        }
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.setObservadorAtivo(false);
        if (evt == null) {
            LogPPGD.debug((String)("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass()));
        }
        if ((evt.getPropertyName() == null || !evt.getPropertyName().equals("ReadOnly")) && evt.getNewValue() instanceof String) {
            String novoValor = (String)evt.getNewValue();
            if (novoValor == null) {
                novoValor = "";
            }
            String descNovoValor = ((Opcao)this.getInformacao()).getDescricaoOpcoes();
            Iterator it = this.opcoes.values().iterator();
            while (it.hasNext()) {
                JCheckBox cb = (JCheckBox)it.next();
                if (descNovoValor.indexOf(cb.getText().trim()) > -1) {
                    this.setBloqueiaItemListener(true);
                    cb.setSelected(true);
                    this.setBloqueiaItemListener(false);
                    continue;
                }
                this.setBloqueiaItemListener(true);
                cb.setSelected(false);
                this.setBloqueiaItemListener(false);
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            JCheckBox cb = (JCheckBox)it.next();
            cb.setEnabled(!readOnly);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        Iterator it = this.opcoes.values().iterator();
        while (it.hasNext()) {
            JCheckBox cb = (JCheckBox)it.next();
            cb.setEnabled(habilitado);
            cb.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
        this.labelCampo.setEnabled(habilitado);
    }

    public JComponent getComponenteFoco() {
        int qtdOpcoes = this.opcoes.values().size();
        int posicaoPrimeiroAtivo = 0;
        if (qtdOpcoes > 0) {
            int i = 0;
            while (i < qtdOpcoes) {
                if (((JCheckBox)this.opcoes.values().toArray()[i]).isEnabled()) {
                    posicaoPrimeiroAtivo = i;
                    break;
                }
                ++i;
            }
            return (JCheckBox)this.opcoes.values().toArray()[posicaoPrimeiroAtivo];
        }
        return null;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bloqueiaItemListener) {
        this.bloqueiaItemListener = bloqueiaItemListener;
    }

    public void setPerdeFocoComEnter(boolean isPerdeFocoComEnter) {
    }
}

