/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.IdUsuario;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioIdIf;
import serpro.ppgd.repositorio.embeddedDB.RepositorioIdDAO;

public class RepositorioIdDB
implements RepositorioIdIf {
    private RepositorioIdDAO repositorioIdDAO = null;

    public RepositorioIdDB(String pNomeCompletoClasseDoId) {
        this.repositorioIdDAO = new RepositorioIdDAO(pNomeCompletoClasseDoId);
    }

    public IdUsuario criaInstanciaIdConcreto() {
        try {
            IdUsuario retorno = this.repositorioIdDAO.criaInstanciaIdConcreto();
            return retorno;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Erro na instancia\u00e7\u00e3o do IdUsuario Concreto :" + e.getMessage());
        }
    }

    public List recuperarIds() {
        try {
            return this.repositorioIdDAO.recuperarIds();
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
            return new Vector();
        }
    }

    public IdUsuario recuperarId(IdUsuario pId) {
        try {
            return this.repositorioIdDAO.recuperarId(pId);
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
            return null;
        }
    }

    public IdUsuario criarId(IdUsuario pId) throws RepositorioException {
        if (this.recuperarId(pId) != null) {
            throw new RepositorioException("O IdUsuario j\u00e1 existe!!!");
        }
        this.repositorioIdDAO.inserir(pId);
        return pId;
    }

    public IdUsuario criarIdNaoPersistido(String pNi) {
        IdUsuario idNovo = this.repositorioIdDAO.criaInstanciaIdConcreto();
        idNovo.getNiContribuinte().setConteudo(pNi);
        return idNovo;
    }

    public void removerId(IdUsuario id) throws RepositorioException {
        try {
            this.repositorioIdDAO.deletar(id);
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
        }
    }

    public void salvar(IdUsuario id) throws RepositorioException {
        if (this.recuperarId(id) == null) {
            try {
                this.repositorioIdDAO.inserir(id);
            }
            catch (RepositorioException e) {
                FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
            }
        } else {
            try {
                this.repositorioIdDAO.alterar(id);
            }
            catch (RepositorioException e) {
                FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
            }
        }
    }

    public void salvar() throws RepositorioException {
    }
}

