/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.persistenciagenerica;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.RepositorioGenericoIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLDefault
implements RepositorioGenericoIf {
    public Map cacheObjetosAbertos = new Hashtable();
    private static RepositorioXMLDefault instancia;
    private boolean manterCache = true;
    static /* synthetic */ Class class$serpro$ppgd$negocio$ObjetoNegocio;

    public static RepositorioXMLDefault getInstancia() {
        return instancia != null ? instancia : (instancia = new RepositorioXMLDefault());
    }

    public void setManterCache(boolean manterCache) {
        this.manterCache = manterCache;
        if (!manterCache) {
            this.zeraCache();
        }
    }

    public boolean isManterCache() {
        return this.manterCache;
    }

    public void zeraCache() {
        this.cacheObjetosAbertos.clear();
    }

    public ObjetoNegocio getObjeto(String pathArquivoXML) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        if (this.manterCache && this.cacheObjetosAbertos.containsKey(pathArquivoXML)) {
            return (ObjetoNegocio)this.cacheObjetosAbertos.get(pathArquivoXML);
        }
        Document arquivoDados = this.leArquivo(pathArquivoXML);
        if (arquivoDados == null) {
            return null;
        }
        String classe = arquivoDados.getDocumentElement().getAttribute("classeJava");
        ObjetoNegocio retorno = this.instanciaObjetoNegocio(classe);
        this.preencheObjetoNegocio(arquivoDados.getDocumentElement(), null, retorno);
        if (this.manterCache) {
            this.cacheObjetosAbertos.put(pathArquivoXML, retorno);
        }
        return retorno;
    }

    public boolean temObjetoNegocioEmCache(String pathArquivoXML) {
        return this.manterCache && this.cacheObjetosAbertos.containsKey(pathArquivoXML);
    }

    public boolean temObjetoPersistido(String pathArquivoXML) {
        File f = new File(pathArquivoXML);
        return f.exists();
    }

    public ObjetoNegocio preencheObjeto(ObjetoNegocio obj, String pathArquivoXML, boolean armazenaEmCache) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        Document arquivoDados = this.leArquivo(pathArquivoXML);
        if (arquivoDados == null) {
            return null;
        }
        String classe = arquivoDados.getDocumentElement().getAttribute("classeJava");
        this.preencheObjetoNegocio(arquivoDados.getDocumentElement(), null, obj);
        if (this.manterCache && armazenaEmCache) {
            this.cacheObjetosAbertos.put(pathArquivoXML, obj);
        }
        return obj;
    }

    public void salvar(ObjetoNegocio obj, String pathArquivoXML) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        if (this.manterCache && !this.cacheObjetosAbertos.containsKey(pathArquivoXML)) {
            this.cacheObjetosAbertos.put(pathArquivoXML, obj);
        }
        try {
            Document cacheDados = this.obterDOM(obj);
            File arquivoXML = new File(pathArquivoXML);
            FileOutputStream os = new FileOutputStream(arquivoXML);
            StreamResult result = new StreamResult(os);
            DOMSource source = new DOMSource(cacheDados);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            os.close();
        }
        catch (Exception e) {
            throw new RepositorioXMLException(e);
        }
    }

    public void excluir(String pathArquivoXML) throws RepositorioXMLException {
        String arq = pathArquivoXML;
        File f = new File(arq);
        f.delete();
        if (this.manterCache && this.cacheObjetosAbertos.containsKey(pathArquivoXML)) {
            this.cacheObjetosAbertos.remove(pathArquivoXML);
        }
    }

    private void preencheObjetoNegocio(Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        Iterator itFields = FabricaUtilitarios.getAllFields(objetoNegocio.getClass()).iterator();
        while (itFields.hasNext()) {
            Field f = (Field)itFields.next();
            if (Modifier.isTransient(f.getModifiers())) continue;
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)f.getName(), (Object)objetoNegocio);
                Node item = namedNodeMap.getNamedItem(f.getName());
                info.setConteudo(item.getNodeValue());
            }
            catch (Exception e) {}
        }
        if (objetoNegocio instanceof Colecao) {
            this.preencheColecao(nodoAtual, (Colecao)objetoNegocio);
        } else {
            NodeList nodeList = nodoAtual.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node nodo = nodeList.item(i);
                if (!(nodo instanceof Element)) continue;
                ObjetoNegocio obj = (ObjetoNegocio)FabricaUtilitarios.getValorFieldGenerico((String)nodo.getNodeName(), (Object)objetoNegocio);
                this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
            }
        }
    }

    private void preencheColecao(Element nodoAtual, Colecao colecao) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        Iterator itFields = FabricaUtilitarios.getAllFields(colecao.getClass()).iterator();
        while (itFields.hasNext()) {
            Field f = (Field)itFields.next();
            if (Modifier.isTransient(f.getModifiers())) continue;
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)f.getName(), (Object)colecao);
                Node item = namedNodeMap.getNamedItem(f.getName());
                info.setConteudo(item.getNodeValue());
            }
            catch (Exception e) {}
        }
        NodeList nodeList = nodoAtual.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodo = nodeList.item(i);
            if (!(nodo instanceof Element) || !nodo.getNodeName().equals("item")) continue;
            ObjetoNegocio obj = colecao.instanciaNovoObjeto();
            this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
            colecao.recuperarLista().add(obj);
        }
    }

    private void preencheElementoXML(Document documentoXML, Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) {
        if (nodoPai != null) {
            nodoPai.appendChild(nodoAtual);
        }
        Iterator itAtributos = FabricaUtilitarios.getAllFields(objetoNegocio.getClass()).iterator();
        while (itAtributos.hasNext()) {
            Field field = (Field)itAtributos.next();
            if (Modifier.isTransient(field.getModifiers())) continue;
            Object valorAtributo = FabricaUtilitarios.getValorFieldGenerico((String)field.getName(), (Object)objetoNegocio);
            if (valorAtributo instanceof Informacao) {
                if (!((Informacao)valorAtributo).isAtributoPersistente() || valorAtributo == null) continue;
                nodoAtual.setAttribute(field.getName(), ((Informacao)valorAtributo).getConteudoFormatado());
                continue;
            }
            if (!(valorAtributo instanceof ObjetoNegocio) || !((ObjetoNegocio)valorAtributo).isPersistente()) continue;
            Element novoNodo = documentoXML.createElement(field.getName());
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, (ObjetoNegocio)valorAtributo);
            if (!(valorAtributo instanceof Colecao)) continue;
            novoNodo.setAttribute("tipoItens", ((Colecao)valorAtributo).getTipoItens().getName());
            this.preencheElementoXMLColecao(documentoXML, novoNodo, nodoAtual, (Colecao)valorAtributo);
        }
    }

    private void preencheElementoXMLColecao(Document documentoXML, Element nodoAtual, Element nodoPai, Colecao colecao) {
        Iterator itItems = colecao.recuperarLista().iterator();
        while (itItems.hasNext()) {
            Element novoNodo = documentoXML.createElement("item");
            ObjetoNegocio obj = (ObjetoNegocio)itItems.next();
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, obj);
        }
    }

    private Document obterDOM(ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        Document declaracaoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.newDocument();
            Element root = declaracaoDOM.createElement("classe");
            declaracaoDOM.appendChild(root);
            root.setAttribute("classeJava", objetoNegocio.getClass().getName());
            root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            if (objetoNegocio instanceof Colecao) {
                root.setAttribute("tipoItens", ((Colecao)objetoNegocio).getTipoItens().getName());
                this.preencheElementoXML(declaracaoDOM, root, null, objetoNegocio);
                this.preencheElementoXMLColecao(declaracaoDOM, root, null, (Colecao)objetoNegocio);
            } else {
                this.preencheElementoXML(declaracaoDOM, root, null, objetoNegocio);
            }
            declaracaoDOM.normalize();
            return declaracaoDOM;
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private ObjetoNegocio instanciaObjetoNegocio(String pClasseAInstanciar) throws RepositorioXMLException {
        ObjetoNegocio resultado = null;
        try {
            Class<?> classeAInstanciar = Class.forName(pClasseAInstanciar);
            if (!Class.forName((class$serpro$ppgd$negocio$ObjetoNegocio == null ? (class$serpro$ppgd$negocio$ObjetoNegocio = RepositorioXMLDefault.class$("serpro.ppgd.negocio.ObjetoNegocio")) : class$serpro$ppgd$negocio$ObjetoNegocio).getName()).isAssignableFrom(classeAInstanciar)) {
                throw new RepositorioXMLException("A classe n\u00e3o \u00e9 um objeto de neg\u00f3cio");
            }
            Constructor<?> construtor = classeAInstanciar.getConstructor(new Class[0]);
            resultado = (ObjetoNegocio)construtor.newInstance(new Object[0]);
            return resultado;
        }
        catch (InvocationTargetException e) {
            throw new RepositorioXMLException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioXMLException(e);
        }
    }

    private Document leArquivo(String pathArquivoDados) {
        Document declaracaoDOM = null;
        File fileArquivoDados = new File(pathArquivoDados);
        if (pathArquivoDados == null || !fileArquivoDados.exists()) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.parse(fileArquivoDados);
        }
        catch (SAXParseException e) {
            LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
        }
        return declaracaoDOM;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FabricaUtilitarios.usaCacheParaReflexao = true;
        instancia = null;
    }
}

