/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import classes.L;
import classes.M;
import classes.bV;
import classes.cK;
import classes.cN;
import classes.da;
import classes.gL;
import classes.gh;
import classes.kC;
import classes.lx;
import classes.s;
import classes.w;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.espolio.DadosEscrituracaoPublica;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNome;

public class Espolio
extends ObjetoNegocio {
    public transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private CPF cpfInventariante = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nomeInventariante = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private Alfa endInventariante = new Alfa((ObjetoNegocio)this, "Endere\u00e7o", 70);
    private Alfa numProcessoJudicial = new Alfa((ObjetoNegocio)this, "N\u00b0 do processo judicial");
    private Alfa idVaraCivil = new Alfa((ObjetoNegocio)this, "Identifica\u00e7\u00e3o da vara c\u00edvil");
    private Alfa comarca = new Alfa((ObjetoNegocio)this, "Comarca");
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", s.a(0));
    private Data dtDecisaoJud = new Data((ObjetoNegocio)this, "Data da decis\u00e3o judicial da partilha");
    private Data dtTransito = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado da decis\u00e3o judicial da partilha");
    private Alfa tipoJudicial = new Alfa((ObjetoNegocio)this, "Judicial");
    private DadosEscrituracaoPublica escrituracaoPublica = new DadosEscrituracaoPublica();

    public Espolio(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.setFicha("Esp\u00f3lio");
        this.tipoJudicial.setConteudo(Logico.SIM);
        this.tipoJudicial.addObservador((Observador)new L(this));
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(this.tab.msg("espolio_cpf_invalido"));
        this.getCpfInventariante().addValidador((ValidadorIf)validadorCPF);
        this.getCpfInventariante().addValidador((ValidadorIf)new lx(this, 3));
        this.getCpfInventariante().addValidador((ValidadorIf)new kC(this, 3, this.tab.msg("espolio_cpf_branco")));
        this.getNomeInventariante().addValidador((ValidadorIf)new w(this, 3, this.tab.msg("espolio_nome_branco")));
        this.getCpfInventariante().addValidador((ValidadorIf)new cN(this, 3));
        this.getNomeInventariante().addValidador((ValidadorIf)new ValidadorNome(3));
        if (this.identificadorDeclaracao.getTipoEspolio().asString().equals(Logico.SIM)) {
            Data data = new Data();
            Data data2 = new Data();
            data.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
            data2.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO);
            this.getDtTransito().addValidador((ValidadorIf)new gh(this, 3));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new bV(this, 3));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new M(this, 3, data, data2));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorData(3));
            this.getDtTransito().addValidador((ValidadorIf)new da(this, 3));
            this.getDtTransito().addValidador((ValidadorIf)new gL(this, 3));
            this.escrituracaoPublica.getDataLavratura().addValidador((ValidadorIf)new cK(this, 3));
        }
    }

    public void setCpfInventariante(CPF cPF) {
        this.cpfInventariante = cPF;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public void setNomeInventariante(Alfa alfa) {
        this.nomeInventariante = alfa;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public void setEndInventariante(Alfa alfa) {
        this.endInventariante = alfa;
    }

    public Alfa getEndInventariante() {
        return this.endInventariante;
    }

    public Alfa getComarca() {
        return this.comarca;
    }

    public Data getDtDecisaoJud() {
        return this.dtDecisaoJud;
    }

    public Data getDtTransito() {
        return this.dtTransito;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public Alfa getIdVaraCivil() {
        return this.idVaraCivil;
    }

    public Alfa getNumProcessoJudicial() {
        return this.numProcessoJudicial;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public String getMesDecisaoJudicial() {
        return this.getDtDecisaoJud().getConteudoFormatado().substring(3, 5);
    }

    public String getAnoDecisaoJudicial() {
        return this.getDtDecisaoJud().getConteudoFormatado().substring(6);
    }

    public int getQtdMesesParaCalculos() {
        String string = this.getAnoDecisaoJudicial();
        String string2 = this.getMesDecisaoJudicial();
        int n2 = -1;
        if (this.tipoJudicial.asString().equals(Logico.SIM)) {
            if (!string.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                n2 = 1;
            } else if (string2.trim().length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        } else {
            String string3 = this.getEscrituracaoPublica().getAnoEscrituracaoPublica();
            String string4 = this.getEscrituracaoPublica().getMesEscrituracaoPublica();
            if (!string3.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                n2 = 1;
            } else if (string4.trim().length() > 0) {
                n2 = Integer.parseInt(string4);
            }
        }
        return n2;
    }

    public Alfa getTipoJudicial() {
        return this.tipoJudicial;
    }

    public DadosEscrituracaoPublica getEscrituracaoPublica() {
        return this.escrituracaoPublica;
    }

    public void limpaCamposFinalEspolio() {
        this.numProcessoJudicial.clear();
        this.idVaraCivil.clear();
        this.comarca.clear();
        this.uf.clear();
        this.dtDecisaoJud.clear();
        this.dtTransito.clear();
    }

    public boolean isVazio() {
        return this.cpfInventariante.isVazio() && this.nomeInventariante.isVazio() && this.endInventariante.isVazio();
    }

    public static Alfa a(Espolio espolio) {
        return espolio.tipoJudicial;
    }
}

