/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import classes.mH;
import java.util.List;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.conjuge.Conjuge;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.eleicoes.Doacoes;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.ganhosdecapital.GanhosDeCapital;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.moedaestrangeira.MoedaEstrangeira;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.negocio.PPGDFacade;

public class IRPFFacade
implements PPGDFacade {
    private static IRPFFacade instancia = null;
    private mH repositorioXMLIRPF = new mH();

    private IRPFFacade() {
    }

    public static IRPFFacade getInstancia() {
        if (instancia == null) {
            instancia = new IRPFFacade();
        }
        return instancia;
    }

    public static void abreDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        try {
            IRPFFacade.getInstancia().repositorioXMLIRPF.b(identificadorDeclaracao);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean existeDeclaracao(String string) {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.f().existeCPFCadastrado(string);
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.f();
    }

    public static void setCacheIdDeclaracao(boolean bl2) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.a(bl2);
    }

    public static void criarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.c(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(String string) {
        IdentificadorDeclaracao identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
        IRPFFacade.excluirDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.a(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(List list) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.a(list);
    }

    public static void salvaDeclaracaoAberta() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.d();
    }

    public static void limpaCacheDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.e();
    }

    public Contribuinte getContribuinte() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getContribuinte();
    }

    public Conjuge getConjuge() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getConjuge();
    }

    public Espolio getEspolio() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getEspolio();
    }

    public Resumo getResumo() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getResumo();
    }

    public boolean isDeclaracaoAberta() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF != null && IRPFFacade.getInstancia().repositorioXMLIRPF.h() != null;
    }

    public ImpostoPago getImpostoPago() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getImpostoPago();
    }

    public Dependentes getDependentes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getDependentes();
    }

    public RendaVariavel getRendaVariavel() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getRendaVariavel();
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getColecaoRendPJTitular();
    }

    public Alimentandos getAlimentandos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getAlimentandos();
    }

    public Pagamentos getPagamentos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getPagamentos();
    }

    public Bens getBens() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getBens();
    }

    public Dividas getDividas() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getDividas();
    }

    public AtividadeRural getAtividadeRural() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getAtividadeRural();
    }

    public GanhosDeCapital getGanhosDeCapital() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getGanhosDeCapital();
    }

    public MoedaEstrangeira getMoedaEstrangeira() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getMoedaEstrangeira();
    }

    public RendPF getRendPFTitular() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getRendPFTitular();
    }

    public Comparativo getComparativo() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getComparativo();
    }

    public ColecaoRendPFDependente getRendPFDependente() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getRendPFDependente();
    }

    public RendIsentos getRendIsentos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getRendIsentos();
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getRendTributacaoExclusiva();
    }

    public Doacoes getDoacoes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h().getDoacoes();
    }

    public ModeloDeclaracao getModelo() {
        return this.getDeclaracao().getModelo();
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return this.repositorioXMLIRPF.b();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao(String string) {
        return this.repositorioXMLIRPF.a(string);
    }

    public DeclaracaoIRPF recuperarDeclaracaoIRPF(String string) {
        try {
            return this.repositorioXMLIRPF.c(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void salvarDeclaracao(String string) {
        try {
            this.repositorioXMLIRPF.b(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void salvarDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        try {
            this.repositorioXMLIRPF.a(declaracaoIRPF);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean existeDeclaracoes() {
        return IRPFFacade.getListaIdDeclaracoes().recuperarLista().size() > 0;
    }

    public DeclaracaoIRPF getDeclaracao() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.h();
    }

    public void verificarIdDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.c();
    }
}

