<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

    // DB_NAME - The name of the database
    define("DB_NAME", "");

    // DB_USER - The username to connect to the database as
    define("DB_USER", "");

    // DB_PASS - The password for DB_USER
    define("DB_PASS", "");

    // DB_ADDR - The address of the database server, in host:port format.
    //           (You might also try setting this to e.g. ":/tmp/mysql.sock" to
    //           use a Unix domain socket, if your mysqld is on the same box as
    //           your web server.)
    define("DB_ADDR", "");

    // DB_TYPE - The database server type. Only "mysql" is supported currently
    define("DB_TYPE", "mysql");

    // DB_PCONNECT - Set to 1 to use persistent database connections. Persistent
    //               connections can give better performance, but may overload
    //               the database server. Set to 0 to use non-persistent
    //               connections.
    define("DB_PCONNECT", 0);

    // INCLUDE_PATH - Filesystem path to the hlstatsinc directory. This path can
    //                be specified relative to hlstats.php by prepending ./ or
    //                ../  If the path begins with a / then it is taken as a
    //                full absolute filesystem path. However if the path begins
    //                with none of these constructs, PHP will search your
    //                include_path (as set in php.ini) (probably NOT the current
    //                directory as might be expected!).
    //                   Example paths:
    //                      1) /usr/local/apache/hlstatsinc
    //                           (absolute path)
    //                      2) ../hlstatsinc
    //                      -) ./hlstatsinc
    //                           (paths relative to hlstats.php)
    //                      3) hlstats/include
    //                           (path relative to include_path)
    //                Under Windows, make sure you use forward slash (/) instead
    //                of back slash (\).
    define("INCLUDE_PATH", "");

    
    // DELETEDAYS - How many days the Event History covers. Must match the value
    //              of DeleteDays in hlstats.conf.
    define("DELETEDAYS", 21);
    
    // MINACTIVITY - How many days players remain in the ranking without playing.
    define("MINACTIVITY", 86400 * 21);

    // Displays menu entry to show the cheater which vac2 has catched
    define("SHOW_VAC_BANS", 1);

    // Displays hitbox flash animation instead of plain html table.
    define("SHOW_WEAPON_TARGET_FLASH", 1);

    // Displays load summarize from all monitored servers. 
    define("SHOW_SERVER_LOAD_IMAGE", 1);
    
    // Defines if chat logging should be saved in the database
    define ("LOG_CHAT", 0);

    // Show country flags for players. 
    // Need to communicate with the masterserver to retrieve countries.
    define("SHOW_FLAGS", 1);
    

    // Displays google worldmap. 
    define("SHOW_GOOGLE_MAP", 0);

    
    // Google map key for your domain!
    // create your key at http://www.google.com/apis/maps/signup.html
    define("GOOGLE_MAP_KEY", "");


    // Google map region to display.
    // For people wanna change the default settings change the coordinates in footer.inc 
    define("GOOGLE_MAP_REGION", "EUROPE");
    //define("GOOGLE_MAP_REGION", "NORTH AMERICA");
    //define("GOOGLE_MAP_REGION", "SOUTH AMERICA");
    //define("GOOGLE_MAP_REGION", "NORTH AFRICA");
    //define("GOOGLE_MAP_REGION", "SOUTH AFRICA");
    //define("GOOGLE_MAP_REGION", "NORTH EUROPE");
    //define("GOOGLE_MAP_REGION", "EAST EUROPE");
    //define("GOOGLE_MAP_REGION", "GERMANY");
    //define("GOOGLE_MAP_REGION", "FRANCE");
    //define("GOOGLE_MAP_REGION", "SPAIN");
    //define("GOOGLE_MAP_REGION", "UNITED KINGDOM");
    //define("GOOGLE_MAP_REGION", "DENMARK");
    //define("GOOGLE_MAP_REGION", "SWEDEN");
    //define("GOOGLE_MAP_REGION", "NORWAY");
    //define("GOOGLE_MAP_REGION", "FINLAND");
    //define("GOOGLE_MAP_REGION", "NETHERLANDS");
    //define("GOOGLE_MAP_REGION", "BELGIUM");
    //define("GOOGLE_MAP_REGION", "POLAND");
    //define("GOOGLE_MAP_REGION", "SUISSE");
    //define("GOOGLE_MAP_REGION", "AUSTRIA");
    //define("GOOGLE_MAP_REGION", "ITALY");
    //define("GOOGLE_MAP_REGION", "TURKEY");
    //define("GOOGLE_MAP_REGION", "BRAZIL");
    //define("GOOGLE_MAP_REGION", "ARGENTINA");
    //define("GOOGLE_MAP_REGION", "RUSSIA");
    //define("GOOGLE_MAP_REGION", "ASIA");
    //define("GOOGLE_MAP_REGION", "CHINA");
    //define("GOOGLE_MAP_REGION", "JAPAN");
    //define("GOOGLE_MAP_REGION", "SOUTH KOREA");
    //define("GOOGLE_MAP_REGION", "AUSTRALIA");
    //define("GOOGLE_MAP_REGION", "WORLD");
    
    // Google map view type - MAP / SATELLITE (default) / HYBRID
    define ("GOOGLE_MAP_TYPE" , "HYBRID");

    

    // MODE - Sets the player-tracking mode. Must match the value of Mode in
    //        hlstats.conf. Possible values:
    //           1) "Normal"    - Recommended for public Internet server use.
    //                            Players will be tracked by Unique ID.
    //           2) "NameTrack" - Useful for shared-PC environments, such as
    //                            Internet cafes, etc. Players will be tracked
    //                            by nickname. EXPERIMENTAL!
    //           3) "LAN"       - Useful for LAN servers where players do not
    //                            have a real Unique ID. Players will be tracked
    //                            by IP Address. EXPERIMENTAL!
    define("MODE", "Normal");


    // set your image path to the web-accessible progress folder - 
    // e.g. /var/www/mywebspace.com/web/hlstatsimg/progress 
    define("IMAGE_PATH", "");
    
    // HLstatsX url without trailing "/hlstats.php" and without trailing "/" - 
    // e.g. HLstatsX url = http://www.mywebspace.com/web/hlstats.php => IMAGE_PATH_URL="http://www.mywebspace.com/web"
    define("IMAGE_PATH_URL", "");

    // Image is updated every 5 minutes
    define("IMAGE_UPDATE_INTERVAL", 300);
    
    // points to the ingame directory, mostly /hlstatsinc/ingame
    define("INGAME_PATH", "");  

    // PLATFORM - Sets the operating system being used. Recognised values:
    //               "POSIX"    - Any variant of Linux or Unix.
    //               "Windows"  - Any variant of Microsoft Windows.
    //            Most parts of HLstats should work on any platform, but this
    //            setting allows for some OS-specific workarounds etc.
    define("PLATFORM", "POSIX");


?>