/**
 * HLstatsX - SourceMod plugin to display ingame messages
 * http://www.hlstatsx.com/
 * Copyright (C) 2007 Tobias Oetzel (Tobi@hlstatsx.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
 
 
#include <sourcemod>
#include <keyvalues>
#include <menus>
#include <sdktools>

new String: game_mod[32];
new String: team_list[16][64];

new Handle: hlx_block_chat_commands;
new String: blocked_commands[][] = { "rank", "skill", "points", "place", "session", "session_data", 
                                     "kpd", "kdratio", "kdeath", "next", "load", "status", "servers", 
                                     "top20", "top10", "top5", "clans", "cheaters", "statsme", "weapons", 
                                     "weapon", "action", "actions", "accuracy", "targets", "target", "kills", 
                                     "kill", "player_kills", "cmd", "cmds", "command", "hlx_display 0", 
                                     "hlx_display 1", "hlx_teams 0", "hlx_teams 1", "hlx_hideranking", 
                                     "hlx_chat 0", "hlx_chat 1", "hlx_menu", "servers 1", "servers 2", 
                                     "servers 3" };

new Handle:HLstatsXMenuMain;
new Handle:HLstatsXMenuAuto;
new Handle:HLstatsXMenuEvents;

new Handle: HandleGameConf;
new Handle: HandleSwitchTeam;
new Handle: HandleRoundRespawn;


public Plugin:myinfo = {
	name = "HLstatsX Plugin",
	author = "Tobi17",
	description = "HLstatsX Ingame Plugin",
	version = "1.1",
	url = "http://www.hlstatsx.com"
};

public OnPluginStart() 
{

	new String: game_description[64];
	GetGameDescription(game_description, 64, true);
	
	if (strcmp(game_description, "Counter-Strike: Source") == 0) {
		game_mod = "CSS";
	}
	if (strcmp(game_description, "Day of Defeat") == 0) {
		game_mod = "DODS";
	}
	if (strcmp(game_description, "Half-Life 2 Deathmatch") == 0) {
		game_mod = "HL2MP";
	}

	LogToGame("Mod Detection: %s [%s]", game_description, game_mod);
	
	HandleGameConf = LoadGameConfigFile("hlstatsx.sdktools");

	StartPrepSDKCall(SDKCall_Player);
	PrepSDKCall_SetFromConf(HandleGameConf, SDKConf_Signature, "SwitchTeam");
	PrepSDKCall_AddParameter(SDKType_PlainOldData, SDKPass_Plain);
	HandleSwitchTeam = EndPrepSDKCall();	

	StartPrepSDKCall(SDKCall_Player);
	PrepSDKCall_SetFromConf(HandleGameConf, SDKConf_Signature, "RoundRespawn");
	HandleRoundRespawn = EndPrepSDKCall();	
	
	CreateHLstatsXMenuMain(HLstatsXMenuMain);
	CreateHLstatsXMenuAuto(HLstatsXMenuAuto);
	CreateHLstatsXMenuEvents(HLstatsXMenuEvents);
	RegServerCmd("hlx_sm_psay",   hlx_sm_psay);
	RegServerCmd("hlx_sm_psay2",  hlx_sm_psay2);
	RegServerCmd("hlx_sm_csay",   hlx_sm_csay);
	RegServerCmd("hlx_sm_msay",   hlx_sm_msay);
	RegServerCmd("hlx_sm_tsay",   hlx_sm_tsay);
	RegServerCmd("hlx_sm_hint",   hlx_sm_hint);
	RegServerCmd("hlx_sm_browse", hlx_sm_browse);
	RegServerCmd("hlx_sm_swap",   hlx_sm_swap);

	RegConsoleCmd("say",          hlx_block_commands);
	RegConsoleCmd("say_team",     hlx_block_commands);

	HookEvent("player_death",     HLstatsX_Event_PlayerDeath);

	CreateConVar("hlx_plugin_version", "1.1", "HLstatsX Ingame Plugin", FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	CreateConVar("hlx_webpage", "http://www.hlstatsx.com", "http://www.hlstatsx.com", FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	hlx_block_chat_commands = CreateConVar("hlx_block_commands", "1", "If activated HLstatsX commands are blocked from the chat area", FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	

}

public OnMapStart()
{
	new max_entities = GetMaxEntities();
	for (new entity_index = 0; (entity_index < max_entities); entity_index++) {
		if (IsValidEntity(entity_index)) {

			new String: entity_classname[64];
			GetEntityNetClass(entity_index, entity_classname, 64);

			if (strcmp(entity_classname, "CCSTeam") == 0) {
				new team_index;
				new index_offset = FindSendPropOffs("CCSTeam", "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs("CCSTeam", "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}

			if (strcmp(entity_classname, "CDODTeam") == 0) {
				new team_index;
				new index_offset = FindSendPropOffs("CDODTeam", "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs("CDODTeam", "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}
			if ((strcmp(entity_classname, "CDODTeam_Allies") == 0) || (strcmp(entity_classname, "CDODTeam_Axis") == 0)) {
				new team_index;
				new index_offset = FindSendPropOffs(entity_classname, "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs(entity_classname, "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}
		}
	}

}

stock color_player(owner_index, player_index, String: client_message[192]) 
{
	if (strcmp(game_mod, "CSS") == 0) {
		new String:client_name[192];
		GetClientName(player_index, client_name, 192);

		if (owner_index == player_index) {
			new String:colored_player_name[192];
			Format(colored_player_name, 192, "\x03%s\x01", client_name);
			ReplaceString(client_message, 192, client_name, colored_player_name);
		} else {
			new String:colored_player_name[192];
			Format(colored_player_name, 192, "\x04%s\x01", client_name);
			ReplaceString(client_message, 192, client_name, colored_player_name);
		}
	}
}

stock color_all_players(owner_index, String: message[192]) 
{
	if (strcmp(game_mod, "CSS") == 0) {
		new max_clients = GetMaxClients();
		for(new i = 1; i <= max_clients; i++) {
			new client = i;
			if (IsClientConnected(client)) {
				color_player(owner_index, client, message);
			}
		}
	}
}

stock get_team_index(String: team_name[])
{
	new loop_break = 0;
	new index = 0;
	while ((loop_break == 0) && (index < sizeof(team_list))) {
   	    if (strcmp(team_name, team_list[index], true) == 0) {
       		loop_break++;
        }
   	    index++;
	}
	if (loop_break == 0) {
		return -1;
	} else {
		return index - 1;
	}
}

stock remove_color_entities(String: message[192])
{
	ReplaceString(message, 192, "x04", "");
	ReplaceString(message, 192, "x03", "");
	ReplaceString(message, 192, "x01", "");
}

stock color_entities(player_index, String: message[192])
{
	ReplaceString(message, 192, "x04", "\x04");
	ReplaceString(message, 192, "x03", "\x03");
	ReplaceString(message, 192, "x01", "\x01");
}


stock build_menu(player_index, String: message[230], time, finish = 1)
{
	new Handle:hBf;
	hBf = StartMessageOne("ShowMenu", player_index);
	if (hBf != INVALID_HANDLE) {
		BfWriteShort(hBf, -1); 
		BfWriteChar(hBf, time);
		BfWriteByte(hBf, finish);
		BfWriteString(hBf, message);
		EndMessage();
	}
}


stock display_menu(player_index, time, String: full_message[1024])
{
	new String: display_message[1024];
	new offset = 0;
	new message_length = strlen(full_message); 
	for(new i = 0; i < message_length; i++) {
		if (i > 0) {
			if ((full_message[i-1] == 92) && (full_message[i] == 110)) {
				new String: buffer[1024];
				strcopy(buffer, (i - offset), full_message[offset]);
				if (strlen(display_message) == 0) {
					strcopy(display_message[strlen(display_message)], strlen(buffer) + 1, buffer); 
				} else {
					display_message[strlen(display_message)] = 10;
					strcopy(display_message[strlen(display_message)], strlen(buffer) + 1, buffer); 
				}
				i++;
				offset = i;
			}
		}
	}

	new String: partial_message[230];
	new maximum_splits = 5;
	new splits = 0;
	while ((splits < maximum_splits) && (strlen(display_message) > 0)) {
		if (strlen(display_message) > 230) {
			strcopy(partial_message, 230, display_message);
			build_menu(player_index, partial_message, time, 1);
			strcopy(display_message, 1024, display_message[229]);
		} else {
			strcopy(partial_message, 230, display_message);
			build_menu(player_index, partial_message, time, 0);
			display_message = ""
		}
		splits++;
	}
}

public Action:hlx_sm_psay(args)
{
	if (args < 3) {
		PrintToServer("Usage: hlx_sm_psay <userid><colored><message> - sends private message");
		return Plugin_Handled;
	}
	
	new String:client_id[32];
	GetCmdArg(1, client_id, 32);

	new String:colored_param[32];
	GetCmdArg(2, colored_param, 32);
	new is_colored = 0;
	new ignore_param = 0;
	if (strcmp(colored_param, "1") == 0) {
		is_colored = 1;
		ignore_param = 1;
	}
	if (strcmp(colored_param, "0") == 0) {
		ignore_param = 1;
	}

	new String:client_message[192];
	new argument_count = GetCmdArgs();

	for(new i = (1 + ignore_param); i < argument_count; i++) {
		new String:temp_argument[192];
		GetCmdArg(i+1, temp_argument, 192);
		if (i > (1 + ignore_param)) {
			if ((191 - strlen(client_message)) > strlen(temp_argument)) {
				if (temp_argument[0] == 41) {
					strcopy(client_message[strlen(client_message)], 191, temp_argument);
				} else if ((strlen(client_message) > 0) && (client_message[strlen(client_message)-1] != 40)) {
					client_message[strlen(client_message)] = 32;
					strcopy(client_message[strlen(client_message)], 192, temp_argument);
				} else {
					strcopy(client_message[strlen(client_message)], 192, temp_argument);
				}
			}
		} else {
			if ((192 - strlen(client_message)) > strlen(temp_argument)) {
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		}
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {

			new String:display_message[192];
			if (strcmp(game_mod, "CSS") == 0) {
				if (is_colored > 0) {
					new String:client_name[192];
					GetClientName(player_index, client_name, 192);
				  	if (StrContains(client_message, client_name, true) >= 0) {
						color_all_players(player_index, client_message);
					}
					color_entities(player_index, client_message);
				}
				Format(display_message, 192, "\x01HLstatsX:\x01 %s", client_message);
				new Handle:hBf;
				hBf = StartMessageOne("SayText2", player_index);
				if (hBf != INVALID_HANDLE) {
					BfWriteByte(hBf, 1); 
					BfWriteByte(hBf, 0); 
					BfWriteString(hBf, display_message);
					EndMessage();
				}
			} else {
				Format(display_message, 192, "HLstatsX: %s", client_message);
				new Handle:hBf;
				hBf = StartMessageOne("SayText", player_index);
				if (hBf != INVALID_HANDLE) {
					BfWriteByte(hBf, 1); 
					BfWriteString(hBf, display_message);
					EndMessage();
				}
			}
			
		}	
	}
	return Plugin_Handled;
}


public Action:hlx_sm_psay2(args)
{
	if (args < 2) {
		PrintToServer("Usage: hlx_sm_psay2 <userid><colored><message> - sends green colored private message");
		return Plugin_Handled;
	}
	
	new String:client_id[32];
	GetCmdArg(1, client_id, 32);

	new String:colored_param[32];
	GetCmdArg(2, colored_param, 32);
	new ignore_param = 0;
	if (strcmp(colored_param, "1") == 0) {
		ignore_param = 1;
	}
	if (strcmp(colored_param, "0") == 0) {
		ignore_param = 1;
	}

	new String:client_message[192];
	new argument_count = GetCmdArgs();

	for(new i = (1 + ignore_param); i < argument_count; i++) {
		new String:temp_argument[192];
		GetCmdArg(i+1, temp_argument, 192);
		if (i > (1 + ignore_param)) {
			if ((191 - strlen(client_message)) > strlen(temp_argument)) {
				if (temp_argument[0] == 41) {
					strcopy(client_message[strlen(client_message)], 191, temp_argument);
				} else if ((strlen(client_message) > 0) && (client_message[strlen(client_message)-1] != 40)) {
					client_message[strlen(client_message)] = 32;
					strcopy(client_message[strlen(client_message)], 192, temp_argument);
				} else {
					strcopy(client_message[strlen(client_message)], 192, temp_argument);
				}
			}
		} else {
			if ((192 - strlen(client_message)) > strlen(temp_argument)) {
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		}
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {

			new String:display_message[192];
			if (strcmp(game_mod, "CSS") == 0) {
				remove_color_entities(client_message);
				Format(display_message, 192, "\x04HLstatsX: %s", client_message);
				new Handle:hBf;
				hBf = StartMessageOne("SayText2", player_index);
				if (hBf != INVALID_HANDLE) {
					BfWriteByte(hBf, 1); 
					BfWriteByte(hBf, 0); 
					BfWriteString(hBf, display_message);
					EndMessage();
				}
			} else {
				Format(display_message, 192, "HLstatsX: %s", client_message);
				new Handle:hBf;
				hBf = StartMessageOne("SayText2", player_index);
				if (hBf != INVALID_HANDLE) {
					BfWriteByte(hBf, 1); 
					BfWriteByte(hBf, 0); 
					BfWriteString(hBf, display_message);
					EndMessage();
				}
			}
		}	
	}
	return Plugin_Handled;
}


public Action:hlx_sm_csay(args)
{
	if (args < 1) {
		PrintToServer("Usage: hlx_sm_csay <message> - display center message");
		return Plugin_Handled;
	}
	
	new String:display_message[192];
	new argument_count = GetCmdArgs();
	for(new i = 1; i <= argument_count; i++) {
		new String:temp_argument[192];
		GetCmdArg(i, temp_argument, 192);
		if (i > 1) {
			if ((191 - strlen(display_message)) > strlen(temp_argument)) {
				display_message[strlen(display_message)] = 32;		
				strcopy(display_message[strlen(display_message)], 192, temp_argument);
			}
		} else {
			if ((192 - strlen(display_message)) > strlen(temp_argument)) {
				strcopy(display_message[strlen(display_message)], 192, temp_argument);
			}
		}
	}

	new Handle:hBf;
	hBf = StartMessageAll("TextMsg");
	if (hBf != INVALID_HANDLE) {
		BfWriteByte(hBf, 4); 
		BfWriteString(hBf, display_message);
		EndMessage();
	}
		
	return Plugin_Handled;
}

public Action:hlx_sm_msay(args)
{
	if (args < 3) {
		PrintToServer("Usage: hlx_sm_msay <time><userid><message> - sends hud message");
		return Plugin_Handled;
	}
	
	if (strcmp("mod", "HL2MP") == 0) {
		return Plugin_Handled;
	}

	new String:display_time[16];
	GetCmdArg(1, display_time, 16);
	new String:client_id[32];
	GetCmdArg(2, client_id, 32);

	new String:client_message[1024];
	new argument_count = GetCmdArgs();
	for(new i = 3; i <= argument_count; i++) {
		new String:temp_argument[1024];
		GetCmdArg(i, temp_argument, 1024);
		if (i > 3) {
			if ((1023 - strlen(client_message)) > strlen(temp_argument)) {
				client_message[strlen(client_message)] = 32;		
				strcopy(client_message[strlen(client_message)], 1024, temp_argument);
			}
		} else {
			if ((1024 - strlen(client_message)) > strlen(temp_argument)) {
				strcopy(client_message[strlen(client_message)], 1024, temp_argument);
			}
		}
	}

	new time = StringToInt(display_time);
	if (time <= 0) {
		time = 10;
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {
			new String: display_message[1024];
			strcopy(display_message, 1024, client_message);
			display_menu(player_index, time, display_message);			
		}	
	}		
		
	return Plugin_Handled;
}

public Action:hlx_sm_tsay(args)
{
	if (args < 3) {
		PrintToServer("Usage: hlx_sm_tsay <time><userid><message> - sends hud message");
		return Plugin_Handled;
	}


	new String:display_time[16];
	GetCmdArg(1, display_time, 16);
	new String:client_id[32];
	GetCmdArg(2, client_id, 32);

	new String:client_message[192];
	new argument_count = GetCmdArgs();
	for(new i = 2; i < argument_count; i++) {
		new String:temp_argument[192];
		GetCmdArg(i+1, temp_argument, 192);
		if (i > 2) {
			if ((191 - strlen(client_message)) > strlen(temp_argument)) {
				client_message[strlen(client_message)] = 32;		
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		} else {
			if ((192 - strlen(client_message)) > strlen(temp_argument)) {
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		}
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {
			new Handle:values = CreateKeyValues("msg");
			KvSetString(values, "title", client_message);
			KvSetNum(values, "level", 1); 
			KvSetString(values, "time", display_time); 
			CreateDialog(player_index, values, DialogType_Msg);
			CloseHandle(values);
		}	
	}		
		
	return Plugin_Handled;
}


public Action:hlx_sm_hint(args)
{
	if (args < 2) {
		PrintToServer("Usage: hlx_sm_hint <userid><message> - send hint message");
		return Plugin_Handled;
	}

	if (strcmp("mod", "HL2MP") == 0) {
		return Plugin_Handled;
	}

	new String:client_id[32];
	GetCmdArg(1, client_id, 32);

	new String:client_message[192];
	new argument_count = GetCmdArgs();
	for(new i = 1; i < argument_count; i++) {
		new String:temp_argument[192];
		GetCmdArg(i+1, temp_argument, 192);
		if (i > 1) {
			if ((191 - strlen(client_message)) > strlen(temp_argument)) {
				client_message[strlen(client_message)] = 32;		
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		} else {
			if ((192 - strlen(client_message)) > strlen(temp_argument)) {
				strcopy(client_message[strlen(client_message)], 192, temp_argument);
			}
		}
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {
			new Handle:hBf;
			hBf = StartMessageOne("HintText", player_index);
			if (hBf != INVALID_HANDLE) {
				if (strcmp(game_mod, "CSS") == 0) {
					BfWriteByte(hBf,   1);
				}
				BfWriteString(hBf, client_message);
				EndMessage();
			}
		}	
	}		
			
	return Plugin_Handled;
}

public Action:hlx_sm_browse(args)
{
	if (args < 2) {
		PrintToServer("Usage: hlx_sm_browse <userid><url> - open client ingame browser");
		return Plugin_Handled;
	}

	new String:client_id[32];
	GetCmdArg(1, client_id, 32);

	new String:client_url[192];
	new String:argument_string[512];
	GetCmdArgString(argument_string, 512);
	new find_pos = StrContains(argument_string, "http://", true);
	if (find_pos == -1) {
		new argument_count = GetCmdArgs();
		for(new i = 1; i < argument_count; i++) {
			new String:temp_argument[192];
			GetCmdArg(i+1, temp_argument, 192);
			if ((192 - strlen(client_url)) > strlen(temp_argument)) {
				strcopy(client_url[strlen(client_url)], 192, temp_argument);
			}
		}
	} else {
		strcopy(client_url, 192, argument_string[find_pos]);
	}

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (!IsFakeClient(player_index)) && (IsClientConnected(player_index))) {
			new Handle:hBf;
			hBf = StartMessageOne("VGUIMenu", player_index);
			if (hBf != INVALID_HANDLE) {
				BfWriteString(hBf, "info");
				BfWriteByte(hBf,   1);
				BfWriteByte(hBf,   3);
				BfWriteString(hBf, "title");
				BfWriteString(hBf, "HLstatsX");
				BfWriteString(hBf, "type");
				BfWriteString(hBf, "2");
				BfWriteString(hBf, "msg");
				BfWriteString(hBf, client_url);
				BfWriteString(hBf, "cmd");
				BfWriteString(hBf, "");
				EndMessage();
			}
		}	
	}		
			
	return Plugin_Handled;
}

public Action:hlx_sm_swap(args)
{
	if (args < 1) {
		PrintToServer("Usage: hlx_sm_swap <userid> - swaps players to the opposite team (css only)");
		return Plugin_Handled;
	}

	new String:client_id[32];
	GetCmdArg(1, client_id, 32);

	new client = StringToInt(client_id);
	if (client > 0) {
		new player_index = GetClientOfUserId(client);
		if ((player_index > 0) && (IsClientConnected(player_index))) {
			swap_player(player_index)
		}
	}
	return Plugin_Handled;
}


stock is_command_blocked(String: command[])
{
	new command_blocked = 0;
	new command_index = 0;
	while ((command_blocked == 0) && (command_index < sizeof(blocked_commands))) {
		if (strcmp(command, blocked_commands[command_index]) == 0) {
			command_blocked++;
		}
		command_index++;
	}
	if (command_blocked > 0) {
		return 1;
	}
	return 0;
}


public Action:hlx_block_commands(client, args)
{

	if (client) {
	
		if (client == 0) {
			return Plugin_Continue;
		}
		
		new block_chat_commands = GetConVarInt(hlx_block_chat_commands);

		new String:user_command[192];
		GetCmdArgString(user_command, 192);
		new String: origin_command[192];

		new start_index = 0
		new command_length = strlen(user_command);
		if (command_length > 0) {
			if (user_command[0] == 34)	{
				start_index = 1;
				if (user_command[command_length - 1] == 34)	{
					user_command[command_length - 1] = 0;
				}
			}
		
			strcopy(origin_command, 192, user_command[start_index]);
			
			if (user_command[start_index] == 47)	{
				start_index++;
			}
		}

		if (command_length > 0) {
			if (block_chat_commands > 0) {

				new String:command_type[32] = "say";
				new command_blocked = is_command_blocked(user_command[start_index]);
				if (command_blocked > 0) {

					if (strcmp("hlx_menu", user_command[start_index]) == 0) {
						DisplayMenu(HLstatsXMenuMain, client, MENU_TIME_FOREVER);
					}
					new String:player_name[64];
					if (!GetClientName(client, player_name, 64))	{
						strcopy(player_name, 64, "UNKNOWN");
					}

					new String:player_authid[64];
					if (!GetClientAuthString(client, player_authid, 64)){
						strcopy(player_authid, 64, "UNKNOWN");
					}

					new player_team_index = GetClientTeam(client);
					new String:player_team[64];
					player_team = team_list[player_team_index];

					new player_userid = GetClientUserId(client);
					LogToGame("\"%s<%d><%s><%s>\" %s \"%s\"", player_name, player_userid, player_authid, player_team, command_type, origin_command); 
					return Plugin_Handled;
				}
			} else {
				if (strcmp("hlx_menu", user_command[start_index]) == 0) {
					DisplayMenu(HLstatsXMenuMain, client, MENU_TIME_FOREVER);
				}
				return Plugin_Continue;
			}
		}
	}
 
	return Plugin_Continue;
}

public Action:HLstatsX_Event_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	if (GetEventBool(event, "headshot"))
	{
		new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));

		new String:player_name[64];
		if (!GetClientName(attacker, player_name, 64))	{
			strcopy(player_name, 64, "UNKNOWN");
		}

		new String:player_authid[64];
		if (!GetClientAuthString(attacker, player_authid, 64)){
			strcopy(player_authid, 64, "UNKNOWN");
		}

		new player_team_index = GetClientTeam(attacker);
		new String:player_team[64];
		player_team = team_list[player_team_index];


		new player_userid = GetClientUserId(attacker);
		LogToGame("\"%s<%d><%s><%s>\" triggered \"headshot\"", player_name, player_userid, player_authid, player_team); 
	}
	return Plugin_Continue
}

stock swap_player(player_index)
{
	if (strcmp(game_mod, "CSS") == 0) {
		if (IsClientConnected(player_index)) {
			new player_team_index = GetClientTeam(player_index);
			new String:player_team[64];
			player_team = team_list[player_team_index];			
				
			new opposite_team_index = -1;
			if (strcmp(player_team, "CT") == 0) {
				opposite_team_index = get_team_index("TERRORIST");
			} else if (strcmp(player_team, "TERRORIST") == 0) {
				opposite_team_index = get_team_index("CT");
			}
			if (opposite_team_index > -1) {
				SDKCall(HandleSwitchTeam, player_index, opposite_team_index);
				SDKCall(HandleRoundRespawn, player_index);
			}
		}
	}
}

CreateHLstatsXMenuMain(&Handle: MenuHandle)
{
	MenuHandle = CreateMenu(HLstatsXMainCommandHandler, MenuAction_Select|MenuAction_Cancel);

	SetMenuTitle(MenuHandle, "HLstatsX - Main Menu");
	AddMenuItem(MenuHandle, "", "Display Rank");
	AddMenuItem(MenuHandle, "", "Next Players");
	AddMenuItem(MenuHandle, "", "Top10 Players");
	AddMenuItem(MenuHandle, "", "Clans Ranking");
	AddMenuItem(MenuHandle, "", "Statsme");
	AddMenuItem(MenuHandle, "", "Auto Ranking");
	AddMenuItem(MenuHandle, "", "Console Events");
	AddMenuItem(MenuHandle, "", "Weapon Usage");
	AddMenuItem(MenuHandle, "", "Weapons Accuracy");
	AddMenuItem(MenuHandle, "", "Weapons Targets");
	AddMenuItem(MenuHandle, "", "Player Kills");
	AddMenuItem(MenuHandle, "", "Toggle Ranking Display");
	AddMenuItem(MenuHandle, "", "VAC Cheaterlist");
	AddMenuItem(MenuHandle, "", "Display Help");

	SetMenuPagination(MenuHandle, 8);
}

CreateHLstatsXMenuAuto(&Handle: MenuHandle)
{
	MenuHandle = CreateMenu(HLstatsXAutoCommandHandler, MenuAction_Select|MenuAction_Cancel);

	SetMenuTitle(MenuHandle, "HLstatsX - Auto-Ranking");
	AddMenuItem(MenuHandle, "", "Enable on round-start");
	AddMenuItem(MenuHandle, "", "Enable on round-end");
	AddMenuItem(MenuHandle, "", "Enable on player death");
	AddMenuItem(MenuHandle, "", "Disable");

	SetMenuPagination(MenuHandle, 8);
}

CreateHLstatsXMenuEvents(&Handle: MenuHandle)
{
	MenuHandle = CreateMenu(HLstatsXEventsCommandHandler, MenuAction_Select|MenuAction_Cancel);

	SetMenuTitle(MenuHandle, "HLstatsX - Console Events");
	AddMenuItem(MenuHandle, "", "Enable Events");
	AddMenuItem(MenuHandle, "", "Disable Events");
	AddMenuItem(MenuHandle, "", "Enable Global Chat");
	AddMenuItem(MenuHandle, "", "Disable Global Chat");

	SetMenuPagination(MenuHandle, 8);
}


stock make_player_command(client, String: player_command[]) 
{
	new String:player_name[64];
	if (!GetClientName(client, player_name, 64)) {
		strcopy(player_name, 64, "UNKNOWN");
	}

	new String:player_authid[64];
	if (!GetClientAuthString(client, player_authid, 64)) {
		strcopy(player_authid, 64, "UNKNOWN");
	}

	new player_team_index = GetClientTeam(client);
	new String:player_team[64];
	player_team = team_list[player_team_index];

	new player_userid = GetClientUserId(client);
	LogToGame("\"%s<%d><%s><%s>\" say \"%s\"", player_name, player_userid, player_authid, player_team, player_command); 

}


public HLstatsXMainCommandHandler(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_Select) {
		if (IsClientConnected(param1)) {
			switch (param2) {
				case 0 : 
					make_player_command(param1, "/rank");
				case 1 : 
					make_player_command(param1, "/next");
				case 2 : 
					make_player_command(param1, "/top10");
				case 3 : 
					make_player_command(param1, "/clans");
				case 4 : 
					make_player_command(param1, "/statsme");
				case 5 : 
					DisplayMenu(HLstatsXMenuAuto, param1, MENU_TIME_FOREVER);
				case 6 : 
					DisplayMenu(HLstatsXMenuEvents, param1, MENU_TIME_FOREVER);
				case 7 : 
					make_player_command(param1, "/weapons");
				case 8 : 
					make_player_command(param1, "/accuracy");
				case 9 : 
					make_player_command(param1, "/targets");
				case 10 : 
					make_player_command(param1, "/kills");
				case 11 : 
					make_player_command(param1, "/hlx_hideranking");
				case 12 : 
					make_player_command(param1, "/cheaters");
				case 13 : 
					make_player_command(param1, "/help");
			}
		}
	}
}

public HLstatsXAutoCommandHandler(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_Select) {
		if (IsClientConnected(param1)) {
			switch (param2) {
				case 0 : 
					make_player_command(param1, "/hlx_auto start rank");
				case 1 : 
					make_player_command(param1, "/hlx_auto end rank");
				case 2 : 
					make_player_command(param1, "/hlx_auto kill rank");
				case 3 : 
					make_player_command(param1, "/hlx_auto clear");
			}
		}
	}
}

public HLstatsXEventsCommandHandler(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_Select) {
		if (IsClientConnected(param1)) {
			switch (param2) {
				case 0 : 
					make_player_command(param1, "/hlx_display 1");
				case 1 : 
					make_player_command(param1, "/hlx_display 0");
				case 2 : 
					make_player_command(param1, "/hlx_chat 1");
				case 3 : 
					make_player_command(param1, "/hlx_chat 0");
			}
		}
	}
}
