<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	// Map Details
	
	$map = valid_request($HTTP_GET_VARS["map"], 0)
		or error("No map specified.");
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() != 1)
		error("Invalid or no game specified.");
	else
		list($gamename) = $db->fetch_row();
		
	pageHeader(
		array($gamename, "Map Details", $map),
		array(
			$gamename=>$g_options["scripturl"] . "?game=$game",
			"Map Statistics"=>$g_options["scripturl"] . "?mode=maps&amp;game=$game",
			"Map Details"=>""
		),
		$map
	);



	$table = new Table(
		array(
			new TableColumn(
				"killerName",
				"Player",
				"width=60&align=left&flag=1&link=" . urlencode("mode=playerinfo&amp;player=%k") 
			),
			new TableColumn(
				"frags",
				"Kills on $map",
				"width=15&align=right"
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=15&align=right"
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			),
			
			
		),
		"killerId", // keycol
		"frags", // sort_default
		"killerName", // sort_default2
		true, // showranking
		50 // numperpage
	);
	
	$result = $db->query("
		SELECT
			hlstats_Events_Frags.killerId,
			hlstats_Players.lastName AS killerName,
      hlstats_Players.flag as flag,
			COUNT(hlstats_Events_Frags.map) AS frags,
			SUM(hlstats_Events_Frags.headshot=1) as headshots,
      IFNULL(SUM(hlstats_Events_Frags.headshot=1) / Count(hlstats_Events_Frags.map), '-') AS hpk
		FROM
			hlstats_Events_Frags,
			hlstats_Players		
		WHERE
			hlstats_Players.playerId = hlstats_Events_Frags.killerId
			AND hlstats_Events_Frags.map='$map'
			AND hlstats_Players.game='$game'
			AND hlstats_Players.hideranking<>'1'
		GROUP BY
			hlstats_Events_Frags.killerId
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder
		LIMIT $table->startitem,$table->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(DISTINCT hlstats_Events_Frags.killerId),
			SUM(hlstats_Events_Frags.map='$map')
		FROM
			hlstats_Events_Frags,
		  hlstats_Servers
		WHERE
			hlstats_Servers.serverId = hlstats_Events_Frags.serverId
			AND hlstats_Events_Frags.map='$map'
			AND hlstats_Servers.game='$game'
	");
	
	list($numitems, $totalkills) = $db->fetch_row($resultCount);
?>


<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Map Details</b><?php echo $g_options["fontend_normal"];?><p>

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%"><?php echo $g_options["font_normal"]; ?><?php echo "<b>".$map."</b>: "; ?>From a total of <b><?php echo number_format(intval($totalkills)); ?></b> kills (Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"]; ?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>Back to <a href="<?php echo $g_options["scripturl"] . "?mode=maps&amp;game=$game"; ?>">Map Statistics</a><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table><p>
<?php // figure out URL and absolute path of image
	$imgurl = $g_options["imgdir"] . "/maps/$game/"
		. "$map";
	
	$image = getImage("/maps/$game/$map");
	
	if ($image || $g_options["map_dlurl"])
	{
?>
<table width="90%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr valign="top">
	<td width="90%"><?php
		$table->draw($result, $numitems, 100, "center");
?></td>
	<td width=10>&nbsp;&nbsp;&nbsp;&nbsp;</td>
	<td width="10%" align="right" nowrap><?php
		echo $g_options["font_normal"];
		
		if ($image)
		{
			echo "<img src=\"" . $image["url"] . "\" " . $image["size"] . " border=1 alt=\"$map\">";
		}
		if ($g_options["map_dlurl"])
		{
			$map_dlurl = str_replace("%MAP%", $map, $g_options["map_dlurl"]);
			$map_dlurl = str_replace("%GAME%", $game, $map_dlurl);
			echo "<p><a href=\"$map_dlurl\">Download this map...</a></p>";
		}
		
		echo $g_options["fontend_normal"];
?></td>
</tr>

</table>
<?php
	}
	else
	{
		$table->draw($result, $numitems, 100, "center");
	}
?>

</td></tr>
</table>
