<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# motd.inc - showing ingame a statistic summary on connect
# ------------------------------------------------------------------------------------
# Created by Gregor Haenel (webmaster@flashman1986.de)
#
# Enhanced by Tobias Oetzel

  //
  // Message of the day
  //
  
  //
  // General
  //
  
  $game="css";  
  if ((isset($_GET['game'])) && (is_string($_GET['game'])))
   $game = valid_request($_GET['game'], 0);

  $db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	$minkills = 1;
  $minmembers = 3;
  
  $players = 1;  
  if ((isset($_GET['players'])) && (is_numeric($_GET['players'])))
    $players = valid_request($_GET['players'], 1);
  
  $clans = 1;  
  if ((isset($_GET['clans'])) && (is_numeric($_GET['clans'])))
    $clans = valid_request($_GET['clans'], 1);
  
  $servers = 1;  
  if ((isset($_GET['servers'])) && (is_numeric($_GET['servers'])))
    $servers = valid_request($_GET['servers'], 1);

  //
  // Top 10 Players
  //
  if($players > 0) {  
    $table_players = new Table(
  		array(
  			new TableColumn(
  				"lastName",
  				"Playername",
  				"width=50&flag=1&link=" . urlencode("mode=statsme&amp;player=%k")
  			),
  			new TableColumn(
  				"skill",
  				"Points",
  				"width=10&align=right"
  			),
        new TableColumn(
         "activity",
         "Activity",
         "width=10&sort=no&type=bargraph"
        ),
        new TableColumn(
         "connection_time",
         "Time",
         "width=15&align=right&type=timestamp"
        ),
        new TableColumn(
          "kpd",
          "Kpd",
          "width=10&align=right"
        ),
  		),
      "playerId",
  		"skill",
      "kpd",
      true,
      10
  	);
  	  
  	$result_players = $db->query("
  		SELECT
        playerId,
  			lastName,
        connection_time,
   			skill,
        flag,
        country,
  			IFNULL(kills/deaths, '-') AS kpd,
  			IFNULL(headshots/kills, '-') AS hpk,
        IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), -1) as activity
  		FROM
  			hlstats_Players
  		WHERE
  			game='$game'
  			AND hideranking=0
  			AND kills >= $minkills
      HAVING 
        activity >= 0
  		ORDER BY
  			$table_players->sort $table_players->sortorder
  		LIMIT 0,5
  	");
    $table_players->draw($result_players, 10, 100);
  }
  
  
  //
  // Top 3 Clans
  //
  if($clans > 0) {
  	$table_clans = new Table(
  		array(
  			new TableColumn(
  				"name",
  				"Clanname",
  				"width=50&link=" . urlencode("mode=claninfo&amp;clan=%k")
  			),
  			new TableColumn(
  				"tag",
  				"Tag",
  				"width=25&align=center"
  			),
  			new TableColumn(
  				"skill",
  				"Points",
  				"width=10&align=right"
  			),
  			new TableColumn(
  				"nummembers",
  				"Members",
  				"width=10&align=right"
  			),
  		),
  		"clanId",
  		"skill",
  		"kpd",
      true,
      3
  	);
  
  	$result_clans = $db->query("
  		SELECT
  			hlstats_Clans.clanId,
  			hlstats_Clans.name,
  			hlstats_Clans.tag,
  			COUNT(hlstats_Players.playerId) AS nummembers,
  			ROUND(AVG(hlstats_Players.skill)) AS skill,
        TRUNCATE(AVG(IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1)),2) as activity
  		FROM
  			hlstats_Clans
  		LEFT JOIN hlstats_Players ON
  			hlstats_Players.clan=hlstats_Clans.clanId
  		WHERE
  			hlstats_Clans.game='$game'
        AND hlstats_Players.hideranking = 0
        AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1) >= 0
  		GROUP BY
  			hlstats_Clans.clanId
  		HAVING
      activity >= 0 AND
			nummembers >= $minmembers
  		ORDER BY
  			$table_clans->sort $table_clans->sortorder
  		LIMIT 0,3
    ");
    $table_clans->draw($result_clans, 3, 100);
  }
  
  //
  // Servers
  //
  if ($servers > 0)  { ?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0  bgcolor="<?php echo $g_options["table_border"]; ?>">

<tr>
  <td>
    <table width="100%" align="center" border=0 cellspacing=1 cellpadding=4 bgcolor="<?php echo $g_options["table_border"]; ?>">
      <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
        <td width="50%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Participating Servers</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="20%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Address</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Map</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Played</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Players</font><?php echo $g_options["fontend_small"]; ?></td>
      </tr>
        
<?php
    $query= "
            SELECT
                serverId,
                name,
                IF(publicaddress != '',
                    publicaddress,
                    concat(address, ':', port)
                ) AS addr,
                statusurl,
                kills,
                headshots,              
                act_players,                                
                max_players,
                act_map,
                map_started,
                map_ct_wins,
                map_ts_wins                 
            FROM
                hlstats_Servers
            WHERE
                game='$game'
            ORDER BY
                serverId
        ";
        $db->query($query);
        $this_server = array();
        $servers = array();
        while ($rowdata = $db->fetch_array()) {
          $servers[] = $rowdata;
          if ($rowdata['serverId'] == $server_id)
            $this_server = $rowdata;
        }  
          

        $i=0;
        for ($i=0; $i<count($servers); $i++)
        {
            $rowdata = $servers[$i]; 
            
            $server_id = $rowdata['serverId'];
            
            $c = ($i % 2) + 1;
            
            if ($rowdata["statusurl"])
            {
                $addr = "<a href=\"" . $rowdata["statusurl"] . "\">"
                    . $rowdata["addr"] . "</a>";
            }
            else
            {
                $addr = $rowdata["addr"];
            }
            
            $kills     = $rowdata['kills'];
            $headshots = $rowdata['headshots'];
            
          
          $player_string = $rowdata['act_players']."/".$rowdata['max_players'];
          $map_ct_wins = $rowdata['map_ct_wins'];
          $map_ts_wins = $rowdata['map_ts_wins'];

?>

                <tr valign="middle" bgcolor="<?php echo $g_options["table_bgcolor$c"]; ?>">
                    <td align="left" width="35%"><?php
                        echo $g_options["font_small"];
                        echo "<b>".$rowdata["name"]."</b>";
                        echo $g_options["fontend_smal"]; ?></td>
                    <td align="left" width="20%"><?php
                        echo $g_options["font_small"];
                        echo $addr;
                        echo $g_options["fontend_smal"];
                    ?></td>
                    <td align="center" width="15%"><?php
                        echo $g_options["font_small"];
                        echo $rowdata['act_map'];
                        echo $g_options["fontend_smal"];
                    ?></td>
                    <td align="center" width="15%"><?php
              $stamp = time()-$rowdata['map_started'];
              $hours = sprintf("%02d", floor($stamp / 3600));
              $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
              $sec   = sprintf("%02d", floor($stamp % 60)); 
                        echo $g_options["font_small"];
                        echo $hours.":".$min.":".$sec;
                        echo $g_options["fontend_smal"];
                    ?></td>
                    <td align="center" width="15%"><?php
                        echo $g_options["font_small"];
                        echo $player_string;
                        echo $g_options["fontend_smal"];
                    ?></td>
                </tr>

<?php } ?>
        </table>        


       </td>
      </tr>
    </table>
    
    
  </td>
</tr>        
     


</table>
<?php  } ?>