<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#


   $server_id = 1;
   if ((isset($_GET['server_id'])) && (is_numeric($_GET['server_id'])))
    $server_id = valid_request($_GET['server_id'], 1);
    
   $game="css";  
   if ((isset($_GET['game'])) && (is_string($_GET['game'])))
    $game = valid_request($_GET['game'], 0);
    

  
?>



<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0  bgcolor="<?php echo $g_options["table_border"]; ?>">

<tr>
  <td>
    <table width="100%" border=0 cellspacing=1 cellpadding=3>
      <tr valign="bottom" bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
        <td width="100%" align="left"><strong><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;<a href="http://www.hlstatsx.com">HLstatsX</a> V<?php echo VERSION; ?> by Tobias Oetzel - http://www.hlstatsx.com</font><?php echo $g_options["fontend_small"]; ?></strong></td>
      </tr>
    </table>  
    <table width="100%" align="center" border=0 cellspacing=1 cellpadding=2 bgcolor="<?php echo $g_options["table_border"]; ?>">
      <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
        <td width="100%" align="left"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Commands display the results ingame</font><?php echo $g_options["fontend_small"]; ?></td>
      </tr>
      <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
        <td>
        <table width="100%" style="margin-left:15px;">
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>rank [skill, points, place (to all)]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Current position<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>kpd [kdratio, kdeath (to all)]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Total player statistics<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>session [session_data (to all)]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Current session statistics<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>next<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Players ahead in the ranking.<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>hlx_auto clear|start|end|kill command<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Auto-Command on specific event (on death, roundstart, roundend)<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>hlx_display 0|1<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Enable or disable displaying console events.<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>hlx_chat 0|1<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Enable or disable the displaying of global chat events(if enabled).<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
        </table>
        </td>  
      </tr>
      <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
        <td width="100%" align="left"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Commands display the results in window</font><?php echo $g_options["fontend_small"]; ?></td>
      </tr>
      <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
        <td>
        <table width="100%" style="margin-left:15px;">
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>load<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Statistics from all servers<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>status<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Current server status<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>servers<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>List of all participating servers<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>top20 [top5, top10]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Top-Players<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>clans<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Clan ranking<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>cheaters<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Banned players from Valve-Anti-Cheat<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>statsme<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Statistic summary<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>weapons [weapon]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Weapons usage<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>accuracy<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Weapons accuracy<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>targets [target]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Targets hit positions<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>kills [kill, player_kills]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Kill statistics (5 or more kills)<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>actions [action]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Server actions summary<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
          <tr>
            <td width="35%"><?php echo $g_options["font_normal"]; ?>help [cmd, cmds, commands]<?php echo $g_options["fontend_normal"]; ?></td><td width="5%"><?php echo $g_options["font_normal"]; ?>=<?php echo $g_options["fontend_normal"]; ?></td><td><?php echo $g_options["font_normal"]; ?>Help screen<?php echo $g_options["fontend_normal"]; ?></td>
          </tr>
        </table>
        </td>  
      </tr>
    </table>
    <table width="100%" align="center" border=0 cellspacing=1 cellpadding=3 bgcolor="<?php echo $g_options["table_border"]; ?>">
      <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
        <td width="55%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Participating Servers</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="23%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Address</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Map</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Played</font><?php echo $g_options["fontend_small"]; ?></td>
        <td width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Players</font><?php echo $g_options["fontend_small"]; ?></td>
      </tr>
        
<?php
    $query= "
            SELECT
                serverId,
                name,
                IF(publicaddress != '',
                    publicaddress,
                    concat(address, ':', port)
                ) AS addr,
                statusurl,
                kills,
                headshots,              
                act_players,                                
                max_players,
                act_map,
                map_started,
                map_ct_wins,
                map_ts_wins                 
            FROM
                hlstats_Servers
            WHERE
                game='$game'
            ORDER BY
                serverId
        ";
        $db->query($query);
        $this_server = array();
        $servers = array();
        while ($rowdata = $db->fetch_array()) {
          $servers[] = $rowdata;
          if ($rowdata['serverId'] == $server_id)
            $this_server = $rowdata;
        }  
          

        
        $i=0;
        for ($i=0; $i<count($servers); $i++)
        {
            $rowdata = $servers[$i]; 
            
            $server_id = $rowdata['serverId'];
            
            $c = ($i % 2) + 1;
            
            if ($rowdata["statusurl"])
            {
                $addr = "<a href=\"" . $rowdata["statusurl"] . "\">"
                    . $rowdata["addr"] . "</a>";
            }
            else
            {
                $addr = $rowdata["addr"];
            }
            
            $kills     = $rowdata['kills'];
            $headshots = $rowdata['headshots'];
            
          
          $player_string = $rowdata['act_players']."/".$rowdata['max_players'];
          $map_ct_wins = $rowdata['map_ct_wins'];
          $map_ts_wins = $rowdata['map_ts_wins'];

?>

                <tr valign="middle" bgcolor="<?php echo $g_options["table_bgcolor$c"]; ?>">
                    <td align="left"><?php
                        echo $g_options["font_small"];
                        echo "<b>".$rowdata["name"]."</b>";
                        echo $g_options["fontend_small"]; ?></td>
                    <td align="left"><?php
                        echo $g_options["font_small"];
                        echo $addr;
                        echo $g_options["fontend_small"];
                    ?></td>
                    <td align="center"><?php 
                        echo $g_options["font_small"];
                        echo $rowdata['act_map'];
                        echo $g_options["fontend_small"];
                    ?></td>
                    <td align="center"><?php
              $stamp = time()-$rowdata['map_started'];
              $hours = sprintf("%02d", floor($stamp / 3600));
              $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
              $sec   = sprintf("%02d", floor($stamp % 60)); 
                        echo $g_options["font_small"];
                        echo $hours.":".$min.":".$sec;
                        echo $g_options["fontend_small"];
                    ?></td>
                    <td align="center"><?php
                        echo $g_options["font_small"];
                        echo $player_string;
                        echo $g_options["fontend_small"];
                    ?></td>
                </tr>

<?php } ?>
    </table>
  </td>
</tr>

</table>
