-- 
-- Datenbank: `hlstats`
-- 

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Actions`
-- 

CREATE TABLE `hlstats_Actions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(128) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `reward_player` int(11) NOT NULL default '10',
  `reward_team` int(11) NOT NULL default '0',
  `team` varchar(128) NOT NULL default '',
  `description` varchar(255) default NULL,
  `for_PlayerActions` enum('0','1') NOT NULL default '0',
  `for_PlayerPlayerActions` enum('0','1') NOT NULL default '0',
  `for_TeamActions` enum('0','1') NOT NULL default '0',
  `for_WorldActions` enum('0','1') NOT NULL default '0',
  `count` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `gamecode` (`game`,`code`),
  KEY `code` (`code`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Awards`
-- 

CREATE TABLE `hlstats_Awards` (
  `awardId` int(10) unsigned NOT NULL auto_increment,
  `awardType` enum('W','O') NOT NULL default 'W',
  `game` varchar(128) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `verb` varchar(255) NOT NULL default '',
  `d_winner_id` int(10) unsigned default NULL,
  `d_winner_count` int(10) unsigned default NULL,
  PRIMARY KEY  (`awardId`),
  UNIQUE KEY `code` (`game`,`awardType`,`code`)
) TYPE=MyISAM;


-- --------------------------------------------------------
-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Chat`
-- 

CREATE TABLE `hlstats_Events_Chat` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `message_mode` tinyint(1) NOT NULL default '0',
  `message` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;
-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_ClanTags`
-- 

CREATE TABLE `hlstats_ClanTags` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `pattern` varchar(255) NOT NULL default '',
  `position` enum('EITHER','START','END') NOT NULL default 'EITHER',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `pattern` (`pattern`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Clans`
-- 

CREATE TABLE `hlstats_Clans` (
  `clanId` int(10) unsigned NOT NULL auto_increment,
  `tag` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `homepage` varchar(255) NOT NULL default '',
  `game` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`clanId`),
  UNIQUE KEY `tag` (`game`,`tag`),
  KEY `game` (`game`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Admin`
-- 

CREATE TABLE `hlstats_Events_Admin` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `type` varchar(255) NOT NULL default 'Unknown',
  `message` text NOT NULL,
  `playerName` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_ChangeName`
-- 

CREATE TABLE `hlstats_Events_ChangeName` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `oldName` varchar(255) NOT NULL default '',
  `newName` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_ChangeRole`
-- 

CREATE TABLE `hlstats_Events_ChangeRole` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `role` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_ChangeTeam`
-- 

CREATE TABLE `hlstats_Events_ChangeTeam` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `team` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Connects`
-- 

CREATE TABLE `hlstats_Events_Connects` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ipAddress` varchar(32) NOT NULL default '',
  `hostname` varchar(255) NOT NULL default '',
  `hostgroup` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Disconnects`
-- 

CREATE TABLE `hlstats_Events_Disconnects` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Entries`
-- 

CREATE TABLE `hlstats_Events_Entries` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Frags`
-- 

CREATE TABLE `hlstats_Events_Frags` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `killerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(128) NOT NULL default '',
  `headshot` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `killerId` (`killerId`),
  KEY `victimId` (`victimId`),
  KEY `map` (`map`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Latency`
-- 

CREATE TABLE `hlstats_Events_Latency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(32) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_PlayerActions`
-- 

CREATE TABLE `hlstats_Events_PlayerActions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `actionId` (`actionId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_PlayerPlayerActions`
-- 

CREATE TABLE `hlstats_Events_PlayerPlayerActions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Rcon`
-- 

CREATE TABLE `hlstats_Events_Rcon` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `type` varchar(6) NOT NULL default 'UNK',
  `remoteIp` varchar(32) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `command` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Statsme`
-- 

CREATE TABLE `hlstats_Events_Statsme` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(128) NOT NULL default '',
  `shots` int(6) unsigned NOT NULL default '0',
  `hits` int(6) unsigned NOT NULL default '0',
  `headshots` int(6) unsigned NOT NULL default '0',
  `damage` int(6) unsigned NOT NULL default '0',
  `kills` int(6) unsigned NOT NULL default '0',
  `deaths` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `weapon` (`weapon`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Statsme2`
-- 

CREATE TABLE `hlstats_Events_Statsme2` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(128) NOT NULL default '',
  `head` int(6) unsigned NOT NULL default '0',
  `chest` int(6) unsigned NOT NULL default '0',
  `stomach` int(6) unsigned NOT NULL default '0',
  `leftarm` int(6) unsigned NOT NULL default '0',
  `rightarm` int(6) unsigned NOT NULL default '0',
  `leftleg` int(6) unsigned NOT NULL default '0',
  `rightleg` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_StatsmeLatency`
-- 

CREATE TABLE `hlstats_Events_StatsmeLatency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_StatsmeTime`
-- 

CREATE TABLE `hlstats_Events_StatsmeTime` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `time` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Suicides`
-- 

CREATE TABLE `hlstats_Events_Suicides` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_TeamBonuses`
-- 

CREATE TABLE `hlstats_Events_TeamBonuses` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `actionId` (`actionId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Teamkills`
-- 

CREATE TABLE `hlstats_Events_Teamkills` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(255) NOT NULL default '',
  `killerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Games`
-- 

CREATE TABLE `hlstats_Games` (
  `code` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`code`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_HostGroups`
-- 

CREATE TABLE `hlstats_HostGroups` (
  `id` int(11) NOT NULL auto_increment,
  `pattern` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Livestats`
-- 

CREATE TABLE `hlstats_Livestats` (
  `player_id` int(10) NOT NULL default '0',
  `server_id` int(4) NOT NULL default '0',
  `cli_address` varchar(32) NOT NULL default '',
  `cli_city` varchar(255) NOT NULL default '',
  `cli_country` varchar(128) NOT NULL default '',
  `cli_flag` varchar(16) NOT NULL default '',
  `cli_state` varchar(255) NOT NULL default '',
  `cli_lat` varchar(32) NOT NULL default '',
  `cli_lng` varchar(32) NOT NULL default '',
  `steam_id` varchar(255) NOT NULL default '',
  `name` text NOT NULL,
  `team` varchar(128) NOT NULL default '',
  `kills` int(6) NOT NULL default '0',
  `deaths` int(6) NOT NULL default '0',
  `suicides` int(6) NOT NULL default '0',
  `headshots` int(6) NOT NULL default '0',
  `shots` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `is_dead` tinyint(1) NOT NULL default '0',
  `has_bomb` int(1) NOT NULL default '0',
  `ping` int(6) NOT NULL default '0',
  `connected` int(10) NOT NULL default '0',
  `skill_change` int(10) NOT NULL default '0',
  `skill` int(10) NOT NULL default '0',
  PRIMARY KEY  (`player_id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Options`
-- 

CREATE TABLE `hlstats_Options` (
  `keyname` varchar(128) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`keyname`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_PlayerNames`
-- 

CREATE TABLE `hlstats_PlayerNames` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `lastuse` datetime NOT NULL default '0000-00-00 00:00:00',
  `connection_time` int(11) unsigned NOT NULL default '0',
  `numuses` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `headshots` int(11) unsigned NOT NULL default '0',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`playerId`,`name`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_PlayerUniqueIds`
-- 

CREATE TABLE `hlstats_PlayerUniqueIds` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `uniqueId` varchar(255) NOT NULL default '',
  `game` varchar(128) NOT NULL default '',
  `merge` int(10) unsigned default NULL,
  PRIMARY KEY  (`uniqueId`,`game`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Players`
-- 

CREATE TABLE `hlstats_Players` (
  `playerId` int(10) unsigned NOT NULL auto_increment,
  `last_event` int(11) unsigned NOT NULL default '0',
  `connection_time` int(11) unsigned NOT NULL default '0',
  `lastName` varchar(255) NOT NULL default '',
  `lastAddress` varchar(32) NOT NULL default '',
  `city` varchar(255) NOT NULL default '',
  `state` varchar(255) NOT NULL default '',
  `country` varchar(255) NOT NULL default '',
  `flag` varchar(16) NOT NULL default '',
  `lat` varchar(32) NOT NULL default '',
  `lng` varchar(32) NOT NULL default '',
  `clan` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `skill` int(11) unsigned NOT NULL default '1000',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `fullName` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `homepage` varchar(255) default NULL,
  `icq` int(10) unsigned default NULL,
  `game` varchar(128) NOT NULL default '',
  `hideranking` int(1) unsigned NOT NULL default '0',
  `headshots` int(10) unsigned NOT NULL default '0',
  `last_skill_change` int(11) NOT NULL default '0',
  PRIMARY KEY  (`playerId`),
  KEY `clan` (`clan`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Players_History`
-- 

CREATE TABLE `hlstats_Players_History` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `eventTime` date NOT NULL default '0000-00-00',
  `connection_time` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `skill` int(11) unsigned NOT NULL default '1000',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `game` varchar(128) NOT NULL default '',
  `headshots` int(11) unsigned NOT NULL default '0',
  `skill_change` int(11) NOT NULL default '0',
  UNIQUE KEY `eventTime` (`eventTime`,`playerId`,`game`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Roles`
-- 

CREATE TABLE `hlstats_Roles` (
  `roleId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(128) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`roleId`),
  UNIQUE KEY `gamecode` (`game`,`code`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Servers`
-- 

CREATE TABLE `hlstats_Servers` (
  `serverId` int(10) unsigned NOT NULL auto_increment,
  `address` varchar(32) NOT NULL default '',
  `port` int(5) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `game` varchar(128) NOT NULL default 'valve',
  `publicaddress` varchar(255) NOT NULL default '',
  `statusurl` varchar(255) default NULL,
  `rcon_password` varchar(255) NOT NULL default '',
  `kills` int(10) NOT NULL default '0',
  `players` int(11) NOT NULL default '0',
  `rounds` int(10) NOT NULL default '0',
  `suicides` int(10) NOT NULL default '0',
  `headshots` int(10) NOT NULL default '0',
  `bombs_planted` int(10) NOT NULL default '0',
  `bombs_defused` int(10) NOT NULL default '0',
  `ct_wins` int(10) NOT NULL default '0',
  `ts_wins` int(10) NOT NULL default '0',
  `act_players` int(4) NOT NULL default '0',
  `max_players` int(4) NOT NULL default '0',
  `act_map` varchar(128) NOT NULL default '',
  `map_rounds` int(6) NOT NULL default '0',
  `map_ct_wins` int(10) NOT NULL default '0',
  `map_ts_wins` int(10) NOT NULL default '0',
  `map_started` int(10) NOT NULL default '0',
  `map_changes` int(10) NOT NULL default '0',
  `ct_shots` int(11) NOT NULL default '0',
  `ct_hits` int(11) NOT NULL default '0',
  `ts_shots` int(11) NOT NULL default '0',
  `ts_hits` int(11) NOT NULL default '0',
  `map_ct_shots` int(11) NOT NULL default '0',
  `map_ct_hits` int(11) NOT NULL default '0',
  `map_ts_shots` int(11) NOT NULL default '0',
  `map_ts_hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`serverId`),
  UNIQUE KEY `addressport` (`address`,`port`)
) TYPE=MyISAM PACK_KEYS=0;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Style`
-- 

CREATE TABLE `hlstats_Style` (
  `keyname` varchar(32) NOT NULL default '',
  `def` varchar(255) NOT NULL default '',
  `black` varchar(255) NOT NULL default '',
  `light_blue` varchar(255) NOT NULL default '',
  `grey` varchar(255) NOT NULL default '',
  `ua_style` varchar(255) NOT NULL default '',
  `red` varchar(255) NOT NULL default '',
  `light_grey` varchar(255) NOT NULL default '',
  `white` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`keyname`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Teams`
-- 

CREATE TABLE `hlstats_Teams` (
  `teamId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(128) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`teamId`),
  UNIQUE KEY `gamecode` (`game`,`code`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Trend`
-- 

CREATE TABLE `hlstats_Trend` (
  `timestamp` int(11) NOT NULL default '0',
  `game` varchar(128) NOT NULL default '',
  `players` int(11) NOT NULL default '0',
  `kills` int(11) NOT NULL default '0',
  `headshots` int(11) NOT NULL default '0',
  `servers` int(11) NOT NULL default '0',
  `act_slots` int(11) NOT NULL default '0',
  `max_slots` int(11) NOT NULL default '0',
  KEY `game` (`game`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Users`
-- 

CREATE TABLE `hlstats_Users` (
  `username` varchar(255) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `acclevel` int(11) NOT NULL default '0',
  `playerId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`username`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Weapons`
-- 

CREATE TABLE `hlstats_Weapons` (
  `weaponId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(128) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `modifier` float(10,2) NOT NULL default '1.00',
  `kills` int(10) unsigned NOT NULL default '0',
  `headshots` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`weaponId`),
  UNIQUE KEY `gamecode` (`game`,`code`),
  KEY `code` (`code`),
  KEY `modifier` (`modifier`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_server_addons`
-- 

CREATE TABLE `hlstats_server_addons` (
  `rule` varchar(255) NOT NULL default '',
  `addon` varchar(255) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`rule`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_server_load`
-- 

CREATE TABLE `hlstats_server_load` (
  `server_id` tinyint(4) NOT NULL default '0',
  `timestamp` int(11) NOT NULL default '0',
  `act_players` tinyint(2) NOT NULL default '0',
  `min_players` tinyint(2) NOT NULL default '0',
  `max_players` tinyint(2) NOT NULL default '0',
  KEY `server_id` (`server_id`)
) TYPE=MyISAM;


-- 
-- Daten fr Tabelle `hlstats_ClanTags`
-- 

INSERT IGNORE INTO `hlstats_ClanTags` VALUES (1, '[AXXXXX]', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (2, '|AXXXXX|', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (3, '(AXXXXX)', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (4, '{AXXXXX}', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (5, '-=AXXX=-', 'START');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (6, '=AXXXXX=', 'START');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (7, '-AXXXXX-', 'START');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (8, '=[AXXXX]=', 'START');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (9, '-=|AXXXXXX|=-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (10, '-=[AXXXXXX]=-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (11, '-=]AXXXXXX[=-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (12, '~{|AXXXXXX|}~', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (13, '-|-AXXXXXX-|-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (14, '-(AXXXXXX)-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (15, '::AXXXXXX::', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (16, '<<AXXXXXX>>', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (17, '{{AXXXXXX}}', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (18, '((AXXXXXX))', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (19, '.|AXXXXXX|.', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (20, '--AXXXXXX--', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (21, '-)AXXXXXX(-', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (22, '/AXXXXXX\\', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (23, '//AXXXXXX\\\\', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (24, '_AXXXXXX_', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (25, '_=|AXXXXXX|=_', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (26, '*AXXXXXX*', 'EITHER');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (27, '.:AXXXXXX:', 'START');
INSERT IGNORE INTO `hlstats_ClanTags` VALUES (28, '[(AXXXXXX)]', 'EITHER');


-- 
-- Daten fr Tabelle `hlstats_Options`
-- 

INSERT IGNORE INTO `hlstats_Options` VALUES ('font_normal', '<font size=2 class="fontNormal">');
INSERT IGNORE INTO `hlstats_Options` VALUES ('fontend_normal', '</font>');
INSERT IGNORE INTO `hlstats_Options` VALUES ('font_small', '<font size=1 class="fontSmall">');
INSERT IGNORE INTO `hlstats_Options` VALUES ('fontend_small', '</font>');
INSERT IGNORE INTO `hlstats_Options` VALUES ('font_title', '<font size=4 class="fontTitle"><b>');
INSERT IGNORE INTO `hlstats_Options` VALUES ('fontend_title', '</b></font>');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_bgcolor1', '#FFFFFF');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_bgcolor2', '#FAFAFA');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_wpnbgcolor', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_border', '#99AAAA');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_head_text', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('table_head_bgcolor', '#ABCCD6');
INSERT IGNORE INTO `hlstats_Options` VALUES ('location_link', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('location_text', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('location_bgcolor', '#EFEFEF');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_leftmargin', '10');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_topmargin', '15');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_alink', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_link', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_hlink', '#7A7A7A');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_vlink', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_text', '#000000');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_bgcolor', '#D4D0C8');
INSERT IGNORE INTO `hlstats_Options` VALUES ('body_background', '');
INSERT IGNORE INTO `hlstats_Options` VALUES ('imgdir', 'hlstatsimg');
INSERT IGNORE INTO `hlstats_Options` VALUES ('contact', 'mailto:Tobi@hlstatsx.com');
INSERT IGNORE INTO `hlstats_Options` VALUES ('sitename', 'HLstatsX');
INSERT IGNORE INTO `hlstats_Options` VALUES ('siteurl', 'http://www.hlstatsx.com');
INSERT IGNORE INTO `hlstats_Options` VALUES ('style', 'default');
INSERT IGNORE INTO `hlstats_Options` VALUES ('imgpath', 'hlstatsimg');
INSERT IGNORE INTO `hlstats_Options` VALUES ('map_dlurl', '');
INSERT IGNORE INTO `hlstats_Options` VALUES ('awards_d_date', '2005-05-30');
INSERT IGNORE INTO `hlstats_Options` VALUES ('awards_numdays', '1');

-- 
-- Daten fr Tabelle `hlstats_Style`
-- 
INSERT IGNORE INTO hlstats_Style VALUES ('font_normal', '<font size=2 class="fontNormal">', '<font face="Courier New, Courier" size=2 class="fontNormal">', '<font face="Verdana, Arial, sans-serif" size=2 class="fontNormal">', '<font face="Georgia, Times New Roman, Times, serif" size=2 class="fontNormal">', '<font face="Verdana,Arial,Helvetica" size="2" class="fontNormal">', '<font face="Verdana, Arial, sans-serif" size=2 class="fontNormal">', '<font face="Georgia, Times New Roman, Times, serif" size=2 class="fontNormal">', '<font face="Geneva, Arial, Helvetica, sans-serif" size=2 class="fontNormal">');
INSERT IGNORE INTO hlstats_Style VALUES ('fontend_normal', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>');
INSERT IGNORE INTO hlstats_Style VALUES ('font_small', '<font size=1 class="fontSmall">', '<font face="Courier New, Courier" size=1 class="fontSmall">', '<font face="Verdana, Arial, sans-serif" size=1 class="fontSmall">', '<font face="Georgia, Times New Roman, Times, serif" size=1 class="fontSmall">', '<font face="Verdana,Arial,Helvetica" size="1" class="fontSmall">', '<font face="Verdana, Arial, sans-serif" size=1 class="fontSmall">', '<font face="Georgia, Times New Roman, Times, serif" size=1 class="fontSmall">', '<font face="Geneva, Arial, Helvetica, sans-serif" size=1 class="fontSmall">');
INSERT IGNORE INTO hlstats_Style VALUES ('fontend_small', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>', '</font>');
INSERT IGNORE INTO hlstats_Style VALUES ('font_title', '<font size=4 class="fontTitle"><b>', '<font face="Courier New, Courier" size=4 class="fontTitle"><b>', '<font face="Arial, sans-serif" size=4 class="fontTitle"><b>', '<font face="Georgia, Times New Roman, Times, serif" size=4 class="fontTitle"><b>', '<font face="Arial,Helvetica" size="3" class="fontTitle"><b>', '<font face="Arial, sans-serif" size=4 class="fontTitle"><b>', '<font face="Georgia, Times New Roman, Times, serif" size=4 class="fontTitle"><b>', '<font face="Geneva, Arial, Helvetica, sans-serif" size=4 class="fontTitle"><b>');
INSERT IGNORE INTO hlstats_Style VALUES ('fontend_title', '</b></font>', '</b></font>', '</b></font>', '</b></font>', '</b></font>', '</b></font>', '</b></font>', '</b></font>');
INSERT IGNORE INTO hlstats_Style VALUES ('table_bgcolor1', '#FFFFFF', '#282828', '#3F5576', '#CCCCCC', '#283846', '#550000', '#FFFFFF', '#edf3f9');
INSERT IGNORE INTO hlstats_Style VALUES ('table_bgcolor2', '#FAFAFA', '#282828', '#3F5569', '#999999', '#1F2F3D', '#440000', '#FAFAFA', '#d0dbe6');
INSERT IGNORE INTO hlstats_Style VALUES ('table_wpnbgcolor', '#000000', '#000000', '#3F5569', '#999999', '#253546', '#440000', '#EAEAEA', '#d0dbe6');
INSERT IGNORE INTO hlstats_Style VALUES ('table_border', '#99AAAA', '#E0E0E0', '#59748D', '#333333', '#39495A', '#000000', '#000000', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('table_head_text', '#000000', '#EEEEEE', '#EEEEEE', '#FFFFFF', '#C6C6C6', '#FFFFFF', '#000000', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('table_head_bgcolor', '#ABCCD6', '#282828', '#3F5576', '#666666', '#39495A', '#660000', '#AEAEAE', '#E8E8E8');
INSERT IGNORE INTO hlstats_Style VALUES ('location_link', '#000000', '#FFFFFF', '#FFFFFF', '#808080', '#FFFFFF', '#FFFFFF', '#AEAEAE', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('location_text', '#000000', '#FFFFFF', '#FFFFFF', '#000000', '#FFFFFF', '#FFFFFF', '#000000', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('location_bgcolor', '#EFEFEF', '#003399', '#3F5576', '#AAAAAA', '#39495A', '#660000', '#EAEAEA', '#E8E8E8');
INSERT IGNORE INTO hlstats_Style VALUES ('body_leftmargin', '10', '10', '10', '10', '10', '10', '10', '10');
INSERT IGNORE INTO hlstats_Style VALUES ('body_topmargin', '15', '15', '15', '15', '15', '15', '15', '15');
INSERT IGNORE INTO hlstats_Style VALUES ('body_alink', '#000000', '#FFFFFF', '#B0B0B0', '#808080', '#C6C6C6', '#800000', '#AEAEAE', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('body_link', '#000000', '#FFFFFF', '#B0B0B0', '#808080', '#C6C6C6', '#C0C0C0', '#AEAEAE', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('body_text', '#000000', '#CCCCCC', '#FFFFFF', '#000000', '#C6C6C6', '#FFFFFF', '#000000', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('body_vlink', '#000000', '#FFFFFF', '#B0B0B0', '#808080', '#C6C6C6', '#C0C0C0', '#AEAEAE', '#000000');
INSERT IGNORE INTO hlstats_Style VALUES ('body_bgcolor', '#D4D0C8', '#000000', '#3F5569', '#AAAAAA', '#253546', '#000000', '#EAEAEA', '#FFFFFF');
INSERT IGNORE INTO hlstats_Style VALUES ('body_background', '', '', '', '', '', '', '', '');
INSERT IGNORE INTO hlstats_Style VALUES ('body_hlink', '#7A7A7A', '#494949', '#FFFFFF', '#FFFFFF', '#FFFFFF', '#800000', '#7A7A7A', '#404040');


-- 
-- Daten fr Tabelle `hlstats_Users`
-- 

INSERT IGNORE INTO hlstats_Users VALUES ('admin',MD5('123456'),100,0);




        