-- GunFu Deadlands
-- Copyright 2009 Christiaan Janssen, September-December 2009
--
-- This file is part of GunFu Deadlands.
--
--     GunFu Deadlands is free software: you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     GunFu Deadlands is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with GunFu Deadlands.  If not, see <http://www.gnu.org/licenses/>.

Sounds = {

	bullet_time = love.audio.newSound("sounds/explosion.ogg"),

	revolver = {
		love.audio.newSound("sounds/Revolver_shot1.ogg"),
		love.audio.newSound("sounds/Revolver_shot2.ogg"),
	},

	revolver_slow = {
		love.audio.newSound("sounds/Revolver_shot1_slow.ogg"),
		love.audio.newSound("sounds/Revolver_shot2_slow.ogg"),
	},

	shot_blue = {
		normal = love.audio.newSound("sounds/Revolver_shot_blue.ogg"),
		slow = love.audio.newSound("sounds/Revolver_shot_blue_slow.ogg"),
	},

	shot_red = {
		normal = love.audio.newSound("sounds/Revolver_shot_red.ogg"),
		slow = love.audio.newSound("sounds/Revolver_shot_red_slow.ogg"),
	},

	shot_green = {
		normal = love.audio.newSound("sounds/Revolver_shot_green.ogg"),
		slow = love.audio.newSound("sounds/Revolver_shot_green_slow.ogg"),
	},

	shot_yellow = {
		normal = love.audio.newSound("sounds/Revolver_shot_yellow.ogg"),
		slow = love.audio.newSound("sounds/Revolver_shot_yellow_slow.ogg"),
	},

	scream_blue = {
		love.audio.newSound("sounds/scream_blue1.ogg"),
 		love.audio.newSound("sounds/scream_blue2.ogg"),
	},

	scream_blue_slow = {
		love.audio.newSound("sounds/scream_blue_slow1.ogg"),
 		love.audio.newSound("sounds/scream_blue_slow2.ogg"),
	},

	scream_red = {
		love.audio.newSound("sounds/scream_red1.ogg"),
		love.audio.newSound("sounds/scream_red2.ogg"),
	},

	scream_red_slow = {
		love.audio.newSound("sounds/scream_red_slow1.ogg"),
		love.audio.newSound("sounds/scream_red_slow2.ogg"),
	},

	scream_yellow = {
		love.audio.newSound("sounds/scream_yellow.ogg"),
	},

	scream_yellow_slow = {
		love.audio.newSound("sounds/scream_yellow_slow.ogg"),
	},

	scream_green = {
		love.audio.newSound("sounds/scream_green.ogg"),
	},

	scream_green_slow = {
		love.audio.newSound("sounds/scream_green_slow.ogg"),
	},

	scream_player = love.audio.newSound("sounds/scream_player.ogg"),

	reload_start = love.audio.newSound("sounds/reload_start.ogg"),
	reload_done = love.audio.newSound("sounds/reload_done.ogg"),
	reload_start_slow = love.audio.newSound("sounds/reload_start_slow.ogg"),
	reload_done_slow = love.audio.newSound("sounds/reload_done_slow.ogg"),

}

Sounds.active = true

function Sounds.play_shot_player()
	if not Sounds.active then return end
	if not BulletTime.active then
		love.audio.play(Sounds.revolver[math.random(table.getn(Sounds.revolver))])
	else
		love.audio.play(Sounds.revolver_slow[math.random(table.getn(Sounds.revolver_slow))])
	end
end

function Sounds.play_shot_enemy( enemy )
	if not Sounds.active then return end
	if not BulletTime.active then
		love.audio.play(enemy.shot_sound.normal)
	else
		love.audio.play(enemy.shot_sound.slow)
	end
end

function Sounds.play_bullettime()
	if not Sounds.active then return end
	love.audio.play(Sounds.bullet_time)
end

function Sounds.play_scream_enemy(enemy)
	if not Sounds.active then return end
	if not BulletTime.active then
		love.audio.play(enemy.scream[math.random(table.getn(enemy.scream))])
	else
		love.audio.play(enemy.scream_slow[math.random(table.getn(enemy.scream))])
	end
end

function Sounds.play_scream_player()
	if not Sounds.active then return end
	love.audio.play(Sounds.scream_player)
end

function Sounds.play_reload_start()
	if not Sounds.active then return end
	if not BulletTime.active then
		love.audio.play(Sounds.reload_start)
	else
		love.audio.play(Sounds.reload_start_slow)
	end
end

function Sounds.play_reload_done()
	if not Sounds.active then return end
	if not BulletTime.active then
		love.audio.play(Sounds.reload_done)
	else
		love.audio.play(Sounds.reload_done_slow)
	end
end

function Sounds.switch()
	Sounds.active = not Sounds.active
end

Music={
	active = true,
	maintheme = love.audio.newMusic( 'music/GunFuMainTheme.ogg' ),
}

function Music.start()
	love.audio.play( Music.maintheme, 0 )
end

function Music.pause()
	love.audio.pause( )
	Music.active = false
end

function Music.continue()
	love.audio.resume()
	Music.active = true
end

function Music.switch()
	if Music.active then
		Music.pause()
	else
		Music.continue()
	end
end

