"""
Copyright (C) 2008  Matthew and Joey Marshall <joey@arcticpaint.com>

See main.py for full notice.
"""
from __future__ import division
import snowui, rabbyt

class Minimap(snowui.Widget):
    zoom = rabbyt.anim_slot(0)
    def __init__(self, ui, **kwargs):
        self.world = world = ui.world
        self.ui = ui
        snowui.Widget.__init__(self, bounds="rect", **kwargs)

        self.zoom = 0.2
        self.pan = snowui.Pan(shape=self.shape, rx=0, ry=0)
        self.pan.rgb = (172/255.0, 142/255.0, 103/255.0)
        self.add(self.pan)
        self.pan.scroll_range_x = (-10000, 10000)
        self.pan.scroll_range_y = (-10000, 10000)
        self.pan.drag_button = None

        self.pane = snowui.Widget(rxy=(0,0),
                shape=(ui.view.width/3*self.zoom,ui.view.height/3*self.zoom))
        self.pan.add(self.pane)
        self.pane._v_rx = ui.view.attrgetter("x")*(self.zoom/3)
        self.pane._v_ry = ui.view.attrgetter("y")*(self.zoom/3)
        self.pane.rgba = (0.3,0.3,1,.1)

        self.pan.scroll._v_rx = -ui.view.attrgetter("x")*(self.zoom/3)+self.shape.width/2
        self.pan.scroll._v_ry = -ui.view.attrgetter("y")*(self.zoom/3)+self.shape.height/2

        for i in world.islands:
            w = snowui.Widget(texture="minimap/i%i.png"%i.id, rxy=(0,0))
            w.shape = (w.shape.width, w.shape.height)
            w.is_active = False
            w.scale = self.attrgetter("zoom")
            w._v_rx = self.attrgetter("zoom")*(i.x/3)
            w._v_ry = self.attrgetter("zoom")*(i.y/3)
            self.pan.add(w)

        overlay = snowui.Widget(texture="minimap/overlay.png", rxy=(0,0))
        overlay.shape = self.shape
        overlay.is_active = False
        self.add(overlay)