'''Simple data loader module.

Loads data files from the "data" directory shipped with a game.

Enhancing this to handle caching etc. is left as an exercise for the reader.
'''
import sys
import os

import pyglet
from pyglet import image

data_py = os.path.abspath(os.path.dirname(__file__))
if "library.zip" in data_py:
    data_dir = os.path.normpath(os.path.join(data_py, '..', '..', 'data'))
else:
    data_dir = os.path.normpath(os.path.join(data_py, '..', 'data'))

sys.path.insert(0, data_dir)

pyglet.resource.path = [data_dir]
pyglet.resource.reindex()

def filepath(filename):
    '''Determine the path to a file in the data directory.
    '''
    return os.path.join(data_dir, filename)

def load(filename, mode='rb'):
    '''Open a file in the data directory.

    "mode" is passed as the second arg to open().
    '''
    return open(os.path.join(data_dir, filename), mode)

import rabbyt
_texture_cache = {}
def load_texture(filename):
    if filename not in _texture_cache:
        #texture = pyglet.resource.texture(filename)
        texture = pyglet.image.load(os.path.join(data_dir, filename)).get_texture()
        _texture_cache[filename] = texture
    return _texture_cache[filename]
rabbyt.set_load_texture_file_hook(load_texture)


