/**************************************************************************************************
 **
 ** $Id: GraphicKeyEvent.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.1/geoapi/src/main/java/org/opengis/go/display/event/GraphicKeyEvent.java $
 **
 ** Copyright (C) 2003-2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.go.display.event;

import java.awt.event.KeyEvent;


/**
 * Provides a common abstraction for the various event objects pertaining to key
 * events on a {@link org.opengis.go.display.primitive.Graphic}.
 *
 * @author <A HREF="http://www.opengis.org">OpenGIS&reg; consortium</A>
 */
public interface GraphicKeyEvent extends GraphicEvent {
    /**
     * Returns the <code>KeyEvent</code> that this event references.
     *
     * @return the <code>KeyEvent</code> referenced by this event.
     *
     * @todo This {@link KeyEvent} implementation is specific to AWT and Swing
     *       (i.e. is not used by SWT as far as I know).
     */
    KeyEvent getKeyEvent();
}
