/**************************************************************************************************
 **
 ** $Id: CanvasState.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.1/geoapi/src/main/java/org/opengis/go/display/canvas/CanvasState.java $
 **
 ** Copyright (C) 2003-2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.go.display.canvas;

import org.opengis.geometry.DirectPosition;


/**
 * Instances of this interface (and its sub-interfaces) describe the current
 * state of a <code>Canvas</code>.  The information contained by instances
 * of this interface should only describe the viewing area or volume of the
 * Canvas and should not contain any state information regarding the data
 * contained within it.
 * <p>
 * When an instance of this class is returned from <code>Canvas</code>
 * methods, a "snapshot" of the current state of the Canvas is taken
 * and the values will never change (even if the Canvas changes state).
 *
 * @author Open GIS Consortium, Inc.
 */
public interface CanvasState {
    /**
     * Returns the title of the <code>Canvas</code>.
     */
    String getTitle();

    /**
     * Returns the position of the center pixel of this Canvas.
     */
    DirectPosition getCenter();

    /**
     * Returns a copy of this state object. The implementation should also clone
     * the object returned by <code>getCanvasParameterAccessor()</code>.
     */
    Object clone() throws CloneNotSupportedException;

    /**
     * Determines if the given object is the same type of Canvas state object
     * and has values equal to this one. As part of the test, the implementation
     * should also test equivalency of the object returned by
     * <code>getCanvasParameterAccessor()</code>.
     */
    boolean equals(Object object);
}
