/*$************************************************************************************************
 **
 ** $Id: FeatureId.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.1/geoapi/src/main/java/org/opengis/filter/identity/FeatureId.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.filter.identity;

import org.opengis.annotation.XmlElement;
import org.opengis.feature.Feature;
import org.opengis.filter.identity.Identifier;


/**
 * Feature identifier.
 * Features are identified as strings.
 *
 * @version <A HREF="http://www.opengis.org/docs/02-059.pdf">Implementation specification 1.0</A>
 * @author Chris Dillard (SYS Technologies)
 * @author Justin Deoliveira (The Open Planning Project)
 * @since GeoAPI 2.0
 */
@XmlElement("FeatureId")
public interface FeatureId extends Identifier<String,Feature> {
    /**
     * The identifier value, which is a string.
     */
    @XmlElement("fid")
    String getID();

    /**
     * Evaluates the identifer value against the given feature.
     *
     * @param feature The feature to be tested.
     * @return {@code true} if a match, otherwise {@code false}.
     */
    boolean matches(Feature feature);
}
