/*$************************************************************************************************
 **
 ** $Id: FeatureStoreException.java 1177 2008-03-27 10:43:54Z avcuster $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.1/geoapi/src/main/java/org/opengis/feature/FeatureStoreException.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.feature;

// J2SE direct dependencies
import java.io.IOException;


/**
 * Thrown to indicate that a {@link FeatureStore} operation could not complete because of a
 * failure in the backing store, or a failure to contact the backing store.
 *
 * @todo Since this is a {@link FeatureStore} exception should we have a backpointer
 *       to the {@code FeatureStore}? Or at least an indication of which data store
 *       caused the problem?
 *
 * @since GeoAPI 2.0
 * 
 * @deprecated Removed pending a redesign of feature storage interfaces
 */
@Deprecated
public class FeatureStoreException extends IOException {
    /**
     * Serial version UID allowing cross compiler use of {@code FeatureStoreException}.
     */
    private static final long serialVersionUID = -7266283714520657425L;

    /**
     * Constructs a new exception with no detail message.
     */
    public FeatureStoreException() {
        super();
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param message the detail message, saved for later retrieval by the {@link #getMessage} method.
     */
    public FeatureStoreException(final String message) {
        super(message);
    }

    /**
     * Constructs a new exception with the specified cause.
     *
     * @param cause the cause, saved for later retrieval by the {@link #getCause} method.
     */
    public FeatureStoreException(final Throwable cause) {
        super(cause == null ? null : cause.toString());
        initCause(cause);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     *
     * @param message the detail message, saved for later retrieval by the {@link #getMessage} method.
     * @param cause the cause, saved for later retrieval by the {@link #getCause} method.
     */
    public FeatureStoreException(final String message, final Throwable cause) {
        super(message);
        initCause(cause);
    }
}
