/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.coverage;

import java.awt.image.renderable.RenderableImage;
import java.util.List;
import java.util.Set;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.coverage.AttributeValues;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.CommonPointRule;
import org.opengis.coverage.DomainObject;
import org.opengis.coverage.GeometryValuePair;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UML(identifier="CV_Coverage", specification=Specification.ISO_19123)
public interface Coverage {
    @UML(identifier="CRS", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    @UML(identifier="envelope", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public Envelope getEnvelope();

    @UML(identifier="domainExtent", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<Extent> getDomainExtents();

    @UML(identifier="domainElement", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<? extends DomainObject> getDomainElements();

    @UML(identifier="rangeElement", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19123)
    public Set<AttributeValues> getRangeElements();

    @UML(identifier="rangeType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public RecordType getRangeType();

    @UML(identifier="commonPointRule", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public CommonPointRule getCommonPointRule();

    @UML(identifier="list", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<? extends GeometryValuePair> list();

    @UML(identifier="select", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<? extends GeometryValuePair> select(Geometry var1, Period var2);

    @UML(identifier="find", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public List<? extends GeometryValuePair> find(DirectPosition var1, int var2);

    @UML(identifier="find", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public GeometryValuePair find(DirectPosition var1);

    @UML(identifier="evaluate", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<Record> evaluate(DirectPosition var1, Set<String> var2);

    @UML(identifier="evaluate", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public Object evaluate(DirectPosition var1) throws CannotEvaluateException;

    @UML(identifier="evaluateAsBoolean", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public boolean[] evaluate(DirectPosition var1, boolean[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsByte", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public byte[] evaluate(DirectPosition var1, byte[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int[] evaluate(DirectPosition var1, int[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public float[] evaluate(DirectPosition var1, float[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsDouble", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public double[] evaluate(DirectPosition var1, double[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateInverse", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<? extends DomainObject> evaluateInverse(Record var1);

    @UML(identifier="dimensionNames", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public InternationalString[] getDimensionNames();

    @UML(identifier="numSampleDimensions", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int getNumSampleDimensions();

    @UML(identifier="getSampleDimension", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public SampleDimension getSampleDimension(int var1) throws IndexOutOfBoundsException;

    @UML(identifier="getSource, numSource", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public List<? extends Coverage> getSources();

    @UML(identifier="metadataNames", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public String[] getMetadataNames();

    @UML(identifier="getMetadataValue", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public String getMetadataValue(String var1) throws MetadataNameNotFoundException;

    public RenderableImage getRenderableImage(int var1, int var2) throws UnsupportedOperationException, IndexOutOfBoundsException;
}

