/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.units.AddConverter;
import javax.units.AlternateUnit;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.MultiplyConverter;
import javax.units.ProductUnit;
import javax.units.TransformedUnit;
import javax.units.UnitFormat;

public abstract class Unit
implements Serializable {
    private static final Unit[] NONE = new Unit[0];
    transient int _id;
    private transient Unit[] _multiplyLookUp = NONE;
    private transient Unit[] _divideLookUp = NONE;
    private transient Unit[] _rootLookUp = NONE;
    private transient Unit[] _powLookUp = NONE;
    private static final Map UNITS = new HashMap();
    private static final Map SYMBOLS = new HashMap();
    static final Map DIMENSIONS = Collections.synchronizedMap(new HashMap());
    static final Map TO_DIMENSIONS = Collections.synchronizedMap(new HashMap());
    public static final Unit ONE = new ProductUnit();
    final String _symbol;
    private transient int _hashCode;

    Unit(String symbol) {
        this._symbol = symbol;
    }

    public final boolean isCompatible(Unit that) {
        return this == that || this.getDimension() == that.getDimension();
    }

    public final Unit getDimension() {
        Unit dimension = (Unit)DIMENSIONS.get(this);
        if (dimension == null) {
            dimension = this.getCtxDimension();
            DIMENSIONS.put(this, dimension);
        }
        return dimension;
    }

    public final Converter getConverterTo(Unit that) throws ConversionException {
        if (this == that) {
            return Converter.IDENTITY;
        }
        if (this.isCompatible(that)) {
            Converter thatToDimension;
            Converter thisToDimension = (Converter)TO_DIMENSIONS.get(this);
            if (thisToDimension == null) {
                thisToDimension = this.getCtxToDimension();
                TO_DIMENSIONS.put(this, thisToDimension);
            }
            if ((thatToDimension = (Converter)TO_DIMENSIONS.get(that)) == null) {
                thatToDimension = that.getCtxToDimension();
                TO_DIMENSIONS.put(that, thatToDimension);
            }
            return thatToDimension.inverse().concatenate(thisToDimension);
        }
        throw new ConversionException(this + " is not compatible with " + that + " in current context");
    }

    public final boolean isSystemUnit() {
        return this.getSystemUnit() == this;
    }

    public abstract Unit getSystemUnit();

    public final Unit alternate(String symbol) {
        return AlternateUnit.getInstance(symbol, this);
    }

    public final Unit add(double offset) {
        return TransformedUnit.getInstance(this, new AddConverter(offset));
    }

    public final Unit multiply(double scale) {
        return TransformedUnit.getInstance(this, new MultiplyConverter(scale));
    }

    public final Unit multiply(Unit that) {
        Unit result;
        if (that._id >= this._multiplyLookUp.length) {
            Unit[] tmp = new Unit[that._id + 1];
            System.arraycopy(this._multiplyLookUp, 0, tmp, 0, this._multiplyLookUp.length);
            this._multiplyLookUp = tmp;
        }
        if ((result = this._multiplyLookUp[that._id]) != null) {
            return result;
        }
        this._multiplyLookUp[that._id] = result = ProductUnit.getProductInstance(this, that);
        return result;
    }

    public final Unit divide(Unit that) {
        Unit result;
        if (that._id >= this._divideLookUp.length) {
            Unit[] tmp = new Unit[that._id + 1];
            System.arraycopy(this._divideLookUp, 0, tmp, 0, this._divideLookUp.length);
            this._divideLookUp = tmp;
        }
        if ((result = this._divideLookUp[that._id]) != null) {
            return result;
        }
        this._divideLookUp[that._id] = result = ProductUnit.getQuotientInstance(this, that);
        return result;
    }

    public final Unit root(int n) {
        if (n > 1) {
            if (this._rootLookUp.length < n - 1) {
                this._rootLookUp = new Unit[n - 1];
            }
            if (this._rootLookUp[n - 2] == null) {
                this._rootLookUp[n - 2] = ProductUnit.getRootInstance(this, n);
            }
            return this._rootLookUp[n - 2];
        }
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit pow(int n) {
        if (n > 1) {
            if (this._powLookUp.length < n - 1) {
                this._powLookUp = new Unit[n - 1];
            }
            if (this._powLookUp[n - 2] == null) {
                this._powLookUp[n - 2] = ProductUnit.getPowInstance(this, n);
            }
            return this._powLookUp[n - 2];
        }
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit valueOf(CharSequence chars) {
        try {
            return UnitFormat.getStandardInstance().parseUnit(chars);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Collection getInstances() {
        return Collections.unmodifiableCollection(UNITS.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit searchSymbol(CharSequence symbol) {
        Class clazz = Unit.class;
        synchronized (clazz) {
            return (Unit)SYMBOLS.get(symbol);
        }
    }

    abstract Unit getCtxDimension();

    abstract Converter getCtxToDimension();

    public final String toString() {
        return this.appendTo(new StringBuffer()).toString();
    }

    public final StringBuffer appendTo(StringBuffer sb) {
        return UnitFormat.getStandardInstance().format(this, sb, null);
    }

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Unit getInstance(Unit template) {
        Class clazz = Unit.class;
        synchronized (clazz) {
            template._hashCode = template.calculateHashCode();
            Object obj = UNITS.get(template);
            if (obj != null) {
                return (Unit)obj;
            }
            if (template._symbol != null) {
                obj = SYMBOLS.get(template._symbol);
                if (obj != null) {
                    throw new UnsupportedOperationException("The symbol: " + template._symbol + " is currently associated to an instance of " + obj.getClass());
                }
                SYMBOLS.put(template._symbol, template);
            }
            UNITS.put(template, template);
            template._id = UNITS.size();
            return template;
        }
    }

    abstract int calculateHashCode();

    protected Object readResolve() {
        return Unit.getInstance(this);
    }

    static {
        UNITS.put(ONE, ONE);
    }
}

