#ifndef G_MAIN_H
#define G_MAIN_H

#ifdef __cplusplus
extern "C" {
#endif


#define X_RES 320
#define Y_RES 240

#define TIMER_ID    1
#define TIMER_RATE  30

extern HINSTANCE ghInstance;
extern WNDCLASS WndClass;
extern int HWnd;
extern HMENU Gens_Menu;

extern int Paused;
extern int Net_Play;
extern int Current_State;
extern int Full_Screen;
extern int Fast_Blur;
extern int Render_W;
extern int Render_FS;
extern int Show_FPS;
extern int Show_Message;
extern int Show_LED;
extern int Auto_Pause;
extern int Auto_Fix_CS;
extern int Language;
extern int Country;
extern int Country_Order[3];
extern int WinNT_Flag;
extern int Gens_Priority;
extern int Kaillera_Client_Running;
extern int Intro_Style;
extern int SegaCD_Accurate;

extern POINT Window_Pos;

extern char Str_Tmp[1024];
extern char Gens_Path[1024];
extern char Language_Path[1024];
extern char CGOffline_Path[1024];
extern char Manual_Path[1024];

extern char **language_name;


int Set_Render(HWND hWnd, int Full, int Num, int Force);
int Change_68K_Type(int hWnd, int Num, int Reset_SND);
int Change_Sound(int hWnd);
HMENU Build_Main_Menu(void);


void End_All(void);
void Sleep(int i);
void update_events();
int Set_Sprite_Over(HWND hWnd, int Num);
int Set_Current_State(int hWnd, int Num);
int Set_Frame_Skip(HWND hWnd, int Num);
int Change_Debug(HWND hWnd, int Debug_Mode);
int Change_Country_Order(int Num);
int Change_Country(HWND hWnd, int Num);
int Change_SegaCD_Synchro(void);
int	Change_Sound(HWND hWnd);
int Change_Sample_Rate(HWND hWnd, int Rate);
int Change_Sound_Stereo(HWND hWnd);
int Change_Z80(HWND hWnd);
int Change_PSG(HWND hWnd);
int Change_PCM(HWND hWnd);
int Change_PWM(HWND hWnd);
int Change_DAC(HWND hWnd);
int Change_CDDA(HWND hWnd);
int Change_Fast_Blur(HWND hWnd);
int Change_Stretch(void);
int Change_VSync(HWND hWnd);
int Change_Blit_Style(void);
int Change_DAC_Improv(HWND hWnd);
int Change_SegaCD_SRAM_Size(int num);
int Change_YM2612(HWND hWnd);
int Change_PSG_Improv(HWND hWnd);
int Change_YM2612_Improv(HWND hWnd);
int Build_Language_String(void);

#ifdef WITH_GTK

#include <gtk/gtk.h>
extern GtkWidget* gens_window;

#endif


#ifdef __PORT__
void win2linux(char* str);
#endif


#define MESSAGE_L(str, def, time)																	\
{																									\
	GetPrivateProfileString(language_name[Language], (str), (def), Str_Tmp, 1024, Language_Path);	\
	Put_Info(Str_Tmp, (time));																		\
}



#define MESSAGE_NUM_L(str, def, num, time)															\
{																									\
	char mes_tmp[1024];																				\
	GetPrivateProfileString(language_name[Language], (str), (def), Str_Tmp, 1024, Language_Path);	\
	sprintf(mes_tmp, Str_Tmp, (num));																\
	Put_Info(mes_tmp, (time));																		\
}



#ifdef __cplusplus
}
#endif

#endif

