/***********************************************************************************
 * QGLE - A Graphical Interface to GLE                                             *
 * Copyright (C) 2006  A. S. Budden & J. Struyf                                    *
 *                                                                                 *
 * This program is free software; you can redistribute it and/or                   *
 * modify it under the terms of the GNU General Public License                     *
 * as published by the Free Software Foundation; either version 2                  *
 * of the License, or (at your option) any later version.                          *
 *                                                                                 *
 * This program is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of                  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                   *
 * GNU General Public License for more details.                                    *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License               *
 * along with this program; if not, write to the Free Software                     *
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. *
 *                                                                                 *
 * Also add information on how to contact you by electronic and paper mail.        *
 ***********************************************************************************/

#ifndef _SNAPLINE_H
#define _SNAPLINE_H

#include "drawingobject.h"

class SnapLine : public GLEDrawingObject
{
	Q_OBJECT


public:
	enum Points
	{
		StartPoint,
		EndPoint,
		Angle
	};

	SnapLine(double resolution, int imageHeight, QObject *parent = 0, QSize qtPageSize = QSize(0,0));

	//! Draw the line on the provided painter
	void draw(QPainter *p);
	//! Return the shortest distance between a given point and the line
	double distanceToPoint(QPointF p, QPointF *nearestPoint);
	//! Set one of the enumerated points
	void setPoint(int pointChoice, QPointF p);


	//! Find points where a line intersects the line
	// If vertical = true, m contains 'x'
	QList<QPointF> intersections(double qtm, double qtc, bool vertical = false);
	QList<QPointF> intersections(QPointF qtp1, double angle);
	QList<QPointF> intersections(QPointF qtp1, QPointF qtp2);

	//! Is the point inside the object (for a line, always false)
	bool isInside(QPointF p);
	void addRelativeOSnaps(QPointF p);

	void deactivate();
	bool isActive();
	void activate();

public slots:
	//! Set the page size
	void setPageSize(QSize qt);
	

private slots:
	//! Update the painter path when the resolution or start/end points change
	void updateLine();

private:
	bool active;

	QSize pageSize;

	bool hitsRightBorder(QPointF *pt);
	bool hitsLeftBorder(QPointF *pt);
	bool hitsTopBorder(QPointF *pt);
	bool hitsBottomBorder(QPointF *pt);

};


#endif
