/***********************************************************************************
 * QGLE - A Graphical Interface to GLE                                             *
 * Copyright (C) 2006  A. S. Budden & J. Struyf                                    *
 *                                                                                 *
 * This program is free software; you can redistribute it and/or                   *
 * modify it under the terms of the GNU General Public License                     *
 * as published by the Free Software Foundation; either version 2                  *
 * of the License, or (at your option) any later version.                          *
 *                                                                                 *
 * This program is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of                  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                   *
 * GNU General Public License for more details.                                    *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License               *
 * along with this program; if not, write to the Free Software                     *
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. *
 *                                                                                 *
 * Also add information on how to contact you by electronic and paper mail.        *
 ***********************************************************************************/

/******************************************************************************
 * main.cpp: Contains the main function.  As with all QT main functions, this *
 * is very sparse: create the application object and show the main window.    *
 ******************************************************************************/

#include <QApplication>

#include "mainwindow.h"

int main(int argc, char *argv[])
{
	// Just for interest: print out a list of the available styles
	QStringList styles = QStyleFactory::keys();
	for ( QStringList::Iterator it = styles.begin(); it != styles.end(); ++it ) {
		qDebug() << "Style: " << *it;
	}
	
	QApplication app(argc,argv);
	Q_INIT_RESOURCE(qgle);
	GLEMainWindow mainWin(argc,argv);
	mainWin.show();
	return app.exec();
}
