/*
	Contouring program, creates gle files.
*/

#include "../all.h"
#include "../SourceLine.h"
#include "../tokens/Tokenizer.h"
#include "../core.h"
#include "../mygraph.h"
#include "../file_io.h"
#include "../texinterface.h"
#include "../cutils.h"
#include "../cmdline.h"
#include "../config.h"
#include "../mem_limits.h"
#include "../token.h"
#include "../gprint.h"
#include "../cutils.h"

#define BEGINDEF extern
#include "../begin.h"

#include "f2c.h"

double get_next_exp(TOKENS tk, int ntk, int *curtok);
void get_next_exp_file(TOKENS tk, int ntok, int *curtok, string* res);

#define kw(ss) if (ct <= ntk && str_i_equals(tk[ct],ss))
#define next_file_eval(s) get_next_exp_file(tk,ntk,&ct,&s)
#define next_str(s) ct+=1;s=tk[ct]

double* read_zdata(const char *fname, double *zmin, double *zmax, int *nx, int *ny);

static double *zz;
static double dxmin,dymin,dxmax,dymax;
static double nnx,nny;
bool smooth = false;
int smoothsub = 5;

void draw_(double *x, double *y, int *iflag);
void gcontr_(double *, int *, int *, int *, double *, int *, double *, int *, S_fp draw);
int glefitcf_(int* mode, double *x, double *y, int* l, int* m, double *u, double *v, int* n);

class GLEContourInfo {
private:
	FILE* m_DatFile;
	FILE* m_LabFile;
	vector <double> m_CVal;
	vector <string> m_CLab;
	vector <double> m_XPt;
	vector <double> m_YPt;
	double m_XCur, m_YCur;
public:
	GLEContourInfo();
	~GLEContourInfo();
	inline int getNbLines() { return m_CVal.size(); }
	inline double getCValue(int i) { return m_CVal[i]; }
	inline void addValue(double v) { m_CVal.push_back(v); }
	inline double* getCValueArray() { return (double*)&m_CVal[0]; }
	inline double getXCur() { return m_XCur; }
	inline double getYCur() { return m_YCur; }
	inline void setXCur(double v) { m_XCur = v; }
	inline void setYCur(double v) { m_YCur = v; }
	inline int getNbDataPoints() { return m_XPt.size(); }
	inline double getDataX(int i) { return m_XPt[i]; }
	inline double getDataY(int i) { return m_YPt[i]; }
	inline double* getDataXArray() { return &m_XPt[0]; }
	inline double* getDataYArray() { return &m_YPt[0]; }
	void addDataPoint(double x, double y);
	void setDataPoint(int i, double x, double y);
	void addAllDataPoints();
	void clearDataPoints();
	double sx(double v);
	double sy(double v);
	void addUnknown();
	void addPoint(double x, double y);
	void addPointScale(double x, double y);
	void addLabel(double x, double y, int i, double v);
	void addVect(int m, double x, double y);
	void fillDefault(double zmin, double zmax, double zdel);
	void createLabels(bool alpha);
	void openData(const string& name, const string& lab);
	void closeData();
	void doContour(double zz[], int nrz, int nx, int ny, double zmax);
	void draw(double* x, double* y, int iflag);
};

GLEContourInfo* g_ContourInfo = NULL;

GLEContourInfo::GLEContourInfo() {
	m_DatFile = NULL;
}

GLEContourInfo::~GLEContourInfo() {
}

void GLEContourInfo::addDataPoint(double x, double y) {
	m_XPt.push_back(x);
	m_YPt.push_back(y);
}

void GLEContourInfo::setDataPoint(int i, double x, double y) {
	m_XPt[i] = x;
	m_YPt[i] = y;
}

void GLEContourInfo::clearDataPoints() {
	m_XPt.clear();
	m_YPt.clear();
}

void GLEContourInfo::addAllDataPoints() {
	for (int i = 0; i < getNbDataPoints(); i++) {
		addPoint(getDataX(i), getDataY(i));
	}
}

void GLEContourInfo::fillDefault(double zmin, double zmax, double zdel) {
	double zval = zmin;
	do {
		m_CVal.push_back(zval);
		zval += zdel;
	} while (zval <= zmax);
}

void GLEContourInfo::createLabels(bool alpha) {
	for (int i = 0; i < getNbLines(); i++) {
		if (alpha) {
			char buff[20];
			sprintf(buff,"%c",i+'A');
			m_CLab.push_back(buff);
		} else {
	  		// use numberformat instead later on
			char buff[50];
			sprintf(buff,"%g",m_CVal[i]);
			m_CLab.push_back(buff);
		}
	}
}

void GLEContourInfo::openData(const string& name, const string& lab) {
	m_DatFile = fopen(name.c_str(), "w");
	m_LabFile = fopen(lab.c_str(), "w");
}

void GLEContourInfo::closeData() {
	fclose(m_DatFile);
	fclose(m_LabFile);
	m_DatFile = NULL;
	m_LabFile = NULL;
}

void GLEContourInfo::doContour(double zz[], int nrz, int nx, int ny, double zmax) {
	int ncv = getNbLines();
	// dimension of work is large enough to contain
	// 2*(dimension of c)*(total dimension of z) useful bits
	int* work = (int*)malloc(((int)sizeof(int) * 2 * ncv * nx * ny)/31 + 10);
	if (work == NULL) {
		printf("Unable to allocate storage for work array\n");
		exit(1);
	}
	zmax = zmax + 100; /* no clipping */
	double* cvalp = getCValueArray();
    	gcontr_(zz, &nrz, &nx, &ny, cvalp, &ncv, &zmax, work, (S_fp)draw_);
}

double GLEContourInfo::sx(double v) {
	return dxmin + (dxmax-dxmin)*(v-1)/(nnx-1);
}

double GLEContourInfo::sy(double v) {
	return dymin + (dymax-dymin)*(v-1)/(nny-1);
}

void GLEContourInfo::addUnknown() {
	fprintf(m_DatFile, "* *\n");
}

void GLEContourInfo::addPoint(double x, double y) {
	fprintf(m_DatFile,"%g %g\n", x, y);
}

void GLEContourInfo::addPointScale(double x, double y) {
	fprintf(m_DatFile,"%g %g\n", sx(x), sy(y));
}

void GLEContourInfo::addLabel(double x, double y, int i, double v) {
	fprintf(m_LabFile,"%g %g %d %g\n", x, y, i, v);
}

void GLEContourInfo::draw(double* x, double* y, int iflag) {
	int ih = iflag / 10;
	/* printf("level %d \n",ih); */
	int il = iflag - ih * 10;
	switch (il) {
	  case 6:   /* Get current point */
		*x = getXCur();
	    	*y = getYCur();
	    	break;
	  case 2: /* start contour at bondary */
	  case 3: /* start contour not at bondary */
		if (smooth) addVect(1, sx(*x), sy(*y));
		else {
			addUnknown();
			addPointScale(*x, *y);
		}
		addLabel(sx(*x),sy(*y), ih-1, getCValue(ih-1));
		break;
	  case 1: /* continue a contour */
		if (smooth) addVect(2, sx(*x), sy(*y));
		else addPointScale(*x, *y);
		break;
	  case 4: /* finish contour at a boundary */
		if (smooth) addVect(4, sx(*x), sy(*y));
		else addPointScale(*x, *y);
		break;
	  case 5: /* finish close contour */
		if (smooth) addVect(3, sx(*x), sy(*y));
		else addPointScale(*x, *y);
		break;
	}
	setXCur(*x);
	setYCur(*y);
}

void GLEContourInfo::addVect(int m, double x, double y) {
	if (m == 1) {
		int nbpts = getNbDataPoints();
		if (getNbDataPoints() != 0) printf("Error, some points not drawn \n");
		clearDataPoints();
	}
	int nbpts = getNbDataPoints();
	if (nbpts > 0 && getDataX(nbpts-1) == x && getDataY(nbpts-1) == y) {
		if (m <= 2) addDataPoint(x, y);
	} else {
		addDataPoint(x, y);
	}
	// Connect the ends by adding some points if contour is right sort
	// 4 = boundary, 3 = closed shape
	if (m == 3 || m == 4) {
		if (nbpts < 2) {
			addAllDataPoints();
			clearDataPoints();
			return;
		}
		bool snipends = false;
		if (m == 3) {
			snipends = true;
			int nbpts = getNbDataPoints();
			addDataPoint(getDataX(nbpts-1), getDataY(nbpts-1));
			for (int i = nbpts-1; i > 0; i--) {
				setDataPoint(i, getDataX(i-1), getDataY(i-1));
			}
			setDataPoint(0, getDataX(nbpts-1), getDataY(nbpts-1));
			addDataPoint(getDataX(2), getDataY(2));
		}
		int ninp = getNbDataPoints();
		int mode = 2; 		// multi valued
		// int nsub = smoothsub;	// user parameter
		// if (nsub < 3) nsub = 3;

		int nsub = 10;
		int nout = (ninp-1)*nsub+1;
		cout << "nsub = " << nsub << endl;
		double* xout = (double*)malloc(nout*sizeof(double));
		double* yout = (double*)malloc(nout*sizeof(double));
		glefitcf_(&mode,getDataXArray(),getDataYArray(),&ninp,&nsub,xout,yout,&nout);
		clearDataPoints();
		addUnknown();
		if (snipends) {
		 	for (int i = nsub; i < nout-nsub; i++) {
				addPoint(xout[i], yout[i]);
		 	}
		} else {
			cout << "nin = " << ninp << " nout = " << nout << endl;
			for (int i = 0; i < nout; i++) {
				addPoint(xout[i], yout[i]);
		 	}
		}
		free(xout); free(yout);
	}
}

void get_contour_values(GLEContourInfo* info, int ct) throw(ParserError) {
	ct++;
	while (ct <= ntk) {
		if (str_contains(tk[ct], ':')) {
			TokenizerLanguage lang;
			StringTokenizer tokens(&lang);
			lang.setSingleCharTokens(":");
			tokens.set_string(tk[ct]);
			double from = tokens.next_double();
			tokens.ensure_next_token(":");
			double to = tokens.next_double();
			tokens.ensure_next_token(":");
			double step = tokens.next_double();
			info->fillDefault(from, to, step);
		} else {
			info->addValue(token_next_double(ct));
		}
		ct += 1;
        }
}

void begin_contour(int *pln, int *pcode, int *cp) throw(ParserError) {
	int nx, ny;
	double zmin = 1e10, zmax = -1e10;
	string data_file;
	bool alpha = false;
	int smoothsub = 0;
	vector<double> cval;
	vector<string> clab;
	// Create new contourinfo object
	if (g_ContourInfo != NULL) {
		delete g_ContourInfo;
		g_ContourInfo = NULL;
	}
	g_ContourInfo = new GLEContourInfo();
	// Start with pcode from the next line
	(*pln)++;
	begin_init();
	while (true) {
		int st = begin_token(&pcode,cp,pln,srclin,tk,&ntk,outbuff);
		if (!st) {
			/* exit loop */
			break;
		}
		int ct = 1;
		// cout << "ct = " << ct << " tk = " << ntk << " tk = " << tk[ct] << endl;
		kw("DATA") {
			next_file_eval(data_file);
			read_zdata((char*)data_file.c_str(),&zmin,&zmax,&nx,&ny);
		} else kw("VALUES") {
			get_contour_values(g_ContourInfo, ct);
		} else kw("LABELS") {
			// get_contour_label_sett(&alpha);
		} else kw("SMOOTH") {
			smoothsub = atoi(tk[++ct]);
		} else if (ct <= ntk) {
			stringstream err;
			err << "illegal keyword in contour block: '" << tk[ct] << "'";
			g_throw_parser_error(err.str());
		}
	}
	if (g_ContourInfo->getNbLines() == 0) {
		g_ContourInfo->fillDefault(zmin, zmax, (zmax-zmin)/10.0);
	}
	int zdim = nx;
	nnx = nx; nny = ny;
	g_ContourInfo->createLabels(true);
	string dat_file, val_file, lab_file;
	GetMainName(data_file, dat_file);
	GetMainName(data_file, val_file);
	GetMainName(data_file, lab_file);
	dat_file += "-cdata.dat";
	val_file += "-cvalues.dat";
	lab_file += "-clabels.dat";
	FILE* val_f = fopen(val_file.c_str(), "w");
	if (val_f != NULL) {
		for (int i = 0; i < g_ContourInfo->getNbLines(); i++) {
			fprintf(val_f, "%g\n", g_ContourInfo->getCValue(i));
		}
		fclose(val_f);
	}
	g_ContourInfo->openData(dat_file, lab_file);
	g_ContourInfo->doContour(zz,zdim,nx,ny,zmax);
	g_ContourInfo->closeData();
}

void plot_(double *a, double *b, int *c) {
}

void draw_(double *x, double *y, int *iflag) {
	g_ContourInfo->draw(x, y, *iflag);
}

bool alloc_zdata2(int nx, int ny) {
	if (zz!=NULL) free(zz);
	zz = (double*)malloc((int) nx * ((int) ny+1) * sizeof(double));
	if (zz==NULL) {
		printf("Unable to allocate enough memory for datafile\n");
		return true;
	}
	return false;
}

double getkeyval(char *buff,char *k);

double* read_zdata(const char *fname, double *zmin, double *zmax, int *nx, int *ny) {
	double v;
	int x,y;
	int c,b;
	char *s;
	int i;
	x = y = 0;
	*nx = 0; *ny = 0;
	char buff[2050];
	FILE* df = fopen(fname,"rt");
	if (df==NULL) {*nx = 0; *ny = 0; return NULL;}
	for (;!feof(df);) {
	  if (fgets(buff,2000,df)!=NULL) {
		if (*nx==0) {
			gle_strupr(buff);
			*nx  = (int)getkeyval(buff,"NX");
			*ny  = (int)getkeyval(buff,"NY");
			dxmin = getkeyval(buff,"XMIN");
			dymin = getkeyval(buff,"YMIN");
			dxmax = getkeyval(buff,"XMAX");
			dymax = getkeyval(buff,"YMAX");
			if (*nx==0 || *ny==0) {
				printf("Expecting to find  ! nx 11 ny 11 xmin 0 xmax 10 ymin 0 ymax 10 \n");
				printf("on first line of data file,  Please enter this data \n");
				return NULL;
			} else {
				fgets(buff,2000,df);
			}
			if (alloc_zdata2(*nx,*ny)) return NULL;
		}
check_again:
		b = strlen(buff);
		c = buff[b-1];
		if (strchr(" \n\t",c)==NULL) { /* we're halfway thru a number */
			buff[b] = getc(df);
			buff[b+1] = 0;
			goto check_again;
		}
		s = strchr(buff,'!');
		if (s!=NULL) *s = 0;
		s = strtok(buff," \t\n,");
		for (;s!=NULL;) {
			v = atof(s);
			if (isdigit(*s) || *s=='-' || *s=='+' || *s=='.') {
				if (x>= *nx) {
					x = 0; y++;
				}
				if (y>= *ny) {
					printf("Too much data in data file %ld %d \n",y,*ny);
					return NULL;
				}
				if (v < *zmin) *zmin = v;
				if (v > *zmax) *zmax = v;
				zz[x + y * *nx] = v;
				x++;
			} else printf("Not a number {%s} \n",s);
			s = strtok(NULL," \t\n,");
		}
	  }
	}
	fclose(df);
	*ny = y+1;
	return zz;
abort_data:
	fclose(df);
	*nx = 0; *ny = 0;
	return NULL;

}
