
#include "all.h"
#include "SourceLine.h"
#include "file_io.h"
#include "gprint.h"

extern char errgle[];

char *sdup(const char *s) {
	char *v;
	v = (char*) myalloc(strlen(s)+1);
	strcpy(v,s);
	return v;
}

void myfree(void *p) {
	myfrees(p,"UNKNOWN");
}

void myfrees(void *p, char *s) {
	free(p);
}

void *myallocn(int nitems,int size) {
	return myallocz(nitems*size);
}

void *myalloc(int size) {
	if (size == 0) {
		sprintf(errgle,"\nError, attempt to allocate ZERO memory \n");
		gle_abort(errgle);
	}
	void* p = malloc(size+sizeof(int)*2);
	if (p == NULL) {
		freeafont();
		p = malloc(size+sizeof(int)*2);
		if (p == NULL) {
			sprintf(errgle,"\nMemory allocation failure (size %d)\n", size);
			gle_abort(errgle);
		}
	}
	return p;
}

void *myallocz(int size) {
	static void *p;
	static int *l;
	if (size==0) {
		sprintf(errgle,"\nError, attempt to allocate ZERO memory \n");
		gle_abort(errgle);
	}
	p = calloc(1,size+sizeof(int)*2);
	if (p == NULL) {
		freeafont();
		p = calloc(1,size+sizeof(int)*2);
		if (p == NULL) {
			sprintf(errgle,"\nMemory allocation failure (size %d)\n", size);
			gle_abort(errgle);
		}
	}
	return p;
}

int mem_total() {
	return 0;
}

int mem_worst() {
	return 0;
}

char errgle[90];
int dont_clear;

void gle_abort(char *s) {
	printf("%s",s);
	exit(1);
}
