#ifndef INCLUDE_GLEPRO
#define INCLUDE_GLEPRO

#define SC (char *)
#define UC (unsigned char *)

#define GLE_TRNS_MATRIX_SIZE 3*3*sizeof(double)
#define CM_PER_INCH 2.54

typedef double dbl;

typedef unsigned char uchar;

#define BITMAP_TYPE_TIFF 1
#define BITMAP_TYPE_GIF  2
#define BITMAP_TYPE_PNG  3
#define BITMAP_TYPE_JPEG 4

//int do_pcode(int *srclin, int *pcode, int plen, int *pend);
char *eval_str(int *pcode,int *plen);
char *gledir(char *filename);
char *sdup(const char *s);
const char *gle_top(void);
double graph_xgraph(double v);
double graph_ygraph(double v);
double myatan2(double y, double x);
double tex_xend(void);
double tex_yend(void);
int axis_type(char *s);
int char_lig(int cf,uchar *c1, int c2);
void df_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
void df_arcto(dbl x1, dbl y1, dbl x2, dbl y2, dbl r);
int df_box_fill(dbl x1, dbl y1, dbl x2, dbl y2);
int df_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2);
int df_circle_fill(dbl r);
int df_circle_stroke(dbl r);
int df_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy);
int mem_total(void);
int mem_worst(void);
int pass_color(const char *s);
int pass_color_var(const char *s);
int pass_font(const char *s);
int testfree(int i);
int text_printf(int *in,int ilen);
int w_message(char *s);
void init_memory(void);
void *myalloc(int size);
void *myallocn(int nitems,int size);
void *myallocz(int size);
void add_svga(void);
void alloc_temp(int n);
void big_close(void);
void box_clip(double *x1, double *y1, double xmin, double ymin, double xmax, double ymax);
void char_bbox(int ff,int cc,double *xx1, double *yy1, double *xx2, double *yy2);
void char_kern(int cf,int c1, int c2, float *w);
void cmd_name(int idx, char **cp);
void d_tidyup(void);
void debug_polish(int *pcode,int *zcp);
void dr_init(void);
void draw_vec(double x1, double y1, double x2, double y2);
void f_init(void);
void find_mkey(string cp, int *idx);
void find_un(char *cp, int *idx,int *ret,int *np,int **plist);
void font_get_lineskip(double *ls,double *gap);
void font_get_parskip(double *ls,double *gap);
void font_init(void);
void font_load(void);
void font_load_metric(int ff);
void font_replace_vector(int ff);
void font_set(char *s);
void font_simple(void);
void freeafont(void);
void freeavec(void);
void freefont(int i);
void g_shear(double sx,double sy);
void get_str(char **s,int l,FILE *fmt);
void gle_include(char *s);
void gprint_do(char *output);
void gr_nomiss(int i);
void gr_thrownomiss(void);
void graph_freedata(void);
void myfree(void *p);
void myfrees(void *p, char *s);
void mystrcpy(char **d,char *s);
void ncpy(char *d, char *s, int n);
void plotter_fonts(void);
void polar_xy(double r, double angle, double *dx, double *dy);
void polar_xy(double rx, double ry, double angle, double *dx, double *dy);
void preview_big(void);
void scheck(int v);
void set_glue(int *in,int ilen,double actual,double width,double stretch,double shrink,double *setlen);
void setdstr(char **s, char *in);
void showpcode(int *p);
void spop(int v);
void spush(int v);
void sub_clear(void);
void sub_get_startend(int idx, int *ss, int *ee);
void sub_set_return(double d);
void sub_set_return_str(const char* s);
void sub_set_startend(int idx, int ss, int ee);
void subscript();
void text_block(const string& s,double width,int justify);
void text_block(const string& s,double width,int justify, int innerjust);
void text_draw(int *in,int ilen);
void text_tomacro(const string& in, uchar *out);
void text_topcode(uchar *in, int *out, int *lout)      /*  passed a paragraph  */;
void text_wrapcode(int *in,int ilen,double width);
void wprintf_do(char *s);
void xy_polar(double dx,double dy,double *radius,double *angle);
void reset_new_error(bool val);
int get_nb_errors();
void inc_nb_errors();
const char* get_font_name(int idx);
int get_nb_fonts();
void name_clear();
void pass_file_name(const char* name, string& file);
int get_nb_extra_args();
const string& get_extra_arg(int i);
void gle_abort(char *s);
void do_wait_for_enter_exit(int exitcode);

#endif
