
#include "all.h"
#include "tokens/stokenizer.h"
#include "SourceLine.h"
#include "tokens/Tokenizer.h"
#include "justify.h"
#include "mygraph.h"
#include "core.h"
#include "axis.h"
#include "gprint.h"
#include "d_interface.h"
#include "numberformat.h"
#include "cutils.h"

#define GRAPHDEF extern
#include "mem_limits.h"
#include "token.h"
#include "graph.h"

void start_subtick(double *tick1, double gmin, double dticks);
void nice_ticks(double *dticks, double *gmin,double *gmax, double *t1,double *tn,int minset, int maxset);
void numtrim(char **d,char *s, double dticks);
void nice_log_ticks(double *start, double *last, double *gmin, double *gmax);

double fnloglen(double v,axis_struct *ax);
double fnlogx(double v,axis_struct *ax);
int fnbig(double v);

extern double graph_x1;
extern double graph_x2;
extern double graph_y1;
extern double graph_y2;

#define fnx(vv) m_fnx(vv)
#define fnlx(vv) fnlogx(vv,ax)
#define true (!false)
#define false 0

static double  gglen,ggmin,ggmax,ggnegate;

double m_fnx(double v);

double m_fnx(double v) {
	if (ggnegate) 	{
		v = ggmax - (v-ggmin);
	}
	return (((v-ggmin)/(ggmax-ggmin)) * gglen );
}

bool axis_is_pos(double pos, int* cnt, double del, vector<double>& vec) {
	if (*cnt < vec.size()) {
		while (*cnt < vec.size() && pos > vec[*cnt]+del/100.0) {
			(*cnt)++;
		}
		if (*cnt < vec.size() && fabs(pos-vec[*cnt]) < del/100.0) {
			return true;
		}
	}
	return false;
}

bool axis_is_pos_perc(double pos, int* cnt, double perc, vector<double>& vec) {
	if (*cnt < vec.size()) {
		while (*cnt < vec.size() && pos > vec[*cnt]*(1+perc)) {
			(*cnt)++;
		}
		if (*cnt < vec.size()) {
			if (vec[*cnt] != 0.0) {
				if (fabs((pos-vec[*cnt])/vec[*cnt]) < perc) return true;
			} else {
				if (fabs(pos-vec[*cnt]) < perc) return true;
			}
		}
	}
	return false;
}

void axis_draw_tick(axis_struct *ax, double fi, int* tick1_cnt, int* tick2_cnt, double ox, double oy, double t) {
	bool has_tick1 = !ax->isNoTick1(fi, tick1_cnt, ax->dsubticks);
	bool has_tick2 = ax->ticks_both && !ax->isNoTick2(fi, tick2_cnt, ax->dsubticks);
	double from = has_tick2 ? -t : 0.0;
	double to = has_tick1 ? t : 0.0;
	if (axis_horizontal(ax->type)) {
		g_move(ox+fnx(fi), oy+from);
		g_line(ox+fnx(fi), oy+to);
	} else {
		g_move(ox+from, oy+fnx(fi));
		g_line(ox+to, oy+fnx(fi));
	}
}

void axis_draw_tick_log(axis_struct *ax, double fi, int* tick1_cnt, int* tick2_cnt, double ox, double oy, double t) {
	bool has_tick1 = !ax->isNoTick1Perc(fi, tick1_cnt);
	bool has_tick2 = ax->ticks_both && !ax->isNoTick2Perc(fi, tick2_cnt);
	double from = has_tick2 ? -t : 0.0;
	double to = has_tick1 ? t : 0.0;
	if (axis_horizontal(ax->type)) {
		g_move(ox+fnlx(fi), oy+from);
		g_line(ox+fnlx(fi), oy+to);
	} else {
		g_move(ox+from, oy+fnlx(fi));
		g_line(ox+to, oy+fnlx(fi));
	}
}

void draw_axis(axis_struct *ax, gbox* box) {
	double fi,x,y,gmin,gmax,dticks,tick1,tickn;
	int i,xax,n,savecap;
	int isbig;
	double tlen,stlen,dsubticks,tt,t,start;
	double h,label_width,dist;
	double bl,br,bu,bd;
	double ox,oy;
	double th;

	// Fix for font problems by Jan Struyf
	g_resetfont();

	xax = axis_horizontal(ax->type);
	g_source("BEGIN AXIS  =====\n");
	if (ax->off) return;
	g_get_xy(&ox,&oy);

/*----------------------------- Generate the places for labels to go */
	ggmin = ax->min;
	ggmax = ax->max;
	ggnegate = ax->negate;
	gmin = ax->min;
	gmax = ax->max;
	gglen = ax->length;

	if (ax->log) {
		/* generate places for log main ticks */
		if (ax->lgset == GLE_AXIS_LOG_DEFAULT) {
			/* dist between 10^0 and 10^1 */
			dist = fnloglen(2,ax) - fnloglen(1,ax);
			if (dist > ax->base*4.5) ax->lgset = GLE_AXIS_LOG_25;
			if (dist > ax->base*22.0) ax->lgset = GLE_AXIS_LOG_1;
		}
		nice_log_ticks(&tick1,&tickn,&gmin,&gmax);
		if (ax->getNbPlaces() == 0) {
			fi = tick1;
			bool is_last = false;
			bool lg1 = ax->lgset == GLE_AXIS_LOG_1;
			bool lg25 = ax->lgset == GLE_AXIS_LOG_25 || ax->lgset == GLE_AXIS_LOG_25B;
			while (!is_last) {
				i = (int) floor(.0001 + fi/pow(10.0,floor(log10(fi))));
				bool enable = fnbig(fi) || lg1 || (lg25 && ((i==2) || (i==5)));
				if (ax->nofirst && fi == tick1) enable = false;
				double next_fi = fi + pow(10.0,floor(log10(fi)+0.0001));
				is_last = next_fi >= tickn+(pow(10.0,floor(log10(next_fi)+0.0001)))/100.0;
				if (ax->nolast && is_last) enable = false;
				if (enable) ax->addPlace(fi);
				fi = next_fi;
			}
		}
	} else {
		dticks = 0;
		if (ax->nticks != 0) dticks = (gmax - gmin)/ax->nticks;
		if (ax->dticks != 0) dticks = ax->dticks;
		if (ax->has_ftick) {
			tick1 = ax->ftick;
			if (ax->dticks == 0) {
				// Compute suitable value for dticks
				double dummy = 0.0;
				nice_ticks(&dticks, &gmin, &gmax, &dummy, &tickn, ax->minset, ax->maxset);
			}
			if (ax->nticks != 0) {
				tickn = tick1 + (ax->nticks-1) * dticks;
			} else {
				tickn = tick1 + floor((gmax-tick1)/dticks) * dticks;
			}
		} else {
			nice_ticks(&dticks, &gmin, &gmax, &tick1, &tickn, ax->minset, ax->maxset);
		}
		if (ax->nofirst) tick1 = tick1 + dticks;
		if (ax->nolast) tickn = tickn - dticks;
		tickn = tickn + dticks/100.0;
		if (ax->getNbPlaces() == 0) {
			/* haven't been set, so generate positions. */
			double end_tick = (tickn+dticks/100.0);
			for (fi = tick1; fi <= end_tick; fi += dticks) {
				ax->addPlace(fi);
			}
		}
	}

/*------------------------------  Now draw the ticks	(subticks first) */
	g_gsave();

	// ticks length
	tlen = ax->base*g_get_fconst(GLEC_TICKSSCALE);
	if (ax->ticks_length!=0) tlen = ax->ticks_length;

	// subticks length and distance
	stlen = tlen/2;
	if (ax->subticks_length!=0) stlen = ax->subticks_length;
	dsubticks = 0;

	// draw subticks
	if (!ax->log) {
		if (ax->nsubticks != 0) dsubticks = dticks/(ax->nsubticks+1);
		if (ax->dsubticks != 0) dsubticks = ax->dsubticks;
		if (dsubticks == 0) dsubticks = dticks / 2.0;
		ax->dsubticks = dsubticks;
		double end_tick = gmax;
		if (ax->has_ftick) {
			tick1 += dsubticks;
			end_tick = tickn;
		} else {
			start_subtick(&tick1, gmin, dsubticks);
		}
		g_set_color(ax->subticks_color);
		g_set_line_width(ax->subticks_lwidth);
		g_set_line_style(ax->subticks_lstyle);
		if (axis_ticks_neg(ax->type)) t = -stlen; else t = stlen;
		if (!ax->subticks_off) {
			int place_cnt = 0;
			int tick1_cnt = 0;
			int tick2_cnt = 0;
			for (fi = tick1; fi <= end_tick; fi += dsubticks) {
				if (!ax->isPlace(fi, &place_cnt, dsubticks)) {
					axis_draw_tick(ax, fi, &tick1_cnt, &tick2_cnt, ox, oy, t);
				}
			}
		}
	}

/*------------------------------  Now the main ticks */
	if (axis_ticks_neg(ax->type)) t = -tlen; else t = tlen;
	if (axis_ticks_neg(ax->type)) tt = -stlen; else tt = stlen;
	if (!ax->ticks_off) {
		if (ax->log) {	/* Draw log ticks */
			int prevbig = -1;
			int tick1_cnt = 0;
			int tick2_cnt = 0;
			nice_log_ticks(&tick1,&tickn,&gmin,&gmax);
			for (fi=tick1; fi<= tickn+(pow(10.0,floor(log10(fi)+.0001)))/100; fi += pow(10.0,floor(log10(fi)+.0001))) {
				i = (int) floor(fi/pow(10.0,floor(log10(fi))));
				isbig = (fnbig(fi));
				/* do not draw small ticks if subticks is off ! (fix 5/11/04) */
				if (isbig || (ax->subticks_off == false)) {
					if (isbig != prevbig) {
						/* not equal to previous size: resize! */
						if (isbig) {
							g_set_color(ax->ticks_color);
							g_set_line_width(ax->ticks_lwidth);
							g_set_line_style(ax->ticks_lstyle);
						} else {
					    		g_set_color(ax->subticks_color);
							g_set_line_width(ax->subticks_lwidth);
							g_set_line_style(ax->subticks_lstyle);
						}
						prevbig = isbig;
					}
					/* select ticks length */
					x = isbig ? t : tt;
					axis_draw_tick_log(ax, fi, &tick1_cnt, &tick2_cnt, ox, oy, x);
				}
			}
		} else {
			g_set_color(ax->ticks_color);
			g_set_line_width(ax->ticks_lwidth);
			g_set_line_style(ax->ticks_lstyle);
			int tick1_cnt = 0;
			int tick2_cnt = 0;
			for (i = 0; i < ax->getNbPlaces(); i++) {
				fi = ax->places[i];
				axis_draw_tick(ax, fi, &tick1_cnt, &tick2_cnt, ox, oy, t);
			}
		}
	}
	g_grestore();

/*-----------------------------  Ok lets draw the side now */
/*-----------------------------  Note: after the ticks - this gives better result if ticks are different color */
	g_get_line_cap(&savecap);
	g_gsave();
	g_set_color(ax->side_color);
	g_set_line_width(ax->side_lwidth);
	g_set_line_style(ax->side_lstyle);
	if (!ax->side_off) {
		g_set_line_cap(1);
		g_get_xy(&x,&y);
		if (xax) g_line(x+ax->length,y);
		else g_line(x,y+ax->length);
	}
	g_grestore();
	g_set_line_cap(savecap);

/*------------------------------  Now draw the labels */
	double real_llen = 0;
	if (!ax->ticks_off) {
		if (tlen < 0) real_llen = -tlen;
		if (ax->ticks_both) real_llen = +tlen;
	}
	h = ax->label_hei;
	if (h==0) h = ax->base;
	double llen = real_llen + h*g_get_fconst(GLEC_ALABELDIST);
	if (ax->label_dist!=0) llen = ax->label_dist;
	if (ax->getNbNames() == 0) {
		char cbuff[100];
		GLENumberFormat* format = ax->format == "" ? NULL : new GLENumberFormat(ax->format);
		if (ax->log) {
			for (i = 0; i < ax->getNbPlaces(); i++) {
				fi = ax->places[i];
				n = (int) floor(.0001 + fi/pow(10.0,floor(log10(fi))));
				if (fnbig(fi)) {
					n = (int) floor(log10(fi)+0.5);
					if (format != NULL) {
						format->format(pow(10.0, n), ax->getNamePtr(i));
					} else {
						if (n == 0) {
							sprintf(cbuff,"1");
						} else if (n == 1) {
							sprintf(cbuff,"10");
						} else {
							sprintf(cbuff,"10\\sup {%d}",n);
						}
						ax->setName(i, cbuff);
					}
				} else {
					if (ax->lgset == GLE_AXIS_LOG_25B && format != NULL) {
						format->format(fi, ax->getNamePtr(i));
					} else {
						n = (int) floor(.0001 + fi/(pow(10.0,floor(log10(fi)))));
						sprintf(cbuff,"{\\sethei{%g}%d}",h*.7,n);
						ax->setName(i, cbuff);
					}
				}
			}
		} else {
			if (ax->getNamesDataSet() != -1) {
				// Get axis labels from a data set
				ax->getLabelsFromDataSet(ax->getNamesDataSet());
			} else {
				for (i = 0; i < ax->getNbPlaces(); i++) {
					fi = ax->places[i]; x = fabs(fi);
					if (x < .00001*dticks) {
						fi = 0; x = 0;
					}
					if (format != NULL) {
						format->format(fi, ax->getNamePtr(i));
					} else {
						char* num_trim_str = NULL;
						if (fi==0 || (x>1e-5 && x<1e6)) sprintf(cbuff,"%f",fi);
						else sprintf(cbuff,"%e",fi);
						numtrim(&num_trim_str,cbuff,dticks);
						if (num_trim_str != NULL) {
							ax->setName(i, num_trim_str);
							myfree(num_trim_str);
						}
					}
				}
			}
		}
		if (format != NULL) delete format;
	}
	g_set_color(ax->label_color);
	g_set_line_width(ax->label_lwidth);
	g_set_line_style(ax->label_lstyle);
	g_set_font(ax->label_font);
	g_set_hei(h*g_get_fconst(GLEC_ALABELSCALE));
	double maxd = 0, maxh = 0;
	GLEMeasureBox measure;
	measure.measureStart();
	// If there are no labels, use g_set_bounds to initialize "measure"
	switch (ax->type) {
		case GLE_AXIS_X:
		case GLE_AXIS_X0:
			g_set_bounds(ox+ax->shift, oy-real_llen);
			break;
		case GLE_AXIS_Y:
		case GLE_AXIS_Y0:
			g_set_bounds(ox-real_llen, oy+ax->shift);
			break;
		case GLE_AXIS_X2:
		case GLE_AXIS_T:
			g_set_bounds(ox+ax->shift, oy+real_llen);
			break;
		case GLE_AXIS_Y2:
			g_set_bounds(ox+real_llen, oy+ax->shift);
			break;
	}
	if (!ax->label_off) {
		int nb_names = ax->getNbNamedPlaces();
		for (i = 0; i < nb_names; i++) {
			g_measure(ax->names[i],&bl,&br,&bu,&bd);
			if (bu > maxh) maxh = bu;
			if (-bd > maxd) maxd = -bd;
		}
		int place_cnt = 0;
		double angle = ax->getLabelAngle();
		for (i = 0; i < nb_names; i++) {
			fi = ax->places[i];
			const string& name = ax->names[i];
			if (!ax->isNoPlaceLogOrReg(fi, &place_cnt, dticks) && name != "") {
				fi = fnx(fi);
				if (ax->log) fi = fnlx(ax->places[i]);
				g_measure(name, &bl, &br, &bu, &bd);
				switch (ax->type) {
					case GLE_AXIS_X:
					case GLE_AXIS_X0:
						if (angle == 0.0) {
							g_move(ox+fi+ax->shift, oy-llen-maxh);
							g_jtext(JUST_CENTRE);
						} else {
							g_gsave();
							g_move(ox+fi+ax->shift, oy-llen);
							g_rotate(angle);
							if (angle == 90.0) g_jtext(JUST_RC);
							else if (angle > 0.0) g_jtext(JUST_TR);
							else g_jtext(JUST_TL);
							g_grestore();
						}
						break;
					case GLE_AXIS_Y:
					case GLE_AXIS_Y0:
						if (angle == 0.0) {
							g_move(ox-llen, oy+fi+ax->shift);
							g_jtext(JUST_RC);
						} else {
							g_gsave();
							if (angle == 90.0) {
								g_move(ox-llen-maxd, oy+fi+ax->shift);
								g_rotate(90);
								g_jtext(JUST_CENTRE);
							} else {
								g_move(ox-llen, oy+fi+ax->shift);
								g_rotate(angle);
								if (angle > 0.0) g_jtext(JUST_BR);
								else g_jtext(JUST_TR);
							}
							g_grestore();
						}
						break;
					case GLE_AXIS_X2:
						if (angle == 0.0) {
							g_move(ox+fi+ax->shift, oy+llen+maxd);
							g_jtext(JUST_CENTRE);
						} else {
							g_gsave();
							g_move(ox+fi+ax->shift, oy+llen);
							g_rotate(angle);
							if (angle == 90.0) g_jtext(JUST_LC);
							else if (angle > 0.0) g_jtext(JUST_BL);
							else g_jtext(JUST_BR);
							g_grestore();
						}
						break;
					case GLE_AXIS_Y2:
						g_move(ox+llen, oy+fi+ax->shift);
						g_jtext(JUST_LC);
						break;
				}
			}
		}
	}
	measure.measureEnd();

/*---------------------------------- Now the axis title. */
	if (ax->title == "") {
		g_update_bounds_box(box);
		return;
	}

	g_gsave();
	th = h * g_get_fconst(GLEC_ATITLESCALE);
	if (ax->title_scale!=0) th = th*ax->title_scale;
	if (ax->title_hei!=0) th = ax->title_hei;
	g_set_color(ax->title_color);
	g_set_font(ax->title_font);
	g_set_hei(th);
	double tdist = ax->title_dist;
	if (tdist == 0) tdist = h * g_get_fconst(GLEC_ATITLEDIST);
	if (!ax->title_off) {
		string title_str = ax->title;
		if (g_get_tex_labels()) {
			title_str.insert(0, "\\tex{");
			title_str.append("}");
		}
		g_measure(title_str,&bl,&br,&bu,&bd);
		switch (ax->type) {
			case GLE_AXIS_X:
			case GLE_AXIS_X0:
				g_move(ox+ax->length/2, measure.getY1() - tdist);
				g_jtext(JUST_TC);
				break;
			case GLE_AXIS_Y:
			case GLE_AXIS_Y0:
				g_move(measure.getX1() - tdist,oy + ax->length/2);
				g_rotate(90.0);
				g_jtext(JUST_BC);
				break;
			case GLE_AXIS_X2:
			case GLE_AXIS_T:
				g_move(ox+ax->length/2, measure.getY2() + tdist);
				g_jtext(JUST_BC);
				break;
			case GLE_AXIS_Y2:
				g_move(measure.getX2() + tdist,oy + ax->length/2);
				if (ax->title_rot) {
					g_rotate(-90.0);
					g_jtext(JUST_BC);
				} else {
					g_rotate(90.0);
					g_jtext(JUST_TC);
				}
				break;
		}
	}
	g_grestore();
	g_update_bounds_box(box);
}

void nice_ticks(double *dticks, double *gmin, double *gmax, double *t1, double *tn, int minset, int maxset) {
	double delta,st,expnt,n;
	int ni;
	delta = *gmax-*gmin;
	if (delta == 0) {
		gprint("Axis range error min=%g max=%g \n",*gmin,*gmax);
		*gmax = *gmin+10;
		delta = 10;
	}
	st = delta/10;
	expnt = floor(log10(st));
	n = st/pow(10.0,expnt);
	if (n>5)
		ni = 10;
	else if (n>2)
		ni = 5;
	else if (n>1)
		ni = 2;
	else
		ni = 1;
	if (*dticks==0) *dticks = ni * pow(10.0,expnt);
	if (*gmin - (delta/1000) <=  floor( *gmin/ *dticks) * *dticks)
		*t1 = *gmin;
	else
		*t1 = (floor(*gmin/ *dticks) * *dticks ) + *dticks;

	*tn = *gmax;
	if (  (floor(.000001+ *gmax / *dticks) * *dticks) <
	  (*gmax - (delta/1000) ) )
		*tn = floor(.00001 + *gmax/ *dticks ) * *dticks;
}

double chop(double f) {
	return (double) (int) f;
}

void start_subtick(double *tick1, double gmin, double dticks) {
	if (gmin == chop(gmin/dticks) * dticks)
		*tick1 = gmin;
	else
		*tick1 = chop(gmin/dticks) * dticks + dticks;
}

void numtrime(char *o,char *s) {
	char *nonzero;
	char *e,*f;

	strcpy(o,s);

	e = strchr(s,'e');
	if (e==NULL) return;

	e--;
	for (; *e=='0'; e--) ;

	f = strchr(s,'e');
	strcpy(e+1,f);
	strcpy(o,s);
}

void numtrim(char **d,char *s,double dticks) {
	char *o,*nonzero=0;

	if (*d==0)  *d = (char*) myallocz(20);
	o = *d;
	nonzero = 0;
	if (strchr(s,'e')!=NULL) {
		numtrime(o,s);
		return;
	}
	while (*s==' ' && *s!=0) s++;
	while (*s!=0) {
		*(o++) = *(s++);
		if (*s=='.') {
			nonzero = o-1;
			if (dticks!=floor(dticks)) nonzero = o+1;
			while (*s!=0) {
				*(o++) = *(s++);
				if ((*s!='0') && (*s!=0))
					if (o>nonzero) nonzero = o;
			}
		}
	}
	*(o++) = 0;
	if (nonzero!=NULL) *(nonzero+1) = 0;
}

void nice_log_ticks(double *start, double *last, double *gmin, double *gmax) {
	double sz;

	if (*gmin<=0) {
		gprint("FATAL ERROR, LOG AXIS WITH MIN OF ZERO***\n");
		*gmin = 1;
	}
	if (*gmax<=0) *gmax = 10;
	*start = pow(10.0,floor(log10(*gmin)));

	if (floor(log10(*gmin)) != log10(*gmin)) {
		sz = pow(10.0,floor(log10(*gmin)));
		*start = floor((*gmin)/sz)*sz + sz;
		if (*start>(*gmin+sz-sz/100)) *start = *start - sz;
	}
	*last = floor(log10(*gmax))+1;
	if (floor(log10(*gmax))==log10(*gmax)) {
		--*last;
		*last = pow(10.0,*last);
	} else {
		*last = pow(10.0,*last-1);
		*last = floor((*gmax) / *last) * *last;
	}
}

double fnloglen(double v,axis_struct *ax) {
	if (ax->negate) {
		v = ax->max - (v- ax->min);
	}
	return ((v-log10(ax->min))/(log10(ax->max)-log10(ax->min))) * ax->length;
}

double fnlogx(double v,axis_struct *ax) {
	if (ax->negate) {
		v = ax->max - (v- ax->min);
	}
	return fnloglen(log10(v),ax);
}

int fnbig(double v) {
	if (fabs(log10(v)-floor(log10(v)+.5)) < .001) return true;
	else return false;
}

void print_axis(axis_struct *ax) {
	cout << "Axis ticks off: " << ax->ticks_off << "\tAxis ticks length: "
	     << ax->ticks_length << "\tAxis ticks color: " << ax->ticks_color << endl;
	cout << "Axis subticks off: " << ax->subticks_off << "\tAxis subticks length: "
	     << ax->subticks_length << "\tAxis subticks color: "  << ax->subticks_color << endl;
}

bool axis_is_max(int axis) {
	return axis == GLE_AXIS_X2 || axis == GLE_AXIS_Y2;
}

bool axis_ticks_neg(int axis) {
	return axis == GLE_AXIS_X2 || axis == GLE_AXIS_Y2;
}

bool axis_horizontal(int axis) {
	return axis == GLE_AXIS_X0 || axis == GLE_AXIS_X || axis == GLE_AXIS_X2 || axis == GLE_AXIS_T;
}

int axis_get_orth(int axis, int which) {
	if (axis_horizontal(axis)) {
		switch (which) {
			case 0:  return GLE_AXIS_Y0;
			case 1:  return GLE_AXIS_Y;
			default: return GLE_AXIS_Y2;
		}
	} else {
		switch (which) {
			case 0:  return GLE_AXIS_X0;
			case 1:  return GLE_AXIS_X;
			default: return GLE_AXIS_X2;
		}
	}
}

int axis_type(char *s) {
	if (str_ni_equals(s,"X0",2)) return GLE_AXIS_X0;
	if (str_ni_equals(s,"Y0",2)) return GLE_AXIS_Y0;
	if (str_ni_equals(s,"X2",2)) return GLE_AXIS_X2;
	if (str_ni_equals(s,"Y2",2)) return GLE_AXIS_Y2;
	if (str_ni_equals(s,"X",1))  return GLE_AXIS_X;
	if (str_ni_equals(s,"Y",1))  return GLE_AXIS_Y;
	gprint("axis type did not match {%s} assuming xaxis \n",s);
	return 1;
}

axis_struct::axis_struct() : format() {
	init(0);
}

axis_struct::~axis_struct() {
}

void axis_struct::init(int i) {
	int c;
	format = ""; title = "";
	names.clear(); places.clear();
	base = 0.0; length = 0.0; shift = 0.0;
	label_font = 0; label_hei = 0.0; label_scale = 0.0; label_dist = 0.0;
	log = 0; min = 0.0; max = 0.0; minset = 0; maxset = 0; nofirst = 0; nolast = 0;
	nticks = 0; nsubticks = 0; dticks = 0.0; dsubticks = 0.0;
	ticks_length = 0.0; ticks_scale = 0.0; ticks_lstyle[0] = 0;
	subticks_length = 0.0; subticks_scale = 0.0; subticks_lstyle[0] = 0;
	label_lstyle[0] = 0;
	off = 0;
	label_off = (i != GLE_AXIS_X && i != GLE_AXIS_Y);
	side_off = 0; ticks_off = 0; subticks_off = 0;
	side_lstyle[0] = 0;
	title_font = 0; title_dist = 0.0; title_hei = 0.0; title_scale = 0.0;
	title_rot = 0; title_off = 0; title_color = 0;
	negate = 0;
	names_ds = -1;
	label_angle = 0.0;
	g_get_color(&c);
	color = c; side_color = c; ticks_color = c;
	label_color = c; subticks_color = c;
	side_lwidth = -1; ticks_lwidth = -1; subticks_lwidth = -1; label_lwidth = -1;
	lgset = GLE_AXIS_LOG_DEFAULT;
	has_ftick = false; ftick = 0.0;
	has_offset = false; offset = 0.0;
	ticks_both = false;
	type = i;
}

string* axis_struct::getNamePtr(int i) {
	while (names.size() <= i) names.push_back(string());
	return &names[i];
}

void axis_struct::setName(int i, const char* name) {
	while (names.size() <= i) names.push_back(string());
	names[i] = name;
}

void axis_struct::setPlace(int i, double place) {
	while (places.size() <= i) places.push_back(0.0);
	places[i] = place;
}

void axis_struct::insertNoTick(double pos, vector<double>& vec) {
	int at = 0;
	while (at < vec.size() && vec[at] < pos) {
		at++;
	}
	if (at == vec.size()) vec.push_back(pos);
	else vec.insert(vec.begin()+at, pos);
}

bool axis_struct::isNoPlaceLogOrReg(double pos, int* place_cnt, double delta) {
	if (log) return axis_is_pos_perc(pos, place_cnt, 0.001, noplaces);
	else return axis_is_pos(pos, place_cnt, delta, noplaces);
}

void axis_struct::addNoTick(double pos) {
	addNoTick1(pos);
	addNoTick2(pos);
}

void axis_struct::insertNoTick(double pos) {
	insertNoTick1(pos);
	insertNoTick2(pos);
}

void axis_struct::insertNoTickOrLabel(double pos) {
	insertNoTick1(pos);
	insertNoTick2(pos);
	insertNoPlace(pos);
}

void axis_struct::clearNoTicks() {
	noticks1.clear();
	noticks2.clear();
}

void axis_struct::printNoTicks() {
	cout << "Noticks1:";
	for (int i = 0; i < noticks1.size(); i++) {
		cout << " " << noticks1[i];
	}
	cout << endl;
	cout << "Noticks2:";
	for (int i = 0; i < noticks2.size(); i++) {
		cout << " " << noticks2[i];
	}
	cout << endl;
	cout << "NoPlaces:";
	for (int i = 0; i < noplaces.size(); i++) {
		cout << " " << noplaces[i];
	}
	cout << endl;
}

int axis_struct::getNbNamedPlaces() {
	int nb = getNbNames();
	if (getNbPlaces() < nb) nb = getNbPlaces();
	return nb;
}

void axis_struct::getLabelsFromDataSet(int ds) {
	int crpos = 0;
	int npnts = dp[ds]->np;
	double* xt = dp[ds]->xv;
	vector<string>* yv_str = dp[ds]->yv_str;
	if (yv_str == NULL) return;
	for (int i = 0; i < getNbPlaces(); i++) {
		double fi = places[i];
		// find last position with x-value smaller than fi
		while (crpos < npnts && xt[crpos] < fi) crpos++;
		if (crpos < npnts) {
			crpos--;
			int sel = crpos;
			double dist = fabs(xt[crpos] - fi);
			if (crpos+1 < npnts) {
				if (fabs(xt[crpos+1] - fi) < dist) sel = crpos+1;
			}
			if (crpos-1 >= 0) {
				if (fabs(xt[crpos-1] - fi) < dist) sel = crpos-1;
			}
			if (sel >= 0 && sel < yv_str->size()) *getNamePtr(i) = (*yv_str)[sel];
		}
	}
}
