/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.GAufnahmeIF;
import de.m740.projectx.gigaset.GAufnahmeLocal;
import de.m740.projectx.gigaset.GConsole;
import de.m740.projectx.gigaset.GDialog;
import de.m740.projectx.gigaset.GPanelAbstract;
import de.m740.projectx.gigaset.GStrings;
import de.m740.projectx.gigaset.GTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Settings;

public class GPanelLocal
extends GPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_AUFNAHME_VERZEICHNIS = "gigaset.record.dir";
    private static final String FN_AUFNAHME_VERZEICHNIS = "gigaset-aufnahme-verzeichnis.txt";
    private static final String T = "" + File.separatorChar;
    private File flAufnahmeOrdner = new File(System.getProperty("user.dir"));
    private JButton btnAufnahmeOrdner = new JButton();
    private JButton btnRefresh = new JButton(GStrings.getString("gdialog.refresh"));
    private JFileChooser fcAufnahmeOrdner = new JFileChooser(this.flAufnahmeOrdner);
    private FileComparator aFileComparator = null;

    public GPanelLocal(GDialog inpDialog) {
        this.setDialog(inpDialog);
        this.buildPanel();
    }

    protected void buildPanel() {
        this.setLayout(new BorderLayout());
        this.fcAufnahmeOrdner.setFileSelectionMode(1);
        this.flAufnahmeOrdner = this.readAufnahmeordner();
        String tmpString = String.valueOf(this.flAufnahmeOrdner);
        this.btnAufnahmeOrdner.setText(this.shortPathOf(tmpString));
        this.btnAufnahmeOrdner.setToolTipText(tmpString);
        JPanel tmpPanelTop = new JPanel(new GridLayout(1, 2));
        tmpPanelTop.add(this.btnAufnahmeOrdner);
        tmpPanelTop.add(this.btnRefresh);
        this.add((Component)tmpPanelTop, "North");
        this.add((Component)this.spAufnahmen, "Center");
        ListSelectionModel tmpSelectionModel = this.aTableAufnahmen.getSelectionModel();
        tmpSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GPanelLocal.this.doEnabled();
                }
            }
        });
        this.aTableAufnahmen.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                GPanelLocal.this.mouseClick(event);
            }
        });
        this.btnAufnahmeOrdner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPanelLocal.this.getFcAufnahmeOrdner().setCurrentDirectory(GPanelLocal.this.getFlAufnahmeOrdner());
                if (GPanelLocal.this.getFcAufnahmeOrdner().showOpenDialog(null) == 0) {
                    GPanelLocal.this.getDialog().zeigeInfos(-1);
                    GPanelLocal.this.setFlAufnahmeOrdner(GPanelLocal.this.getFcAufnahmeOrdner().getSelectedFile());
                    String tmpPathname = String.valueOf(GPanelLocal.this.getFlAufnahmeOrdner());
                    GPanelLocal.this.getBtnAufnahmeOrdner().setText(GPanelLocal.this.shortPathOf(tmpPathname));
                    GPanelLocal.this.getBtnAufnahmeOrdner().setToolTipText(tmpPathname);
                    try {
                        RandomAccessFile konfDatei = new RandomAccessFile(GPanelLocal.FN_AUFNAHME_VERZEICHNIS, "rw");
                        konfDatei.setLength(0L);
                        konfDatei.writeBytes(GPanelLocal.this.getFlAufnahmeOrdner().toString());
                        konfDatei.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    GPanelLocal.this.sucheAufnahmen();
                }
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPanelLocal.this.sucheAufnahmen();
            }
        });
    }

    private File readAufnahmeordner() {
        File tmpFile = null;
        try {
            Settings tmpSettings = Common.getSettings();
            String tmpProp = PROPERTY_AUFNAHME_VERZEICHNIS;
            String tmpFN = tmpSettings.getProperty(tmpProp);
            if (tmpFN == null) {
                RandomAccessFile konfDatei = new RandomAccessFile(FN_AUFNAHME_VERZEICHNIS, "r");
                tmpFN = konfDatei.readLine();
                konfDatei.close();
            }
            if (!(tmpFile = new File(tmpFN)).exists()) {
                tmpFile = new File(System.getProperty("user.dir"));
            }
            tmpFN = String.valueOf(tmpFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tmpFile;
    }

    private void sucheAufnahmen2(File inpAufnahmeOrdner) {
        this.clearSelection();
        this.aTableModel.clear();
        this.aTableModel.fireTableDataChanged();
        this.fireStateChanged();
        if (inpAufnahmeOrdner != null && inpAufnahmeOrdner.isDirectory()) {
            int anz;
            String[] cridDateien = inpAufnahmeOrdner.list(new FilenameFilter(){

                public boolean accept(File f, String s) {
                    return s.toLowerCase().endsWith(".crid");
                }
            });
            int n = anz = cridDateien == null ? 0 : cridDateien.length;
            if (anz > 1) {
                Arrays.sort(cridDateien, this.getFileComparator());
                this.setSortSelector(0);
            }
            this.aAufnahmen = new ArrayList(anz);
            HashMap tmpHash = new HashMap(anz);
            int i = 0;
            while (i < anz) {
                try {
                    String tmpFN = cridDateien[i];
                    GAufnahmeLocal tmpAufnahme = new GAufnahmeLocal(inpAufnahmeOrdner + T + tmpFN);
                    if (tmpAufnahme.isValid()) {
                        this.aAufnahmen.add(tmpAufnahme);
                        this.addAufnahme(i, tmpAufnahme, tmpHash);
                    } else {
                        GConsole.setMessage("Invalid file " + tmpFN + " skipped!");
                    }
                }
                catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
                ++i;
            }
            this.countChildren(3);
            this.aTableModel.fireTableRowsUpdated(0, this.aTableModel.getRowCount() - 1);
            tmpHash = null;
            if (this.aTableModel.getRowCount() == 0) {
                this.getDialog().zeigeInfos(-1);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sucheAufnahmen1(File inpAufnahmeOrdner) {
        try {
            try {
                this.sucheAufnahmen2(inpAufnahmeOrdner);
            }
            catch (Exception e) {
                GConsole.setErrorMessage(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.btnAufnahmeOrdner.setEnabled(true);
            this.btnRefresh.setEnabled(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.btnAufnahmeOrdner.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    public List getSelectedRecording() {
        try {
            GAufnahmeIF tmpAufnahme = this.getSelectedAufnahme();
            GConsole.setMessage("Get selected recording: " + tmpAufnahme.getTitel());
            return tmpAufnahme.getMpgFiles();
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
            return null;
        }
    }

    public void sucheAufnahmen() {
        Runnable tmpRunnable = new Runnable(){

            public void run() {
                try {
                    GPanelLocal.this.sucheAufnahmen1(GPanelLocal.this.getFlAufnahmeOrdner());
                }
                catch (Exception exc) {
                    GConsole.setErrorMessage(exc);
                }
            }
        };
        try {
            this.btnAufnahmeOrdner.setEnabled(false);
            this.btnRefresh.setEnabled(false);
            GConsole.clear();
            if (EventQueue.isDispatchThread()) {
                new Thread(tmpRunnable).start();
            } else {
                EventQueue.invokeLater(tmpRunnable);
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    protected GTable getTableAufnahmen() {
        return this.aTableAufnahmen;
    }

    protected JFileChooser getFcAufnahmeOrdner() {
        return this.fcAufnahmeOrdner;
    }

    protected JButton getBtnAufnahmeOrdner() {
        return this.btnAufnahmeOrdner;
    }

    public File getFlAufnahmeOrdner() {
        return this.flAufnahmeOrdner;
    }

    protected void setFlAufnahmeOrdner(File inpFlAufnahmeOrdner) {
        this.flAufnahmeOrdner = inpFlAufnahmeOrdner;
    }

    public void deleteSelectedAufnahme() {
        try {
            GAufnahmeIF tmpAufnahme = this.getSelectedAufnahme();
            if (tmpAufnahme == null) {
                return;
            }
            File tmpCridFile = new File(tmpAufnahme.getCridFilename());
            String tmpWarning = "<html>" + tmpAufnahme.getTitel() + "<hr>" + GStrings.getString("gdialog.delete.text") + " " + this.flAufnahmeOrdner + " :<br>" + tmpCridFile.getName() + "<br>";
            if (tmpAufnahme.istGesperrt()) {
                tmpWarning = String.valueOf(tmpWarning) + "<hr> " + GStrings.getString("gdialog.delete.locked") + " <hr>";
            }
            tmpWarning = String.valueOf(tmpWarning) + "</html>";
            Toolkit.getDefaultToolkit().beep();
            if (JOptionPane.showConfirmDialog(null, tmpWarning, GStrings.getString("gdialog.delete"), 2) == 0) {
                boolean ok = tmpCridFile.delete();
                this.aAufnahmen.remove(tmpAufnahme);
                GConsole.setInfo(String.valueOf(tmpCridFile.getName()) + (ok ? " " : " NOT ") + "deleted");
                this.sortiereAufnahmen(this.getSortSelector());
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public void doEnabled() {
        GDialog tmpDialog = this.getDialog();
        int index = this.getTableAufnahmen().getSelectedRow();
        boolean enable = index >= 0;
        tmpDialog.btnPrintEPG.setEnabled(enable);
        tmpDialog.aItemPlayMPC.setEnabled(enable);
        tmpDialog.aItemLoeschen.setEnabled(enable);
        tmpDialog.aItemReread.setEnabled(enable);
        tmpDialog.btnAuswaehlen.setEnabled(enable);
        tmpDialog.aItemAuswaehlen.setEnabled(enable);
        tmpDialog.btnHinzufuegen.setEnabled(enable);
        tmpDialog.aItemHinzufuegen.setEnabled(enable);
        tmpDialog.zeigeInfos(index);
    }

    public List getUsedRecDirectories() {
        ArrayList<File> tmpList = null;
        int anza = this.aAufnahmen == null ? 0 : this.aAufnahmen.size();
        int i = 0;
        while (i < anza) {
            GAufnahmeIF tmpAufnahmeIF = (GAufnahmeIF)this.aAufnahmen.get(i);
            if (tmpAufnahmeIF instanceof GAufnahmeLocal) {
                GAufnahmeLocal tmpAufnahme = (GAufnahmeLocal)tmpAufnahmeIF;
                File[] tmpFiles = tmpAufnahme.getFmpgDirectories();
                int anzf = tmpFiles == null ? 0 : tmpFiles.length;
                int j = 0;
                while (j < anzf) {
                    File tmpFile = tmpFiles[j];
                    if (tmpFile != null) {
                        if (tmpList == null) {
                            tmpList = new ArrayList<File>();
                        }
                        tmpList.add(tmpFile);
                        GConsole.setMessage("Used dir: " + tmpFile.getAbsolutePath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tmpList;
    }

    public Object getLostDirectories(List inpList) {
        String tmpRecVerzeichnis;
        int anzd;
        List inpUsedDirList;
        File tmpRecDir;
        block12: {
            block11: {
                block10: {
                    tmpRecDir = null;
                    GConsole.setMessage("*** Start searching lost directories ***");
                    inpUsedDirList = this.getUsedRecDirectories();
                    if (inpUsedDirList != null) break block10;
                    return null;
                }
                anzd = inpUsedDirList == null ? 0 : inpUsedDirList.size();
                tmpRecDir = this.getFlAufnahmeOrdner();
                if (tmpRecDir != null) break block11;
                return null;
            }
            tmpRecVerzeichnis = tmpRecDir.getAbsolutePath();
            if (!tmpRecVerzeichnis.endsWith(File.separator)) {
                tmpRecVerzeichnis = String.valueOf(tmpRecVerzeichnis) + File.separator;
            }
            if ((tmpRecDir = new File(tmpRecVerzeichnis = String.valueOf(tmpRecVerzeichnis) + ".rec" + File.separator)).exists()) break block12;
            GConsole.setMessage("No directory " + tmpRecVerzeichnis + " found!");
            return null;
        }
        try {
            String[] tmpDirs = tmpRecDir.list(new FilenameFilter(){

                public boolean accept(File f, String s) {
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return s.toLowerCase().endsWith(".fmpg");
                }
            });
            ArrayList<File> tmpList = null;
            anzd = tmpDirs == null ? 0 : tmpDirs.length;
            GConsole.setMessage(String.valueOf(anzd) + " fmpg-files found in .rec-dir");
            int i = 0;
            while (i < anzd) {
                String tmpFN = String.valueOf(tmpRecVerzeichnis) + tmpDirs[i];
                File tmpFile = new File(tmpFN);
                if (tmpList == null) {
                    tmpList = new ArrayList<File>();
                }
                tmpList.add(tmpFile);
                GConsole.setInfo(tmpFN);
                ++i;
            }
            inpList.clear();
            i = 0;
            while (i < anzd) {
                File tmpFile = (File)tmpList.get(i);
                if (!inpUsedDirList.contains(tmpFile)) {
                    inpList.add(tmpFile);
                    GConsole.setMessage("Lost dir: " + tmpFile.getAbsolutePath());
                }
                ++i;
            }
            anzd = inpList == null ? 0 : inpList.size();
            GConsole.setMessage(String.valueOf(anzd) + " lost directories found");
            GConsole.setMessage("*** End of searching lost directories ***");
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpRecDir;
    }

    private FileComparator getFileComparator() {
        if (this.aFileComparator == null) {
            this.aFileComparator = new FileComparator();
        }
        return this.aFileComparator;
    }

    class FileComparator
    implements Comparator {
        FileComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            try {
                String tmpFN0 = (String)arg0;
                String tmpFN1 = (String)arg1;
                return -tmpFN0.compareTo(tmpFN1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

