/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.DvbString;
import de.m740.projectx.gigaset.GAufnahmeAbstract;
import de.m740.projectx.gigaset.GConsole;
import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class GAufnahmeLocal
extends GAufnahmeAbstract {
    private RandomAccessFile cridFile;
    private File aCridDirectory;
    private File[][] flMpgDateien;
    private File[] aFmpgDirectories;

    GAufnahmeLocal(String inpCridFilename) {
        this.cridFilename = inpCridFilename;
        try {
            this.readAufnahme();
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    private String readSender(RandomAccessFile inpCridFile) {
        String tmpName = this.getSender();
        try {
            if (inpCridFile.getFilePointer() >= inpCridFile.length()) {
                return tmpName;
            }
            inpCridFile.skipBytes(14);
            int len = inpCridFile.readShort();
            if (len > 0) {
                if (len > 25) {
                    len = 25;
                }
                byte[] tmpBs = new byte[len];
                inpCridFile.read(tmpBs, 0, tmpBs.length);
                tmpName = new String(tmpBs);
                tmpName = tmpName.trim();
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpName;
    }

    public void readAufnahme() {
        try {
            GConsole.setInfo(this.cridFilename);
            this.setAnzahlFMPGsErwartet(0);
            this.setAnzahlFMPGsVorhanden(0);
            this.setAnzahlMPGsErwartet(0);
            this.setAnzahlMPGsVorhanden(0);
            this.anzahlByte = 0L;
            this.cridFile = new RandomAccessFile(this.cridFilename, "r");
            this.cridFile.skipBytes(12);
            this.status = this.cridFile.readInt();
            this.startZeitInSek = this.cridFile.readInt();
            this.endeZeitInSek = this.cridFile.readInt();
            this.cridFile.skipBytes(16);
            this.aSerienID = this.cridFile.readInt();
            this.gesperrt = this.cridFile.readShort();
            byte[] b = new byte[this.cridFile.readInt()];
            this.cridFile.read(b, 0, b.length);
            this.titel = new String(b);
            this.titel = new DvbString(this.titel).getDisplayString();
            int z = this.cridFile.readInt();
            this.setAnzahlFMPGsErwartet(z);
            this.dateiNamenBasen = new String[z];
            int i = 0;
            while (i < z) {
                b = new byte[this.cridFile.readInt()];
                this.cridFile.read(b, 0, b.length);
                this.dateiNamenBasen[i] = new String(b);
                this.aufnahmeBeginnInSek = this.cridFile.readInt();
                this.cridFile.skipBytes(16);
                ++i;
            }
            b = new byte[this.cridFile.readInt()];
            this.cridFile.read(b, 0, b.length);
            this.info = new String(b);
            this.info = new DvbString(this.info).getDisplayString();
            b = new byte[this.cridFile.readInt()];
            this.cridFile.read(b, 0, b.length);
            this.inhalt = new String(b);
            this.inhalt = new DvbString(this.inhalt).getDisplayString();
            this.gesehenBisInSek = this.cridFile.readInt();
            this.setSender(this.readSender(this.cridFile));
            this.cridFile.close();
            String tmpAufnahmeverzeichnis = new File(this.cridFilename).getParent();
            File tmpDirectory = new File(tmpAufnahmeverzeichnis);
            this.setCridDirectory(tmpDirectory);
            int anzb = this.dateiNamenBasen == null ? 0 : this.dateiNamenBasen.length;
            this.flMpgDateien = new File[anzb][];
            this.aFmpgDirectories = new File[anzb];
            this.setAnzahlFMPGsVorhanden(0);
            this.setAnzahlMPGsErwartet(0);
            this.setAnzahlMPGsVorhanden(0);
            int x = 0;
            while (x < anzb) {
                String tmpRecordVerzeichnis = tmpAufnahmeverzeichnis;
                String dateiNamenBasis = this.dateiNamenBasen[x];
                File tmpFile = new File(tmpRecordVerzeichnis, dateiNamenBasis);
                if (!tmpFile.exists()) {
                    if (!tmpRecordVerzeichnis.endsWith(File.separator)) {
                        tmpRecordVerzeichnis = String.valueOf(tmpRecordVerzeichnis) + File.separator;
                    }
                    tmpRecordVerzeichnis = String.valueOf(tmpRecordVerzeichnis) + ".rec" + File.separator;
                    tmpRecordVerzeichnis = String.valueOf(tmpRecordVerzeichnis) + dateiNamenBasis;
                    tmpDirectory = new File(tmpRecordVerzeichnis);
                }
                this.setFmpgDirectory(x, tmpDirectory);
                final List tmpList = this.readFmpgDateien(tmpDirectory, dateiNamenBasis);
                this.aAnzahlMPGsErwartet += tmpList == null ? 0 : tmpList.size();
                this.flMpgDateien[x] = tmpDirectory.listFiles(new FilenameFilter(){

                    public boolean accept(File f, String s) {
                        return tmpList == null ? false : tmpList.contains(s);
                    }
                });
                int anz = this.flMpgDateien[x] == null ? 0 : this.flMpgDateien[x].length;
                this.aAnzahlMPGsVorhanden += anz;
                if (anz > 1) {
                    Arrays.sort(this.flMpgDateien[x]);
                }
                int i2 = 0;
                while (i2 < anz) {
                    this.anzahlByte += this.flMpgDateien[x][i2].length();
                    ++i2;
                }
                ++x;
            }
            this.setValid(true);
        }
        catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    private List readFmpgDatei(File inpFile) {
        ArrayList<String> tmpList = null;
        try {
            GConsole.setInfo(inpFile.toString());
            RandomAccessFile tmpRAF = new RandomAccessFile(inpFile, "r");
            long tmpSize = inpFile.length();
            long anz = tmpSize / 256L;
            int i = 0;
            while ((long)i < anz) {
                tmpRAF.skipBytes(16);
                byte[] tmpBs = new byte[112];
                tmpRAF.read(tmpBs);
                String tmpFN = null;
                int x = 0;
                while (x < tmpBs.length) {
                    if (tmpBs[x] == 0) {
                        int len;
                        String tmpStr = new String(tmpBs, 0, x);
                        String[] tmpStrs = tmpStr.split("/");
                        int n = len = tmpStrs == null ? 0 : tmpStrs.length;
                        if (len > 0) {
                            tmpFN = tmpStrs[len - 1];
                            break;
                        }
                        tmpFN = tmpStr;
                        break;
                    }
                    ++x;
                }
                if (tmpFN != null) {
                    if (tmpList == null) {
                        tmpList = new ArrayList<String>();
                    }
                    tmpList.add(tmpFN);
                }
                tmpRAF.skipBytes(128);
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private List readFmpgDateien(File inpDir, final String inpDateinamenbasis) {
        List tmpList = null;
        try {
            File[] tmpFiles = inpDir.listFiles(new FilenameFilter(){

                public boolean accept(File f, String s) {
                    return s.toLowerCase().equals(inpDateinamenbasis.toLowerCase());
                }
            });
            int anzf = tmpFiles == null ? 0 : tmpFiles.length;
            this.aAnzahlFMPGsVorhanden += anzf;
            int i = 0;
            while (i < anzf) {
                List tmpList2 = this.readFmpgDatei(tmpFiles[i]);
                if (tmpList2 != null) {
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private Object[][] getFlMpgDateien() {
        return this.flMpgDateien;
    }

    public List getMpgFiles() {
        ArrayList<XInputFile> tmpList = null;
        try {
            String[] tmpDateinamenBasen = this.getDateinamenBasen();
            int anzb = tmpDateinamenBasen == null ? 0 : tmpDateinamenBasen.length;
            int b = 0;
            while (b < anzb) {
                File[] tmpFlMpgDateien = (File[])this.getFlMpgDateien()[b];
                int anzf = tmpFlMpgDateien == null ? 0 : tmpFlMpgDateien.length;
                int i = 0;
                while (i < anzf) {
                    File tmpFile = tmpFlMpgDateien[i];
                    XInputFile tmpXFile = new XInputFile((Object)tmpFile);
                    if (tmpList == null) {
                        tmpList = new ArrayList<XInputFile>();
                    }
                    tmpList.add(tmpXFile);
                    ++i;
                }
                ++b;
            }
            return tmpList;
        }
        catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
            return tmpList;
        }
    }

    protected File getCridDirectory() {
        return this.aCridDirectory;
    }

    protected void setCridDirectory(File inpCridDirectory) {
        this.aCridDirectory = inpCridDirectory;
    }

    public File[] getFmpgDirectories() {
        return this.aFmpgDirectories;
    }

    protected void setFmpgDirectory(int inpIndex, File inpFmpgDirectory) {
        if (this.aFmpgDirectories != null && inpIndex >= 0 && inpIndex < this.aFmpgDirectories.length) {
            this.aFmpgDirectories[inpIndex] = inpFmpgDirectory;
        }
    }
}

