/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.DvbString;
import de.m740.projectx.gigaset.GAufnahmeAbstract;
import de.m740.projectx.gigaset.GConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

public class GAufnahmeFTP
extends GAufnahmeAbstract {
    private XInputFile aCridFile = null;
    private XInputDirectory aCridDirectory = null;
    private List aMpgFiles = null;

    GAufnahmeFTP(XInputFile inpCridFile, XInputDirectory inpCridDirectory) {
        this.setCridDirectory(inpCridDirectory);
        this.setCridFile(inpCridFile);
        this.cridFilename = inpCridFile.getName();
        try {
            this.readAufnahme();
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        this.anzahlByte = -1L;
    }

    private String readSender(XInputFile inpCridFile) {
        String tmpName = this.getSender();
        try {
            int len = inpCridFile.randomAccessRead(new byte[14]);
            if (len < 0) {
                return tmpName;
            }
            len = this.readUShort(inpCridFile);
            if (len > 0) {
                byte[] tmpBs;
                if (len > 25) {
                    len = 25;
                }
                if ((len = inpCridFile.randomAccessRead(tmpBs = new byte[len], 0, tmpBs.length)) >= 0) {
                    tmpName = new String(tmpBs);
                    tmpName = tmpName.trim();
                }
            }
        }
        catch (Exception e) {
            String tmpString = e.toString();
            GConsole.setInfo(tmpString);
        }
        return tmpName;
    }

    public void readAufnahme() {
        try {
            XInputFile tmpCridFile = this.getCridFile();
            GConsole.setInfo(tmpCridFile.toString());
            this.setAnzahlFMPGsErwartet(-1);
            this.setAnzahlFMPGsVorhanden(-1);
            this.setAnzahlMPGsErwartet(-1);
            this.setAnzahlMPGsVorhanden(-1);
            this.anzahlByte = -1L;
            this.aMpgFiles = null;
            tmpCridFile.randomAccessOpen("r");
            tmpCridFile.randomAccessSeek(0L);
            tmpCridFile.randomAccessRead(new byte[12]);
            this.status = this.readUInt(tmpCridFile);
            this.startZeitInSek = this.readUInt(tmpCridFile);
            this.endeZeitInSek = this.readUInt(tmpCridFile);
            tmpCridFile.randomAccessRead(new byte[16]);
            this.aSerienID = this.readUInt(tmpCridFile);
            this.gesperrt = this.readUShort(tmpCridFile);
            byte[] b = new byte[this.readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            this.titel = new String(b);
            this.titel = new DvbString(this.titel).getDisplayString();
            int z = this.readUInt(tmpCridFile);
            this.dateiNamenBasen = new String[z];
            this.setAnzahlFMPGsErwartet(z);
            int i = 0;
            while (i < z) {
                b = new byte[this.readUInt(tmpCridFile)];
                tmpCridFile.randomAccessRead(b, 0, b.length);
                this.dateiNamenBasen[i] = new String(b);
                this.aufnahmeBeginnInSek = this.readUInt(tmpCridFile);
                tmpCridFile.randomAccessRead(new byte[16]);
                ++i;
            }
            b = new byte[this.readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            this.info = new String(b);
            this.info = new DvbString(this.info).getDisplayString();
            b = new byte[this.readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            this.inhalt = new String(b);
            this.inhalt = new DvbString(this.inhalt).getDisplayString();
            this.gesehenBisInSek = this.readUInt(tmpCridFile);
            this.setSender(this.readSender(tmpCridFile));
            this.setValid(true);
            tmpCridFile.randomAccessClose();
        }
        catch (IOException e) {
            GConsole.setErrorMessage(e);
        }
        this.anzahlByte = -1L;
    }

    private int readUInt(XInputFile inpXFile) throws IOException {
        int ch1 = 0xFF & inpXFile.randomAccessRead();
        int ch2 = 0xFF & inpXFile.randomAccessRead();
        int ch3 = 0xFF & inpXFile.randomAccessRead();
        int ch4 = 0xFF & inpXFile.randomAccessRead();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private short readUShort(XInputFile inpXFile) throws IOException {
        int ch1 = 0xFF & inpXFile.randomAccessRead();
        int ch2 = 0xFF & inpXFile.randomAccessRead();
        return (short)((ch1 << 8) + ch2);
    }

    protected XInputDirectory getCridDirectory() {
        return this.aCridDirectory;
    }

    protected void setCridDirectory(XInputDirectory inpInputDirectory) {
        this.aCridDirectory = inpInputDirectory;
    }

    private XInputDirectory makeRecDirectory(String inpDateinamenbasis) {
        try {
            String tmpPort;
            XInputDirectory tmpXDirectory = this.getCridDirectory();
            String tmpAufnahmeverzeichnis = tmpXDirectory.getDirectory();
            String tmpServer = tmpXDirectory.getServer();
            String tmpUser = tmpXDirectory.getUser();
            String tmpPassword = tmpXDirectory.getPassword();
            String tmpDirectory = tmpAufnahmeverzeichnis;
            if (!tmpDirectory.endsWith("/")) {
                tmpDirectory = String.valueOf(tmpDirectory) + "/";
            }
            tmpDirectory = String.valueOf(tmpDirectory) + ".rec/";
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword, tmpDirectory = String.valueOf(tmpDirectory) + inpDateinamenbasis, tmpPort = tmpXDirectory.getPort(), null);
            XInputDirectory tmpIDirectory = new XInputDirectory((Object)tmpVO);
            if (tmpIDirectory.test()) {
                return tmpIDirectory;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    private List readFmpgDatei(XInputFile inpFile) {
        ArrayList<String> tmpList = null;
        try {
            GConsole.setInfo(inpFile.toString());
            long tmpSize = inpFile.length();
            long anz = tmpSize / 256L;
            inpFile.randomAccessOpen("r");
            inpFile.randomAccessSeek(0L);
            int i = 0;
            while ((long)i < anz) {
                inpFile.randomAccessRead(new byte[16]);
                byte[] tmpBs = new byte[112];
                inpFile.randomAccessRead(tmpBs);
                String tmpFN = null;
                int x = 0;
                while (x < tmpBs.length) {
                    if (tmpBs[x] == 0) {
                        int len;
                        String tmpStr = new String(tmpBs, 0, x);
                        String[] tmpStrs = tmpStr.split("/");
                        int n = len = tmpStrs == null ? 0 : tmpStrs.length;
                        if (len > 0) {
                            tmpFN = tmpStrs[len - 1];
                            break;
                        }
                        tmpFN = tmpStr;
                        break;
                    }
                    ++x;
                }
                if (tmpFN != null) {
                    if (tmpList == null) {
                        tmpList = new ArrayList<String>();
                    }
                    tmpList.add(tmpFN);
                }
                inpFile.randomAccessRead(new byte[128]);
                ++i;
            }
            inpFile.randomAccessClose();
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private XInputFile getFMpgFile(XInputDirectory inpXDirectory, String inpDateinamenbasis) {
        XInputFile tmpFileFmpg = null;
        try {
            XInputFile[] tmpFiles = inpXDirectory.getFiles();
            int anzf = tmpFiles == null ? 0 : tmpFiles.length;
            int i = 0;
            while (i < anzf) {
                XInputFile tmpFile = tmpFiles[i];
                String tmpFN = tmpFile.getName();
                if (tmpFN.equals(inpDateinamenbasis)) {
                    tmpFileFmpg = tmpFile;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpFileFmpg;
    }

    private List getMpgFiles(XInputDirectory inpXDirectory, String inpDateinamenbasis) {
        ArrayList<XInputFile> tmpList = null;
        try {
            XInputFile[] tmpFiles = inpXDirectory.getFiles();
            int anzf = tmpFiles == null ? 0 : tmpFiles.length;
            XInputFile tmpFileFmpg = null;
            int i = 0;
            while (i < anzf) {
                XInputFile tmpFile = tmpFiles[i];
                String tmpFN = tmpFile.getName();
                if (tmpFN.equals(inpDateinamenbasis)) {
                    tmpFileFmpg = tmpFile;
                    break;
                }
                ++i;
            }
            if (tmpFileFmpg != null) {
                ++this.aAnzahlFMPGsVorhanden;
                List tmpList2 = this.readFmpgDatei(tmpFileFmpg);
                this.aAnzahlMPGsErwartet += tmpList2 == null ? 0 : tmpList2.size();
                int i2 = 0;
                while (i2 < anzf) {
                    XInputFile tmpFile = tmpFiles[i2];
                    String tmpFN = tmpFile.getName();
                    if (tmpList2 != null && tmpList2.contains(tmpFN)) {
                        if (tmpList == null) {
                            tmpList = new ArrayList<XInputFile>();
                        }
                        tmpList.add(tmpFile);
                        ++this.aAnzahlMPGsVorhanden;
                        this.anzahlByte += tmpFile.length();
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private List getMpgFiles(String inpDateinamenbasis) {
        List tmpList = null;
        try {
            XInputDirectory tmpXDirectory = this.getCridDirectory();
            tmpList = this.getMpgFiles(tmpXDirectory, inpDateinamenbasis);
            if (tmpList == null || tmpList.size() == 0) {
                tmpXDirectory = this.makeRecDirectory(inpDateinamenbasis);
                tmpList = this.getMpgFiles(tmpXDirectory, inpDateinamenbasis);
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    private List readMpgFiles() {
        List tmpList = null;
        try {
            this.anzahlByte = 0L;
            this.setAnzahlFMPGsVorhanden(0);
            this.setAnzahlMPGsErwartet(0);
            this.setAnzahlMPGsVorhanden(0);
            int anzf = this.dateiNamenBasen == null ? 0 : this.dateiNamenBasen.length;
            int i = 0;
            while (i < anzf) {
                String tmpDateinamenbasis = this.dateiNamenBasen[i];
                List tmpList2 = this.getMpgFiles(tmpDateinamenbasis);
                if (tmpList2 != null && tmpList2.size() > 0) {
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMpgFiles() {
        GAufnahmeFTP gAufnahmeFTP = this;
        synchronized (gAufnahmeFTP) {
            try {
                if (this.aAnzahlMPGsVorhanden < 0) {
                    this.aMpgFiles = this.readMpgFiles();
                    this.fireStateChanged();
                }
            }
            catch (Exception e) {
                GConsole.setErrorMessage(e);
            }
            return this.aMpgFiles;
        }
    }

    private XInputDirectory getFmpgDirectory(String inpDateinamenbasis, boolean inpRecOnly) {
        try {
            XInputDirectory tmpXDirectory = this.getCridDirectory();
            XInputFile tmpFile = null;
            if (!inpRecOnly) {
                this.getFMpgFile(tmpXDirectory, inpDateinamenbasis);
            }
            if (tmpFile == null) {
                tmpXDirectory = this.makeRecDirectory(inpDateinamenbasis);
                tmpFile = this.getFMpgFile(tmpXDirectory, inpDateinamenbasis);
            }
            if (tmpFile != null) {
                return tmpXDirectory;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    public XInputDirectory[] getFmpgDirectories(boolean inpRecOnly) {
        XInputDirectory[] tmpDirectories = null;
        try {
            int anzf = this.dateiNamenBasen == null ? 0 : this.dateiNamenBasen.length;
            int i = 0;
            while (i < anzf) {
                String tmpDateinamenbasis = this.dateiNamenBasen[i];
                XInputDirectory tmpDirectory = this.getFmpgDirectory(tmpDateinamenbasis, inpRecOnly);
                if (tmpDirectories == null) {
                    tmpDirectories = new XInputDirectory[anzf];
                }
                tmpDirectories[i] = tmpDirectory;
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpDirectories;
    }

    protected XInputFile getCridFile() {
        return this.aCridFile;
    }

    protected void setCridFile(XInputFile inpCridFile) {
        this.aCridFile = inpCridFile;
    }
}

